/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.dsig.util.Base64;
import com.ibm.xml.enc.KeyInfoResolverBase;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.KeyName;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyIdentifierKeyResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver == null ? (class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver = KeyIdentifierKeyResolver.class$("com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver")) : class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver == null ? (class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver = KeyIdentifierKeyResolver.class$("com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver")) : class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver).getName();
    private KeyLocator fKeyLocator;
    private Map fId2Name;
    private Map fId602Name;
    private boolean sender = false;
    private QName _ITSHA1 = null;
    private QName _IT60SHA1 = null;
    private QName _BASE64_BINARY = null;
    private QName _HEX_BINARY = null;
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$enc$KeyIdentifierKeyResolver;

    KeyIdentifierKeyResolver(KeyLocator keyLocator, int n, Map map, boolean bl) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyIdentifierKeyResolver(" + keyLocator + "," + n + ")");
        }
        super.setOperationMode(n);
        this.fKeyLocator = keyLocator;
        this.fId2Name = new HashMap();
        this.fId602Name = new HashMap();
        this.sender = bl;
        String string = Constants.getWSSENS(map);
        if (this.sender) {
            this._ITSHA1 = Constants.getQName(string, "ITSHA1");
            this._IT60SHA1 = Constants.getQName(string, "IT60SHA1");
            this._BASE64_BINARY = Constants.getQName(string, "Base64Binary");
            this._HEX_BINARY = Constants.getQName(string, "HexBinary");
        } else {
            this._ITSHA1 = Constants.ITSHA1_RCVR;
            this._IT60SHA1 = Constants.IT60SHA1_RCVR;
            this._BASE64_BINARY = Constants.BASE64_BINARY_RCVR;
            this._HEX_BINARY = Constants.HEX_BINARY_RCVR;
        }
        Iterator iterator = keyLocator.getNames((Object)map).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Certificate certificate = keyLocator.getCertificate(string2);
            if (certificate == null) continue;
            byte[] byArray = KeyIdentifierKeyResolver.makeIdentifier(certificate, this._ITSHA1, string);
            this.fId2Name.put(Base64.encode((byte[])byArray), string2);
            byArray = KeyIdentifierKeyResolver.makeIdentifier(certificate, this._IT60SHA1, string);
            this.fId602Name.put(Base64.encode((byte[])byArray), string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyIdentifierKeyResolver(KeyLocator locator, int operationMode)");
        }
    }

    private boolean isSecurityTokenReference(Element element) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityTokenReference(" + element + ")");
        }
        boolean bl2 = bl = NamespaceUtil.isWsse(element.getNamespaceURI()) && "SecurityTokenReference".equals(element.getLocalName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityTokenReference(Element elem) returns " + bl);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private Key resolveSecurityTokenReference(Element var1_1) throws KeyInfoResolvingException {
        if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
            Tr.entry(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(" + var1_1 + ")");
        }
        if ((var2_2 = NamespaceUtil.getFirstChildWsseElement(var1_1, "KeyIdentifier")) == null) {
            Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.resolveSecurityTokenReference.nokid");
            if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
                Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns null");
            }
            return null;
        }
        var4_3 = this._ITSHA1;
        var5_4 = this._BASE64_BINARY;
        var6_5 = var2_2.getAttribute("IdentifierType");
        if (var6_5.length() > 0) {
            var4_3 = DOMUtil.getQName(var2_2, var6_5);
        }
        if ((var7_6 = var2_2.getAttribute("EncodingType")).length() > 0) {
            var5_4 = DOMUtil.getQName(var2_2, var7_6);
        }
        if (this._BASE64_BINARY.equals(var5_4)) {
            var3_7 = Base64.decode((String)DOMUtil.getStringValue(var2_2));
        } else if (this._HEX_BINARY.equals(var5_4)) {
            try {
                var3_7 = Hex.decode(DOMUtil.getStringValue(var2_2));
            }
            catch (ParseException var8_8) {
                Tr.processException((Throwable)var8_8, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "154", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.resolveSecurityTokenReference.decode", var8_8);
                if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
                    Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns null");
                }
                return null;
            }
        } else {
            throw new IllegalArgumentException("Internal Error: " + var5_4);
        }
        var8_9 = null;
        if (this.fInEncryptMode) {
            var9_10 = true;
            if (!this._ITSHA1.equals(var4_3)) {
                if (this._IT60SHA1.equals(var4_3)) {
                    var9_10 = false;
                } else {
                    throw new IllegalArgumentException("Internal Error: " + var4_3);
                }
            }
            var10_12 = Base64.encode((byte[])var3_7);
            try {
                v0 = var11_14 = var9_10 != false ? (String)this.fId2Name.get(var10_12) : (String)this.fId602Name.get(var10_12);
                if (var11_14 == null) ** GOTO lbl63
                var8_9 = this.fKeyLocator.getEncryptionKey(var11_14, null);
            }
            catch (KeyLocatorException var11_15) {
                Tr.processException((Throwable)var11_15, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "186", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)var11_15);
                throw new KeyInfoResolvingException(var11_15.getMessage());
            }
        } else {
            var9_11 = true;
            if (!this._ITSHA1.equals(var4_3)) {
                if (this._IT60SHA1.equals(var4_3)) {
                    var9_11 = false;
                } else {
                    throw new IllegalArgumentException("Internal Error: " + var4_3);
                }
            }
            var10_13 = Base64.encode((byte[])var3_7);
            try {
                v1 = var11_16 = var9_11 != false ? (String)this.fId2Name.get(var10_13) : (String)this.fId602Name.get(var10_13);
                if (var11_16 != null) {
                    var8_9 = this.fKeyLocator.getDecryptionKey(var11_16, null);
                }
            }
            catch (KeyLocatorException var11_17) {
                Tr.processException((Throwable)var11_17, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "210", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)var11_17);
                throw new KeyInfoResolvingException(var11_17.getMessage());
            }
        }
lbl63:
        // 3 sources

        if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
            Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns " + var8_9);
        }
        return var8_9;
    }

    private static byte[] certToIdentifier(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        byte[] byArray = ((X509Certificate)certificate).getExtensionValue(OID_KEYIDENTIFIER);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
        return byArray2;
    }

    private static byte[] pubkeyToIdentifier(Certificate certificate, QName qName, String string) throws NoSuchAlgorithmException, SoapSecurityException {
        byte[] byArray;
        byte[] byArray2 = certificate.getPublicKey().getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        if (byArray2[0] != 48) {
            throw new RuntimeException("Unknown encoded key: " + Hex.encode(byArray2));
        }
        int n = byArray2[1] & 0xFF;
        int n2 = (n & 0x80) == 0 ? 2 : 2 + (n & 0x7F);
        n = byArray2[n2 + 1] & 0xFF;
        if ((n & 0x80) == 0) {
            n2 += 2;
        } else {
            int n3 = n2 + 2;
            n2 += 2 + (n & 0x7F);
            switch (n & 0x7F) {
                case 1: {
                    n = byArray2[n3] & 0xFF;
                    break;
                }
                case 2: {
                    n = ((byArray2[n3] & 0xFF) << 8) + (byArray2[n3 + 1] & 0xFF);
                    break;
                }
                case 3: {
                    n = ((byArray2[n3] & 0xFF) << 16) + ((byArray2[n3 + 1] & 0xFF) << 8) + (byArray2[n3 + 2] & 0xFF);
                    break;
                }
                case 4: {
                    n = ((byArray2[n3] & 0xFF) << 24) + ((byArray2[n3 + 1] & 0xFF) << 16) + ((byArray2[n3 + 2] & 0xFF) << 8) + (byArray2[n3 + 3] & 0xFF);
                    break;
                }
                default: {
                    throw new RuntimeException("Integer overflow: " + Hex.encode(byArray2));
                }
            }
        }
        if (byArray2[n2 += n] != 3) {
            throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(byArray2[n2] & 0xFF, 16));
        }
        n2 += ((n = byArray2[n2 + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (n & 0x7F);
        if (qName == null || NamespaceUtil.equals(qName, Constants.getQName(string, "ITSHA1")) || NamespaceUtil.equals(qName, Constants.ITSHA1_RCVR)) {
            messageDigest.update(byArray2, n2, byArray2.length - n2);
            byArray = messageDigest.digest();
        } else if (NamespaceUtil.equals(qName, Constants.getQName(string, "IT60SHA1")) || NamespaceUtil.equals(qName, Constants.IT60SHA1_RCVR)) {
            messageDigest.update(byArray2, n2, byArray2.length - n2);
            byte[] byArray3 = messageDigest.digest();
            byArray = new byte[8];
            byArray[0] = (byte)(64 + (byArray3[byArray3.length - 8] & 0xF));
            System.arraycopy(byArray3, byArray3.length - 8 + 1, byArray, 1, byArray.length - 1);
        } else {
            throw new IllegalArgumentException("Internal Error: " + qName);
        }
        return byArray;
    }

    private static byte[] makeIdentifier(Certificate certificate, QName qName, String string) throws NoSuchAlgorithmException, SoapSecurityException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeIdentifier(" + certificate + "," + qName + ")");
        }
        if ((byArray = KeyIdentifierKeyResolver.certToIdentifier(certificate)) == null || qName != null) {
            if (qName == null || NamespaceUtil.equals(qName, Constants.getQName(string, "ITSHA1")) || NamespaceUtil.equals(qName, Constants.ITSHA1_RCVR)) {
                if (byArray == null || byArray.length != 20) {
                    byArray = KeyIdentifierKeyResolver.pubkeyToIdentifier(certificate, qName, string);
                }
            } else if (NamespaceUtil.equals(qName, Constants.getQName(string, "IT60SHA1")) || NamespaceUtil.equals(qName, Constants.IT60SHA1_RCVR)) {
                if (byArray == null || byArray.length != 8) {
                    byArray = KeyIdentifierKeyResolver.pubkeyToIdentifier(certificate, qName, string);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIdentifier(KeyStore store, String alias, QName idty) returns " + byArray);
        }
        return byArray;
    }

    static void addKeyId(KeyInfo keyInfo, KeyLocator keyLocator, String string, Document document, QName qName, QName qName2, Object object) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyId(" + keyInfo + "," + keyLocator + "," + string + "," + document + "," + qName + "," + qName2 + "," + object + ")");
        }
        Key key = keyLocator.getEncryptionKey(string, object);
        boolean bl = false;
        if (key == null) {
            throw new NullPointerException("Key not located: " + string);
        }
        if (key instanceof PublicKey) {
            Certificate certificate = keyLocator.getCertificate(key);
            if (certificate != null) {
                Map map = (Map)object;
                Element element = KeyIdentifierKeyResolver.createElement(document, certificate, qName, qName2, Constants.getWSSENS(map));
                keyInfo.addKeyId(element);
                bl = true;
            }
        } else {
            String string2 = keyLocator.getName(key);
            if (string2 != null) {
                KeyName keyName = new KeyName();
                keyName.setName(string2);
                keyInfo.addKeyName(keyName);
                bl = true;
            }
        }
        if (!bl) {
            throw new RuntimeException("Key id not added: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyId(KeyInfo keyInfo, KeyLocator locator, String name, Document factory, QName idty, QName encoding, Object context)");
        }
    }

    private static Element createElement(Document document, Certificate certificate, QName qName, QName qName2, String string) throws NoSuchAlgorithmException, SoapSecurityException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createElement(" + document + "," + certificate + "," + qName + "," + qName2 + ")");
        }
        byte[] byArray = KeyIdentifierKeyResolver.makeIdentifier(certificate, qName, string);
        if (qName2 == null || NamespaceUtil.equals(qName2, Constants.getQName(string, "Base64Binary")) || NamespaceUtil.equals(qName2, Constants.BASE64_BINARY_RCVR)) {
            string2 = Base64.encode((byte[])byArray);
        } else if (NamespaceUtil.equals(qName2, Constants.getQName(string, "HexBinary")) || NamespaceUtil.equals(qName2, Constants.HEX_BINARY_RCVR)) {
            string2 = Hex.encode(byArray);
        } else {
            throw new IllegalArgumentException("Internal Error: " + qName);
        }
        Element element = document.createElementNS(string, "wsse:KeyIdentifier");
        element.appendChild(document.createTextNode(string2));
        Element element2 = document.createElementNS(string, "wsse:SecurityTokenReference");
        element2.appendChild(element);
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", string);
        if (byArray.length != 20) {
            DOMUtil.setQNameAttr(element, null, "IdentifierType", Constants.getQName(string, "IT60SHA1"));
        }
        if (qName2 != null) {
            DOMUtil.setQNameAttr(element, null, "EncodingType", qName2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created KeyInfo for (cert) " + certificate + " and (content) " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createElement(Document factory, Certificate cert, QName idty, QName encoding) returns " + element2);
        }
        return element2;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveKeyName(" + keyName + "," + encryptionMethod + "," + key + ")");
        }
        if (key == null) {
            String string = keyName.getName();
            if (this.fInEncryptMode) {
                try {
                    key = this.fKeyLocator.getEncryptionKey(string, null);
                }
                catch (KeyLocatorException keyLocatorException) {
                    Tr.processException((Throwable)keyLocatorException, clsName + ".resolveKeyName", "455", (Object)this);
                    Tr.error(tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)keyLocatorException);
                    throw new KeyInfoResolvingException(keyLocatorException.getMessage());
                }
            }
            try {
                key = this.fKeyLocator.getDecryptionKey(string, null);
            }
            catch (KeyLocatorException keyLocatorException) {
                Tr.processException((Throwable)keyLocatorException, clsName + ".resolveKeyName", "464", (Object)this);
                Tr.error(tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)keyLocatorException);
                throw new KeyInfoResolvingException(keyLocatorException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) returns " + key);
        }
        return key;
    }

    protected Key resolveKeyId(Element element, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveKeyId(" + element + "," + encryptionMethod + "," + key + ")");
        }
        if (key == null && this.isSecurityTokenReference(element)) {
            key = this.resolveSecurityTokenReference(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveKeyId(Element keyId, EncryptionMethod encMeth, Key key) returns " + key);
        }
        return key;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

