/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluatorException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReceiverLogin
implements ReceiverLoginComponent {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$token$ReceiverLogin == null ? (class$com$ibm$xml$soapsec$token$ReceiverLogin = ReceiverLogin.class$("com.ibm.xml.soapsec.token.ReceiverLogin")) : class$com$ibm$xml$soapsec$token$ReceiverLogin, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = (class$com$ibm$xml$soapsec$token$ReceiverLogin == null ? (class$com$ibm$xml$soapsec$token$ReceiverLogin = ReceiverLogin.class$("com.ibm.xml.soapsec.token.ReceiverLogin")) : class$com$ibm$xml$soapsec$token$ReceiverLogin).getName();
    private static final String comp = "security.wssecurity";
    protected TokenReceiverConfig conf = null;
    protected SignatureReceiverConfig sconf = null;
    protected String currentRealm = null;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$ReceiverLogin;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$X509;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$Username;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$SignatureResult;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$Generic;

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(class$com$ibm$xml$soapsec$token$TokenReceiverConfig == null ? (class$com$ibm$xml$soapsec$token$TokenReceiverConfig = ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenReceiverConfig")) : class$com$ibm$xml$soapsec$token$TokenReceiverConfig);
        this.sconf = (SignatureReceiverConfig)map.get(class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig == null ? (class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig = ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureReceiverConfig")) : class$com$ibm$xml$soapsec$dsig$SignatureReceiverConfig);
        this.currentRealm = UserRegistry.getInstance().getRealm();
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        if (this.conf == null) {
            String string2 = Constants.getWSSENS(map);
            throw SoapSecurityException.format((QName)Constants.getQName(string2, "InvalidSecurity"), (String)"security.wssecurity.ReceiverLogin.token01");
        }
        String string3 = this.conf.getIdType();
        String string4 = this.conf.getTrustMode();
        LinkedList linkedList = this.conf.getAuthMethods();
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        Subject subject = null;
        String string5 = null;
        boolean bl = false;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.equals("IDAssertion")) {
                int n;
                Result[] resultArray;
                object = null;
                if (string3.equals("X509Certificate")) {
                    resultArray = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$X509 == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$X509") : class$com$ibm$xml$soapsec$token$TokenResult$X509);
                    for (n = 0; n < resultArray.length; ++n) {
                        TokenResult.X509 x509 = (TokenResult.X509)resultArray[n];
                        if (x509.getUsed()) continue;
                        subject = ReceiverLogin.login(this.conf.getLoginMapping("IDAssertion"), this.getSecurityName(x509.getCertificate()), null, null, map);
                        string5 = x509.getIdName();
                        object = x509;
                        x509.setAuthenticatedId();
                        break;
                    }
                } else {
                    resultArray = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                    for (n = 0; n < resultArray.length; ++n) {
                        TokenResult.Username username = (TokenResult.Username)resultArray[n];
                        if (!username.isIdAssertion()) continue;
                        subject = username.getSubject();
                        string5 = username.getIdName();
                        object = username;
                        break;
                    }
                }
                if ("BasicAuth".equals(string4)) {
                    resultArray = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                    n = 0;
                    for (int i = 0; i < resultArray.length; ++i) {
                        TokenResult.Username username = (TokenResult.Username)resultArray[i];
                        if (username.isIdAssertion() || !this.validateId(username.getUsername())) continue;
                        n = 1;
                        break;
                    }
                    if (n == 0) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token35");
                    }
                } else if ("Signature".equals(string4)) {
                    resultArray = ResultPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureResult") : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                    if (resultArray.length <= 0) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token03");
                    }
                    String string6 = object.getIdName();
                    if (string6 == null) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token05");
                    }
                    boolean bl2 = false;
                    for (int i = 0; i < resultArray.length; ++i) {
                        SignatureResult signatureResult = (SignatureResult)resultArray[i];
                        String string7 = this.getSecurityName(signatureResult.getCertificate());
                        if (!signatureResult.isSigned(string6) || !this.validateId(string7)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token06");
                    }
                }
            } else if (string.equals("BasicAuth")) {
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    TokenResult.Username username = (TokenResult.Username)object[i];
                    if (username.isIdAssertion()) continue;
                    subject = username.getSubject();
                    string5 = username.getIdName();
                    break;
                }
            } else if (string.equals("Signature")) {
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureResult") : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    SignatureResult signatureResult = (SignatureResult)object[i];
                    if (!signatureResult.getCompliance()) continue;
                    subject = ReceiverLogin.login(this.conf.getLoginMapping("Signature"), this.getSecurityName(signatureResult.getCertificate()), null, null, map);
                    bl = true;
                    signatureResult.setAuthenticatedId();
                    break;
                }
            } else {
                int n = 0;
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Generic == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Generic") : class$com$ibm$xml$soapsec$token$TokenResult$Generic);
                if (n < ((Result[])object).length) {
                    TokenResult.Generic generic = (TokenResult.Generic)object[n];
                    subject = generic.getSubject();
                    string5 = generic.getIdName();
                }
            }
            if (subject == null) continue;
        }
        if (linkedList.size() != 0) {
            if (subject == null) {
                string = Constants.getWSSENS(map);
                throw SoapSecurityException.format((QName)Constants.getQName(string, "FailedAuthentication"), (String)"security.wssecurity.ReceiverLogin.token07");
            }
            if (!bl && this.sconf.getRequiredIntegralParts().contains("securitytoken")) {
                boolean bl3 = false;
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? (class$com$ibm$xml$soapsec$dsig$SignatureResult = ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureResult")) : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    SignatureResult signatureResult = (SignatureResult)object[i];
                    if (!signatureResult.isSigned(string5)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    String string8 = Constants.getWSSENS(map);
                    throw SoapSecurityException.format((QName)Constants.getQName(string8, "FailedCheck"), (String)"security.wssecurity.ReceiverLogin.unsigned");
                }
            }
            ResultPool.add(map, new LoginResult(subject));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    protected boolean validateId(String string) {
        try {
            return this.conf.getTrustedIDEvaluator().evaluate(string);
        }
        catch (TrustedIDEvaluatorException trustedIDEvaluatorException) {
            Tr.processException(trustedIDEvaluatorException, clsName + ".validateId", "265");
            Tr.error(tc, "security.wssecurity.ReceiverLogin.trust", (Object)trustedIDEvaluatorException);
            return false;
        }
    }

    static Subject login(LoginMapping loginMapping, Object object, Document document, char[] cArray, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(" + loginMapping + "," + object + "," + "XXXXXX" + "," + map + ")");
        }
        String string = loginMapping.getConfigName();
        CallbackHandlerFactory callbackHandlerFactory = loginMapping.getCallbackHandlerFactory();
        if (object instanceof byte[]) {
            callbackHandlerFactory.setTokenBytes((byte[])object);
        } else if (object instanceof Element) {
            callbackHandlerFactory.setXMLToken((Element)object);
            callbackHandlerFactory.setSOAPMessage(document);
        } else {
            callbackHandlerFactory.setUsername((String)object);
            callbackHandlerFactory.setPassword(cArray);
        }
        callbackHandlerFactory.setProperties(loginMapping.getProperties());
        CallbackHandler callbackHandler = callbackHandlerFactory.newCallbackHandler();
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(loginMapping.getConfigName(), callbackHandler);
        }
        catch (LoginException loginException) {
            String string2 = "security.wssecurity.ReceiverLogin.token10";
            Tr.processException(loginException, clsName + ".login", "300");
            Tr.error(tc, string2, loginException);
            String string3 = Constants.getWSSENS(map);
            throw SoapSecurityException.format((QName)Constants.getQName(string3, "InvalidSecurity"), (String)string2, (String)loginException.toString());
        }
        try {
            loginContext.login();
        }
        catch (LoginException loginException) {
            String string4 = "security.wssecurity.ReceiverLogin.token11";
            String string5 = "security.wssecurity.WSEC5201E";
            Tr.processException(loginException, clsName + ".login", "315");
            Tr.error(tc, string5, loginException);
            String string6 = Constants.getWSSENS(map);
            throw SoapSecurityException.format((QName)Constants.getQName(string6, "FailedAuthentication"), (String)string4, (String)loginException.toString());
        }
        Subject subject = loginContext.getSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(LoginMapping mapping, Object token, char[] password) returns " + subject);
        }
        return subject;
    }

    private String getSecurityName(X509Certificate x509Certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName", x509Certificate);
        }
        String string = UserRegistry.getInstance().mapCertificate(x509Certificate);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mappedName: " + string);
        }
        if (string == null || string.length() == 0) {
            string = x509Certificate.getSubjectDN().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mappedName is null, so used the DN in the certificate: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName returns " + string);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

