/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.dsig.util.Base64;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UsernameTokenReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$token$UsernameTokenReceiver == null ? (class$com$ibm$xml$soapsec$token$UsernameTokenReceiver = UsernameTokenReceiver.class$("com.ibm.xml.soapsec.token.UsernameTokenReceiver")) : class$com$ibm$xml$soapsec$token$UsernameTokenReceiver, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    TokenReceiverConfig conf = null;
    private static final String clsName = (class$com$ibm$xml$soapsec$token$UsernameTokenReceiver == null ? (class$com$ibm$xml$soapsec$token$UsernameTokenReceiver = UsernameTokenReceiver.class$("com.ibm.xml.soapsec.token.UsernameTokenReceiver")) : class$com$ibm$xml$soapsec$token$UsernameTokenReceiver).getName();
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$UsernameTokenReceiver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenReceiverConfig;

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(class$com$ibm$xml$soapsec$token$TokenReceiverConfig == null ? (class$com$ibm$xml$soapsec$token$TokenReceiverConfig = UsernameTokenReceiver.class$("com.ibm.xml.soapsec.token.TokenReceiverConfig")) : class$com$ibm$xml$soapsec$token$TokenReceiverConfig);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        String string2 = (string = IdUtil.getIdAttributeName(element)) == null ? null : element.getAttribute(string);
        Element element2 = (Element)NamespaceUtil.getWsseElementsByTagName(element, "Username").item(0);
        String string3 = DOMUtil.getStringValue(element2);
        char[] cArray = null;
        QName qName = null;
        NodeList nodeList = NamespaceUtil.getWsseElementsByTagName(element, "Password");
        if (nodeList.getLength() != 0) {
            object2 = (Element)nodeList.item(0);
            object = object2.getAttribute("Type");
            if (!((String)object).equals("") && NamespaceUtil.equals(qName = DOMUtil.getQName((Element)object2, (String)object), Constants.PASSWORD_DIGEST_RCVR)) {
                String string4 = Constants.getWSSENS(map);
                throw SoapSecurityException.format((QName)Constants.getQName(string4, "UnsupportedSecurityToken"), (String)"security.wssecurity.UsernameTokenReceiver.token08");
            }
            cArray = DOMUtil.getStringValue((Node)object2).toCharArray();
        }
        this.validateNonceTimestamp(element, map);
        this.validateNonce(element, map);
        Object object3 = object2 = cArray == null ? this.conf.getLoginMapping("IDAssertion") : this.conf.getLoginMapping("BasicAuth");
        if (object2 != null) {
            object = ReceiverLogin.login((LoginMapping)object2, string3, null, cArray, map);
            boolean bl = cArray == null;
            TokenResult.Username username = null;
            username = string2 != null ? new TokenResult.Username((Subject)object, string3, bl, string2) : new TokenResult.Username((Subject)object, string3, bl, element);
            ResultPool.add(map, username);
        } else {
            Tr.warning(tc, "security.wssecurity.UsernameTokenReceiver.token53");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void validateNonceTimestamp(Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNonceTimestamp");
        }
        String string = Constants.getWSSENS(map);
        NodeList nodeList = NamespaceUtil.getWsuElementsByTagName(element, "Created");
        if (nodeList.getLength() == 0) {
            if (this.conf.isNonceTimestampChecked()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Nonce timestamp found in Username token");
                }
                String string2 = "security.wssecurity.WSEC5192E";
                Tr.error(tc, string2);
                throw new SoapSecurityException(Constants.getQName(string, "InvalidSecurityToken"), string2);
            }
        } else {
            Element element2 = (Element)nodeList.item(0);
            String string3 = DOMUtil.getStringValue(element2);
            Date date = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing Nonce timestamp in String format = " + string3);
                }
                date = UTC.parse(string3);
            }
            catch (ParseException parseException) {
                String string4 = "security.wssecurity.WSEC5191E";
                Tr.processException(parseException, clsName + ".validateNonceTimestamp", "168");
                Tr.error(tc, string4, new Object[]{string3, parseException});
                String string5 = MessageFormat.format(ConfigUtil.getMessage(string4), string3, parseException.toString());
                throw new SoapSecurityException(Constants.getQName(string, "InvalidSecurity"), string5, (Throwable)parseException);
            }
            long l = System.currentTimeMillis();
            Long l2 = new Long(l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time = " + l + " ms");
            }
            l -= this.conf.getNonceMaxAge();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce max age = " + this.conf.getNonceMaxAge() + " ms, (current - Nonce max age) = " + l + " ms");
            }
            l -= this.conf.getNonceClockSkew();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce clock skew = " + this.conf.getNonceClockSkew() + " ms, (current - Nonce clock skew) = " + l + " ms");
            }
            long l3 = date.getTime();
            Long l4 = new Long(l3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce created time (timestamp) = " + l3 + " ms");
            }
            if (l3 < l) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce timestamp is not fresh, creation timestamp " + UTC.format(date) + " too old");
                }
                String string6 = "security.wssecurity.WSEC5193E";
                String string7 = "security.wssecurity.WSEC5200E";
                Tr.error(tc, string7, new Object[]{l2.toString(), l4.toString()});
                throw SoapSecurityException.format((QName)Constants.getQName(string, "FailedAuthentication"), (String)string6);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNonceTimestamp");
        }
    }

    private void validateNonce(Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNonce");
        }
        String string = Constants.getWSSENS(map);
        NodeList nodeList = NamespaceUtil.getWsseElementsByTagName(element, "Nonce");
        if (nodeList.getLength() == 0) {
            if (this.conf.isNonceChecked()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Nonce found in Username token");
                }
                String string2 = "security.wssecurity.WSEC5194E";
                Tr.error(tc, string2);
                throw new SoapSecurityException(Constants.getQName(string, "InvalidSecurityToken"), string2);
            }
        } else {
            Element element2 = (Element)nodeList.item(0);
            QName qName = null;
            if (element2.hasAttribute("EncodingType")) {
                qName = DOMUtil.getQName(element2, element2.getAttribute("EncodingType"));
            }
            String string3 = DOMUtil.getStringValue(element2);
            byte[] byArray = null;
            if (qName == null || NamespaceUtil.equals(qName, Constants.BASE64_BINARY_RCVR)) {
                byArray = Base64.decode((String)string3);
            } else if (NamespaceUtil.equals(qName, Constants.HEX_BINARY_RCVR)) {
                try {
                    byArray = Hex.decode(string3);
                }
                catch (ParseException parseException) {
                    String string4 = "security.wssecurity.WSEC5175E";
                    Tr.processException(parseException, clsName + ".validateNonce", "262");
                    Tr.error(tc, string4, parseException);
                    String string5 = MessageFormat.format(ConfigUtil.getMessage(string4), parseException.toString());
                    throw new SoapSecurityException(Constants.getQName(string, "InvalidSecurity"), string5, (Throwable)parseException);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding type: " + qName.toString());
                }
                String string6 = "security.wssecurity.UsernameToken.token55";
                Tr.error(tc, string6, new Object[]{qName.toString()});
                throw SoapSecurityException.format((QName)Constants.getQName(string, "UnsupportedSecurityToken"), (String)string6, (String)qName.toString());
            }
            NonceManager nonceManager = this.conf.getNonceManager();
            if (nonceManager == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NonceManager is not set");
                }
                throw SoapSecurityException.format((String)"security.wssecurity.UsernameToken.token56");
            }
            if (!nonceManager.validate(byArray)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Repeated Nonce: " + string3);
                }
                String string7 = "security.wssecurity.WSEC5178E";
                Tr.error(tc, string7);
                throw SoapSecurityException.format((QName)Constants.getQName(string, "FailedAuthentication"), (String)string7);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNonce");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

