/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.Initializable;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$util$ConfigUtil == null ? (class$com$ibm$xml$soapsec$util$ConfigUtil = ConfigUtil.class$("com.ibm.xml.soapsec.util.ConfigUtil")) : class$com$ibm$xml$soapsec$util$ConfigUtil, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static final PrivilegedAction contextLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static ResourceBundle _resource = null;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$util$ConfigUtil;
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$config$KeyLocator;

    private ConfigUtil() {
    }

    public static boolean isTrue(String string) {
        string = string.trim();
        for (int i = 0; i < TRUE_VALUES.length; ++i) {
            if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static File fixPath(String string, String string2) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        if (string2 != null) {
            return new File(string2, string);
        }
        return new File(file.getAbsolutePath());
    }

    public static KeyStore getKeyStore(String string, File file, char[] cArray) throws SoapSecurityException {
        if (cArray == null || cArray.length == 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s03", (String)file.getAbsolutePath());
        }
        return ConfigUtil.createKeyStore(string, file, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KeyStore createKeyStore(String string, File file, char[] cArray) throws SoapSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                keyStore.load(fileInputStream, cArray);
                Object var6_10 = null;
                if (fileInputStream == null) return keyStore;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return keyStore;
            }
            catch (IOException iOException) {}
            return keyStore;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s04", (String)file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s05", (String)file.getAbsolutePath(), (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)file.getAbsolutePath(), (String)certificateException.getClass().getName(), (String)certificateException.getMessage(), (Throwable)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)file.getAbsolutePath(), (String)noSuchAlgorithmException.getClass().getName(), (String)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)file.getAbsolutePath(), (String)keyStoreException.getClass().getName(), (String)keyStoreException.getMessage(), (Throwable)keyStoreException);
        }
    }

    public static Key getKey(KeyStore keyStore, String string, char[] cArray) throws SoapSecurityException {
        try {
            return keyStore.getKey(string, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s07", (String)string, (String)keyStore.toString(), (String)keyStoreException.getClass().getName(), (String)keyStoreException.getMessage(), (Throwable)keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s07", (String)string, (String)keyStore.toString(), (String)noSuchAlgorithmException.getClass().getName(), (String)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s07", (String)string, (String)keyStore.toString(), (String)unrecoverableKeyException.getClass().getName(), (String)unrecoverableKeyException.getMessage(), (Throwable)unrecoverableKeyException);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String string) throws SoapSecurityException {
        try {
            return keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw SoapSecurityException.format((String)"security.wssecurity.FileConfigSSR.s13", (String)string, (String)keyStore.toString(), (String)keyStoreException.getClass().getName(), (String)keyStoreException.getMessage(), (Throwable)keyStoreException);
        }
    }

    public static X509Certificate getX509Certificate(File file, CertificateFactory certificateFactory) throws SoapSecurityException {
        try {
            return (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s23", (String)file.getAbsolutePath(), (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s24", (String)file.getAbsolutePath(), (Throwable)certificateException);
        }
    }

    public static CertificateFactory createCertificateFactory(String string) throws SoapSecurityException {
        try {
            if (string == null || "".equals(string)) {
                return CertificateFactory.getInstance("X.509");
            }
            return CertificateFactory.getInstance("X.509", string);
        }
        catch (CertificateException certificateException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s24", (String)string, (Throwable)certificateException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw SoapSecurityException.format((String)"security.wssecurity.CommonReceiverConfig.s22", (String)string, (Throwable)noSuchProviderException);
        }
    }

    public static Document mergeDocuments(Document[] documentArray) throws SoapSecurityException {
        Document document = DOMUtil.createDocument();
        Element element = document.createElement("root");
        document.appendChild(element);
        if (documentArray != null) {
            for (int i = 0; i < documentArray.length; ++i) {
                Element element2;
                if (documentArray[i] == null || (element2 = documentArray[i].getDocumentElement()) == null) continue;
                element.appendChild(document.importNode(element2, true));
            }
        }
        return document;
    }

    public static Initializable instantiate(String string, Class clazz, Map map) throws SoapSecurityException {
        Initializable initializable;
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)contextLoaderGetter);
        try {
            Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s17", (String)string, (String)clazz.getName());
            }
            initializable = (Initializable)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s09", (String)string);
        }
        catch (InstantiationException instantiationException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s10", (String)string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s11", (String)string);
        }
        initializable.init(map);
        return initializable;
    }

    public static Map getProperties(Element element) throws SoapSecurityException {
        NodeList nodeList = DOMUtil.getChildElements(element, Constants.NS_CONFIG, "Property");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            hashMap.put(DOMUtil.getAttribute(element2, "name"), DOMUtil.getAttribute(element2, "value"));
        }
        return hashMap;
    }

    public static KeyLocator findKeyLocator(Element element, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKeyLocator(" + element + "," + string + "," + string2 + ")");
        }
        NodeList nodeList = element.getElementsByTagNameNS(Constants.NS_CONFIG, "KeyLocator");
        Element element2 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        String string3 = null;
        KeyLocator keyLocator = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            if (!string.equals(DOMUtil.getAttribute(element2, "name"))) continue;
            string3 = DOMUtil.getAttribute(element2, "classname");
            Map map = ConfigUtil.getProperties(element2);
            if (string3.equals("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator")) {
                map.put("base", string2);
            }
            keyLocator = (KeyLocator)ConfigUtil.instantiate(string3, class$com$ibm$wsspi$wssecurity$config$KeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$KeyLocator = ConfigUtil.class$("com.ibm.wsspi.wssecurity.config.KeyLocator")) : class$com$ibm$wsspi$wssecurity$config$KeyLocator, map);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKeyLocator(Element elem, String name, String parentPath) returns " + keyLocator);
        }
        return keyLocator;
    }

    public static String getMessage(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getMessage", new Object[]{string});
        }
        String string2 = string;
        if (_resource != null) {
            try {
                string2 = _resource.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", new Object[]{missingResourceException});
                }
                Tr.processException(missingResourceException, (class$com$ibm$xml$soapsec$util$ConfigUtil == null ? (class$com$ibm$xml$soapsec$util$ConfigUtil = ConfigUtil.class$("com.ibm.xml.soapsec.util.ConfigUtil")) : class$com$ibm$xml$soapsec$util$ConfigUtil).getName() + ".getMessage", "327");
                string2 = string;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getMessage", new Object[]{string2});
        }
        return string2;
    }

    private static void init() {
        try {
            _resource = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, (class$com$ibm$xml$soapsec$util$ConfigUtil == null ? (class$com$ibm$xml$soapsec$util$ConfigUtil = ConfigUtil.class$("com.ibm.xml.soapsec.util.ConfigUtil")) : class$com$ibm$xml$soapsec$util$ConfigUtil).getName(), "342");
            Tr.warning(tc, "security.wssecurity.cannot.laod.resource", new Object[]{throwable});
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConfigUtil.init();
    }
}

