/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ErrorHandlerImpl;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    private static final TraceComponent tc = Tr.register(class$com$ibm$xml$soapsec$util$DOMUtil == null ? (class$com$ibm$xml$soapsec$util$DOMUtil = DOMUtil.class$("com.ibm.xml.soapsec.util.DOMUtil")) : class$com$ibm$xml$soapsec$util$DOMUtil, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$xml$soapsec$util$DOMUtil == null ? (class$com$ibm$xml$soapsec$util$DOMUtil = DOMUtil.class$("com.ibm.xml.soapsec.util.DOMUtil")) : class$com$ibm$xml$soapsec$util$DOMUtil).getName();
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    static Random randomgen;
    private static final HashSet INDENT_NS;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$util$DOMUtil;

    private DOMUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputSource inputSource, boolean bl) throws SoapSecurityException {
        try {
            DocumentBuilder documentBuilder;
            Object object = builderFactory;
            synchronized (object) {
                builderFactory.setValidating(bl);
                documentBuilder = builderFactory.newDocumentBuilder();
            }
            object = new ErrorHandlerImpl();
            documentBuilder.setErrorHandler((ErrorHandler)object);
            documentBuilder.setEntityResolver(new JarEntityResolver());
            Document document = documentBuilder.parse(inputSource);
            if (((ErrorHandlerImpl)object).getErrorCount() > 0) {
                throw new SAXException("Parsing error(s) occured: " + ((ErrorHandlerImpl)object).getErrorCount());
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SoapSecurityException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new SoapSecurityException((Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new SoapSecurityException((Throwable)sAXException);
        }
    }

    public static Document getPrivateConfig(boolean bl) {
        final String string = bl ? "config/ibm-wssecurity-sender-private.xml" : "config/ibm-wssecurity-receiver-private.xml";
        try {
            return (Document)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource(string);
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)((Object)privilegedActionException.getException());
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "104");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", (Object)soapSecurityException);
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "114");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", throwable);
            throw new IllegalArgumentException(throwable.getMessage());
        }
    }

    public static Document getConfigValidation() {
        try {
            return (Document)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource("config/ibm-wssecurity-config-validation.xml");
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)((Object)privilegedActionException.getException());
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "133");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", (Object)soapSecurityException);
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "143");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", throwable);
            throw new IllegalArgumentException(throwable.getMessage());
        }
    }

    public static InputSource getResourceAsInputSource(String string) {
        InputStream inputStream;
        ClassLoader classLoader = (class$com$ibm$xml$soapsec$util$DOMUtil == null ? (class$com$ibm$xml$soapsec$util$DOMUtil = DOMUtil.class$("com.ibm.xml.soapsec.util.DOMUtil")) : class$com$ibm$xml$soapsec$util$DOMUtil).getClassLoader();
        if (classLoader == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream == null) {
                inputStream = ClassLoader.getSystemResourceAsStream("/" + string);
            }
        } else {
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream("/" + string);
            }
        }
        if (inputStream == null) {
            throw new RuntimeException("Internal Error: No such resource: " + string);
        }
        return new InputSource(inputStream);
    }

    public static String toString(Node node) {
        byte[] byArray;
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                byArray = XPathCanonicalizer.serializeSubset((Node)((Element)node), (boolean)true);
                break;
            }
            case 9: {
                byArray = XPathCanonicalizer.serializeAll((Document)((Document)node), (boolean)true);
                break;
            }
            default: {
                throw new UnknownError("Unsupported node type: " + node);
            }
        }
        return new String(byArray);
    }

    public static String toString(Node node, String string) {
        byte[] byArray;
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                byArray = XPathCanonicalizer.serializeSubset((Node)((Element)node), (boolean)true);
                break;
            }
            case 9: {
                byArray = XPathCanonicalizer.serializeAll((Document)((Document)node), (boolean)true);
                break;
            }
            default: {
                throw new UnknownError("Unsupported node type: " + node);
            }
        }
        String string2 = null;
        try {
            string2 = new String(byArray, string);
        }
        catch (Exception exception) {
            string2 = new String(byArray);
        }
        return string2;
    }

    public static Document createDocument() throws SoapSecurityException {
        try {
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SoapSecurityException((Throwable)parserConfigurationException);
        }
    }

    public static Element getZeroOrOneElement(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        throw SoapSecurityException.format((String)"security.wssecurity.RequestReceiverConfig.sconf02", (String)string2);
    }

    public static Element getZeroOrOneElement(Document document, String string, String string2) throws SoapSecurityException {
        return DOMUtil.getZeroOrOneElement(document.getDocumentElement(), string, string2);
    }

    public static Element getOneElement(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() != 1) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)string2);
        }
        return (Element)nodeList.item(0);
    }

    public static Element getOneElement(Document document, String string, String string2) throws SoapSecurityException {
        NodeList nodeList = document.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() != 1) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)string2);
        }
        return (Element)nodeList.item(0);
    }

    public static NodeList getChildElements(Element element, String string, String string2) {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !DOMUtil.equals(node, string, string2)) continue;
            arrayList.add(node);
        }
        return new NodeList(){

            public int getLength() {
                return arrayList.size();
            }

            public Node item(int n) {
                return (Node)arrayList.get(n);
            }
        };
    }

    public static Element getChildElement(Element element, String string, String string2) {
        Element element2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !DOMUtil.equals(node, string, string2)) continue;
            element2 = (Element)node;
            break;
        }
        return element2;
    }

    public static boolean equals(Node node, String string, String string2) {
        return DOMUtil.equals(node.getNamespaceURI(), string) && DOMUtil.equals(node.getLocalName(), string2);
    }

    private static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static NodeList getOneOrMoreChildElements(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList = DOMUtil.getChildElements(element, string, string2);
        if (nodeList.getLength() <= 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf09", (String)string2);
        }
        return nodeList;
    }

    public static NodeList getOneOrMoreElements(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() <= 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf09", (String)string2);
        }
        return nodeList;
    }

    public static String getAttribute(Element element, String string) throws SoapSecurityException {
        if (!element.hasAttribute(string)) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf10", (String)element.getLocalName(), (String)string);
        }
        return element.getAttribute(string);
    }

    public static Element getOneChildElement(Element element, String string, String string2) throws SoapSecurityException {
        Element element2 = DOMUtil.getChildElement(element, string, string2);
        if (element2 == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)string2);
        }
        return element2;
    }

    public static Element getOneChildElement(Element element, String string, String[] stringArray) throws SoapSecurityException {
        Element element2 = null;
        for (int i = 0; i < stringArray.length && (element2 = DOMUtil.getChildElement(element, string, stringArray[i])) == null; ++i) {
        }
        if (element2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf11", (String)stringBuffer.toString());
        }
        return element2;
    }

    public static Node getNextSibling2(Node node) {
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getNextSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getFirstChild();
                if (node4 == null) {
                    node2 = DOMUtil.getNextSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        return node2;
    }

    public static Node getPreviousSibling2(Node node) {
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getPreviousSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getLastChild();
                if (node4 == null) {
                    node2 = DOMUtil.getPreviousSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        return node2;
    }

    public static Node getFirstChild2(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getFirstChild();
            if (node3 == null) {
                node2 = DOMUtil.getNextSibling2(node2);
                break;
            }
            node2 = node3;
        }
        return node2;
    }

    public static Node getLastChild2(Node node) {
        Node node2 = node.getLastChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getLastChild();
            if (node3 == null) {
                node2 = DOMUtil.getPreviousSibling2(node2);
                break;
            }
            node2 = node3;
        }
        return node2;
    }

    public static Element getFirstChildElement(Node node) {
        Node node2 = DOMUtil.getFirstChild2(node);
        while (node2 != null && node2.getNodeType() != 1) {
            node2 = DOMUtil.getNextSibling2(node2);
        }
        return (Element)node2;
    }

    public static Element getFirstChildElement(Node node, String string, String string2) {
        Node node2 = DOMUtil.getFirstChild2(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Element element = (Element)node2;
                String string3 = element.getNamespaceURI();
                if ((string2.equals("*") || element.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            node2 = DOMUtil.getNextSibling2(node2);
        }
        return (Element)node2;
    }

    public static Element getNextElement(Node node) {
        Node node2 = node;
        while ((node2 = DOMUtil.getNextSibling2(node2)) != null && node2.getNodeType() != 1) {
        }
        return (Element)node2;
    }

    public static String getStringValue(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    return "";
                }
                if (node2 == node.getLastChild() && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    return node2.getNodeValue();
                }
                StringBuffer stringBuffer = new StringBuffer();
                DOMUtil.getStringValue0(node, stringBuffer);
                return new String(stringBuffer);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        throw new RuntimeException("Internal Error: Unexpected node type: " + node.getNodeType());
    }

    private static void getStringValue0(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    DOMUtil.getStringValue0(node2, stringBuffer);
                }
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    public static boolean declareNamespace(Element element) {
        String string = "xmlns";
        if (element.getPrefix() != null) {
            string = "xmlns:" + element.getPrefix();
        }
        String string2 = element.getNamespaceURI();
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            Attr attr = node.getAttributeNode(string);
            if (attr == null) continue;
            if (string2 == null) {
                if (attr.getNodeValue().length() == 0) {
                    return false;
                }
                element.setAttributeNS(Constants.NS_XMLNS, string, "");
                return true;
            }
            if (string2.equals(attr.getNodeValue())) {
                return false;
            }
            element.setAttributeNS(Constants.NS_XMLNS, string, string2);
            return true;
        }
        if (string2 == null) {
            return false;
        }
        element.setAttributeNS(Constants.NS_XMLNS, string, string2);
        return true;
    }

    public static String makeUniqueId(Document document, String string) {
        IdUtil idUtil = new IdUtil();
        String string2 = null;
        while (idUtil.findWsuId(document, string2 = string + String.valueOf(Math.abs(randomgen.nextLong())))) {
        }
        return string2;
    }

    public static void removeIndentation(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                DOMUtil.removeIndentation((Element)node);
                node = node.getNextSibling();
                continue;
            }
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                Node node2 = node;
                if (DOMUtil.isAllSpace(node)) {
                    node = node.getNextSibling();
                    element.removeChild(node2);
                    continue;
                }
                if (DOMUtil.hasSpace(node)) {
                    DOMUtil.trimSpaces(node);
                    node = node.getNextSibling();
                    continue;
                }
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public static void indent(Element element, int n, int n2) {
        int n3 = n + n2;
        if (!INDENT_NS.contains(element.getNamespaceURI())) {
            return;
        }
        if (!element.hasChildNodes()) {
            return;
        }
        element.normalize();
        Document document = element.getOwnerDocument();
        Node node = null;
        for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1) {
                if (node == null || node.getNodeType() != 3) {
                    element.insertBefore(DOMUtil.createTextNode(document, n3), node2);
                } else if (DOMUtil.isAllSpace(node)) {
                    element.replaceChild(DOMUtil.createTextNode(document, n3), node);
                }
                DOMUtil.indent((Element)node2, n3, n2);
            }
            node = node2;
        }
        if (node == null || node.getNodeType() != 3) {
            element.appendChild(DOMUtil.createTextNode(document, n));
        } else if (DOMUtil.isAllSpace(node)) {
            element.replaceChild(DOMUtil.createTextNode(document, n), node);
        }
    }

    private static Node createTextNode(Document document, int n) {
        StringBuffer stringBuffer = new StringBuffer(1 + n);
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return document.createTextNode(new String(stringBuffer));
    }

    private static boolean isAllSpace(Node node) {
        String string = node.getNodeValue();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    private static boolean hasSpace(Node node) {
        String string = node.getNodeValue();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            return true;
        }
        return false;
    }

    private static void trimSpaces(Node node) {
        String string = node.getNodeValue();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            stringBuffer.append(c);
        }
        node.setNodeValue(new String(stringBuffer));
    }

    public static QName getQName(Element element, String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n == -1) {
            string2 = "xmlns";
            string3 = string;
        } else {
            string2 = "xmlns:" + string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Node node = element;
        String string4 = "";
        while (node instanceof Element && (string4 = node.getAttribute(string2)).equals("")) {
            node = node.getParentNode();
        }
        return new QName(string4, string3);
    }

    public static void setQNameAttr(Element element, String string, String string2, QName qName) {
        String string3 = DOMUtil.setQName0(element, qName);
        element.setAttributeNS(string, string2, string3);
    }

    public static void setQNameText(Element element, QName qName) {
        String string = DOMUtil.setQName0(element, qName);
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode(string));
    }

    private static String setQName0(Element element, QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        Node node = element;
        String string3 = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (node instanceof Element) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                String string4 = node2.getNodeName();
                String string5 = node2.getNodeValue();
                if (!string4.startsWith("xmlns")) continue;
                String string6 = null;
                int n = string4.indexOf(":");
                string6 = n == -1 ? "" : string4.substring(n + 1);
                if (string5.equals(string) && string3 == null && !hashSet.contains(string6)) {
                    string3 = string6;
                }
                hashSet.add(string6);
            }
            node = node.getParentNode();
        }
        if (string3 == null) {
            while (hashSet.contains(string3 = "ns" + DOMUtil.makeRandomStr())) {
            }
            element.setAttributeNS(Constants.NS_XMLNS, "xmlns:" + string3, string);
        }
        return string3.equals("") ? string2 : string3 + ":" + string2;
    }

    private static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static Element StringToElement(String string, String string2, String string3) {
        Element element = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringToElement(namespace, name, string)", new Object[]{string, string2, string3});
        }
        try {
            Document document = DOMUtil.createDocument();
            Element element2 = null;
            element2 = string == null || string.length() == 0 ? document.createElement(string2) : document.createElementNS(string, string2);
            Text text = document.createTextNode(string3);
            element2.appendChild(text);
            element = element2;
        }
        catch (SoapSecurityException soapSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ParserConfigurationException", new Object[]{soapSecurityException});
            }
            Tr.processException(soapSecurityException, (class$com$ibm$xml$soapsec$util$DOMUtil == null ? (class$com$ibm$xml$soapsec$util$DOMUtil = DOMUtil.class$("com.ibm.xml.soapsec.util.DOMUtil")) : class$com$ibm$xml$soapsec$util$DOMUtil).getName(), "892");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringToElement(namespace, name, string)");
        }
        return element;
    }

    public static boolean hasNamespaceDeclaration(Element element, String string) {
        return DOMUtil.getNamespaceDeclaration(element, string) != null;
    }

    public static String getNamespacePrefix(Element element, String string) {
        String string2;
        Attr attr = DOMUtil.getNamespaceDeclaration(element, string);
        String string3 = null;
        if (attr != null && !"xmlns".equals(string2 = attr.getLocalName())) {
            string3 = string2;
        }
        return string3;
    }

    private static Attr getNamespaceDeclaration(Element element, String string) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = null;
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr2 = (Attr)namedNodeMap.item(i);
            String string2 = attr2.getName();
            if (!"xmlns".equals(string2) && !string2.startsWith("xmlns:") || !string.equals(string2 = attr2.getValue())) continue;
            attr = attr2;
            break;
        }
        return attr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        builderFactory.setNamespaceAware(true);
        randomgen = new Random();
        INDENT_NS = new HashSet();
        INDENT_NS.add(Constants.NS_WSSE);
        INDENT_NS.add(Constants.NS_DSIG);
        INDENT_NS.add(Constants.NS_ENC);
        INDENT_NS.add(Constants.NS_WSSE200207);
        INDENT_NS.add(Constants.NS_WSSE200204);
        INDENT_NS.add(Constants.NS_WSU);
        INDENT_NS.add(Constants.NS_WSU200207);
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            String string3 = null;
            if (string2 == null) {
                return null;
            }
            try {
                int n = string2.lastIndexOf(47);
                string3 = n < 0 ? "config/" + string2 : "config/" + string2.substring(n + 1);
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                if (inputStream == null) {
                    return null;
                }
                return new InputSource(inputStream);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

