/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdUtil
implements IDResolver {
    private static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String[][] KNOWN_IDATTRS = new String[][]{{Constants.NS_WSSE, "*", "Id"}, {Constants.NS_WSSE200207, "*", "Id"}, {Constants.NS_WSSE200204, "*", "Id"}, {Constants.NS_DSIG, "*", "Id"}, {Constants.NS_ENC, "*", "Id"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{Constants.NS_WSU, "Id"}, {Constants.NS_WSU200207, "Id"}};

    public static String getIdAttributeName(Element element) {
        int n;
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        for (n = 0; n < KNOWN_IDATTRS.length; ++n) {
            if (!KNOWN_IDATTRS[n][0].equals(string) || !"*".equals(KNOWN_IDATTRS[n][1]) && !KNOWN_IDATTRS[n][1].equals(string2) || !element.hasAttribute(KNOWN_IDATTRS[n][2])) continue;
            return KNOWN_IDATTRS[n][2];
        }
        for (n = 0; n < KNOWN_GLOBAL_IDATTRS.length; ++n) {
            Attr attr = element.getAttributeNodeNS(KNOWN_GLOBAL_IDATTRS[n][0], KNOWN_GLOBAL_IDATTRS[n][1]);
            if (attr == null) continue;
            return attr.getNodeName();
        }
        return null;
    }

    private static boolean matchId(Element element, String string, boolean bl) {
        if (bl) {
            return string.equals(NamespaceUtil.getWsuAttribute(element, "Id"));
        }
        String string2 = IdUtil.getIdAttributeName(element);
        return string2 != null && string.equals(element.getAttribute(string2));
    }

    public Element resolveID(Document document, String string) {
        return this.resolveId0(document, string, false);
    }

    public boolean findWsuId(Document document, String string) {
        return this.resolveId0(document, string, true) != null;
    }

    private Element resolveId0(Document document, String string, boolean bl) {
        if (document == null) {
            return null;
        }
        Element element = document.getElementById(string);
        if (element != null) {
            return element;
        }
        return this.resolve(document.getDocumentElement(), string, bl);
    }

    private Element resolve(Node node, String string, boolean bl) {
        if (node.getNodeType() == 1 && IdUtil.matchId((Element)node, string, bl)) {
            return (Element)node;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 && node2.getNodeType() != 5 || (element = this.resolve(node2, string, bl)) == null) continue;
            return element;
        }
        return null;
    }
}

