/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPHeaderElementProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static boolean isWsse(String string) {
        if (string == null) {
            return false;
        }
        return NamespaceUtil.compareNS(string.intern(), 0);
    }

    public static boolean isWsu(String string) {
        if (string == null) {
            return false;
        }
        return NamespaceUtil.compareNS(string.intern(), 1);
    }

    public static String getCorrespondingWSUNS(String string) {
        String string2 = string.intern();
        String string3 = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            if (string2 != Constants.NAMESPACES[0][i] || i >= Constants.NAMESPACES[1].length) continue;
            string3 = Constants.NAMESPACES[1][i];
        }
        return string3;
    }

    public static boolean validate(MessageContextProxy messageContextProxy) {
        int n;
        String string;
        String string2 = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace");
        int n2 = -1;
        int n3 = -1;
        if (string2 != null) {
            string2 = string2.intern();
            for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
                if (string2 != Constants.NAMESPACES[1][i]) continue;
                n3 = i;
            }
        }
        if ((string = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) != null) {
            string = string.intern();
            for (n = 0; n < Constants.NAMESPACES[0].length; ++n) {
                if (string != Constants.NAMESPACES[0][n]) continue;
                n2 = n;
            }
        }
        n = 0;
        if (n3 != -1) {
            n = n2 == n3 ? 1 : 0;
        } else if (n2 == Constants.NAMESPACES[0].length) {
            n = 1;
        }
        return n != 0;
    }

    public static NodeList getWsseElementsByTagName(Element element, String string) {
        return NamespaceUtil.getXElementsByTagName(element, string, 0);
    }

    private static NodeList getXElementsByTagName(Element element, String string, int n) {
        NodeList nodeList = null;
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            nodeList = element.getElementsByTagNameNS(Constants.NAMESPACES[n][i], string);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            return nodeList;
        }
        return nodeList;
    }

    public static NodeList getWsuElementsByTagName(Element element, String string) {
        return NamespaceUtil.getXElementsByTagName(element, string, 1);
    }

    public static Element getFirstChildWsseElement(Element element, String string) {
        Element element2 = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            element2 = DOMUtil.getFirstChildElement(element, Constants.NAMESPACES[0][i], string);
            if (element2 == null) continue;
            return element2;
        }
        return element2;
    }

    public static Element getFirstChildWsuElement(Element element, String string) {
        Element element2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            element2 = DOMUtil.getFirstChildElement(element, Constants.NAMESPACES[1][i], string);
            if (element2 == null) continue;
            return element2;
        }
        return element2;
    }

    public static SOAPHeaderElementProxy getWsseHeaderByName(SOAPEnvelopeProxy sOAPEnvelopeProxy, String string, boolean bl) throws FaultProxy {
        return NamespaceUtil.findHeader(sOAPEnvelopeProxy, string, bl, 0);
    }

    public static SOAPHeaderElementProxy getWsuHeaderByName(SOAPEnvelopeProxy sOAPEnvelopeProxy, String string, boolean bl) throws FaultProxy {
        return NamespaceUtil.findHeader(sOAPEnvelopeProxy, string, bl, 1);
    }

    private static SOAPHeaderElementProxy findHeader(SOAPEnvelopeProxy sOAPEnvelopeProxy, String string, boolean bl, int n) throws FaultProxy {
        SOAPHeaderElementProxy sOAPHeaderElementProxy = null;
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            sOAPHeaderElementProxy = sOAPEnvelopeProxy.getHeaderByName(Constants.NAMESPACES[n][i], string, bl);
            if (sOAPHeaderElementProxy == null) continue;
            return sOAPHeaderElementProxy;
        }
        return sOAPHeaderElementProxy;
    }

    public static String getWsuAttribute(Element element, String string) {
        String string2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            string2 = element.getAttributeNS(Constants.NAMESPACES[1][i], string);
            if (string2.length() == 0) continue;
            return string2;
        }
        return string2;
    }

    public static boolean equals(QName qName, QName qName2) {
        String string;
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName2.equals(qName)) {
            return true;
        }
        String string2 = qName.getLocalPart();
        if (string2 != (string = qName2.getLocalPart())) {
            return false;
        }
        String string3 = qName.getNamespaceURI();
        String string4 = qName2.getNamespaceURI();
        return string4 == Constants.NAMESPACES[0][0] ? NamespaceUtil.compareNS(string3, 0) : string4 == Constants.NAMESPACES[1][0] && NamespaceUtil.compareNS(string3, 1);
    }

    private static boolean compareNS(String string, int n) {
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            if (string != Constants.NAMESPACES[n][i]) continue;
            return true;
        }
        return false;
    }
}

