/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.latin;

import com.ibm.xml.b2b.scan.DTDParams;
import com.ibm.xml.b2b.scan.ExternalSubsetHandler;
import com.ibm.xml.b2b.scan.latin.LatinMarkupDeclScanner;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class LatinExternalSubsetScanner
extends LatinMarkupDeclScanner {
    private static final int ENTITYSTATE_DTD_EXTERNAL_SUBSET = 0;
    private static final int ENTITYSTATE_PE_BETWEEN_MARKUP = 1;
    private static final int ENTITYSTATE_PE_WITHIN_MARKUP = 2;
    private ExternalSubsetHandler fHandler;
    private DTDParams fDTDParams;
    private ParsedEntity fEntityContent;
    private byte[] fData;
    private int fCurrentOffset;
    private int fEntityDepth;
    private DTDParams[] fDTDParamsStack;
    private ParsedEntity[] fEntityContentStack;
    private byte[][] fDataStack;
    private int[] fCurrentOffsetStack;
    private int fEntityState;
    private int fIncludeSectDepth;
    private int fMarkupDepth;
    private int[] fEntityStateStack;

    public LatinExternalSubsetScanner(ExternalSubsetHandler externalSubsetHandler) {
        this.fHandler = externalSubsetHandler;
        this.fCurrentOffset = -1;
        this.fEntityState = -1;
        this.fDTDParamsStack = new DTDParams[4];
        this.fEntityContentStack = new ParsedEntity[4];
        this.fDataStack = new byte[4][];
        this.fCurrentOffsetStack = new int[4];
        this.fEntityStateStack = new int[4];
    }

    public void reset(boolean bl) {
        this.fIncludeSectDepth = 0;
        this.fMarkupDepth = 0;
        this.fEntityDepth = 0;
    }

    public boolean scanExternalSubset(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 0);
        bl = this.scanExtSubsetDecl();
        this.endExternalSubset();
        return bl;
    }

    public boolean scanExtSubsetDecl(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 1);
        bl = this.scanExtSubsetDecl();
        this.endPEReferenceBetweenMarkup();
        return bl;
    }

    public boolean scanPEWithinMarkup(DTDParams dTDParams, ParsedEntity parsedEntity) {
        this.setupContext(dTDParams, parsedEntity, 2);
        return true;
    }

    private void setupContext(DTDParams dTDParams, ParsedEntity parsedEntity, int n) {
        if (this.fEntityDepth > 0) {
            int n2 = this.fEntityDepth - 1;
            if (n2 == this.fDTDParamsStack.length) {
                this.growContext();
            }
            if (this.fEntityContent.bytes != this.fData || this.fEntityContent.offset != this.fCurrentOffset) {
                throw new RuntimeException("LatinExternalSubsetScanner#setupContext()");
            }
            this.fDTDParamsStack[n2] = this.fDTDParams;
            this.fEntityContentStack[n2] = this.fEntityContent;
            this.fDataStack[n2] = this.fData;
            this.fCurrentOffsetStack[n2] = this.fCurrentOffset;
            this.fEntityStateStack[n2] = this.fEntityState;
        }
        this.fDTDParams = dTDParams;
        this.fEntityContent = parsedEntity;
        this.fData = parsedEntity.bytes;
        this.fCurrentOffset = parsedEntity.offset;
        this.fEntityState = n;
        ++this.fEntityDepth;
    }

    private boolean scanExtSubsetDecl() {
        int n = this.fEntityDepth;
        while (true) {
            byte by = this.fData[this.fCurrentOffset];
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                by = this.fData[++this.fCurrentOffset];
            }
            if (by == 60) {
                ++this.fCurrentOffset;
                ++this.fMarkupDepth;
                if (!this.scanMarkupDecl()) {
                    return false;
                }
                --this.fMarkupDepth;
                continue;
            }
            if (by == 37) {
                XMLName xMLName = this.fDTDParams.getPEName();
                xMLName.offset = ++this.fCurrentOffset;
                while (by != 59) {
                    by = this.fData[++this.fCurrentOffset];
                }
                xMLName.endOffset = this.fCurrentOffset++;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fHandler.externalSubsetPEReference(xMLName);
                this.fCurrentOffset = this.fEntityContent.offset;
                this.fDTDParams.resetPEName();
                continue;
            }
            if (by == 93) {
                this.fCurrentOffset += 3;
                --this.fIncludeSectDepth;
                continue;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (this.fEntityDepth == n) {
                return true;
            }
            this.endOfContentWithinMarkup();
            this.fDTDParams.resetPEReferenceName();
        }
    }

    private boolean scanMarkupDecl() {
        byte by = this.fData[this.fCurrentOffset];
        if (by == 33) {
            if ((by = this.fData[++this.fCurrentOffset]) == 69 && this.fData[this.fCurrentOffset + 1] == 76 && this.fData[this.fCurrentOffset + 2] == 69 && this.fData[this.fCurrentOffset + 3] == 77 && this.fData[this.fCurrentOffset + 4] == 69 && this.fData[this.fCurrentOffset + 5] == 78 && this.fData[this.fCurrentOffset + 6] == 84) {
                this.fCurrentOffset += 7;
                this.scanElementDecl();
                return true;
            }
            if (by == 65 && this.fData[this.fCurrentOffset + 1] == 84 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 83 && this.fData[this.fCurrentOffset + 6] == 84) {
                this.fCurrentOffset += 7;
                return this.scanAttlistDecl();
            }
            if (by == 69 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 73 && this.fData[this.fCurrentOffset + 4] == 84 && this.fData[this.fCurrentOffset + 5] == 89) {
                this.fCurrentOffset += 6;
                return this.scanEntityDecl();
            }
            if (by == 78 && this.fData[this.fCurrentOffset + 1] == 79 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 65 && this.fData[this.fCurrentOffset + 4] == 84 && this.fData[this.fCurrentOffset + 5] == 73 && this.fData[this.fCurrentOffset + 6] == 79 && this.fData[this.fCurrentOffset + 7] == 78) {
                this.fCurrentOffset += 8;
                this.scanNotationDecl();
                return true;
            }
            if (by == 45) {
                this.fCurrentOffset += 2;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fCurrentOffset = LatinMarkupDeclScanner.scanComment(this.fHandler, this.fDTDParams, this.fEntityContent);
                return true;
            }
            ++this.fCurrentOffset;
            int n = this.fEntityDepth;
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            if (by == 73 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 67 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 85 && this.fData[this.fCurrentOffset + 5] == 68 && this.fData[this.fCurrentOffset + 6] == 69) {
                this.fCurrentOffset += 7;
                this.checkForPEReference();
                if (this.fEntityDepth != n) {
                    // empty if block
                }
                ++this.fCurrentOffset;
                ++this.fIncludeSectDepth;
                return true;
            }
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            ++this.fCurrentOffset;
            this.scanIgnoreSectContents();
            return true;
        }
        this.fEntityContent.offset = ++this.fCurrentOffset;
        this.fCurrentOffset = LatinMarkupDeclScanner.scanPI(this.fHandler, this.fDTDParams, this.fEntityContent);
        return true;
    }

    private void scanIgnoreSectContents() {
        int n = 1;
        while (true) {
            byte by;
            if ((by = this.fData[this.fCurrentOffset]) == 60 && this.fData[this.fCurrentOffset + 1] == 33 && this.fData[this.fCurrentOffset + 2] == 91) {
                this.fCurrentOffset += 3;
                ++n;
                continue;
            }
            if (by == 93 && this.fData[this.fCurrentOffset + 1] == 93 && this.fData[this.fCurrentOffset + 2] == 62) {
                this.fCurrentOffset += 3;
                if (--n != 0) continue;
                return;
            }
            ++this.fCurrentOffset;
        }
    }

    private void scanElementDecl() {
        byte by;
        this.checkForPEReference();
        QName qName = this.fDTDParams.getElementType();
        qName.offset = this.fCurrentOffset;
        do {
            if ((by = this.fData[++this.fCurrentOffset]) != 58) continue;
            qName.sepOffset = this.fCurrentOffset++;
            by = this.fData[this.fCurrentOffset];
        } while (by != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0);
        qName.endOffset = this.fCurrentOffset;
        this.fHandler.startElementDecl(qName);
        this.checkForPEReference();
        by = this.fData[this.fCurrentOffset];
        if (by == 65) {
            this.fCurrentOffset += 3;
            this.fHandler.contentModelANY();
        } else if (by == 69) {
            this.fCurrentOffset += 5;
            this.fHandler.contentModelEMPTY();
        } else {
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            if (by == 35 && this.fData[this.fCurrentOffset + 1] == 80 && this.fData[this.fCurrentOffset + 2] == 67 && this.fData[this.fCurrentOffset + 3] == 68 && this.fData[this.fCurrentOffset + 4] == 65 && this.fData[this.fCurrentOffset + 5] == 84 && this.fData[this.fCurrentOffset + 6] == 65) {
                this.fCurrentOffset += 7;
                this.fHandler.contentModelPCDATA();
                this.scanMixed();
            } else {
                this.scanChildren(1);
            }
        }
        this.checkForPEReference();
        ++this.fCurrentOffset;
        this.fHandler.endElementDecl();
        this.fDTDParams.resetElementType();
    }

    private void scanMixed() {
        while (true) {
            this.checkForPEReference();
            byte by = this.fData[this.fCurrentOffset];
            if (by == 41) {
                by = this.fData[++this.fCurrentOffset];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (by == 42) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                }
                return;
            }
            this.fHandler.contentModelSeparator(0);
            this.checkForPEReference();
            QName qName = this.fDTDParams.getContentModelElement();
            qName.offset = ++this.fCurrentOffset;
            do {
                if ((by = this.fData[++this.fCurrentOffset]) != 58) continue;
                qName.sepOffset = this.fCurrentOffset++;
                by = this.fData[this.fCurrentOffset];
            } while (by != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0 && by != 124 && by != 41);
            qName.endOffset = this.fCurrentOffset;
            this.fHandler.contentModelElement(qName);
            this.fDTDParams.resetContentModelElement();
        }
    }

    private void scanChildren(int n) {
        while (true) {
            this.scanCp(n);
            this.checkForPEReference();
            byte by = this.fData[this.fCurrentOffset];
            if (by == 41) {
                by = this.fData[++this.fCurrentOffset];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (by == 63) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(0);
                } else if (by == 42) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                } else if (by == 43) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(2);
                }
                return;
            }
            ++this.fCurrentOffset;
            if (by == 124) {
                this.fHandler.contentModelSeparator(0);
            } else {
                this.fHandler.contentModelSeparator(1);
            }
            this.checkForPEReference();
        }
    }

    private void scanCp(int n) {
        byte by;
        if (this.fData[this.fCurrentOffset] == 40) {
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            this.checkForPEReference();
            this.scanChildren(n + 1);
            return;
        }
        QName qName = this.fDTDParams.getContentModelElement();
        qName.offset = this.fCurrentOffset;
        do {
            if ((by = this.fData[++this.fCurrentOffset]) != 58) continue;
            qName.sepOffset = this.fCurrentOffset++;
            by = this.fData[this.fCurrentOffset];
        } while (by != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0 && by != 124 && by != 44 && by != 41 && by != 63 && by != 42 && by != 43);
        qName.endOffset = this.fCurrentOffset++;
        this.fHandler.contentModelElement(qName);
        this.fDTDParams.resetContentModelElement();
        if (by == 63) {
            this.fHandler.contentModelOccurrence(0);
        } else if (by == 42) {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(1);
        } else if (by == 43) {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(2);
        }
    }

    private boolean scanAttlistDecl() {
        byte by;
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        this.checkForPEReference();
        QName qName = this.fDTDParams.getElementType();
        qName.offset = this.fCurrentOffset;
        do {
            if ((by = this.fData[++this.fCurrentOffset]) != 58) continue;
            qName.sepOffset = this.fCurrentOffset++;
            by = this.fData[this.fCurrentOffset];
        } while (by != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0);
        qName.endOffset = this.fCurrentOffset;
        this.fHandler.startAttlistDecl(qName);
        while (true) {
            boolean bl;
            XMLString xMLString;
            XMLString xMLString2;
            boolean bl2;
            this.checkForPEReference();
            if (this.fData[this.fCurrentOffset] == 62) break;
            DTDParams dTDParams3 = this.fDTDParams;
            QName qName2 = dTDParams3.getAttributeName();
            qName2.offset = this.fCurrentOffset;
            do {
                if ((by = this.fData[++this.fCurrentOffset]) != 58) continue;
                qName2.sepOffset = this.fCurrentOffset++;
                by = this.fData[this.fCurrentOffset];
            } while (by != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0);
            qName2.endOffset = this.fCurrentOffset;
            this.checkForPEReference();
            boolean bl3 = bl2 = this.fData[this.fCurrentOffset] == 40;
            if (!bl2) {
                bl2 = this.fData[this.fCurrentOffset + 1] == 79;
                dTDParams = this.fDTDParams;
                xMLString2 = dTDParams.getAttributeType();
                xMLString2.offset = this.fCurrentOffset;
                while ((by = this.fData[++this.fCurrentOffset]) != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0) {
                }
                xMLString2.endOffset = this.fCurrentOffset;
                if (bl2) {
                    this.checkForPEReference();
                }
            } else {
                xMLString2 = null;
            }
            this.fHandler.startAttDef(qName2, xMLString2);
            if (bl2) {
                this.fHandler.startEnumerationType();
                do {
                    this.checkForPEReference();
                    XMLString xMLString3 = this.fDTDParams.getEnumerationTypeToken();
                    xMLString3.offset = ++this.fCurrentOffset;
                    while ((by = this.fData[++this.fCurrentOffset]) != 32 && by != 10 && by != 9 && by != 13 && by != 37 && by != 0 && by != 124 && by != 41) {
                    }
                    xMLString3.endOffset = this.fCurrentOffset;
                    this.fHandler.enumerationType(xMLString3);
                    this.fDTDParams.resetEnumerationTypeToken();
                    this.checkForPEReference();
                } while ((by = this.fData[this.fCurrentOffset]) != 41);
                ++this.fCurrentOffset;
                this.fHandler.endEnumerationType();
            }
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            if (by == 35) {
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getAttributeDefaultType();
                xMLString.offset = this.fCurrentOffset++;
                by = this.fData[this.fCurrentOffset];
                if (by == 70 && this.fData[this.fCurrentOffset + 1] == 73 && this.fData[this.fCurrentOffset + 2] == 88 && this.fData[this.fCurrentOffset + 3] == 69 && this.fData[this.fCurrentOffset + 4] == 68) {
                    this.fCurrentOffset += 5;
                    xMLString.endOffset = this.fCurrentOffset;
                    this.checkForPEReference();
                    bl = true;
                    by = this.fData[this.fCurrentOffset];
                } else {
                    this.fCurrentOffset = by == 73 && this.fData[this.fCurrentOffset + 1] == 77 && this.fData[this.fCurrentOffset + 2] == 80 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 69 && this.fData[this.fCurrentOffset + 6] == 68 ? (this.fCurrentOffset += 7) : (this.fCurrentOffset += 8);
                    xMLString.endOffset = this.fCurrentOffset;
                    bl = false;
                    by = this.fData[this.fCurrentOffset];
                }
            } else {
                xMLString = null;
                bl = true;
            }
            if (bl) {
                byte by2 = by;
                this.fHandler.startDefaultAttValue();
                this.fEntityContent.offset = ++this.fCurrentOffset;
                if (!LatinMarkupDeclScanner.scanDefaultAttValue(this.fHandler, this.fDTDParams, this.fEntityContent, by2)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
            }
            this.fHandler.endAttDef(xMLString);
            dTDParams3.resetAttributeName();
            if (xMLString2 != null) {
                dTDParams.resetAttributeType();
            }
            if (xMLString == null) continue;
            dTDParams2.resetAttributeDefaultType();
        }
        ++this.fCurrentOffset;
        this.fHandler.endAttlistDecl();
        this.fDTDParams.resetElementType();
        return true;
    }

    private boolean scanEntityDecl() {
        XMLString xMLString;
        byte by;
        boolean bl;
        DTDParams dTDParams = null;
        boolean bl2 = false;
        byte by2 = this.fData[this.fCurrentOffset];
        if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            while ((by2 = this.fData[++this.fCurrentOffset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            }
            if (by2 != 37) {
                bl = false;
            } else if ((by2 = this.fData[++this.fCurrentOffset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                by2 = this.fData[++this.fCurrentOffset];
                this.checkForPEReference();
                bl = true;
            } else if (by2 == 37) {
                this.checkForPEReference();
                bl = true;
            } else {
                bl2 = true;
                bl = false;
            }
        } else {
            by2 = this.fData[++this.fCurrentOffset];
            bl2 = true;
            bl = false;
        }
        if (bl2) {
            while (true) {
                XMLName xMLName = this.fDTDParams.getPEReferenceName();
                xMLName.offset = ++this.fCurrentOffset;
                while (by2 != 59) {
                    by2 = this.fData[++this.fCurrentOffset];
                }
                xMLName.endOffset = this.fCurrentOffset++;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
                this.fCurrentOffset = this.fEntityContent.offset;
                while (true) {
                    by2 = this.fData[this.fCurrentOffset];
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        by2 = this.fData[++this.fCurrentOffset];
                    }
                    this.fEntityContent.offset = this.fCurrentOffset;
                    if (by2 != 0 || this.fCurrentOffset != this.fEntityContent.endOffset) break;
                    this.endOfContentWithinMarkup();
                    this.fDTDParams.resetPEReferenceName();
                }
                if (by2 != 37) break;
                ++this.fCurrentOffset;
                if (bl) continue;
                by2 = this.fData[this.fCurrentOffset];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    ++this.fCurrentOffset;
                    this.checkForPEReference();
                    bl = true;
                    break;
                }
                bl = by2 == 37;
                if (!bl) continue;
            }
        }
        DTDParams dTDParams2 = this.fDTDParams;
        XMLName xMLName = dTDParams2.getEntityDeclName();
        xMLName.offset = this.fCurrentOffset;
        while ((by2 = this.fData[++this.fCurrentOffset]) != 32 && by2 != 10 && by2 != 9 && by2 != 13 && by2 != 37 && by2 != 0) {
        }
        xMLName.endOffset = this.fCurrentOffset;
        this.checkForPEReference();
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 34 || by2 == 39) {
            byte by3 = by2;
            ++this.fCurrentOffset;
            this.fHandler.startEntityValue();
            this.fEntityContent.offset = this.fCurrentOffset;
            if (!LatinMarkupDeclScanner.scanEntityValue(this.fHandler, this.fDTDParams, this.fEntityContent, by3)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            this.checkForPEReference();
            by2 = this.fData[this.fCurrentOffset];
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.internalPEDecl(xMLName);
            } else {
                this.fHandler.internalEntityDecl(xMLName);
            }
            dTDParams2.resetEntityDeclName();
            return true;
        }
        if (by2 == 80 && this.fData[this.fCurrentOffset + 1] == 85 && this.fData[this.fCurrentOffset + 2] == 66 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 67) {
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            by2 = this.fData[++this.fCurrentOffset];
            dTDParams = this.fDTDParams;
            xMLString = dTDParams.getPublicID();
            xMLString.offset = this.fCurrentOffset;
            while (by2 != by) {
                by2 = this.fData[++this.fCurrentOffset];
            }
            xMLString.endOffset = this.fCurrentOffset++;
        } else {
            this.fCurrentOffset += 6;
            xMLString = null;
        }
        this.checkForPEReference();
        by = this.fData[this.fCurrentOffset];
        by2 = this.fData[++this.fCurrentOffset];
        DTDParams dTDParams3 = this.fDTDParams;
        XMLString xMLString2 = dTDParams3.getSystemID();
        xMLString2.offset = this.fCurrentOffset;
        while (by2 != by) {
            by2 = this.fData[++this.fCurrentOffset];
        }
        xMLString2.endOffset = this.fCurrentOffset++;
        this.checkForPEReference();
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 62) {
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.externalPEDecl(xMLName, xMLString, xMLString2);
            } else {
                this.fHandler.externalEntityDecl(xMLName, xMLString, xMLString2);
            }
        } else {
            this.fCurrentOffset += 5;
            this.checkForPEReference();
            DTDParams dTDParams4 = this.fDTDParams;
            XMLName xMLName2 = dTDParams4.getNotationName();
            xMLName2.offset = this.fCurrentOffset;
            while ((by2 = this.fData[++this.fCurrentOffset]) != 32 && by2 != 10 && by2 != 9 && by2 != 13 && by2 != 37 && by2 != 0 && by2 != 62) {
            }
            xMLName2.endOffset = this.fCurrentOffset++;
            this.checkForPEReference();
            this.fHandler.unparsedEntityDecl(xMLName, xMLString, xMLString2, xMLName2);
            dTDParams4.resetNotationName();
        }
        dTDParams2.resetEntityDeclName();
        if (xMLString != null) {
            dTDParams.resetPublicID();
        }
        dTDParams3.resetSystemID();
        return true;
    }

    private void scanNotationDecl() {
        XMLString xMLString;
        XMLString xMLString2;
        byte by;
        byte by2;
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        this.checkForPEReference();
        DTDParams dTDParams3 = this.fDTDParams;
        XMLName xMLName = dTDParams3.getNotationName();
        xMLName.offset = this.fCurrentOffset;
        while ((by2 = this.fData[++this.fCurrentOffset]) != 32 && by2 != 10 && by2 != 9 && by2 != 13 && by2 != 37 && by2 != 0) {
        }
        xMLName.endOffset = this.fCurrentOffset;
        this.checkForPEReference();
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 80 && this.fData[this.fCurrentOffset + 1] == 85 && this.fData[this.fCurrentOffset + 2] == 66 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 67) {
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            by2 = this.fData[++this.fCurrentOffset];
            dTDParams = this.fDTDParams;
            xMLString2 = dTDParams.getPublicID();
            xMLString2.offset = this.fCurrentOffset;
            while (by2 != by) {
                by2 = this.fData[++this.fCurrentOffset];
            }
            xMLString2.endOffset = this.fCurrentOffset++;
        } else {
            this.fCurrentOffset += 6;
            xMLString2 = null;
        }
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 62) {
            xMLString = null;
        } else {
            this.checkForPEReference();
            by = this.fData[this.fCurrentOffset];
            if (by == 34 || by == 39) {
                by2 = this.fData[++this.fCurrentOffset];
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getSystemID();
                xMLString.offset = this.fCurrentOffset;
                while (by2 != by) {
                    by2 = this.fData[++this.fCurrentOffset];
                }
                xMLString.endOffset = this.fCurrentOffset++;
            } else {
                xMLString = null;
            }
        }
        this.checkForPEReference();
        ++this.fCurrentOffset;
        this.fHandler.notationDecl(xMLName, xMLString2, xMLString);
        dTDParams3.resetNotationName();
        if (xMLString2 != null) {
            dTDParams.resetPublicID();
        }
        if (xMLString != null) {
            dTDParams2.resetSystemID();
        }
    }

    private void checkForPEReference() {
        while (true) {
            byte by = this.fData[this.fCurrentOffset];
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                by = this.fData[++this.fCurrentOffset];
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (by == 0 && this.fCurrentOffset == this.fEntityContent.endOffset) {
                this.endOfContentWithinMarkup();
                this.fDTDParams.resetPEReferenceName();
                continue;
            }
            if (by != 37) {
                return;
            }
            XMLName xMLName = this.fDTDParams.getPEReferenceName();
            xMLName.offset = ++this.fCurrentOffset;
            while (by != 59) {
                by = this.fData[++this.fCurrentOffset];
            }
            xMLName.endOffset = this.fCurrentOffset++;
            this.fEntityContent.offset = this.fCurrentOffset;
            this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
        }
    }

    private void endExternalSubset() {
        --this.fEntityDepth;
    }

    private void endPEReferenceBetweenMarkup() {
        --this.fEntityDepth;
        if (this.fEntityDepth > 0) {
            int n = this.fEntityDepth - 1;
            this.fDTDParams = this.fDTDParamsStack[n];
            this.fEntityContent = this.fEntityContentStack[n];
            this.fData = this.fDataStack[n];
            this.fCurrentOffset = this.fCurrentOffsetStack[n];
            this.fEntityState = this.fEntityStateStack[n];
        }
    }

    private void endOfContentWithinMarkup() {
        --this.fEntityDepth;
        this.fHandler.endPEReferenceWithinMarkup(this.fMarkupDepth);
        int n = this.fEntityDepth - 1;
        this.fDTDParams = this.fDTDParamsStack[n];
        this.fEntityContent = this.fEntityContentStack[n];
        this.fData = this.fDataStack[n];
        this.fCurrentOffset = this.fCurrentOffsetStack[n];
        this.fEntityState = this.fEntityStateStack[n];
    }

    private void growContext() {
        int n = this.fEntityDepth - 1;
        int n2 = n << 1;
        DTDParams[] dTDParamsArray = new DTDParams[n2];
        System.arraycopy(this.fDTDParamsStack, 0, dTDParamsArray, 0, n);
        this.fDTDParamsStack = dTDParamsArray;
        ParsedEntity[] parsedEntityArray = new ParsedEntity[n2];
        System.arraycopy(this.fEntityContentStack, 0, parsedEntityArray, 0, n);
        this.fEntityContentStack = parsedEntityArray;
        byte[][] byArrayArray = new byte[n2][];
        System.arraycopy(this.fDataStack, 0, byArrayArray, 0, n);
        this.fDataStack = byArrayArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.fCurrentOffsetStack, 0, nArray, 0, n);
        this.fCurrentOffsetStack = nArray;
        nArray = new int[n2];
        System.arraycopy(this.fEntityStateStack, 0, nArray, 0, n);
        this.fEntityStateStack = nArray;
    }

    private LatinExternalSubsetScanner() {
    }
}

