/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.RemoteAdminService;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.management.event.ClientNotificationService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class AdminServiceImpl
implements AdminService,
RemoteAdminService {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)resBundleName);
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$AdminServiceImpl == null ? (class$com$ibm$ws$management$AdminServiceImpl = AdminServiceImpl.class$("com.ibm.ws.management.AdminServiceImpl")) : class$com$ibm$ws$management$AdminServiceImpl), (String)"Admin", (String)resBundleName);
    private NotificationService notificationService;
    private ClientNotificationService localNotificationService;
    private final String WAS_DOMAIN = "WebSphere";
    private String domainName = null;
    private String cellName = null;
    private String nodeName = null;
    private String processName = null;
    private final Session session = new Session();
    private String adminType = "ManagedProcess";
    private ObjectName serverMBean = null;
    private MBeanFactoryImpl mbeanFactory = new MBeanFactoryImpl(this.getDomainName());
    private MBeanServer _mbServer = this.mbeanFactory.getMBeanServer();
    static /* synthetic */ Class class$com$ibm$ws$management$AdminServiceImpl;

    public AdminServiceImpl() {
        this.notificationService = new NotificationService(this._mbServer);
    }

    public MBeanFactory getMBeanFactory() {
        return this.mbeanFactory;
    }

    protected void setCellName(String string) {
        this.cellName = string;
    }

    public String getCellName() {
        return this.cellName;
    }

    protected void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected void setProcessName(String string) {
        this.processName = string;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Session isAlive() {
        return this.session;
    }

    public String getJvmType() {
        return AdminHelper.getPlatformHelper().getJvmType();
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMBean");
        }
        ObjectInstance objectInstance = this._mbServer.createMBean(string, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createMBean");
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMBean");
        }
        ObjectInstance objectInstance = this._mbServer.createMBean(string, objectName, objectName2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createMBean");
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMBean");
        }
        ObjectInstance objectInstance = this._mbServer.createMBean(string, objectName, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createMBean");
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMBean");
        }
        ObjectInstance objectInstance = this._mbServer.createMBean(string, objectName, objectName2, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createMBean");
        }
        return objectInstance;
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerMBean", (Object)objectName);
        }
        ObjectInstance objectInstance = this._mbServer.registerMBean(object, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerMBean");
        }
        return objectInstance;
    }

    public String getDomainName() {
        if (this.domainName == null) {
            this.domainName = "WebSphere";
        }
        return this.domainName;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterMBean");
        }
        this._mbServer.unregisterMBean(objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterMBean");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        Set<Object> set;
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"queryNames", (Object)objectName);
            }
            set = new HashSet();
            String string = null;
            RoutingGuide routingGuide = null;
            boolean bl = false;
            if (objectName == null) {
                string = "*";
                bl = true;
            } else {
                routingGuide = new RoutingGuide(objectName, true);
                if (routingGuide.eligible()) {
                    string = routingGuide.getRoutingKey();
                    bl = routingGuide.includeSelf();
                } else {
                    string = null;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
            }
            if (string == null) {
                set = this._mbServer.queryNames(objectName, queryExp);
            } else if (!string.equals("*")) {
                if (bl) {
                    set = this._mbServer.queryNames(objectName, queryExp);
                }
                if (RoutingTable.getInstance().isRoutable(string)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("remote queryNames: " + string));
                        }
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                        Set set2 = adminClient.queryNames(objectName, queryExp);
                        if (set == null || set.isEmpty()) {
                            set = set2;
                        } else if (set2 != null && !set2.isEmpty()) {
                            set.addAll(set2);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.AdminServiceImpl.queryNames", (String)"284", (Object)objectName);
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug((TraceComponent)tc, (String)"error while doing remote queryNames", (Object)exception);
                    }
                }
            } else {
                if (bl) {
                    set = this._mbServer.queryNames(objectName, queryExp);
                }
                AdminClient[] adminClientArray = RoutingTable.getInstance().getAdminClients();
                for (int i = 0; i < adminClientArray.length; ++i) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"remote queryNames");
                        }
                        Set set3 = adminClientArray[i].queryNames(objectName, queryExp);
                        if (set == null || set.isEmpty()) {
                            set = set3;
                            continue;
                        }
                        if (set3 == null || set3.isEmpty()) continue;
                        set.addAll(set3);
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.AdminServiceImpl.queryNames", (String)"261", (Object)objectName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"error while doing remote queryNames", (Object)exception);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryNames");
        }
        return set;
    }

    public boolean isRegistered(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isRegistered", (Object)objectName);
        }
        boolean bl = false;
        if (objectName == null) {
            return false;
        }
        RoutingGuide routingGuide = new RoutingGuide(objectName, false);
        String string = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
        }
        if (string == null) {
            bl = this._mbServer.isRegistered(objectName);
        } else if (RoutingTable.getInstance().isRoutable(string)) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remote isRegistered: " + string));
                }
                AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                bl = adminClient.isRegistered(objectName);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.isRegistered", (String)"321", (Object)objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
            }
            bl = this._mbServer.isRegistered(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isRegistered");
        }
        return bl;
    }

    public Integer getMBeanCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMBeanCount");
        }
        Integer n = this._mbServer.getMBeanCount();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMBeanCount");
        }
        return n;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object object;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)objectName);
            }
            object = null;
            try {
                RoutingGuide routingGuide = new RoutingGuide(objectName, false);
                String string2 = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string2);
                }
                if (string2 == null) {
                    this.preInvoke(objectName, string, true);
                    object = this._mbServer.getAttribute(objectName, string);
                    break block14;
                }
                if (RoutingTable.getInstance().isRoutable(string2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remote getAttribute: " + string2));
                    }
                    try {
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string2);
                        object = adminClient.getAttribute(objectName, string);
                        break block14;
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.getAttribute", (String)"379", (Object)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                        }
                        throw new JMRuntimeException(this.connectorMsg(this.processName, string2, (Exception)((Object)connectorException)));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
                }
                this.preInvoke(objectName, string, true);
                object = this._mbServer.getAttribute(objectName, string);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"408", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0007I", (Object)((Object)new AdminException(mBeanException)));
                throw mBeanException;
            }
            catch (ReflectionException reflectionException) {
                FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"415", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0007I", (Object)((Object)new AdminException(reflectionException)));
                throw reflectionException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"422", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0007I", (Object)((Object)new AdminException(runtimeException)));
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)object);
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAttributes", (Object)objectName);
            }
            attributeList = null;
            try {
                RoutingGuide routingGuide = new RoutingGuide(objectName, false);
                String string = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
                }
                if (string == null) {
                    this.preInvoke(objectName, stringArray, true);
                    attributeList = this._mbServer.getAttributes(objectName, stringArray);
                    break block13;
                }
                if (RoutingTable.getInstance().isRoutable(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remote getAttributes: " + string));
                    }
                    try {
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                        attributeList = adminClient.getAttributes(objectName, stringArray);
                        break block13;
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.getAttributes", (String)"437", (Object)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                        }
                        throw new JMRuntimeException(this.connectorMsg(this.processName, string, (Exception)((Object)connectorException)));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
                }
                this.preInvoke(objectName, stringArray, true);
                attributeList = this._mbServer.getAttributes(objectName, stringArray);
            }
            catch (ReflectionException reflectionException) {
                FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"476", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0008I", (Object)((Object)new AdminException(reflectionException)));
                throw reflectionException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"483", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0008I", (Object)((Object)new AdminException(runtimeException)));
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes");
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setAttribute", (Object)objectName);
            }
            try {
                RoutingGuide routingGuide = new RoutingGuide(objectName, false);
                String string = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
                }
                if (string == null) {
                    this.preInvoke(objectName, attribute, false);
                    this._mbServer.setAttribute(objectName, attribute);
                    break block13;
                }
                if (RoutingTable.getInstance().isRoutable(string)) {
                    try {
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                        adminClient.setAttribute(objectName, attribute);
                        break block13;
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.setAttribute", (String)"488", (Object)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                        }
                        throw new MBeanException((Exception)((Object)connectorException), "connector malfunction");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
                }
                this.preInvoke(objectName, attribute, false);
                this._mbServer.setAttribute(objectName, attribute);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"537", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0009I", (Object)((Object)new AdminException(mBeanException)));
                throw mBeanException;
            }
            catch (ReflectionException reflectionException) {
                FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"544", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0009I", (Object)((Object)new AdminException(reflectionException)));
                throw reflectionException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"551", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0009I", (Object)((Object)new AdminException(runtimeException)));
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList2;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setAttributes", (Object)objectName);
            }
            attributeList2 = null;
            try {
                RoutingGuide routingGuide = new RoutingGuide(objectName, false);
                String string = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
                }
                if (string == null) {
                    this.preInvoke(objectName, attributeList, false);
                    attributeList2 = this._mbServer.setAttributes(objectName, attributeList);
                    break block12;
                }
                if (RoutingTable.getInstance().isRoutable(string)) {
                    try {
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                        attributeList2 = adminClient.setAttributes(objectName, attributeList);
                        break block12;
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.setAttributes", (String)"544", (Object)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                        }
                        throw new JMRuntimeException(this.connectorMsg(this.processName, string, (Exception)((Object)connectorException)));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
                }
                this.preInvoke(objectName, attributeList, false);
                attributeList2 = this._mbServer.setAttributes(objectName, attributeList);
            }
            catch (ReflectionException reflectionException) {
                FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"605", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0010I", (Object)((Object)new AdminException(reflectionException)));
                throw reflectionException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"612", (Object)this, (Object[])new Object[]{objectName});
                Tr.service((TraceComponent)tc, (String)"ADMN0010I", (Object)((Object)new AdminException(runtimeException)));
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes", (Object)attributeList2);
        }
        return attributeList2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"invoke", (Object)objectName);
            }
            object = null;
            try {
                RoutingGuide routingGuide = new RoutingGuide(objectName, false);
                String string2 = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string2);
                }
                if (string2 == null) {
                    this.preInvoke(objectName, string, stringArray, true);
                    object = this._mbServer.invoke(objectName, string, objectArray, stringArray);
                    break block18;
                }
                if (RoutingTable.getInstance().isRoutable(string2)) {
                    try {
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string2);
                        object = adminClient.invoke(objectName, string, objectArray, stringArray);
                        break block18;
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"591", (Object)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                        }
                        throw new JMRuntimeException(this.connectorMsg(this.processName, string2, (Exception)((Object)connectorException)));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
                }
                this.preInvoke(objectName, string, stringArray, true);
                object = this._mbServer.invoke(objectName, string, objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"672", (Object)this, (Object[])new Object[]{objectName});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invoke method throws exception", (Object)((Object)new AdminException(instanceNotFoundException)));
                }
                throw instanceNotFoundException;
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"679", (Object)this, (Object[])new Object[]{objectName});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invoke method throws exception", (Object)((Object)new AdminException(mBeanException)));
                }
                throw mBeanException;
            }
            catch (ReflectionException reflectionException) {
                FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"686", (Object)this, (Object[])new Object[]{objectName});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invoke method throws exception", (Object)((Object)new AdminException(reflectionException)));
                }
                throw reflectionException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.management.AdminServiceImpl.invoke", (String)"693", (Object)this, (Object[])new Object[]{objectName});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invoke method throws exception", (Object)((Object)new AdminException(runtimeException)));
                }
                throw runtimeException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke");
        }
        return object;
    }

    public String getDefaultDomain() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultDomain");
        }
        String string = this._mbServer.getDefaultDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultDomain");
        }
        return string;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMBeanInfo", (Object)objectName);
        }
        MBeanInfo mBeanInfo = null;
        RoutingGuide routingGuide = new RoutingGuide(objectName, false);
        String string = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string);
        }
        if (string == null) {
            mBeanInfo = this._mbServer.getMBeanInfo(objectName);
        } else if (RoutingTable.getInstance().isRoutable(string)) {
            try {
                AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
                mBeanInfo = adminClient.getMBeanInfo(objectName);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.getMBeanInfo", (String)"674", (Object)objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                }
                throw new JMRuntimeException(this.connectorMsg(this.processName, string, (Exception)((Object)connectorException)));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
            }
            mBeanInfo = this._mbServer.getMBeanInfo(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMBeanInfo");
        }
        return mBeanInfo;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isInstanceOf", (Object)objectName);
        }
        boolean bl = false;
        RoutingGuide routingGuide = new RoutingGuide(objectName, false);
        String string2 = routingGuide.eligible() ? routingGuide.getRoutingKey() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"routing key is: ", (Object)string2);
        }
        if (string2 == null) {
            bl = this._mbServer.isInstanceOf(objectName, string);
        } else if (RoutingTable.getInstance().isRoutable(string2)) {
            try {
                AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string2);
                bl = adminClient.isInstanceOf(objectName, string);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.AdminServiceImpl.isInstanceOf", (String)"738", (Object)objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connector problem occurs", (Object)((Object)connectorException));
                }
                throw new JMRuntimeException(this.connectorMsg(this.processName, string2, (Exception)((Object)connectorException)));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The targeted MBean is not routeable, try the local MBeanServer", (Object)objectName);
            }
            bl = this._mbServer.isInstanceOf(objectName, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isInstanceOf");
        }
        return bl;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException("Could not find " + objectName);
        }
        if (this.localNotificationService == null) {
            this.initLocalEventService();
        }
        try {
            this.localNotificationService.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void addNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (objectName == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (this.localNotificationService == null) {
            this.initLocalEventService();
        }
        try {
            this.localNotificationService.addNotificationListenerExtended(objectName, notificationListener, notificationFilter, object);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (objectName == null) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null.");
        }
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException("Could not find " + objectName);
        }
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        try {
            this.localNotificationService.removeNotificationListener(objectName, notificationListener);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void removeNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.localNotificationService == null) {
            throw new ListenerNotFoundException();
        }
        try {
            this.localNotificationService.removeNotificationListenerExtended(objectName, notificationListener);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
    }

    public void removeNotificationListenerExtended(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.removeNotificationListenerExtended(null, notificationListener);
    }

    private synchronized void initLocalEventService() {
        if (this.localNotificationService == null) {
            this.localNotificationService = new ClientNotificationService();
            this.localNotificationService.setFilterChangeListener(this.notificationService.getDownstreamServerManager());
            this.notificationService.addListener(this.localNotificationService);
        }
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) {
        return this.notificationService.addNotificationListener(consolidatedFilter, pushNotificationListener);
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ReceiverNotFoundException {
        this.notificationService.removeNotificationListener(listenerIdentifier);
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ReceiverNotFoundException {
        this.notificationService.resetFilter(listenerIdentifier, consolidatedFilter);
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ReceiverNotFoundException {
        return this.notificationService.pullNotifications(listenerIdentifier, n);
    }

    public String getProcessType() {
        return this.adminType;
    }

    public void setProcessType(String string) {
        this.adminType = string;
    }

    public ObjectName getServerMBean() {
        return this.getLocalServerMBean();
    }

    public ObjectName getLocalServer() {
        return this.getLocalServerMBean();
    }

    public void setLocalServer(ObjectName objectName) {
        this.serverMBean = objectName;
    }

    public boolean isLocalServer(String string, String string2, String string3) {
        boolean bl = false;
        ObjectNameHelper objectNameHelper = new ObjectNameHelper();
        if (ObjectNameHelper.getCellName(this.serverMBean).equals(string)) {
            if (ObjectNameHelper.getNodeName(this.serverMBean).equals(string2)) {
                if (ObjectNameHelper.getProcessName(this.serverMBean).equals(string3)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public AdminClient getDeploymentManagerAdminClient() throws AdminException {
        AdminClient adminClient = null;
        try {
            adminClient = Utils.getDmgrAdminClient();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        return adminClient;
    }

    private void preInvoke(ObjectName objectName, String string, boolean bl) throws InstanceNotFoundException, ReflectionException {
        this.preInvoke(objectName, new Attribute(string, null), bl);
    }

    private void preInvoke(ObjectName objectName, String[] stringArray, boolean bl) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            attributeList.add(new Attribute(stringArray[i], null));
        }
        this.preInvoke(objectName, attributeList, bl);
    }

    private void preInvoke(ObjectName objectName, Attribute attribute, boolean bl) throws InstanceNotFoundException, ReflectionException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"preInvoke", (Object)new Object[]{objectName, attribute, new Boolean(bl)});
        }
        if (objectName == null || attribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"null object name or attribute");
            }
            return;
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(attribute);
        this.preInvoke(objectName, attributeList, bl);
    }

    private void preInvoke(ObjectName objectName, AttributeList attributeList, boolean bl) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preInvoke", (Object)new Object[]{objectName, attributeList, new Boolean(bl)});
        }
        if (objectName == null || attributeList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"null object name or attributes");
            }
            return;
        }
        this.checkForAttrDeprecation(objectName, attributeList);
        if (!SecurityHelper.getHelper().isSecurityEnabled() || !SecurityHelper.getHelper().isSecurityServiceStarted()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"preInvoke - security not enabled");
            }
            return;
        }
        String string = ObjectNameHelper.getMBeanType(objectName);
        List list = AdminServiceFactory.getMBeanFactory().getMBeanTypes();
        if (!list.contains(string)) {
            return;
        }
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            String[] stringArray;
            Object object;
            Cloneable cloneable;
            String string2 = ((Attribute)attributeList.get(i)).getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"permission check for attribute: ", (Object)string2);
            }
            try {
                cloneable = this.getMBeanInfo(objectName);
                if (cloneable instanceof ModelMBeanInfo) {
                    object = (ModelMBeanInfo)((Object)cloneable);
                    modelMBeanAttributeInfo = object.getAttribute(string2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.AdminServiceImpl.setAttribute", (String)"1069", (Object)objectName);
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{objectName}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
            }
            if (modelMBeanAttributeInfo == null) continue;
            cloneable = modelMBeanAttributeInfo.getDescriptor();
            object = modelMBeanAttributeInfo.getType();
            String string3 = null;
            if (bl) {
                string3 = (String)cloneable.getFieldValue("getMethod");
                stringArray = new String[]{};
            } else {
                string3 = (String)cloneable.getFieldValue("setMethod");
                stringArray = new String[]{object};
            }
            if (string3 == null) continue;
            this.preInvoke(objectName, string3, stringArray, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preInvoke - granted");
        }
    }

    private void checkForAttrDeprecation(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkForAttrDeprecation");
        }
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanInfo(objectName);
        }
        catch (IntrospectionException introspectionException) {
            FFDCFilter.processException((Throwable)introspectionException, (String)"com.ibm.ws.management.AdminServiceImpl.checkForAttrDeprecation", (String)"1267", (Object)objectName);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{objectName}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = ((Attribute)iterator.next()).getName();
            ModelMBeanAttributeInfo modelMBeanAttributeInfo = null;
            try {
                if (mBeanInfo instanceof ModelMBeanInfo) {
                    modelMBeanAttributeInfo = ((ModelMBeanInfo)((Object)mBeanInfo)).getAttribute(string2);
                }
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.AdminServiceImpl.checkForAttrDeprecation", (String)"1285", (Object)objectName);
                throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{objectName}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
            }
            if (modelMBeanAttributeInfo == null || (string = (String)modelMBeanAttributeInfo.getDescriptor().getFieldValue("deprecated")) == null) continue;
            Tr.warning((TraceComponent)tc, (String)"ADMN0036W", (Object)new Object[]{string2, string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkForAttrDeprecation");
        }
    }

    private void preInvoke(ObjectName objectName, String string, String[] stringArray, boolean bl) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preInvoke", (Object)new Object[]{objectName, string, stringArray});
        }
        if (bl) {
            this.checkForOpDeprecation(objectName, string);
        }
        if (!SecurityHelper.getHelper().isSecurityEnabled() || !SecurityHelper.getHelper().isSecurityServiceStarted()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"preInvoke - security not enabled");
            }
            return;
        }
        String string2 = ObjectNameHelper.getMBeanType(objectName);
        List list = AdminServiceFactory.getMBeanFactory().getMBeanTypes();
        if (!list.contains(string2)) {
            return;
        }
        String string3 = ObjectNameHelper.getMBeanType(objectName);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(":").append(stringArray[i]);
            }
        }
        try {
            RoleBasedAuthorizer roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
            boolean bl2 = roleBasedAuthorizer.checkAccess(string3, string3, stringBuffer.toString());
            if (!bl2) {
                throw new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{string, string3}, "Access denied for the {0} operation on {1} MBean"));
            }
        }
        catch (RoleBasedAppException roleBasedAppException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"preInvoke -  denied");
            }
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0022E", new Object[]{string, string3}, "Access denied for the {0} operation on {1} MBean"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preInvoke - granted");
        }
    }

    private void checkForOpDeprecation(ObjectName objectName, String string) throws InstanceNotFoundException, ReflectionException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkForOpDeprecation");
        }
        ModelMBeanOperationInfo modelMBeanOperationInfo = null;
        try {
            object = this.getMBeanInfo(objectName);
            if (object instanceof ModelMBeanInfo) {
                modelMBeanOperationInfo = ((ModelMBeanInfo)object).getOperation(string);
            }
        }
        catch (IntrospectionException introspectionException) {
            FFDCFilter.processException((Throwable)introspectionException, (String)"com.ibm.ws.management.AdminServiceImpl.checkForOpDeprecation", (String)"1360", (Object)objectName);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{objectName}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.AdminServiceImpl.checkForOpDeprecation", (String)"1380", (Object)objectName);
            throw new JMRuntimeException(nls.getFormattedMessage("ADMN0025E", new Object[]{objectName}, "Access denied; Failed to get ModelMBeanInfo for mbean: {0}"));
        }
        if (modelMBeanOperationInfo != null && (object = (String)modelMBeanOperationInfo.getDescriptor().getFieldValue("deprecated")) != null) {
            Tr.warning((TraceComponent)tc, (String)"ADMN0037W", (Object)new Object[]{string, object});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkForOpDeprecation");
        }
    }

    private ObjectName getLocalServerMBean() {
        if (this.serverMBean == null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("WebSphere:type=Server,process=" + this.processName + ",*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            Set<ObjectName> set = null;
            set = this._mbServer.queryNames(objectName, null);
            if (!set.isEmpty()) {
                Iterator<ObjectName> iterator = set.iterator();
                this.serverMBean = iterator.next();
            }
        }
        return this.serverMBean;
    }

    private String connectorMsg(String string, String string2, Exception exception) {
        return nls.getFormattedMessage("ADMN0034E", new Object[]{string2, string, exception}, "ADMN0034E: Unable to obtain a valid admin client to connect process: \"{0}\" from process \"{1}\" due to exception: {2}");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RoutingGuide {
        ObjectName on;
        boolean allowPattern;
        boolean eligible = true;
        boolean includeSelf = false;
        String key = null;

        RoutingGuide(ObjectName objectName, boolean bl) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RoutingGuide", (Object)new Object[]{objectName, new Boolean(bl)});
            }
            this.on = objectName;
            this.allowPattern = bl;
            if (objectName.isPropertyPattern() && !bl) {
                this.eligible = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"not elligible for routing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"RoutingGuide");
                }
                return;
            }
            this.processRoutingKey();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RoutingGuide");
            }
        }

        void processRoutingKey() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"processRoutingKey");
            }
            String string = this.on.getKeyProperty("node");
            String string2 = this.on.getKeyProperty("process");
            if (AdminServiceImpl.this.adminType.equalsIgnoreCase("DeploymentManager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cellmgr routing key handling");
                }
                if (string == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no node property specified in ObjectName");
                    }
                    if (!this.on.isPropertyPattern()) {
                        this.key = null;
                        this.includeSelf = true;
                    } else {
                        this.key = "*";
                        if (string2 == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"no process property specified in ObjectName");
                            }
                            this.includeSelf = true;
                        } else if (string2.equals(AdminServiceImpl.this.processName)) {
                            this.includeSelf = true;
                            this.key = null;
                        } else {
                            this.includeSelf = false;
                        }
                    }
                } else {
                    this.key = string;
                    if (string2 == null) {
                        this.includeSelf = false;
                        if (string.equals(AdminServiceImpl.this.nodeName)) {
                            this.includeSelf = true;
                        }
                    } else if (string2.equals(AdminServiceImpl.this.processName) && string.equals(AdminServiceImpl.this.nodeName)) {
                        this.includeSelf = true;
                        this.key = null;
                    } else {
                        this.includeSelf = false;
                    }
                }
            } else if (AdminServiceImpl.this.adminType.equalsIgnoreCase("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"nodeagent routing key handling");
                }
                if (string2 == null) {
                    if (this.on.isPropertyPattern()) {
                        this.key = "*";
                        this.includeSelf = true;
                    } else {
                        this.key = null;
                        this.includeSelf = true;
                    }
                } else {
                    this.key = string2;
                    if (string2.equals(AdminServiceImpl.this.processName)) {
                        this.includeSelf = true;
                        this.key = null;
                    } else {
                        this.includeSelf = false;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processRoutingKey");
            }
        }

        boolean eligible() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("eligible: " + this.eligible));
            }
            return this.eligible;
        }

        boolean includeSelf() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("includeSelf: " + this.includeSelf));
            }
            if (this.eligible()) {
                return this.includeSelf;
            }
            return false;
        }

        String getRoutingKey() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("routing key: " + this.key));
            }
            if (this.eligible()) {
                return this.key;
            }
            return null;
        }
    }
}

