/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public final class RoutingTable
implements NotificationListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$RoutingTable == null ? (class$com$ibm$ws$management$RoutingTable = RoutingTable.class$("com.ibm.ws.management.RoutingTable")) : class$com$ibm$ws$management$RoutingTable), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static RoutingTable _instance;
    private Map _rt;
    private Map _rtStateMachine;
    private List _routingListeners;
    private RoutingListener[] listenerArray;
    private Accessor parent;
    private StateMachine parentStateMachine;
    private StateMachineCallback parentStateMachineCallback;
    private StateMachineCallback childStateMachineCallback;
    private int numMonitorThreads = 0;
    private boolean nodeAgentListenerAdded = false;
    private ServerInfo ownInfo;
    private Map agentPingThreads = new HashMap();
    public static final String[] eventNames;
    public static final String[] stateNames;
    static /* synthetic */ Class class$com$ibm$ws$management$RoutingTable;

    private RoutingTable() {
        this._rt = Collections.synchronizedMap(new HashMap());
        this._rtStateMachine = Collections.synchronizedMap(new HashMap());
        this.parentStateMachine = new StateMachine();
        this.parentStateMachineCallback = new ParentStateMachineCallback();
        this.childStateMachineCallback = new ChildStateMachineCallback();
        this._routingListeners = new ArrayList();
        this.listenerArray = new RoutingListener[0];
    }

    public static synchronized RoutingTable getInstance() {
        if (_instance == null) {
            _instance = new RoutingTable();
        }
        return _instance;
    }

    public synchronized void addRoutingListener(RoutingListener routingListener) {
        this._routingListeners.add(routingListener);
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public synchronized void removeRoutingListener(RoutingListener routingListener) {
        this._routingListeners.remove(routingListener);
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public String getProductVersion(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getServerInfo().getVersion();
        }
        return "";
    }

    public synchronized AdminClient getParent() throws ConnectorException {
        if (this.parent != null && this.parentStateMachine.getState() == 1) {
            return this.parent.getConnector();
        }
        throw new ConnectorNotAvailableException();
    }

    public boolean connectedToParent(long l) {
        while (this.parent == null && l > 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l -= 500L;
        }
        return this.parent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getSession();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(string)) {
                return this.parent.getSession();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPid(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getPid();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(string)) {
                return this.parent.getPid();
            }
            return "";
        }
    }

    public void setOwnInfo(ServerInfo serverInfo) {
        this.ownInfo = serverInfo;
    }

    public ServerInfo getOwnInfo() {
        return this.ownInfo;
    }

    public boolean isRoutable(String string) {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isRoutable", (Object)string);
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isRoutable - false");
            }
            return false;
        }
        boolean bl = accessor.isRoutable();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isRoutable: " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminClient[] getAdminClients() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAdminClients");
        }
        AdminClient[] adminClientArray = this;
        synchronized (this) {
            Accessor[] accessorArray = new Accessor[this._rt.size()];
            accessorArray = this._rt.values().toArray(accessorArray);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            adminClientArray = new AdminClient[accessorArray.length];
            for (int i = 0; i < adminClientArray.length; ++i) {
                try {
                    adminClientArray[i] = accessorArray[i].getConnector();
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.RoutingTable.getAdminClients", (String)"177", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"failed to get one AdminClient", (Object)exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAdminClients");
            }
            return adminClientArray;
        }
    }

    public AdminClient getAdminClient(String string) throws ConnectorException {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAdminClient", (Object)string);
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return accessor.getConnector();
    }

    public AdminClient getAdminClient(String string, String string2) throws ConnectorException {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAdminClient", (Object)new Object[]{string, string2});
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAdminClient");
        }
        return accessor.getConnector(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addChild", (Object)serverInfo);
        }
        try {
            Accessor accessor = new Accessor(serverInfo);
            Session session = accessor.resetSession();
            if (session == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"can't get session");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addChild", (Object)serverInfo);
                }
                return;
            }
            String string = serverInfo.getRole().equals("NodeAgent") ? serverInfo.getNode() : serverInfo.getName();
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(string);
                if (stateMachine == null) {
                    stateMachine = new StateMachine();
                    this._rtStateMachine.put(string, stateMachine);
                }
                stateMachine.transition(0, session, accessor, this.childStateMachineCallback);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"247", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChild:", (Object)serverInfo);
        }
    }

    private void childRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"childRouteAdded", (Object)accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String string = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                string = serverInfo.getNode();
            }
            this._rt.put(string, accessor);
            new AddChildThread(serverInfo).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"203", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChild");
        }
    }

    private void childRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"childRouteRemoved", (Object)accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String string = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                string = serverInfo.getNode();
            }
            this._rt.remove(string);
            new RemoveChildThread(serverInfo).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.childRouteRemoved", (String)"314", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChild");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeAgentListener() {
        Object object = this;
        synchronized (object) {
            if (this.nodeAgentListenerAdded) {
                return;
            }
            this.nodeAgentListenerAdded = true;
        }
        try {
            object = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            AdminServiceFactory.getAdminService().addNotificationListenerExtended((ObjectName)object, this, notificationFilterSupport, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    public synchronized void removeChild(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeChild", (Object)string);
        }
        boolean bl = false;
        Accessor accessor = (Accessor)this._rt.get(string);
        StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(string);
        if (stateMachine != null) {
            stateMachine.transition(3, null, accessor, this.childStateMachineCallback);
            this._rtStateMachine.remove(string);
        }
        if (accessor == null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove - not in cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeChild");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addParent");
        }
        try {
            Accessor accessor = new Accessor(serverInfo);
            Session session = accessor.resetSession();
            if (session == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"null tmpSession");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addParent");
                }
                return;
            }
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                this.parentStateMachine.transition(0, session, accessor, this.parentStateMachineCallback);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.addParent", (String)"399", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addParent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyParentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyParentAdded");
        }
        Subject subject = null;
        if (SecurityHelper.getHelper().isSecurityEnabled()) {
            subject = this.pushServerSubject();
        }
        try {
            for (int i = 0; i < this.listenerArray.length; ++i) {
                try {
                    this.listenerArray[i].parentAdded(serverInfo);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.addParent", (String)"392", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"exception thrown from the routing listener: addParent", (Object)throwable);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.notifyParentAdded", (String)"449", (Object)this);
        }
        finally {
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                SecurityHelper.pushInvocationSubject(subject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyParentAdded");
        }
    }

    private void parentRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parentRouteAdded");
        }
        this.parent = accessor;
        try {
            new AddParentThread(accessor.getServerInfo()).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.parentRouteAdded", (String)"469", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parentRouteAdded");
        }
    }

    private void parentRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parentRouteRemoved");
        }
        if (this.parent == null) {
            return;
        }
        this.parent = null;
        ServerInfo serverInfo = accessor.getServerInfo();
        for (int i = 0; i < this.listenerArray.length; ++i) {
            try {
                this.listenerArray[i].parentRemoved(serverInfo);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.removeParent", (String)"392", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"exception thrown from the routing listener: parentRouteRemoved", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeParent");
        }
    }

    private Subject pushServerSubject() {
        Subject subject = null;
        Subject subject2 = null;
        try {
            subject2 = SecurityHelper.getOwnedSubject();
            if (subject2 != null) {
                subject = SecurityHelper.pushInvocationSubject(subject2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.RoutingTable.pushServerSubject", (String)"612", (Object)this);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)notification);
        }
        String string = ((ObjectName)notification.getSource()).getKeyProperty("node");
        Map map = this.agentPingThreads;
        synchronized (map) {
            List list = (List)this.agentPingThreads.get(string);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    private synchronized void incrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"incrMonitorThreads");
        }
        ++this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("numMonitorThread: " + this.numMonitorThreads));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"incrMonitorThreads");
        }
    }

    private synchronized void decrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decrMonitorThreads");
        }
        --this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("numMonitorThread: " + this.numMonitorThreads));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decrMonitorThreads");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        eventNames = new String[]{"DISCOVERY_EVENT", "REACHABLE_EVENT", "NOT_REACHABLE_EVENT", "RESET_EVENT"};
        stateNames = new String[]{"INIT_STATE", "MONITOR_STATE", "RECOVERY_STATE"};
    }

    public class StateMachine {
        public static final int INIT_STATE = 0;
        public static final int MONITOR_STATE = 1;
        public static final int RECOVERY_STATE = 2;
        public static final int DISCOVERY_EVENT = 0;
        public static final int REACHABLE_EVENT = 1;
        public static final int NOT_REACHABLE_EVENT = 2;
        public static final int RESET_EVENT = 3;
        private int nodeState = 0;
        private Accessor nodeAccessor = null;

        public void transition(int n, Session session, Accessor accessor, StateMachineCallback stateMachineCallback) {
            boolean bl = false;
            try {
                String string;
                String string2 = string = session == null ? "null" : session.toString();
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"transition", (Object)new Object[]{eventNames[n], string});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("currentState: " + stateNames[this.nodeState]));
                }
                boolean bl2 = false;
                if (n == 3) {
                    switch (this.nodeState) {
                        case 0: {
                            bl = true;
                            break;
                        }
                        case 1: {
                            bl = true;
                            stateMachineCallback.routeRemoved(this.nodeAccessor);
                            this.nodeState = 0;
                            break;
                        }
                        case 2: {
                            bl = true;
                            this.nodeState = 0;
                        }
                    }
                    this.nodeAccessor = null;
                } else {
                    boolean bl3 = false;
                    Session session2 = null;
                    if (this.nodeAccessor != null) {
                        session2 = this.nodeAccessor.getSession();
                    }
                    if (session != null && session.equals(session2)) {
                        bl3 = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sameSession:" + bl3));
                    }
                    if (n == 0) {
                        switch (this.nodeState) {
                            case 0: {
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(accessor);
                                this.nodeState = 1;
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                if (bl3) break;
                                stateMachineCallback.routeRemoved(this.nodeAccessor);
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(this.nodeAccessor);
                                bl2 = true;
                                break;
                            }
                            case 2: {
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(this.nodeAccessor);
                                this.nodeState = 1;
                                if (bl3) break;
                                bl2 = true;
                            }
                        }
                    } else if (n == 1) {
                        switch (this.nodeState) {
                            case 0: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                if (bl3) break;
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (bl3) {
                                    stateMachineCallback.routeAdded(this.nodeAccessor);
                                    this.nodeState = 1;
                                    break;
                                }
                                bl = true;
                            }
                        }
                    } else if (n == 2) {
                        switch (this.nodeState) {
                            case 0: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                if (bl3) {
                                    stateMachineCallback.routeRemoved(this.nodeAccessor);
                                    this.nodeState = 2;
                                    break;
                                }
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (bl3) break;
                                bl = true;
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("unknown event: " + n));
                    }
                }
                if (bl2) {
                    stateMachineCallback.startMonitor(this.nodeAccessor);
                }
                if (bl) {
                    stateMachineCallback.stopMonitor(accessor);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.StateMachine", (String)"602", (Object)this);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("nextState: " + stateNames[this.nodeState]));
                Tr.debug((TraceComponent)tc, (String)("stopMonitor:" + bl));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"transition");
            }
        }

        public int getState() {
            return this.nodeState;
        }
    }

    public class ParentStateMachineCallback
    implements StateMachineCallback {
        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"startMonitor");
            }
            try {
                String string = accessor.getName();
                UpstreamPing upstreamPing = new UpstreamPing(string, accessor, RoutingTable.this.parentStateMachine);
                upstreamPing.start();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", (String)"996", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stopMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stopMonitor");
            }
        }
    }

    public class ChildStateMachineCallback
    implements StateMachineCallback {
        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"startMonitor");
            }
            try {
                String string;
                ServerInfo serverInfo = accessor.getServerInfo();
                String string2 = serverInfo.getName();
                if (serverInfo.getRole().equals("NodeAgent")) {
                    string2 = serverInfo.getNode();
                }
                if ((string = AdminServiceFactory.getAdminService().getProcessType()).equals("DeploymentManager")) {
                    RoutingTable.this.addNodeAgentListener();
                    StateMachine stateMachine = (StateMachine)RoutingTable.this._rtStateMachine.get(string2);
                    NodeAgentPing nodeAgentPing = new NodeAgentPing(string2, accessor, stateMachine);
                    nodeAgentPing.start();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", (String)"996", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stopMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stopMonitor");
            }
        }
    }

    public static interface StateMachineCallback {
        public void routeAdded(Accessor var1);

        public void routeRemoved(Accessor var1);

        public void startMonitor(Accessor var1);

        public void stopMonitor(Accessor var1);
    }

    private class RemoveChildThread
    extends Thread {
        ServerInfo serverInfo;

        RemoveChildThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RemoveChildThread.run");
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            try {
                for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RoutingListner.parentRemoved: " + RoutingTable.this.listenerArray[i].getClass().getName()));
                    }
                    try {
                        RoutingTable.this.listenerArray[i].childRemoved(this.serverInfo);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.remove", (String)"246", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"exception thrown from the routing listener: parentRemoved", (Object)throwable);
                    }
                }
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RemoveChildThread.run");
            }
        }
    }

    private class AddParentThread
    extends Thread {
        ServerInfo serverInfo;

        AddParentThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"AddParentThread.run");
            }
            RoutingTable.this.notifyParentAdded(this.serverInfo);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"AddParentThread.run");
            }
        }
    }

    private class AddChildThread
    extends Thread {
        ServerInfo serverInfo;

        AddChildThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"AddChildThread.run");
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            try {
                for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RoutingListner.childAdded: " + RoutingTable.this.listenerArray[i].getClass().getName()));
                    }
                    try {
                        RoutingTable.this.listenerArray[i].childAdded(this.serverInfo);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.addChild", (String)"194", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"failed to execute RoutingListener.childAdded");
                    }
                }
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"AddChildThread.run");
            }
        }
    }

    private class NodeAgentPing
    extends PingThread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NodeAgentPing(String string, Accessor accessor, StateMachine stateMachine) {
            super(string, accessor, stateMachine);
            Map map = RoutingTable.this.agentPingThreads;
            synchronized (map) {
                ArrayList<NodeAgentPing> arrayList = (ArrayList<NodeAgentPing>)RoutingTable.this.agentPingThreads.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<NodeAgentPing>();
                    RoutingTable.this.agentPingThreads.put(string, arrayList);
                }
                arrayList.add(this);
            }
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"NodeAgentPing.routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"NodeAgentPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"NodeAgentPing.routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"NodeAgentPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"NodeAgentPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"NodeAgentPing.startMonitor");
            }
        }
    }

    private class UpstreamPing
    extends PingThread {
        UpstreamPing(String string, Accessor accessor, StateMachine stateMachine) {
            super(string, accessor, stateMachine);
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UpstreamPing.routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UpstreamPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UpstreamPing.routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UpstreamPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UpstreamPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UpstreamPing.startMonitor");
            }
        }
    }

    private abstract class PingThread
    extends Thread
    implements StateMachineCallback {
        protected String name;
        protected Accessor accessor;
        protected StateMachine stateMachine;
        protected boolean stopMonitor = false;

        PingThread(String string, Accessor accessor, StateMachine stateMachine) {
            this.name = string;
            this.accessor = accessor;
            this.stateMachine = stateMachine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"PingThread.run", (Object)this.name);
            }
            RoutingTable.this.incrMonitorThreads();
            try {
                object = System.getProperty("com.ibm.websphere.management.monitoring.pingInterval", "60");
                int n = new Integer((String)object);
                object = System.getProperty("com.ibm.websphere.management.monitoring.pingMaximumAttempts", "1");
                int n2 = new Integer((String)object);
                int n3 = 0;
                object = System.getProperty("com.ibm.websphere.management.monitoring.shortPingInterval", "5");
                int n4 = new Integer((String)object);
                object = System.getProperty("com.ibm.websphere.management.monitoring.shortPingMaximumAttempts", "10");
                int n5 = new Integer((String)object);
                boolean bl = false;
                AdminClient adminClient = this.accessor.getConnector();
                Session session = this.accessor.getSession();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("pingInterval is: " + n));
                    Tr.debug((TraceComponent)tc, (String)("pingMaxiumAttempts is: " + n2));
                    Tr.debug((TraceComponent)tc, (String)("session is: " + session));
                }
                int n6 = 0;
                while (!this.stopMonitor) {
                    try {
                        RoutingTable routingTable;
                        boolean bl2;
                        block36: {
                            bl2 = false;
                            Session session2 = null;
                            try {
                                session2 = adminClient.isAlive();
                                if (session2 == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"got null session");
                                    }
                                    break block36;
                                }
                                if (!session2.equals(session)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("got new session:" + session2));
                                    }
                                    break;
                                }
                                bl2 = true;
                            }
                            catch (Throwable throwable) {
                                if (!tc.isDebugEnabled()) break block36;
                                Tr.debug((TraceComponent)tc, (String)("unable to reach parent. Got exception " + throwable));
                            }
                        }
                        if (bl2) {
                            n6 = 0;
                            routingTable = RoutingTable.this;
                            synchronized (routingTable) {
                                this.stateMachine.transition(1, session, this.accessor, this);
                            }
                        } else if (++n6 == n2) {
                            n6 = 0;
                            routingTable = RoutingTable.this;
                            synchronized (routingTable) {
                                this.stateMachine.transition(2, session, this.accessor, this);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("node not reachable, curAttempts : " + n6));
                        }
                        if (this.stopMonitor) continue;
                        if (n3 > 0) {
                            if (++n3 >= n5) {
                                n3 = 0;
                            }
                            Thread.sleep(n4 * 1000);
                            continue;
                        }
                        if (bl2) {
                            Thread.sleep(n * 1000);
                            continue;
                        }
                        Thread.sleep(n * 2000);
                    }
                    catch (InterruptedException interruptedException) {
                        n3 = 1;
                        try {
                            Thread.sleep(n4 * 1000);
                        }
                        catch (InterruptedException interruptedException2) {
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1080", (Object)this);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1082", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.RoutingTable.PingThread.run", (String)"1137", (Object)this);
            }
            object = RoutingTable.this.agentPingThreads;
            synchronized (object) {
                List list = (List)RoutingTable.this.agentPingThreads.get(this.name);
                if (list != null) {
                    list.remove(this);
                }
            }
            RoutingTable.this.decrMonitorThreads();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"PingThread.run", (Object)this.name);
            }
        }

        public abstract void routeAdded(Accessor var1);

        public abstract void routeRemoved(Accessor var1);

        public abstract void startMonitor(Accessor var1);

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"PingThread.stopMonitor");
            }
            this.stopMonitor = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"PingThread.stopMonitor");
            }
        }
    }

    public class Accessor {
        String name;
        String pid;
        String defaultType;
        ServerInfo serverInfo;
        Map connectorCfgs = new HashMap();
        Session session;

        Accessor(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        public Accessor(Session session) {
            this.session = session;
        }

        String getName() {
            return this.serverInfo.getName();
        }

        String getPid() {
            return this.serverInfo.getPid();
        }

        public String toString() {
            return this.serverInfo.toString();
        }

        void setServerInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        private void setConnectors(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setConnectors");
            }
            String string = null;
            this.connectorCfgs.clear();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Properties properties = (Properties)iterator.next();
                string = properties.getProperty("type");
                if (properties.getProperty("preferred") != null) {
                    this.defaultType = string;
                }
                this.connectorCfgs.put(string, properties);
            }
            if (this.defaultType == null) {
                this.defaultType = string;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setConnectors");
            }
        }

        void clear() {
            this.connectorCfgs.clear();
        }

        boolean isRoutable() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isRoutable: " + !this.connectorCfgs.isEmpty()));
            }
            return !this.connectorCfgs.isEmpty();
        }

        boolean isReachAble() {
            boolean bl;
            block2: {
                bl = false;
                try {
                    bl = this.getConnector().isAlive() != null;
                    bl = true;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)"can not reach: ", (Object)this.getName());
                }
            }
            return bl;
        }

        AdminClient getConnector(String string) throws ConnectorException {
            AdminClient adminClient;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"getConnector(type)", (Object)string);
                }
                adminClient = null;
                Properties properties = (Properties)this.connectorCfgs.get(string);
                if (properties == null) {
                    throw new ConnectorNotAvailableException();
                }
                try {
                    adminClient = AdminClientFactory.createAdminClient(properties);
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"583", (Object)this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"unable to create connector with properties:", (Object)properties);
                }
            }
            if (adminClient == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnector(type) - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnector(type)");
            }
            return adminClient;
        }

        AdminClient getConnector() throws ConnectorException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getConnector");
            }
            AdminClient adminClient = null;
            if (this.defaultType != null) {
                try {
                    adminClient = this.getConnector(this.defaultType);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"610", (Object)this);
                }
            }
            if (adminClient == null) {
                Iterator iterator = this.connectorCfgs.keySet().iterator();
                while (adminClient == null && iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.defaultType != null && this.defaultType.equals(string)) continue;
                    try {
                        adminClient = this.getConnector(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.RoutingTable.Accessor.getConnector", (String)"523", (Object)this);
                    }
                }
            }
            if (adminClient == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnector - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            return adminClient;
        }

        Session resetSession() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"resetSession");
            }
            try {
                AdminClient adminClient = this.getConnector();
                this.session = adminClient.isAlive();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.RoutingTable.getAllAdminClients", (String)"492", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resetSession");
            }
            return this.session;
        }

        Session getSession() {
            return this.session;
        }
    }
}

