/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.init.ArchiveInit;
import com.ibm.etools.jca.ConfigProperty;
import com.ibm.etools.jca.Connector;
import com.ibm.etools.jca.ResourceAdapter;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.component.AdminImpl;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class AdminOperationsMBean {
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.adminservice");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$component$AdminOperationsMBean == null ? (class$com$ibm$ws$management$component$AdminOperationsMBean = AdminOperationsMBean.class$("com.ibm.ws.management.component.AdminOperationsMBean")) : class$com$ibm$ws$management$component$AdminOperationsMBean), (String)"Admin", (String)"com.ibm.ws.management.resources.adminservice");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private static final long TOKEN_EXPIRATION_TIME = 1800000L;
    private AdminImpl adminImpl;
    private boolean nodeFederationOrRemovalInProgress = false;
    private Integer currentToken = new Integer(0);
    private long previousTokenHandout = 0L;
    static /* synthetic */ Class class$com$ibm$ws$management$component$AdminOperationsMBean;

    public AdminOperationsMBean(AdminImpl adminImpl) throws AdminException {
        this.adminImpl = adminImpl;
        DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this, "AdminOperations");
        AdminServiceFactory.getMBeanFactory().activateMBean("AdminOperations", defaultRuntimeCollaborator, "AdminOperations", null);
    }

    public void addNode(String string, String string2) {
        this.addNodeWithOptions(string, string2, null);
    }

    public void addNodeWithOptions(String string, String string2, String string3) {
        block12: {
            CreationParams creationParams = new CreationParams();
            String string4 = System.getProperty("was.install.root") + File.separator + "bin";
            creationParams.setWorkingDirectory(string4);
            String string5 = "addNode.sh";
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                string5 = "addNode.bat";
            } else if (System.getProperty("os.name").equals("OS/400")) {
                string5 = "addNode";
            }
            String string6 = string4 + File.separator + string5;
            creationParams.setExecutable(string6);
            creationParams.setProcessName("addNode");
            creationParams.setDetachProcess(true);
            List<String> list = new ArrayList<String>();
            if (System.getProperty("os.name").equals("OS/400")) {
                list.add("-instance");
                list.add(this.getInstanceName());
            }
            list.add(string);
            list.add(string2);
            list = this.addCommandLineOptions(list, string3);
            list.add("-fromMBean");
            creationParams.setCommandLineArgs(this.createCommandArgsFromGivenOptions(list));
            String string7 = this.getLogFileName("addNode");
            creationParams.setStdFileName(1, string7);
            creationParams.setStdFileName(2, string7);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Launching process with params: " + creationParams.toString()));
            }
            AdminClient adminClient = null;
            Properties properties = this.createUserData();
            ObjectName objectName = null;
            try {
                adminClient = this.createAdminClient(string, string2, list);
                objectName = this.getNotificationService(adminClient);
                if (objectName != null) {
                    this.emitStartingNotification(adminClient, objectName, "websphere.addnode.starting", creationParams, properties);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.AdminOperationsMBean.addNode", (String)"149", (Object)this);
            }
            try {
                Process process = ProcessFactory.create((CreationParams)creationParams);
                process.release();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.AdminOperationsMBean.addNode", (String)"157", (Object)this);
                if (objectName == null) break block12;
                try {
                    this.emitFailedNotification(adminClient, objectName, "websphere.addnode.failed", creationParams, properties, exception);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private String getInstanceName() {
        String string = System.getProperty("user.install.root");
        return string.substring(string.lastIndexOf(File.separator) + 1);
    }

    private String getLogFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.expandVariable("${LOG_ROOT}"));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append("MBean.log");
        return stringBuffer.toString();
    }

    private ObjectName getNotificationService(AdminClient adminClient) throws Exception {
        String string = "WebSphere:*,type=NotificationService,process=" + Utils.getNetmgrName(adminClient);
        Set set = adminClient.queryNames(new ObjectName(string), null);
        if (!set.isEmpty()) {
            return (ObjectName)set.iterator().next();
        }
        return null;
    }

    private Properties createUserData() {
        Properties properties = new Properties();
        properties.setProperty("nodeName", AdminServiceFactory.getAdminService().getNodeName());
        return properties;
    }

    private void emitStartingNotification(AdminClient adminClient, ObjectName objectName, String string, CreationParams creationParams, Properties properties) throws Exception {
        String string2 = AdminOperationsMBean.getFormattedMessage("ADMN0032I", new Object[]{creationParams.getExecutable() + " " + this.toString(creationParams.getCommandLineArgs())}, null);
        adminClient.invoke(objectName, "emitNotification", new Object[]{string, string2, properties}, NTFY_PARAMS);
    }

    private void emitFailedNotification(AdminClient adminClient, ObjectName objectName, String string, CreationParams creationParams, Properties properties, Exception exception) throws Exception {
        String string2 = AdminOperationsMBean.getFormattedMessage("ADMN0033E", new Object[]{creationParams.getProcessName(), exception}, null);
        adminClient.invoke(objectName, "emitNotification", new Object[]{string, string2, properties}, NTFY_PARAMS);
    }

    public void removeNode() {
        this.removeNodeWithOptions(null);
    }

    public void removeNodeWithOptions(String string) {
        block12: {
            CreationParams creationParams = new CreationParams();
            String string2 = System.getProperty("was.install.root") + File.separator + "bin";
            creationParams.setWorkingDirectory(string2);
            String string3 = "removeNode.sh";
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                string3 = "removeNode.bat";
            } else if (System.getProperty("os.name").equals("OS/400")) {
                string3 = "removeNode";
            }
            String string4 = string2 + File.separator + string3;
            creationParams.setExecutable(string4);
            creationParams.setProcessName("removeNode");
            creationParams.setDetachProcess(true);
            List<String> list = new ArrayList<String>();
            if (System.getProperty("os.name").equals("OS/400")) {
                list.add("-instance");
                list.add(this.getInstanceName());
            }
            list = this.addCommandLineOptions(list, string);
            list.add("-fromMBean");
            creationParams.setCommandLineArgs(this.createCommandArgsFromGivenOptions(list));
            String string5 = this.getLogFileName("removeNode");
            creationParams.setStdFileName(1, string5);
            creationParams.setStdFileName(2, string5);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Launching process with params: " + creationParams.toString()));
            }
            AdminClient adminClient = null;
            Properties properties = this.createUserData();
            ObjectName objectName = null;
            try {
                adminClient = com.ibm.ws.management.discovery.Utils.getDmgrAdminClient();
                objectName = this.getNotificationService(adminClient);
                if (objectName != null) {
                    this.emitStartingNotification(adminClient, objectName, "websphere.removenode.starting", creationParams, properties);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.AdminOperationsMBean.removeNode", (String)"282", (Object)this);
            }
            try {
                Process process = ProcessFactory.create((CreationParams)creationParams);
                process.release();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.AdminOperationsMBean.removeNode", (String)"291", (Object)this);
                if (objectName == null) break block12;
                try {
                    this.emitFailedNotification(adminClient, objectName, "websphere.removenode.failed", creationParams, properties, exception);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private List addCommandLineOptions(List list, String string) {
        if (string == null) {
            return list;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        return list;
    }

    private String[] createCommandArgsFromGivenOptions(List list) {
        Object object;
        int n = list.indexOf("-configURL");
        if (n != -1) {
            String string;
            list.remove(n);
            object = (String)list.remove(n);
            int n2 = object.indexOf(34);
            if (n2 != -1) {
                n2 = object.indexOf(34, n2);
                while (n2 != -1) {
                    string = (String)list.remove(n);
                    object = (String)object + string;
                    n2 = string.indexOf(34);
                }
            }
            object = this.expandVariable((String)object);
            n = list.indexOf("-conntype");
            if (n != -1) {
                string = (String)list.get(n + 1);
                if (string.equalsIgnoreCase("SOAP")) {
                    System.setProperty("com.ibm.SOAP.ConfigURL", (String)object);
                } else {
                    System.setProperty("com.ibm.CORBA.ConfigURL", (String)object);
                }
            } else {
                System.setProperty("com.ibm.SOAP.ConfigURL", (String)object);
            }
        }
        object = new String[list.size()];
        object = list.toArray((T[])object);
        return object;
    }

    private AdminClient createAdminClient(String string, String string2, List list) throws ConnectorException {
        Properties properties = new Properties();
        properties.setProperty("host", string);
        properties.setProperty("port", string2);
        if (list != null) {
            int n = list.indexOf("-conntype");
            if (n != -1) {
                properties.setProperty("type", (String)list.get(n + 1));
            } else {
                properties.setProperty("type", "SOAP");
            }
            n = list.indexOf("-username");
            if (n != -1) {
                properties.setProperty("username", (String)list.get(n + 1));
            }
            if ((n = list.indexOf("-user")) != -1) {
                properties.setProperty("username", (String)list.get(n + 1));
            }
            if ((n = list.indexOf("-password")) != -1) {
                properties.setProperty("password", (String)list.get(n + 1));
            }
        }
        return AdminClientFactory.createAdminClient(properties);
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        return stringBuffer.toString();
    }

    public synchronized Object getTokenForNodeFederationOrRemoval() {
        if (this.nodeFederationOrRemovalInProgress) {
            if (this.isTokenExpired()) {
                this.currentToken = new Integer(this.currentToken + 1);
            } else {
                return null;
            }
        }
        this.nodeFederationOrRemovalInProgress = true;
        this.previousTokenHandout = System.currentTimeMillis();
        return this.currentToken;
    }

    private boolean isTokenExpired() {
        return System.currentTimeMillis() - this.previousTokenHandout > 1800000L;
    }

    public synchronized boolean completeNodeFederationOrRemoval(Object object) {
        if (object != null && object.equals(this.currentToken)) {
            this.nodeFederationOrRemovalInProgress = false;
            this.currentToken = new Integer(this.currentToken + 1);
            return true;
        }
        return false;
    }

    public synchronized void forceNodeFederationOrRemovalTokenReset() {
        this.nodeFederationOrRemovalInProgress = false;
    }

    public String expandVariable(String string) {
        String string2 = string;
        try {
            string2 = this.adminImpl.expandGivenVariable(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.component.AdminOperationsMBean.expandVariable", (String)"313", (Object)this);
        }
        return string2;
    }

    public AttributeList getResourceAdapterFromRAR(String string, Hashtable hashtable) throws AdminException {
        String string2;
        String string3;
        CommonarchiveFactory commonarchiveFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getResourceAdapterFromRAR: " + string + ", " + hashtable));
        }
        if (string == null) {
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0027E", null, null));
        }
        RARFile rARFile = null;
        try {
            ArchiveInit.init();
            commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            string3 = this.expandVariable(string);
            string3 = string3.replace('\\', '/');
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Path: " + string3));
            }
            rARFile = commonarchiveFactory.openRARFile(string3);
        }
        catch (Exception exception) {
            throw new AdminException(exception, AdminOperationsMBean.getFormattedMessage("ADMN0028E", new String[]{string, exception.toString()}, "Could not open RAR file " + string));
        }
        commonarchiveFactory = rARFile.getDeploymentDescriptor();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Connector is: " + commonarchiveFactory));
        }
        string3 = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
        J2cFactory j2cFactory = string3.getJ2cFactory();
        ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
        ResourcesFactory resourcesFactory = resourcesPackage.getResourcesFactory();
        File file = new File(string.replace('\\', '/'));
        String string4 = (String)hashtable.get("rar.name");
        if (string4 == null || string4.trim().length() == 0) {
            string4 = commonarchiveFactory.getDisplayName();
            if (string4 == null) {
                string4 = file.getName();
            }
            hashtable.put("rar.name", string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Name is : " + string4));
        }
        if ((string2 = (String)hashtable.get("rar.archivePath")) == null) {
            string2 = "${CONNECTOR_INSTALL_ROOT}/";
        }
        if (!string2.trim().endsWith("/") && !string2.trim().endsWith(File.separator)) {
            string2 = string2 + "/";
        }
        string2 = string2 + file.getName();
        hashtable.put("rar.archivePath", string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Archive path: " + string2));
        }
        AttributeList attributeList = null;
        try {
            J2CResourceAdapter j2CResourceAdapter = AdminOperationsMBean.createJ2CResourceAdapter(j2cFactory, resourcesFactory, (Connector)commonarchiveFactory, hashtable);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created new J2CResourceAdapter : " + j2CResourceAdapter));
            }
            attributeList = MOFUtil.getAttributes((EObject)j2CResourceAdapter, null, true);
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (rARFile != null) {
                rARFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResourceAdapterFromRAR:" + attributeList));
        }
        return attributeList;
    }

    private static J2CResourceAdapter createJ2CResourceAdapter(J2cFactory j2cFactory, ResourcesFactory resourcesFactory, Connector connector2, Hashtable hashtable) throws Exception {
        ResourceAdapter resourceAdapter;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createJ2CResourceAdapter");
        }
        J2CResourceAdapter j2CResourceAdapter = j2cFactory.createJ2CResourceAdapter();
        String string2 = (String)hashtable.get("rar.name");
        j2CResourceAdapter.setName(string2);
        String string3 = (String)hashtable.get("rar.archivePath");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Archive path: " + string3));
        }
        j2CResourceAdapter.setArchivePath(string3);
        String string4 = (String)hashtable.get("rar.desc");
        if (string4 != null) {
            j2CResourceAdapter.setDescription(string4);
        }
        String string5 = (String)hashtable.get("rar.classpath");
        j2CResourceAdapter.getClasspath().add((Object)string3);
        if (string5 != null) {
            AdminOperationsMBean.addFromString(string5, (List)j2CResourceAdapter.getClasspath());
        }
        if ((string = (String)hashtable.get("rar.nativePath")) != null) {
            AdminOperationsMBean.addFromString(string, (List)j2CResourceAdapter.getNativepath());
        }
        if ((resourceAdapter = connector2.getResourceAdapter()).getConfigProperties() != null) {
            J2EEResourcePropertySet j2EEResourcePropertySet = resourcesFactory.createJ2EEResourcePropertySet();
            EList eList = resourceAdapter.getConfigProperties();
            for (int i = 0; i < eList.size(); ++i) {
                ConfigProperty configProperty = (ConfigProperty)eList.get(i);
                J2EEResourceProperty j2EEResourceProperty = resourcesFactory.createJ2EEResourceProperty();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("..... setting up resource property: " + configProperty.getName()));
                }
                j2EEResourceProperty.setName(configProperty.getName());
                j2EEResourceProperty.setType(configProperty.getType());
                j2EEResourceProperty.setValue(configProperty.getValue());
                j2EEResourceProperty.setDescription(configProperty.getDescription());
                j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
            }
            j2CResourceAdapter.setPropertySet(j2EEResourcePropertySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createJ2CResourceAdapter");
        }
        return j2CResourceAdapter;
    }

    private static void addFromString(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addFromString: " + string + " and " + list));
        }
        if (string == null || list == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.trim().length() == 0) continue;
            list.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addFromString: " + list));
        }
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = nls.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (Exception exception) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
    }

    public void extractArchive(String string, String string2, int n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractArchive: " + string + ", flags=: " + n));
        }
        try {
            ArchiveInit.init();
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            String string3 = this.expandVariable(string);
            string3 = string3.replace('\\', '/');
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ArchivePath: " + string3));
            }
            Archive archive = commonarchiveFactory.openArchive(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Archive: " + archive));
            }
            if (archive != null) {
                string3 = this.expandVariable(string2);
                File file = new File(string3 = string3.replace('/', File.separatorChar));
                if (!(file.mkdirs() || file.exists() && file.isDirectory())) {
                    throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0031E", new String[]{string3}, "Error extracting archive: could not create directory path " + string3));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Dest: " + string3));
                }
                archive.extractTo(string3, n);
                archive.close();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0029E", new String[]{string, throwable.toString()}, "Error extracting archive " + string + ": " + throwable));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractArchive");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        this.adminImpl.configChanged(configRepositoryEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

