/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class ConfigChangeHandler
implements ConfigRepositoryListener,
AlarmListener,
NotificationListener {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$component$ConfigChangeHandler == null ? (class$com$ibm$ws$management$component$ConfigChangeHandler = ConfigChangeHandler.class$("com.ibm.ws.management.component.ConfigChangeHandler")) : class$com$ibm$ws$management$component$ConfigChangeHandler), (String)"Admin", (String)"com.ibm.ws.management.resources.adminservice");
    private List listeners = new ArrayList();
    private boolean holdEvents = false;
    private List heldEvents = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ws$management$component$ConfigChangeHandler;

    ConfigChangeHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(configChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(configChangeListener);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this.holdEvents = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            ConfigRepositoryEvent configRepositoryEvent;
            ConfigRepository configRepository = null;
            ArrayList<ConfigChangeNotifier> arrayList = new ArrayList<ConfigChangeNotifier>();
            ConfigChangeNotifier[] configChangeNotifierArray = this.heldEvents.iterator();
            while (configChangeNotifierArray.hasNext()) {
                configRepositoryEvent = (ConfigRepositoryEvent)configChangeNotifierArray.next();
                if (configRepository == null) {
                    configRepository = (ConfigRepository)configRepositoryEvent.getSource();
                }
                arrayList.addAll(Arrays.asList(configRepositoryEvent.getChanges()));
            }
            if (arrayList.size() > 0) {
                configChangeNotifierArray = new ConfigChangeNotifier[arrayList.size()];
                arrayList.toArray(configChangeNotifierArray);
                configRepositoryEvent = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), configChangeNotifierArray);
                this.sendEvent(configRepositoryEvent);
                this.heldEvents.clear();
            }
            this.holdEvents = false;
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (this.holdEvents) {
            this.heldEvents.add(configRepositoryEvent);
        } else {
            this.sendEvent(configRepositoryEvent);
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        this.sendEvent(configRepositoryEvent);
    }

    public void alarm(Object object) {
        ConfigChangeEventDispatcher configChangeEventDispatcher = (ConfigChangeEventDispatcher)object;
        configChangeEventDispatcher.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConfigRepositoryEvent configRepositoryEvent) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendEvent," + configRepositoryEvent.getId()));
        }
        Object object2 = this.listeners;
        synchronized (object2) {
            object = this.listeners.iterator();
            while (object.hasNext()) {
                AlarmManager.create((long)0L, (AlarmListener)this, (Object)new ConfigChangeEventDispatcher(configRepositoryEvent, (ConfigChangeListener)object.next()));
            }
        }
        object2 = AdminServiceFactory.getAdminService();
        if (object2.getProcessType().equals("NodeAgent")) {
            object = null;
            try {
                object = new ObjectName("*:type=AdminOperations,*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                malformedObjectNameException.printStackTrace();
            }
            Set set = object2.queryNames((ObjectName)object, null);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string = ObjectNameHelper.getProcessName(objectName);
                if (string.equals(object2.getProcessName())) continue;
                new Thread(new ConfigChangeEventDispatcher(configRepositoryEvent, objectName)).start();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendEvent");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConfigChangeEventDispatcher
    implements Runnable {
        private ConfigRepositoryEvent e;
        private ConfigChangeListener l = null;
        private ObjectName adminOperation = null;

        ConfigChangeEventDispatcher(ConfigRepositoryEvent configRepositoryEvent, ConfigChangeListener configChangeListener) {
            this.e = configRepositoryEvent;
            this.l = configChangeListener;
        }

        ConfigChangeEventDispatcher(ConfigRepositoryEvent configRepositoryEvent, ObjectName objectName) {
            this.e = configRepositoryEvent;
            this.adminOperation = objectName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Subject subject = null;
            Subject subject2 = null;
            subject2 = SecurityHelper.getOwnedSubject();
            try {
                if (subject2 != null) {
                    subject = SecurityHelper.pushInvocationSubject(subject2);
                }
                if (this.l != null) {
                    this.l.configChanged(this.e);
                } else if (this.adminOperation != null) {
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        adminService.invoke(this.adminOperation, "configChanged", new Object[]{this.e}, new String[]{"com.ibm.websphere.management.repository.ConfigRepositoryEvent"});
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.component.ConfigChangeHandler.run", (String)"186", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"ADMN0014W", (Object)new Object[]{this.adminOperation, this.e});
                    }
                }
            }
            finally {
                if (subject2 != null) {
                    SecurityHelper.popInvocationSubject(subject);
                }
            }
        }
    }
}

