/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.HTTPConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.TCPIPProtocolType;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.rmi.RMIConnectorController;
import com.ibm.ws.management.connector.soap.JMXSoapAdapter;
import com.ibm.ws.management.discovery.CMDiscoveryAdapter;
import com.ibm.ws.management.discovery.MPDiscoveryAdapter;
import com.ibm.ws.management.discovery.NADiscoveryAdapter;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.transport.MulticastServer;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.ThreadPool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class JMXConnectors
extends ComponentImpl
implements IWorkloadRegulator,
PropertyChangeListener,
SecurityServiceListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$component$JMXConnectors == null ? (class$com$ibm$ws$management$component$JMXConnectors = JMXConnectors.class$("com.ibm.ws.management.component.JMXConnectors")) : class$com$ibm$ws$management$component$JMXConnectors), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private static final String TMX4J_HTTP_PORT_PROPERTY = "tmx4j.httpadaptor.port";
    public static final String DEFAULT_HTTP_CONNECTOR_PORT = "8082";
    private SecurityService securityService;
    private EndPointMgr endPtMgr;
    private Repository repository;
    private MBeanFactory _mbeanFactory;
    private String adminType;
    private String cellName;
    private String nodeName;
    private String serverName;
    private int cellDiscoveryProtocol;
    private int nodeDiscoveryProtocol;
    private String pConnectorType;
    private EndPtCollector epCollector;
    private ThreadPoolMgr threadPoolMgr;
    private JMXConnector soapConnector;
    private JMXConnector rmiConnector;
    private boolean soapConnectorEnabled = false;
    private boolean rmiConnectorEnabled = false;
    private boolean httpConnectorEnabled = false;
    private String httpAdapterPort;
    private Properties soapConnectorProperties;
    static /* synthetic */ Class class$com$ibm$ws$management$component$JMXConnectors;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$EndPointMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadPoolMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$ServerInfo;

    public void initialize(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        this.endPtMgr = (EndPointMgr)this.getService(class$com$ibm$ws$runtime$service$EndPointMgr == null ? (class$com$ibm$ws$runtime$service$EndPointMgr = JMXConnectors.class$("com.ibm.ws.runtime.service.EndPointMgr")) : class$com$ibm$ws$runtime$service$EndPointMgr);
        this.threadPoolMgr = (ThreadPoolMgr)this.getService(class$com$ibm$ws$runtime$service$ThreadPoolMgr == null ? (class$com$ibm$ws$runtime$service$ThreadPoolMgr = JMXConnectors.class$("com.ibm.ws.runtime.service.ThreadPoolMgr")) : class$com$ibm$ws$runtime$service$ThreadPoolMgr);
        this.repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = JMXConnectors.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
        this.cellName = this.repository.getCellName();
        this.nodeName = this.repository.getNodeName();
        this.serverName = this.repository.getServerName();
        Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = JMXConnectors.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
        server.addPropertyChangeListener("state", (PropertyChangeListener)this);
        WorkloadController.registerRegulator((IWorkloadRegulator)this);
        this.releaseService(this.endPtMgr);
        this.releaseService(this.repository);
        this.releaseService(this.threadPoolMgr);
        this.releaseService(server);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        this.securityService = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? (class$com$ibm$ws$security$service$SecurityService = JMXConnectors.class$("com.ibm.ws.security.service.SecurityService")) : class$com$ibm$ws$security$service$SecurityService);
        SecurityHelper.getHelper().setSecurityService(this.securityService);
        this.securityService.addListener((SecurityServiceListener)SecurityHelper.getHelper());
        this.securityService.addListener((SecurityServiceListener)this);
        this.releaseService(this.securityService);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    private void initDiscovery() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initDiscovery");
            }
            try {
                Properties properties = AdminInitializer.getInstance().getProperties();
                this.adminType = (String)properties.get("adminTypeProperty");
                if (!this.adminType.equals("UnManagedProcess")) {
                    String string;
                    if (!this.adminType.equals("ManagedProcess")) {
                        this.epCollector = new EndPtCollector(this.endPtMgr);
                    }
                    this.cellDiscoveryProtocol = (string = (String)properties.get("cellDiscoveryProtocolConfigProperty")) != null ? TCPIPProtocolType.get((String)string).getValue() : 1;
                    String string2 = (String)properties.get("nodeDiscoveryProtocolConfigProperty");
                    this.nodeDiscoveryProtocol = string2 != null ? TCPIPProtocolType.get((String)string2).getValue() : 1;
                    this.interprocessRegistration();
                    if (this.epCollector != null && !this.adminType.equals("NodeAgent")) {
                        this.epCollector.discard();
                        this.epCollector = null;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.initDiscovery", (String)"202", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Got Exception initializing discovery:", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initDiscovery");
        }
    }

    public void stop() {
        if (this.soapConnectorEnabled && this.soapConnector != null) {
            this.soapConnector.stop();
        }
    }

    public void destroy() {
    }

    public void initializeConnectors(AdminService adminService) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeConnectors");
        }
        com.ibm.websphere.models.config.adminservice.JMXConnector jMXConnector = adminService.getPreferredConnector();
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints("@");
        EList eList = adminService.getConnectors();
        for (int i = 0; i < eList.size(); ++i) {
            com.ibm.websphere.models.config.adminservice.JMXConnector jMXConnector2 = (com.ibm.websphere.models.config.adminservice.JMXConnector)eList.get(i);
            EList eList2 = jMXConnector2.getProperties();
            Properties properties = new Properties();
            for (int j = 0; j < eList2.size(); ++j) {
                Property property = (Property)eList2.get(j);
                String string = property.getName();
                String string2 = property.getValue();
                if (string == null || string2 == null) continue;
                properties.put(string, string2);
            }
            if (jMXConnector2 instanceof SOAPConnector) {
                this.initSOAPConnector(properties, (EndPointMgr.EndPoints)serverEndPoints, this.threadPoolMgr);
                this.soapConnectorEnabled = true;
                if (!jMXConnector2.getClass().isAssignableFrom(jMXConnector.getClass())) continue;
                this.pConnectorType = "SOAP";
                String string = properties.getProperty("requestTimeout");
                if (string == null) continue;
                System.getProperties().setProperty("com.ibm.SOAP.requestTimeout", string);
                continue;
            }
            if (jMXConnector2 instanceof HTTPConnector) {
                this.initHTTPConnector(properties);
                this.httpConnectorEnabled = true;
                continue;
            }
            if (!(jMXConnector2 instanceof RMIConnector)) continue;
            this.initRMIConnector(properties, (EndPointMgr.EndPoints)serverEndPoints);
            this.rmiConnectorEnabled = true;
            if (!jMXConnector2.getClass().isAssignableFrom(jMXConnector.getClass())) continue;
            this.pConnectorType = "RMI";
        }
        if (tc.isDebugEnabled() && this.pConnectorType != null) {
            Tr.debug((TraceComponent)tc, (String)"the preferred connector type:", (Object)this.pConnectorType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeConnectors");
        }
    }

    private void initSOAPConnector(Properties properties, EndPointMgr.EndPoints endPoints, ThreadPoolMgr threadPoolMgr) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initSOAPConnector");
        }
        String string = null;
        String string2 = null;
        EndPoint endPoint = endPoints.getEndPoint("SOAP_CONNECTOR_ADDRESS");
        if (endPoint != null) {
            string = new Integer(endPoint.getPort()).toString();
            string2 = endPoint.getHost();
            if (string2 == null) {
                try {
                    string2 = AdminHelper.getInstance().getHostName();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.initSOAPConnector", (String)"296", (Object)this);
                }
            }
        } else {
            throw new RuntimeError(connectorNLS.getString("ADMC0016E"));
        }
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", string2);
        properties.setProperty("port", string);
        this.soapConnectorProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initSOAPConnector", (Object)this.soapConnectorProperties);
        }
    }

    private void startSOAPConnector() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startSOAPConnector");
        }
        if (!this.soapConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"soapConnector is not enabled");
            }
            return;
        }
        String string = null;
        int n = 5;
        String string2 = System.getProperty("com.ibm.websphere.management.soapThreads");
        if (string2 != null) {
            n = new Integer(string2);
        }
        ThreadPool threadPool = this.getThreadPool("SoapConnectorThreadPool", n);
        JMXSoapAdapter jMXSoapAdapter = new JMXSoapAdapter(threadPool);
        this.soapConnector = jMXSoapAdapter;
        string = this.soapConnectorProperties.getProperty("sslConfig");
        jMXSoapAdapter.initialize(this.soapConnectorProperties);
        this.soapConnectorProperties = null;
        DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(jMXSoapAdapter, "SOAPConnector");
        AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", defaultRuntimeCollaborator, "SOAPConnector", null);
        Properties properties = null;
        if (string != null) {
            properties = this.securityService.getSecureSocketLayer(string);
            String string3 = properties.getProperty("com.ibm.ssl.contextProvider");
            if (string3 != null && string3.equals("IBMJSSEFIPS")) {
                properties.setProperty("ssl.SocketFactory.provider", "com.ibm.fips.jsse.JSSESocketFactory");
            }
            SecurityHelper.getHelper().setSOAPSslSetting(properties);
            if (tc.isDebugEnabled()) {
                Properties properties2 = (Properties)properties.clone();
                properties2.remove("com.ibm.ssl.trustStorePassword");
                properties2.remove("com.ibm.ssl.keyStorePassword");
                Tr.debug((TraceComponent)tc, (String)"SOAP connector with ssl alias/setting:", (Object)new Object[]{string, properties2});
            }
        }
        if (this.securityService.isSecurityEnabled()) {
            if (string != null && properties != null) {
                ((JMXSoapAdapter)this.soapConnector).enableSsl(properties);
            } else {
                throw new RuntimeError(connectorNLS.getString("ADMC0019E"));
            }
        }
        this.soapConnector.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startSOAPConnector");
        }
    }

    private void initRMIConnector(Properties properties, EndPointMgr.EndPoints endPoints) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initRMIConnector");
        }
        try {
            this.rmiConnector = new RMIConnectorController();
            Properties properties2 = new Properties();
            String string = null;
            String string2 = null;
            EndPoint endPoint = endPoints.getEndPoint("BOOTSTRAP_ADDRESS");
            if (endPoint == null) {
                throw new RuntimeError(connectorNLS.getString("ADMC0018E"));
            }
            string = new Integer(endPoint.getPort()).toString();
            string2 = endPoint.getHost();
            properties2.setProperty("type", "RMI");
            properties2.setProperty("port", string);
            properties2.setProperty("host", string2);
            this.rmiConnector.initialize(properties2);
            AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", new DefaultRuntimeCollaborator(this.rmiConnector, "RMIConnector"), "RMIConnector", null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.component.JMXConnectors.initRMIConnector", (String)"396", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to initialize the RMI connector", (Object)throwable);
            }
            Tr.error((TraceComponent)tc, (String)"ADMC0020E", (Object)throwable.getMessage());
            throw new RuntimeError(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initRMIConnector");
        }
    }

    private void initHTTPConnector(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initHTTPConnector");
        }
        this.httpAdapterPort = properties.getProperty("port");
        if (this.httpAdapterPort == null || this.httpAdapterPort.equals("")) {
            this.httpAdapterPort = DEFAULT_HTTP_CONNECTOR_PORT;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initHTTPConnector", (Object)this.httpAdapterPort);
        }
    }

    private void startHTTPConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startHTTPConnector");
        }
        if (!this.httpConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"httpConnector is not enabled");
            }
            return;
        }
        try {
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                Tr.audit((TraceComponent)tc, (String)"ADMC0040I");
            } else {
                System.setProperty(TMX4J_HTTP_PORT_PROPERTY, this.httpAdapterPort);
                ObjectName objectName = new ObjectName("WebSphere", "name", "HTTPAdapter");
                ObjectInstance objectInstance = AdminServiceFactory.getMBeanFactory().getMBeanServer().createMBean("com.tivoli.jmx.http_pa.Listener", objectName);
                AdminServiceFactory.getMBeanFactory().getMBeanServer().invoke(objectName, "startListener", null, null);
                Tr.audit((TraceComponent)tc, (String)"ADMC0027I", (Object)this.httpAdapterPort);
                this.httpAdapterPort = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.startHTTPConnector", (String)"381", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMC0028W", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startHTTPConnector");
        }
    }

    private void interprocessRegistration() throws Exception {
        Object object;
        JMXConnector[] jMXConnectorArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"interprocessRegistration");
        }
        if (this.adminType.equals("UnManagedProcess")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"interprocessRegistration - standalone");
            }
            return;
        }
        Process process = com.ibm.ws.process.ProcessFactory.createSelf();
        String string = process.id();
        Vector<String> vector = new Vector<String>();
        EndPoint endPoint = this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("BOOTSTRAP_ADDRESS");
        if (endPoint != null) {
            jMXConnectorArray = new Integer(endPoint.getPort()).toString();
            String string2 = endPoint.getHost();
            object = new StringBuffer("endpoint:");
            ((StringBuffer)object).append("name=").append("BOOTSTRAP_ADDRESS");
            ((StringBuffer)object).append(";host=").append(string2);
            ((StringBuffer)object).append(";port=").append((String)jMXConnectorArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"bootstrap endpoint:", (Object)object);
            }
            vector.addElement(((StringBuffer)object).toString());
        }
        jMXConnectorArray = new JMXConnector[]{this.soapConnector, this.rmiConnector};
        for (int i = 0; i < jMXConnectorArray.length; ++i) {
            object = jMXConnectorArray[i];
            StringBuffer stringBuffer = new StringBuffer("connector:");
            stringBuffer.append(object.getName());
            if (this.pConnectorType != null && object.getType().equals(this.pConnectorType)) {
                stringBuffer.append(";preferred=true");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the preferred connector name: ", (Object)stringBuffer);
                }
            }
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"security enabled connector");
                }
                stringBuffer.append(";").append("securityEnabled").append("=true");
            }
            stringBuffer.append(";").append("isInternal").append("=true");
            vector.addElement(stringBuffer.toString());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("connector URI: " + stringBuffer));
        }
        ServerInfo serverInfo = new ServerInfo(string, this.cellName, this.nodeName, this.serverName, this.adminType, Utils.getProductVersion(), vector);
        RoutingTable.getInstance().setOwnInfo(serverInfo);
        if (this.adminType.equals("DeploymentManager")) {
            this.doCellMgrDiscovery(serverInfo);
        } else if (this.adminType.equals("NodeAgent")) {
            this.doNodeAgentDiscovery(serverInfo);
        } else if (this.adminType.equals("ManagedProcess")) {
            this.doManagedProcessDiscovery(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"interprocessRegistration");
        }
    }

    private void doCellMgrDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doCellMgrDiscovery");
        }
        Map map = this.epCollector.getNodeAgents();
        String string = new Integer(this.epCollector.getCellDiscoveryEndPoint().getPort()).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initialize the CellManager discovery service");
        }
        CMDiscoveryAdapter cMDiscoveryAdapter = new CMDiscoveryAdapter(serverInfo, string, this.cellDiscoveryProtocol);
        try {
            cMDiscoveryAdapter.initialize(this.threadPoolMgr);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.doCellMgrDiscovery", (String)"455", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMC0029E", (Object)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doCellMgrDiscovery - failed");
            }
            return;
        }
        HashMap hashMap = this.loadNodeProtocols();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            EndPoint endPoint = (EndPoint)map.get(string2);
            String string3 = endPoint.getHost();
            String string4 = new Integer(endPoint.getPort()).toString();
            ServerInfo serverInfo2 = new ServerInfo(this.cellName, string2, "NodeAgent");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The deployment manager is looking for the node agent: ", (Object)new Object[]{string2, string3, string4, serverInfo2});
            }
            Integer n = (Integer)hashMap.get(string2);
            int n2 = 1;
            if (n != null) {
                n2 = n;
            }
            cMDiscoveryAdapter.discovery(string3, string4, n2, serverInfo2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doCellMgrDiscovery");
        }
    }

    private void doNodeAgentDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doNodeAgentDiscovery");
        }
        String string = new Integer(this.epCollector.getNodeDiscoveryEndPoint().getPort()).toString();
        NADiscoveryAdapter nADiscoveryAdapter = new NADiscoveryAdapter(serverInfo, string, this.nodeDiscoveryProtocol);
        try {
            nADiscoveryAdapter.initialize(this.threadPoolMgr);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.doNodeAgentDiscovery", (String)"501", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMC0030E", (Object)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doNodeAgentDiscovery - failed");
            }
            return;
        }
        String string2 = this.epCollector.getCellDiscoveryEndPoint().getHost();
        String string3 = new Integer(this.epCollector.getCellDiscoveryEndPoint().getPort()).toString();
        String string4 = this.epCollector.getCellNodeName();
        ServerInfo serverInfo2 = new ServerInfo(this.cellName, string4, "DeploymentManager");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"The node agent is looking for the cell manager:", (Object)new Object[]{this.cellName, string2, string3, serverInfo2});
        }
        nADiscoveryAdapter.discovery(string2, string3, this.cellDiscoveryProtocol, serverInfo2);
        EndPoint endPoint = this.epCollector.getServerMulticastDiscoveryEndPoint();
        ServerInfo serverInfo3 = new ServerInfo(this.cellName, this.nodeName, "ManagedProcess");
        if (endPoint != null) {
            String string5 = endPoint.getHost();
            String string6 = new Integer(endPoint.getPort()).toString();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"looking for the managed process (multicast based):", (Object)new Object[]{string5, string6, serverInfo3});
            }
            MulticastVerifier multicastVerifier = new MulticastVerifier(string5, string6, 60000);
            multicastVerifier.start();
            multicastVerifier.waitForListening();
            nADiscoveryAdapter.discovery(string5, string6, 2, serverInfo3);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking for app servers, non-multicast based");
            }
            HashMap hashMap = this.epCollector.getServerDiscoveryEndPoints();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                EndPoint endPoint2 = (EndPoint)hashMap.get(string7);
                String string8 = endPoint2.getHost();
                String string9 = new Integer(endPoint2.getPort()).toString();
                if (tc.isEntryEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"looking for server: ", (Object)new Object[]{string7, string8, string9});
                }
                nADiscoveryAdapter.discovery(string8, string9, this.nodeDiscoveryProtocol, serverInfo3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doNodeAgentDiscovery");
        }
    }

    private void doManagedProcessDiscovery(ServerInfo serverInfo) throws Exception {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doManagedProcessDiscovery");
        }
        MulticastServer.setupNodeAgentConnector(this.endPtMgr);
        EndPoint endPoint = this.getServerMulticastDiscoveryEndPoint();
        ServerInfo serverInfo2 = new ServerInfo(this.cellName, this.nodeName, "NodeAgent");
        MPDiscoveryAdapter mPDiscoveryAdapter = null;
        if (endPoint != null) {
            string2 = endPoint.getHost();
            string = new Integer(endPoint.getPort()).toString();
            mPDiscoveryAdapter = new MPDiscoveryAdapter(serverInfo, string, 2, string2);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initialize the managed process discovery service: multicast");
                }
                mPDiscoveryAdapter.initialize(this.threadPoolMgr);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"565", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMC0031E", (Object)exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doManagedProcessDiscovery - failed");
                }
                return;
            }
        }
        string2 = this.getServerDiscoveryEndPoint();
        if (string2 == null) {
            NullPointerException nullPointerException = new NullPointerException("getServerDiscoveryEndPoint returned null value");
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"714", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMC0031E", (Object)nullPointerException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doManagedProcessDiscovery - failed");
            }
            throw nullPointerException;
        }
        mPDiscoveryAdapter = new MPDiscoveryAdapter(serverInfo, new Integer(string2.getPort()).toString(), this.nodeDiscoveryProtocol);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initialize the managed process discovery service: non-multicast");
            }
            mPDiscoveryAdapter.initialize(this.threadPoolMgr);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", (String)"714", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMC0031E", (Object)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doManagedProcessDiscovery - failed");
            }
            return;
        }
        string2 = this.getNodeDiscoveryEndPoint();
        string = string2.getHost();
        String string3 = new Integer(string2.getPort()).toString();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"The managed process is looking for its node agent:", (Object)new Object[]{this.nodeName, string, string3, serverInfo2});
        }
        mPDiscoveryAdapter.discovery(string, string3, this.nodeDiscoveryProtocol, serverInfo2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doManagedProcessDiscovery");
        }
    }

    private HashMap loadNodeProtocols() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadNodeProtocols");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ConfigRoot configRoot = this.repository.getConfigRoot();
        String[] stringArray = configRoot.list(3, null);
        String string = configRoot.getValue(3);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Integer n;
                configRoot.setValue(3, stringArray[i]);
                Resource resource = configRoot.getResource(3, "node.xml");
                Node node = (Node)resource.getContents().get(0);
                if (node.isSetDiscoveryProtocol()) {
                    TCPIPProtocolType tCPIPProtocolType = node.getDiscoveryProtocol();
                    n = new Integer(tCPIPProtocolType.getValue());
                } else {
                    n = new Integer(1);
                }
                if (n == null) continue;
                hashMap.put(node.getName(), n);
                continue;
            }
            catch (Exception exception) {
                Tr.service((TraceComponent)tc, (String)"ADMC0050E");
            }
        }
        configRoot.setValue(3, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadNodeProtocols");
        }
        return hashMap;
    }

    private EndPoint getServerDiscoveryEndPoint() throws Exception {
        return this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("SERVER_DISCOVERY_ADDRESS");
    }

    private EndPoint getServerMulticastDiscoveryEndPoint() throws Exception {
        EndPoint endPoint = null;
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        endPoint = nodeEndPoints.getEndPoint("NODE_MULTICAST_DISCOVERY_ADDRESS");
        return endPoint;
    }

    private EndPoint getNodeDiscoveryEndPoint() throws Exception {
        EndPoint endPoint = null;
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        endPoint = nodeEndPoints.getEndPoint("NODE_DISCOVERY_ADDRESS");
        return endPoint;
    }

    private ThreadPool getThreadPool(String string, int n) throws Exception {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(3);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(true);
        threadPool = this.threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (string.equals("STARTED")) {
            this.initDiscovery();
        }
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stateChanged");
        }
        if ((n = securityServiceEvent.getState()) == 1) {
            try {
                this.startSOAPConnector();
                this.startHTTPConnector();
            }
            catch (Exception exception) {
                throw new WsRuntimeException((Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stateChanged");
        }
    }

    public boolean started() {
        try {
            if (this.rmiConnectorEnabled) {
                this.rmiConnector.start();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return true;
    }

    public boolean quiesce() {
        if (this.rmiConnectorEnabled && this.rmiConnector != null) {
            this.rmiConnector.stop();
        }
        return true;
    }

    public boolean starting() {
        return true;
    }

    public boolean quiesceComplete() {
        return true;
    }

    public String getTypeName() {
        return "RMIConnector";
    }

    public int getType() {
        return 16;
    }

    public String getName() {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MulticastVerifier
    extends Thread {
        MulticastSocket serverSocket;
        boolean failed = false;
        boolean listening = false;
        boolean ignore = false;
        int timeout;

        MulticastVerifier(String string, String string2, int n) {
            super("MulticastVerifier");
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"MulticastVerifier", (Object)new Object[]{string, string2, new Integer(this.timeout)});
            }
            int n2 = Integer.parseInt(string2);
            this.timeout = n;
            try {
                this.serverSocket = new MulticastSocket(n2);
                this.serverSocket.joinGroup(InetAddress.getByName(string));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier", (String)"959", (Object)this);
                this.failed = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"MulticastVerifier");
            }
        }

        synchronized boolean isLisetening() {
            return this.listening;
        }

        void waitForListening() {
            int n = 0;
            while (true) {
                ++n;
                if (this.isLisetening()) {
                    return;
                }
                if (n > 10) {
                    this.ignore = true;
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"MulticastVerifier.run");
            }
            if (this.serverSocket != null) {
                try {
                    byte[] byArray = new byte[16384];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    this.serverSocket.setSoTimeout(this.timeout);
                    this.listening = true;
                    this.serverSocket.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    FFDCFilter.processException((Throwable)interruptedIOException, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", (String)"979", (Object)this);
                    this.failed = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", (String)"987", (Object)this);
                }
                finally {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.failed = true;
            }
            if (this.failed && !this.ignore) {
                Tr.warning((TraceComponent)tc, (String)"ADMC0051W");
                this.rediscover();
            }
            if (JMXConnectors.this.epCollector != null) {
                JMXConnectors.this.epCollector.discard();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"MulticastVerifier.run");
            }
        }

        void rediscover() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"rediscover");
            }
            HashMap hashMap = JMXConnectors.this.epCollector.getServerConnectorEndPoints();
            AdminClient adminClient = null;
            ObjectName objectName = null;
            boolean bl = SecurityHelper.getHelper().isSecurityEnabled();
            String string = bl ? "true" : "false";
            try {
                objectName = new ObjectName("*:*,type=Discovery");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            Subject subject = SecurityHelper.getServerSubject();
            if (subject != null) {
                SecurityHelper.pushInvocationSubject(subject);
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                String string2;
                block14: {
                    string2 = (String)iterator.next();
                    EndPoint endPoint = (EndPoint)hashMap.get(string2);
                    String string3 = new Integer(endPoint.getPort()).toString();
                    bl2 = false;
                    Properties properties = new Properties();
                    String string4 = Forwarder.getServerConnectorType(string2);
                    properties.setProperty("host", "localhost");
                    properties.setProperty("port", string3);
                    properties.setProperty("type", string4);
                    properties.setProperty("securityEnabled", string);
                    properties.setProperty("isInternal", "true");
                    try {
                        adminClient = AdminClientFactory.createAdminClient(properties);
                    }
                    catch (ConnectorException connectorException) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"unable to create client to remote process", (Object)new Object[]{properties, connectorException});
                    }
                }
                if (adminClient != null) {
                    try {
                        Set set = adminClient.queryNames(objectName, null);
                        if (set.iterator().hasNext()) {
                            ObjectName objectName2 = (ObjectName)set.iterator().next();
                            adminClient.invoke(objectName2, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{(class$com$ibm$ws$management$discovery$ServerInfo == null ? JMXConnectors.class$("com.ibm.ws.management.discovery.ServerInfo") : class$com$ibm$ws$management$discovery$ServerInfo).getName()});
                        } else {
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"failed to send out discover message", (Object)exception);
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                Tr.warning((TraceComponent)tc, (String)"ADMC0052W", (Object)string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rediscover");
            }
        }
    }

    private class EndPtCollector {
        String cellNodeName;
        Map nodeAgents;
        EndPoint cellDiscoveryEndPoint;
        EndPoint nodeDiscoveryEndPoint;
        EndPoint serverDiscoveryEndPoint;
        HashMap serverDiscoveryEndPoints;
        HashMap serverConnectorEndPoints;

        EndPtCollector(EndPointMgr endPointMgr) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"EndPtCollector");
            }
            this.nodeAgents = new HashMap();
            this.serverDiscoveryEndPoints = new HashMap();
            this.serverConnectorEndPoints = new HashMap();
            Map map = endPointMgr.getNodeEndPoints();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equals("@")) continue;
                EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)map.get(string);
                Map map2 = nodeEndPoints.getServerEndPoints();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processing node: ", (Object)string);
                }
                Iterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (string2.equals("@")) continue;
                    EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)map2.get(string2);
                    Map map3 = endPoints.getEndPoints();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processing server: ", (Object)string2);
                    }
                    Iterator iterator3 = map3.keySet().iterator();
                    while (iterator3.hasNext()) {
                        String string3;
                        String string4 = (String)iterator3.next();
                        EndPoint endPoint = (EndPoint)map3.get(string4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"processing endPoint: ", (Object)string4);
                        }
                        if (string4.equals("NODE_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("node agent discovery endpoint found for node: " + string));
                            }
                            this.nodeAgents.put(string, endPoint);
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            this.nodeDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("NODE_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("server discovery endpoint found for server: " + string2));
                            }
                            this.serverDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("CELL_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("cellmgr node name: " + string));
                            }
                            this.cellNodeName = string;
                            if (JMXConnectors.this.cellDiscoveryProtocol == 2) continue;
                            this.cellDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("CELL_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("cellmgr node name: " + JMXConnectors.this.nodeName));
                            }
                            this.cellNodeName = JMXConnectors.this.nodeName;
                            if (JMXConnectors.this.cellDiscoveryProtocol != 2) continue;
                            this.cellDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("SERVER_DISCOVERY_ADDRESS")) {
                            this.serverDiscoveryEndPoints.put(string2, endPoint);
                            continue;
                        }
                        if (string4.equals("SOAP_CONNECTOR_ADDRESS")) {
                            if (!string.equals(JMXConnectors.this.nodeName) || string2.equals(JMXConnectors.this.serverName) || !(string3 = Forwarder.getServerConnectorType(string2)).equals("SOAP")) continue;
                            this.serverConnectorEndPoints.put(string2, endPoint);
                            continue;
                        }
                        if (!string4.equals("BOOTSTRAP_ADDRESS") || !string.equals(JMXConnectors.this.nodeName) || string2.equals(JMXConnectors.this.serverName) || !(string3 = Forwarder.getServerConnectorType(string2)).equals("RMI")) continue;
                        this.serverConnectorEndPoints.put(string2, endPoint);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"EndPtCollector");
            }
        }

        EndPoint getCellDiscoveryEndPoint() {
            return this.cellDiscoveryEndPoint;
        }

        String getCellNodeName() {
            return this.cellNodeName;
        }

        EndPoint getNodeDiscoveryEndPoint() {
            return this.nodeDiscoveryEndPoint;
        }

        Map getNodeAgents() {
            return this.nodeAgents;
        }

        EndPoint getServerMulticastDiscoveryEndPoint() {
            return this.serverDiscoveryEndPoint;
        }

        HashMap getServerDiscoveryEndPoints() {
            return this.serverDiscoveryEndPoints;
        }

        HashMap getServerConnectorEndPoints() {
            return this.serverConnectorEndPoints;
        }

        void discard() {
            this.nodeAgents.clear();
            this.serverDiscoveryEndPoints.clear();
            this.serverConnectorEndPoints.clear();
            this.cellDiscoveryEndPoint = null;
            this.nodeDiscoveryEndPoint = null;
            this.serverDiscoveryEndPoint = null;
        }
    }
}

