/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.FileTransferService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.fileservice.FileServiceFactory;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class NodeAgentImpl
extends ComponentImpl
implements com.ibm.ws.management.service.NodeAgent {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$component$NodeAgentImpl == null ? (class$com$ibm$ws$management$component$NodeAgentImpl = NodeAgentImpl.class$("com.ibm.ws.management.component.NodeAgentImpl")) : class$com$ibm$ws$management$component$NodeAgentImpl), (String)"Admin", (String)"com.ibm.ws.management.resources.adminservice");
    private NodeAgent agentcfg;
    private static final int UUID_LENGTH = 16;
    private VariableMap variableMap = null;
    private Repository repository = null;
    static /* synthetic */ Class class$com$ibm$ws$management$component$NodeAgentImpl;
    static /* synthetic */ Class class$com$ibm$ws$management$service$NodeAgent;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadPoolMgr;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        NodeAgent nodeAgent;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        if ((nodeAgent = (NodeAgent)object).getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.agentcfg = (NodeAgent)etoolsCopyUtility.copy((EObject)nodeAgent);
        this.addService(class$com$ibm$ws$management$service$NodeAgent == null ? (class$com$ibm$ws$management$service$NodeAgent = NodeAgentImpl.class$("com.ibm.ws.management.service.NodeAgent")) : class$com$ibm$ws$management$service$NodeAgent);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            try {
                this.variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = NodeAgentImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
                this.repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NodeAgentImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                this.registerAgentMBean();
                this.createFileServiceMBean();
                this.startFileTransferService();
                this.initializeNodeSync();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.NodeAgentImpl.start", (String)"89", (Object)this);
                throw new RuntimeError((Throwable)exception);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.releaseService(this.variableMap);
            this.releaseService(this.repository);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"start");
            throw throwable;
        }
        this.releaseService(this.variableMap);
        this.releaseService(this.repository);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    public void stop() {
    }

    public void destroy() {
    }

    protected String getUuid(long l) {
        String string = Long.toHexString(l);
        if (string.length() < 16) {
            for (int i = 16 - string.length(); i > 0; --i) {
                string = string + "0";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startFileTransferService() {
        Serializable serializable;
        FileTransferService fileTransferService = this.agentcfg.getFileTransferService();
        if (fileTransferService == null) return;
        if (!fileTransferService.isEnable()) {
            return;
        }
        FileTransferConfig fileTransferConfig = null;
        try {
            serializable = Class.forName("com.ibm.ws.management.filetransfer.FileTransferConfigImpl");
            fileTransferConfig = (FileTransferConfig)((Class)serializable).newInstance();
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"ADMN0016E", (Object)throwable);
        }
        fileTransferConfig.setTransferRequestTimeout(new Integer(fileTransferService.getRetryWaitTime()));
        fileTransferConfig.setTransferRetryCount(new Integer(fileTransferService.getRetriesCount()));
        fileTransferConfig.setVariableMap(this.variableMap);
        serializable = ComponentImpl.getProperties((Service)fileTransferService);
        if (serializable == null) {
            serializable = new Properties();
        } else {
            Enumeration<Object> enumeration = ((Properties)serializable).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = ((Properties)serializable).getProperty(string);
                string2 = this.variableMap.expand(string2);
                ((Properties)serializable).put(string, string2);
            }
        }
        fileTransferConfig.setProperties((Properties)serializable);
        try {
            try {
                FileTransferFactory.initialize((FileTransferConfig)fileTransferConfig);
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"ADFS0102", (Object)throwable);
                Object var8_10 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"initialize");
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"initialize");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"initialize");
    }

    private void createFileServiceMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileServiceMBean");
        }
        boolean bl = true;
        EList eList = this.agentcfg.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            if (!"com.ibm.websphere.management.enableFileServiceMBean".equals(string) || !"false".equalsIgnoreCase(property.getValue())) continue;
            bl = false;
            break;
        }
        if (bl) {
            FileServiceFactory.createFileBrowserMBean(this.variableMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileServiceMBean");
        }
    }

    private void initializeNodeSync() throws ConfigurationWarning {
        Property property;
        Properties properties = new Properties();
        ConfigSynchronizationService configSynchronizationService = this.agentcfg.getFileSynchronizationService();
        EList eList = configSynchronizationService.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            property = (Property)iterator.next();
            properties.setProperty(property.getName(), property.getValue());
        }
        property = null;
        if (configSynchronizationService != null) {
            properties.setProperty("was.sync.processType", "NodeAgent");
            properties.setProperty("was.sync.autoSyncEnabled", new Boolean(configSynchronizationService.isAutoSynchEnabled()).toString());
            properties.setProperty("was.sync.syncInterval", new Integer(configSynchronizationService.getSynchInterval()).toString());
            properties.setProperty("was.sync.serverStartupSyncEnabled", new Boolean(configSynchronizationService.isSynchOnServerStartup()).toString());
            property = configSynchronizationService.getExclusions();
            try {
                NodeSync nodeSync = NodeSync.createNodeSync();
                if (nodeSync != null) {
                    nodeSync.initialize(properties, (List)property, this.variableMap);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.component.AdminImpl.initializeNodeSync", (String)"604", (Object)this);
                throw new ConfigurationWarning("Problem initializing node sync.", (Throwable)exception);
            }
        }
    }

    private void registerAgentMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerAgentMBeans");
        }
        Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = NodeAgentImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)this.getService(class$com$ibm$ws$runtime$service$ThreadPoolMgr == null ? (class$com$ibm$ws$runtime$service$ThreadPoolMgr = NodeAgentImpl.class$("com.ibm.ws.runtime.service.ThreadPoolMgr")) : class$com$ibm$ws$runtime$service$ThreadPoolMgr);
        Forwarder.initReceiver(this.repository, this.variableMap, threadPoolMgr);
        Forwarder.serverListenerRegistration(server);
        this.releaseService(server);
        this.releaseService(threadPoolMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerAgentMBeans");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

