/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.validation.IMessage;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SessionPropertyConstants;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.MalformedContainmentPathException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.AuthorizationTableExtDelegator;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.ClusterMemberDelegator;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.DataSourceDelegator;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.InnerConfigObjectDelegator;
import com.ibm.ws.management.configservice.J2CConnectionFactoryDelegator;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.NodeDelegator;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.SecurityDelegator;
import com.ibm.ws.management.configservice.ServerClusterDelegator;
import com.ibm.ws.management.configservice.ServerDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.ConnectionFactoryType;
import com.ibm.ws.management.configservice.csmetadata.ResourceProviderType;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ContextValidationMessages;
import com.ibm.ws.sm.validation.DocumentValidationMessages;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidatorValidationMessages;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ConfigServiceImpl
implements ConfigService,
SessionPropertyConstants {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$ConfigServiceImpl == null ? (class$com$ibm$ws$management$configservice$ConfigServiceImpl = ConfigServiceImpl.class$("com.ibm.ws.management.configservice.ConfigServiceImpl")) : class$com$ibm$ws$management$configservice$ConfigServiceImpl), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static ConfigService instance = null;
    private static HashMap sessionProps = new HashMap();
    private final HashMap delegatorTable = new HashMap();
    private AppManagement appMgr = null;
    private boolean initialized = false;
    private Properties props;
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$ConfigServiceImpl;

    public ConfigServiceImpl(Properties properties) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigServiceImpl");
        }
        if (properties == null) {
            properties = new Properties();
        }
        this.props = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigServiceImpl");
        }
    }

    private synchronized void initialize() {
        Object object;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.initialized = true;
        String string = this.props.getProperty("location");
        if (string != null && string.equalsIgnoreCase("local")) {
            ModelMgr.initialize((String)"ws-server");
        }
        try {
            RepositoryMetaDataFactory.initialize();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"62", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)exception);
        }
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        this.registerDelegator(new NodeDelegator(this));
        this.registerDelegator(new ServerDelegator(this));
        this.registerDelegator(new AuthorizationTableExtDelegator(this));
        this.registerDelegator(new ServerClusterDelegator(this));
        this.registerDelegator(new DataSourceDelegator(this));
        this.registerDelegator(new ClusterMemberDelegator(this));
        this.registerDelegator(new SecurityDelegator(this));
        this.registerDelegator(new J2CConnectionFactoryDelegator(this));
        this.registerRootConfigObjectDelegator(null, repositoryMetaData.getContextType("cells"));
        ConfigServiceMetadata configServiceMetadata = CSMetadataMgr.getConfigServiceMetadata();
        EList eList = configServiceMetadata.getResourceProviderTypes();
        for (int i = 0; i < eList.size(); ++i) {
            ResourceProviderType resourceProviderType = (ResourceProviderType)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("providerType" + eList));
            }
            object = resourceProviderType.getTypeName();
            RootObjectDelegator rootObjectDelegator = (RootObjectDelegator)this.getDelegator((String)(object = TypeRegistry.getShortType((String)object)));
            if (rootObjectDelegator == null) continue;
            EList eList2 = resourceProviderType.getConnectionFactoryTypes();
            for (int j = 0; j < eList2.size(); ++j) {
                ConnectionFactoryType connectionFactoryType = (ConnectionFactoryType)eList2.get(j);
                InnerConfigObjectDelegator innerConfigObjectDelegator = new InnerConfigObjectDelegator(this, TypeRegistry.getShortType(connectionFactoryType.getTypeName()), "factories");
                innerConfigObjectDelegator = (InnerConfigObjectDelegator)this.registerDelegatorIfNec(innerConfigObjectDelegator);
                rootObjectDelegator.registerChildType(innerConfigObjectDelegator.getType(), true, innerConfigObjectDelegator);
            }
        }
        try {
            String[] stringArray = TypeRegistry.getSubTypes("ServerComponent");
            for (int i = 0; i < stringArray.length; ++i) {
                object = new InnerConfigObjectDelegator(this, stringArray[i], "components");
                this.registerTypeAtServer(((InnerConfigObjectDelegator)object).getType(), true, (ConfigObjectDelegator)object);
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException((Throwable)((Object)invalidConfigDataTypeException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"91", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)((Object)invalidConfigDataTypeException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    private void registerRootConfigObjectDelegator(ConfigObjectDelegator configObjectDelegator, RepositoryContextType repositoryContextType) {
        String[] stringArray;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRootConfigObjectDelegator", (Object)new Object[]{configObjectDelegator, repositoryContextType});
        }
        RepositoryDocumentType repositoryDocumentType = repositoryContextType.getRootDocumentType();
        List list = repositoryContextType.getChildDocumentTypes();
        RootObjectDelegator rootObjectDelegator = null;
        if (repositoryDocumentType != null && repositoryDocumentType.getRootRefObjectTypes().length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"rootDocumentType name ", (Object)repositoryDocumentType.getFilePattern());
            }
            rootObjectDelegator = new RootObjectDelegator(this, repositoryContextType);
            rootObjectDelegator = (RootObjectDelegator)this.registerDelegatorIfNec(rootObjectDelegator);
            if (configObjectDelegator != null) {
                configObjectDelegator.registerChildType(rootObjectDelegator.getType(), true, rootObjectDelegator);
            }
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (RepositoryDocumentType)object2.next();
                if (object.equals(repositoryDocumentType) || (stringArray = object.getRootRefObjectTypes()) == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    RootObjectDelegator rootObjectDelegator2 = (RootObjectDelegator)this.getDelegator(stringArray[i]);
                    if (rootObjectDelegator2 == null) {
                        rootObjectDelegator2 = new RootObjectDelegator(this, stringArray[i], (RepositoryDocumentType)object);
                        rootObjectDelegator2 = (RootObjectDelegator)this.registerDelegatorIfNec(rootObjectDelegator2);
                    }
                    rootObjectDelegator.registerChildType(rootObjectDelegator2.getType(), true, rootObjectDelegator2);
                }
            }
        }
        object2 = repositoryContextType.getChildContextTypes();
        object = object2.iterator();
        while (object.hasNext()) {
            stringArray = (String[])object.next();
            this.registerRootConfigObjectDelegator(rootObjectDelegator, (RepositoryContextType)stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerRootConfigObjectDelegator");
        }
    }

    AppManagement getAppManagement() {
        if (this.appMgr == null) {
            try {
                this.appMgr = AdminServiceFactory.getAdminService() != null ? AppManagementProxy.getJMXProxyForServer() : AppManagementProxy.getLocalProxy();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.getAppManagement", (String)"193", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)new Object[]{exception});
            }
        }
        return this.appMgr;
    }

    public void registerTypeAtCell(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Cell")).registerChildType(string, bl, configObjectDelegator);
    }

    public void registerTypeAtNode(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Node")).registerChildType(string, bl, configObjectDelegator);
    }

    public void registerTypeAtServer(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Server")).registerChildType(string, bl, configObjectDelegator);
    }

    public void setProperties(Session session, HashMap hashMap) throws ConfigServiceException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperties", (Object)new Object[]{session, hashMap});
        }
        this.initialize();
        Integer n = hashMap.put("VALIDATION_LEVEL", null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"validationLevel", (Object)n);
        }
        Boolean bl = hashMap.put("ENABLE_CROSS_VALIDATION", null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"enableCrossValidation", (Object)bl);
        }
        if (n != null || bl != null) {
            object2 = WorkspaceHelper.getValidationManager(session);
            object = object2.getPolicy();
            if (bl != null) {
                object.setIncludeCross(bl);
            }
            if (SessionPropertyConstants.NO_VALIDATION.equals(n)) {
                object.setIncludeExtracted(false);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (SessionPropertyConstants.LOW_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (SessionPropertyConstants.MEDIUM_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(true);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (SessionPropertyConstants.HIGH_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(true);
                object.setIncludeLocalSiblings(true);
                object.setIncludeAll(false);
            } else if (SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(false);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"set enable to be all");
                }
                object.setIncludeAll(true);
            }
            try {
                object.affectUpdate();
            }
            catch (ValidationManagerException validationManagerException) {
                FFDCFilter.processException((Throwable)((Object)validationManagerException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"213", (Object)this);
                throw new ConfigServiceException((Throwable)((Object)validationManagerException));
            }
        }
        object2 = (Locale)hashMap.get("LOCALE");
        object = (Properties)sessionProps.get(session);
        if (object == null) {
            object = new Properties();
            sessionProps.put(session, object);
        }
        if (object2 != null) {
            ((Properties)object).put("LOCALE", object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperties");
        }
    }

    Object getSessionProperty(Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSessionProperty", (Object)new Object[]{session, string});
        }
        Properties properties = (Properties)sessionProps.get(session);
        Object object = null;
        if (properties != null) {
            object = properties.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSessionProperty");
        }
        return object;
    }

    public ValidationResult validate(Session session, ObjectName objectName) throws ConfigServiceException {
        RepositoryContext repositoryContext;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate", (Object)new Object[]{session, objectName});
        }
        this.initialize();
        if (objectName == null) {
            object = WorkspaceHelper.getWorkspace(session);
            repositoryContext = object.getRootContext();
        } else {
            object = ConfigServiceHelper.getConfigDataId(objectName);
            repositoryContext = WorkspaceHelper.getContext(session, (ConfigDataId)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("context" + repositoryContext.getURI()));
        }
        try {
            object = WorkspaceHelper.getValidationManager(session);
            ContextValidationMessages contextValidationMessages = object.getResults(repositoryContext);
            ValidationResult validationResult = new ValidationResult();
            Locale locale = (Locale)this.getSessionProperty(session, "LOCALE");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"client locale", (Object)locale);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Iterator iterator = contextValidationMessages.getDocumentMessages();
            while (iterator.hasNext()) {
                DocumentValidationMessages documentValidationMessages = (DocumentValidationMessages)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"documentMsgs", (Object)documentValidationMessages);
                }
                Iterator iterator2 = documentValidationMessages.getValidatorMessages();
                while (iterator2.hasNext()) {
                    ValidatorValidationMessages validatorValidationMessages = (ValidatorValidationMessages)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"validatorMsgs", (Object)validatorValidationMessages);
                    }
                    Iterator iterator3 = validatorValidationMessages.getMessages();
                    while (iterator3.hasNext()) {
                        IMessage iMessage = (IMessage)iterator3.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"msg", (Object)iMessage);
                        }
                        String string = iMessage.getText(locale);
                        Object object2 = iMessage.getTargetObject();
                        if (object2 instanceof EObject) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"targetObject", (Object)object2);
                            }
                            try {
                                object2 = MOFUtil.createObjectName((EObject)object2);
                            }
                            catch (Exception exception) {
                                object2 = object2.toString();
                            }
                        } else if (object2 != null) {
                            object2 = object2.toString();
                        }
                        ValidationResult.ValidationMessage validationMessage = new ValidationResult.ValidationMessage(string, object2, iMessage.getSeverity(), iMessage.getLineNo());
                        validationResult.addMessage(documentValidationMessages.getDocumentFullUri(), validatorValidationMessages.getValidatorClassName(), validationMessage);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate", (Object)validationResult);
            }
            return validationResult;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"277", (Object)this);
            String string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0017E", (Object[])new Object[]{session, objectName}, null);
            throw new ConfigServiceException(exception, string);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnsavedChanges", (Object)session);
        }
        this.initialize();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        List list = workSpace.getModifiedList();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = ((WorkSpaceFile)list.get(i)).getURI();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUnsavedChanges", (Object)stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConflictDocuments", (Object)session);
        }
        this.initialize();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        try {
            map = workSpace.checkSynchState();
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException((Throwable)((Object)workSpaceException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.getConflictDocuments", (String)"164", (Object)this);
            throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConflictDocuments", (Object)map);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Session session, boolean bl) throws ConfigServiceException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"save", (Object)session);
            }
            this.initialize();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            Subject subject = SecurityHelper.retrieveSubject();
            boolean bl2 = false;
            try {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    if (AdminServiceFactory.getAdminService() != null && subject != null) {
                        object3 = workSpace.getModifiedList();
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = ((WorkSpaceFile)object2.next()).getURI();
                            if (!RestrictedAccess.isRestricted((String)object)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) {
                            try {
                                object2 = null;
                                object2 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                    public Object run() {
                                        return SecurityHelper.getOwnedSubject();
                                    }
                                });
                                if (object2 != null) {
                                    SecurityHelper.pushInvocationSubject((Subject)object2);
                                }
                            }
                            catch (Exception exception) {
                                throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
                            }
                        }
                    }
                    object3 = workSpace.checkSynchState();
                    object2 = object3.keySet();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Object k = object.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("conflict uri" + k));
                        }
                        if (bl) {
                            object3.put(k, ConflictResolution.OVER_WRITE);
                            continue;
                        }
                        object3.remove(k);
                    }
                    workSpace.synch((Map)object3);
                }
                catch (WorkSpaceException workSpaceException) {
                    FFDCFilter.processException((Throwable)((Object)workSpaceException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.save", (String)"191", (Object)this);
                    throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getMessage());
                }
                Object var11_12 = null;
                if (!bl2 || subject == null) break block17;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (!bl2) throw throwable;
                if (subject == null) throw throwable;
                try {
                    SecurityHelper.pushInvocationSubject(subject);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
                }
            }
            try {}
            catch (Exception exception) {
                throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
            }
            SecurityHelper.pushInvocationSubject(subject);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"save", (Object)session);
    }

    public void discard(Session session) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"discard", (Object)session);
            }
            this.initialize();
            try {
                WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
                ValidationManagerRegistry validationManagerRegistry = ValidationHelper.getRegistry();
                validationManagerRegistry.release(WorkspaceHelper.getWorkspace(session));
                workSpaceManager.removeWorkSpace(session.toString());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.discard", (String)"207", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discard");
        }
    }

    private ConfigServiceDelegator registerDelegatorIfNec(ConfigServiceDelegator configServiceDelegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerDelegatorIfNec", (Object)configServiceDelegator);
        }
        if (this.delegatorTable.get(configServiceDelegator.getType()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("register delegator for type " + configServiceDelegator.getType()));
            }
            this.delegatorTable.put(configServiceDelegator.getType(), configServiceDelegator);
        } else {
            configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(configServiceDelegator.getType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerDelegatorIfNec", (Object)configServiceDelegator);
        }
        return configServiceDelegator;
    }

    public void registerDelegator(ConfigServiceDelegator configServiceDelegator) {
        this.delegatorTable.put(configServiceDelegator.getType(), configServiceDelegator);
    }

    public String[] getSupportedConfigObjectTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSupportedConfigObjectTypes");
        }
        this.initialize();
        Set set = TypeRegistry.getAllTypes();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSupportedConfigObjectTypes", (Object)stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributesMetaInfo", (Object)string);
        }
        this.initialize();
        AttributeList attributeList = null;
        ConfigServiceDelegator configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(string);
        attributeList = configServiceDelegator == null ? this.getAttributesMetaInfoBasic(string) : configServiceDelegator.getAttributesMetaInfo(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributesMetaInfo", (Object)attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(String string) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationshipsMetaInfo", (Object)string);
        }
        this.initialize();
        AttributeList attributeList = null;
        ConfigServiceDelegator configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(string);
        attributeList = configServiceDelegator == null ? this.getRelationshipsMetaInfoBasic(string) : configServiceDelegator.getRelationshipsMetaInfo(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsMetaInfo", (Object)attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] queryTemplates(Session session, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"qeuryTemplates", (Object)new Object[]{session, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ObjectName[] objectNameArray = null;
        try {
            RepositoryContext repositoryContext;
            Object object;
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session2);
            try {
                object = TemplateManagerFactory.getManager(workSpace);
                repositoryContext = object.getRootTemplateContext();
            }
            catch (WorkSpaceException workSpaceException) {
                throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getLocalizedMessage());
            }
            object = MOFUtil.createObjectName(repositoryContext);
            objectNameArray = this.getAllBasic(session2, (ObjectName)object, string, false);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryTemplates", (Object)objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] queryConfigObjects(Session session, ObjectName objectName, ObjectName objectName2, QueryExp queryExp) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("queryConfigObjects" + new Object[]{session, objectName, objectName2, queryExp}));
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ObjectName[] objectNameArray = null;
        try {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName2);
            if (configDataId != null) {
                ObjectName objectName3;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configId", (Object)configDataId);
                }
                if (ConfigServiceHelper.getDisplayName(objectName3 = WorkspaceHelper.getDocAccessor(session2, configDataId).resolveObjectName(session2, configDataId)) == null && ConfigServiceHelper.getDisplayName(objectName2) != null) {
                    objectName3 = ConfigServiceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(objectName3), ConfigServiceHelper.getConfigDataType(objectName3), ConfigServiceHelper.getDisplayName(objectName2));
                }
                objectNameArray = new ObjectName[]{objectName3};
            } else {
                ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName2);
                ObjectName[] objectNameArray2 = configServiceDelegator == null ? this.getAllBasic(session2, objectName, ConfigServiceHelper.getConfigDataType(objectName2), true) : configServiceDelegator.getAll(session2, objectName);
                ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(objectNameArray2.length);
                for (int i = 0; i < objectNameArray2.length; ++i) {
                    String string = ConfigServiceHelper.getDisplayName(objectName2);
                    if (string != null && !string.equals(ConfigServiceHelper.getDisplayName(objectNameArray2[i]))) continue;
                    arrayList.add(objectNameArray2[i]);
                }
                objectNameArray = new ObjectName[arrayList.size()];
                arrayList.toArray(objectNameArray);
            }
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryConfigObjects", (Object)objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] resolve(Session session, String string) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{session, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        try {
            AttributeList attributeList = this.parseContainmentPath(string);
            Attribute attribute = (Attribute)attributeList.remove(0);
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, attribute.getName(), (String)attribute.getValue());
            ArrayList arrayList = new ArrayList();
            ObjectName[] objectNameArray2 = this.queryConfigObjects(session2, null, objectName, null);
            for (int i = 0; i < objectNameArray2.length; ++i) {
                this.resolve(session2, objectNameArray2[i], attributeList, arrayList);
            }
            objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve", (Object)objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataByTemplate(Session session, ObjectName objectName, String string, AttributeList attributeList, ObjectName objectName2) throws ConfigServiceException {
        ObjectName objectName3;
        block11: {
            Session session2;
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"createConfigDataByTemplate", (Object)new Object[]{session, objectName, string, attributeList, objectName2});
                }
                this.initialize();
                session2 = session;
                if (session2 == null) {
                    session2 = new Session();
                }
                boolean bl = false;
                objectName3 = null;
                try {
                    ConfigServiceDelegator configServiceDelegator;
                    if (objectName2 != null) {
                        ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Template", objectName2);
                    }
                    objectName3 = (configServiceDelegator = this.getDelegator(session2, objectName)) == null ? this.createConfigDataBasic(session2, objectName, string, attributeList) : configServiceDelegator.createConfigData(session2, objectName, string, attributeList);
                    bl = true;
                    Object var11_10 = null;
                    if (session != null) break block11;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (session == null) {
                        if (bl) {
                            try {
                                this.save(session2, false);
                            }
                            catch (ConfigDocumentSaveException configDocumentSaveException) {
                                FFDCFilter.processException((Throwable)((Object)configDocumentSaveException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.createConfigData", (String)"359", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)((Object)configDocumentSaveException));
                            }
                        }
                        this.discard(session2);
                    }
                    throw throwable;
                }
                try {
                    this.save(session2, false);
                }
                catch (ConfigDocumentSaveException configDocumentSaveException) {
                    FFDCFilter.processException((Throwable)((Object)configDocumentSaveException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.createConfigData", (String)"359", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)((Object)configDocumentSaveException));
                }
            }
            this.discard(session2);
            {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigDataByTemplate", (Object)objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, String string2, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfigData", (Object)new Object[]{session, objectName, string, string2, attributeList});
        }
        this.initialize();
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Type", string2);
        }
        ObjectName objectName2 = this.createConfigDataByTemplate(session, objectName, string, attributeList, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigData", (Object)objectName2);
        }
        return objectName2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttributes", (Object)new Object[]{session, objectName, attributeList});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.setAttributesBasic(session2, objectName, attributeList);
            } else {
                configServiceDelegator.setAttributes(session2, objectName, attributeList);
            }
            bl = true;
            Object var8_7 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addElement", (Object)new Object[]{session, objectName, string, object, new Integer(n)});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.addElementBasic(session2, objectName, string, object, n);
            } else {
                configServiceDelegator.addElement(session2, objectName, string, object, n);
            }
            bl = true;
            Object var10_9 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeElement", (Object)new Object[]{session, objectName, string, object});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.removeElementBasic(session2, objectName, string, object);
            } else {
                configServiceDelegator.removeElement(session2, objectName, string, object);
            }
            bl = true;
            Object var9_8 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetAttributes", (Object)new Object[]{session, objectName, stringArray});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.unsetAttributesBasic(session2, objectName, stringArray);
            } else {
                configServiceDelegator.unsetAttributes(session2, objectName, stringArray);
            }
            bl = true;
            Object var8_7 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetAttributes", (Object)new Object[]{session, objectName, attributeList});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.resetAttributesBasic(session2, objectName, attributeList);
            } else {
                configServiceDelegator.resetAttributes(session2, objectName, attributeList);
            }
            bl = true;
            Object var8_7 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributes", (Object)new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl2 = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            attributeList = configServiceDelegator == null ? this.getAttributesBasic(session2, objectName, stringArray, bl) : configServiceDelegator.getAttributes(session2, objectName, stringArray, bl);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes", (Object)attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)new Object[]{session, objectName, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        Object object = null;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            object = configServiceDelegator == null ? this.getAttributeBasic(session2, objectName, string) : configServiceDelegator.getAttribute(session2, objectName, string);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteConfigData", (Object)new Object[]{session, objectName});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.deleteConfigDataBasic(session2, objectName);
            } else {
                configServiceDelegator.deleteConfigData(session2, objectName);
            }
            bl = true;
            Object var7_6 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                } else {
                    this.discard(session2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                } else {
                    this.discard(session2);
                }
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteConfigData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getRelationships(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationships", (Object)new Object[]{session, objectName, stringArray});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        AttributeList attributeList = new AttributeList();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ObjectName[] objectNameArray = this.getRelationship(session2, objectName, stringArray[i]);
                    attributeList.add(new Attribute(stringArray[i], objectNameArray));
                    continue;
                }
                catch (InvalidAttributeNameException invalidAttributeNameException) {
                    FFDCFilter.processException((Throwable)((Object)invalidAttributeNameException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.getRelationships", (String)"611", (Object)this);
                }
            }
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationship", (Object)new Object[]{session, objectName, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ObjectName[] objectNameArray = null;
        try {
            ConfigServiceDelegator configServiceDelegator = this.getDelegator(session2, objectName);
            objectNameArray = configServiceDelegator == null ? this.getRelationshipBasic(session2, objectName, string) : configServiceDelegator.getRelationship(session2, objectName, string);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationship", (Object)objectNameArray);
        }
        return objectNameArray;
    }

    public AttributeList getRelationshipsMetaInfoBasic(String string) throws InvalidConfigDataTypeException {
        TypeRegistry.getMetaObject(string);
        return new AttributeList();
    }

    public AttributeList getAttributesMetaInfoBasic(String string) throws InvalidConfigDataTypeException {
        return MOFUtil.getAttributesMetaInfo((EObject)TypeRegistry.getMetaObject(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataBasic(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            ObjectName objectName2 = docAccessor.createConfigData(session, configDataId, string, attributeList, false);
            docAccessor.localSave();
            ObjectName objectName3 = objectName2;
            return objectName3;
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributesBasic(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.setAttributes(session, configDataId, attributeList);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementBasic(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.addElementAt(session, configDataId, string, object, n, false);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementBasic(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.removeElement(session, configDataId, string, object);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributesBasic(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.unsetAttributes(session, configDataId, stringArray);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributesBasic(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            docAccessor.resetAttributes(session, configDataId, attributeList);
            docAccessor.localSave();
        }
        finally {
            if (docAccessor != null) {
                docAccessor.cleanup();
            }
        }
    }

    public AttributeList getAttributesBasic(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        return docAccessor.getAttributes(session, configDataId, stringArray, bl);
    }

    public Object getAttributeBasic(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        return docAccessor.getAttribute(session, configDataId, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigDataBasic(Session session, ObjectName objectName) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.deleteConfigData(session, configDataId);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    public ObjectName[] getRelationshipBasic(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        throw new UnsupportedOperationException();
    }

    public ObjectName[] getAllBasic(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllBasic", (Object)objectName);
        }
        Collection collection = WorkspaceHelper.getScopeContexts(session, objectName);
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName[] objectNameArray = collection.iterator();
        while (objectNameArray.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)objectNameArray.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"context", (Object)repositoryContext.getURI());
            }
            List list = repositoryContext.getAllList(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"file", (Object)workSpaceFile);
                }
                if (!workSpaceFile.toString().endsWith("xml")) continue;
                boolean bl2 = true;
                if (bl) {
                    bl2 = WorkspaceHelper.isConfigDocument(repositoryContext.getType(), workSpaceFile.getFileName());
                }
                if (!bl2) continue;
                try {
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, workSpaceFile);
                    ObjectName[] objectNameArray2 = docAccessor.getTypedObjects(session, string);
                    for (int i = 0; i < objectNameArray2.length; ++i) {
                        arrayList.add(objectNameArray2[i]);
                    }
                }
                catch (ConfigDocumentLoadException configDocumentLoadException) {
                    FFDCFilter.processException((Throwable)((Object)configDocumentLoadException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.getAllBasic", (String)"786", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ADMG0003E", (Object)((Object)configDocumentLoadException));
                }
            }
        }
        objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAll", (Object)objectNameArray);
        }
        return objectNameArray;
    }

    ConfigServiceDelegator getDelegator(String string) {
        return (ConfigServiceDelegator)this.delegatorTable.get(string);
    }

    private String getType(Session session, ObjectName objectName) throws ConfigServiceException {
        String string = ConfigServiceHelper.getConfigDataType(objectName);
        if (string == null) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            if (configDataId == null) {
                ConfigServiceException configServiceException = new ConfigServiceException("Config id is null.  Check if ObjectName is a valid WebSphere datatype");
                Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)((Object)configServiceException));
                FFDCFilter.processException((Throwable)((Object)configServiceException), (String)"com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", (String)"290", (Object)this);
                throw configServiceException;
            }
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            string = ConfigServiceHelper.getConfigDataType(docAccessor.resolveObjectName(session, configDataId));
        }
        return string;
    }

    private ConfigServiceDelegator getDelegator(Session session, ObjectName objectName) throws ConfigServiceException {
        return (ConfigServiceDelegator)this.delegatorTable.get(this.getType(session, objectName));
    }

    private String generateRelationshipName(ConfigServiceDelegator configServiceDelegator) {
        String string = configServiceDelegator.getType();
        return string;
    }

    private void resolve(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{session, objectName, attributeList, list});
        }
        if (attributeList.size() > 0) {
            Attribute attribute = (Attribute)attributeList.get(0);
            String string = attribute.getName();
            String string2 = (String)attribute.getValue();
            try {
                ObjectName[] objectNameArray = this.getRelationship(session, objectName, string);
                attributeList.remove(0);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    if (string2 != null && !string2.equals(ConfigServiceHelper.getDisplayName(objectNameArray[i]))) continue;
                    this.resolve(session, objectNameArray[i], attributeList, list);
                }
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(objectName));
                docAccessor.resolve(session, objectName, attributeList, list);
            }
        } else {
            list.add(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    private AttributeList parseContainmentPath(String string) throws MalformedContainmentPathException, InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseContainmentPath", (Object)string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        AttributeList attributeList = new AttributeList();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"token", (Object)string2);
            }
            String string3 = (n = string2.indexOf(61)) == -1 ? string2 : string2.substring(0, n);
            string3 = string3.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"key", (Object)string3);
            }
            TypeRegistry.getMetaObject(string3);
            if (string3.length() == 0) {
                throw new MalformedContainmentPathException(string, string2);
            }
            String string4 = n == -1 || n == string2.length() - 1 ? "" : string2.substring(n + 1);
            if ((string4 = string4.trim()).startsWith("\"")) {
                string4 = string4.substring(1);
            }
            if (string4.endsWith("\"")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if (string4.length() == 0) {
                string4 = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value", (Object)string4);
            }
            attributeList.add(new Attribute(string3, string4));
        }
        if (attributeList.size() == 0) {
            throw new MalformedContainmentPathException(string, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseContainmentPath", (Object)attributeList);
        }
        return attributeList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

