/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.InvalidSessionException;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.websphere.management.exception.VersionNotMatchException;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class DocAccessor {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$DocAccessor == null ? (class$com$ibm$ws$management$configservice$DocAccessor = DocAccessor.class$("com.ibm.ws.management.configservice.DocAccessor")) : class$com$ibm$ws$management$configservice$DocAccessor), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private Resource res;
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$DocAccessor;

    public DocAccessor(Resource resource) {
        this.res = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigData(Session session, ConfigDataId configDataId, String string, AttributeList attributeList, boolean bl) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            Object object;
            EObject eObject = this.lookup(configDataId);
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, bl);
            this.checkPermission(this.getDocumentUri(), eStructuralFeature.getEType(), attributeList);
            EObject eObject2 = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), (EObject)eStructuralFeature.getEType(), attributeList);
            RequiredAttributesRegistry.checkRequiredAttributes(eObject2);
            if (eStructuralFeature.isMany()) {
                object = (List)eObject.eGet(eStructuralFeature);
                SpecialAttributeRegistry.checkUnique((EClass)eStructuralFeature.getEType(), (List)object, eObject2);
                object.add(eObject2);
            } else {
                eObject.eSet(eStructuralFeature, (Object)eObject2);
            }
            object = MOFUtil.createObjectName(eObject2);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createRootConfigObject(Session session, String string, AttributeList attributeList) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EClass eClass = TypeRegistry.getMetaObject(string);
            this.checkPermission(this.getDocumentUri(), (EClassifier)eClass, attributeList);
            EObject eObject = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), (EObject)eClass, attributeList);
            RequiredAttributesRegistry.checkRequiredAttributes(eObject);
            SpecialAttributeRegistry.checkUnique(eClass, (List)this.res.getContents(), eObject);
            this.res.getContents().add((Object)eObject);
            MOFUtil.objectAdded(WorkspaceHelper.getContext(this.res), eObject, new MOFUtil.ReferenceHandler(), new Stack());
            ObjectName objectName = MOFUtil.createObjectName(eObject);
            return objectName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Session session, ConfigDataId configDataId, AttributeList attributeList) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            this.checkAttributeListVersion(attributeList);
            EObject eObject = this.lookup(configDataId);
            this.checkPermission(this.getDocumentUri(), (EClassifier)eObject.eClass(), attributeList);
            MOFUtil.setAttributes(WorkspaceHelper.getContext(this.res), eObject, attributeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName addElementAt(Session session, ConfigDataId configDataId, String string, Object object, int n, boolean bl) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            this.checkPermission(this.getDocumentUri(), (EClassifier)eObject.eClass(), string, object, true, bl);
            Object object2 = MOFUtil.addElementAt(WorkspaceHelper.getContext(this.res), eObject, string, object, n, bl);
            ObjectName objectName = null;
            if (object2 instanceof EObject) {
                EObject eObject2 = (EObject)object2;
                RequiredAttributesRegistry.checkRequiredAttributes(eObject2);
                objectName = MOFUtil.createObjectName(eObject2);
            }
            return objectName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Session session, ConfigDataId configDataId, String string, Object object) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            MOFUtil.removeElement(WorkspaceHelper.getContext(this.res), eObject, string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributes(Session session, ConfigDataId configDataId, String[] stringArray) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            String string = this.getDocumentUri();
            EClass eClass = eObject.eClass();
            for (int i = 0; i < stringArray.length; ++i) {
                this.checkPermission(string, (EClassifier)eClass, stringArray[i], null, false, false);
                MOFUtil.unsetAttribute(eObject, stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributes(Session session, ConfigDataId configDataId, AttributeList attributeList) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            this.checkAttributeListVersion(attributeList);
            EObject eObject = this.lookup(configDataId);
            this.checkPermission(this.getDocumentUri(), (EClassifier)eObject.eClass(), attributeList);
            MOFUtil.resetAttributes(WorkspaceHelper.getContext(this.res), eObject, attributeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getRootObjects(Session session) throws ConfigDataNotFoundException {
        Resource resource = this.res;
        synchronized (resource) {
            EList eList = this.res.getContents();
            ObjectName[] objectNameArray = new ObjectName[eList.size()];
            for (int i = 0; i < eList.size(); ++i) {
                EObject eObject = (EObject)eList.get(i);
                objectNameArray[i] = MOFUtil.createObjectName(eObject);
            }
            return objectNameArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getTypedObjects(Session session, String string) throws InvalidConfigDataTypeException {
        Resource resource = this.res;
        synchronized (resource) {
            Class<?> clazz;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getTypedObjects", (Object)new Object[]{session, string});
            }
            EList eList = this.res.getContents();
            try {
                clazz = Class.forName(TypeRegistry.getFullyQualifiedType(string));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.DocAccessor.getTypedObjects", (String)"279", (Object)this);
                throw new InvalidConfigDataTypeException(exception, string);
            }
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            for (int i = 0; eList != null && i < eList.size(); ++i) {
                EObject eObject = (EObject)eList.get(i);
                if (clazz.isInstance(eObject)) {
                    arrayList.add(MOFUtil.createObjectName(eObject));
                    continue;
                }
                TreeIterator treeIterator = eObject.eAllContents();
                while (treeIterator.hasNext()) {
                    Object e = treeIterator.next();
                    if (!clazz.isInstance(e) || !(e instanceof EObject)) continue;
                    arrayList.add(MOFUtil.createObjectName((EObject)e));
                }
            }
            ObjectName[] objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTypedObjects", (Object)objectNameArray);
            }
            return objectNameArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Session session, ConfigDataId configDataId, String string) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            Object object = MOFUtil.getAttribute(eObject, string, true);
            object = this.clearRestrictedAttribute(this.getDocumentUri(), TypeRegistry.getTypeShortName((EClassifier)eObject.eClass()), string, object);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getParent(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            EObject eObject2 = eObject.eContainer();
            return MOFUtil.createObjectName(eObject2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getRelationship(Session session, ConfigDataId configDataId, String string) throws InvalidAttributeNameException, ConfigDataNotFoundException {
        Resource resource = this.res;
        synchronized (resource) {
            ObjectName[] objectNameArray;
            EObject eObject = this.lookup(configDataId);
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, true);
            Object object = eObject.eGet(eStructuralFeature);
            if (object instanceof List) {
                List list = (List)object;
                objectNameArray = new ObjectName[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EObject eObject2 = (EObject)list.get(i);
                    objectNameArray[i] = MOFUtil.createObjectName(eObject2);
                }
            } else if (object instanceof EObject) {
                objectNameArray = new ObjectName[]{MOFUtil.createObjectName((EObject)object)};
            } else {
                throw new InvalidAttributeNameException(new String[]{string});
            }
            return objectNameArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName resolveObjectName(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException, ConfigDocumentLoadException, InvalidSessionException, SessionTimeoutException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            return MOFUtil.createObjectName(eObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{session, objectName, attributeList, list});
        }
        if (attributeList.size() == 0) {
            list.add(objectName);
        } else {
            Resource resource = this.res;
            synchronized (resource) {
                EObject eObject = this.lookup(ConfigServiceHelper.getConfigDataId(objectName));
                EList eList = eObject.eContents();
                Attribute attribute = (Attribute)attributeList.remove(0);
                String string = attribute.getName();
                String string2 = (String)attribute.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"type", (Object)string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"objectName", (Object)string2);
                }
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName2 = MOFUtil.createObjectName((EObject)iterator.next());
                    if (!string.equals(ConfigServiceHelper.getConfigDataType(objectName2)) || string2 != null && !string2.equals(ConfigServiceHelper.getDisplayName(objectName2))) continue;
                    this.resolve(session, objectName2, attributeList, list);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(Session session, ConfigDataId configDataId, String[] stringArray, boolean bl) throws ConfigServiceException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            AttributeList attributeList = MOFUtil.getAttributes(eObject, stringArray, bl);
            this.clearRestrictedAttributes(this.getDocumentUri(), attributeList);
            attributeList.add(new Attribute("_Websphere_Config_Data_Version", this.getDocumentDigest()));
            return attributeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigData(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        Resource resource = this.res;
        synchronized (resource) {
            EObject eObject = this.lookup(configDataId);
            String string = this.getDocumentUri();
            MOFUtil.delete(eObject);
            if (this.res.getContents().size() == 0) {
                RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
                this.res.getResourceSet().getResources().remove((Object)this.res);
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(this.res.getURI().path());
                try {
                    repositoryContext.notifyChanged(2, arrayList);
                }
                catch (WorkSpaceException workSpaceException) {
                    throw new ConfigDataNotFoundException(string, configDataId, (Exception)((Object)workSpaceException));
                }
                this.res = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentUri() {
        Resource resource = this.res;
        synchronized (resource) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
            return repositoryContext.getURI() + '/' + this.res.getURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localSave() throws ConfigDocumentSaveException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"localSave");
        }
        if (this.res == null) {
            return;
        }
        Resource resource = this.res;
        synchronized (resource) {
            try {
                if (this.res.isModified()) {
                    this.res.save(new HashMap());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.DocAccessor.localSave", (String)"454", (Object)this);
                throw new ConfigDocumentSaveException(this.getDocumentUri(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"localSave");
        }
    }

    public void cleanup() {
        if (this.res == null) {
            return;
        }
        if (this.res.isModified() && this.res.getResourceSet() != null) {
            this.res.getResourceSet().getResources().remove((Object)this.res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EObject lookup(ConfigDataId configDataId) throws ConfigDataNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookup", (Object)configDataId);
        }
        Resource resource = this.res;
        synchronized (resource) {
            URI uRI = MOFUtil.getURI(configDataId);
            EObject eObject = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ref id", (Object)uRI.fragment());
            }
            if (!uRI.hasFragment()) {
                if (this.res.getContents().size() > 0) {
                    eObject = (EObject)this.res.getContents().get(0);
                }
            } else {
                eObject = this.res.getEObject(uRI.fragment());
            }
            if (eObject == null) {
                throw new ConfigDataNotFoundException(this.getDocumentUri(), configDataId, null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookup", (Object)eObject);
            }
            return eObject;
        }
    }

    Resource getResource() {
        return this.res;
    }

    private void checkPermission(String string, EClassifier object, AttributeList attributeList) throws ConfigServiceException {
        Object object2;
        block9: {
            if (!SecurityContext.isSecurityEnabled()) {
                return;
            }
            if (attributeList == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
                object2 = TypeRegistry.getMetaObject(string2);
                if (object.getInstanceClass().isAssignableFrom(object2.getInstanceClass())) {
                    object = object2;
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"type is not specified");
                }
            }
            catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
                FFDCFilter.processException((Throwable)((Object)invalidConfigDataTypeException), (String)"com.ibm.ws.management.configservice.MOFUtil.validateAttributeList", (String)"497");
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"specified type is not valid", (Object)string2);
            }
        }
        if (RestrictedAccess.isRestricted((String)string)) {
            object2 = attributeList.iterator();
            while (object2.hasNext()) {
                Attribute attribute = (Attribute)object2.next();
                Object object3 = attribute.getValue();
                String string3 = attribute.getName();
                this.checkPermission(string, (EClassifier)object, string3, object3, false, false);
            }
        }
    }

    private void checkPermission(String string, EClassifier eClassifier, String string2, Object object, boolean bl, boolean bl2) throws ConfigServiceException {
        String string3;
        if (!SecurityContext.isSecurityEnabled()) {
            return;
        }
        if (SystemAttributes.isSystemAttribute(string2)) {
            return;
        }
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eClassifier, string2, bl2);
        if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) {
            if (object == null) {
                return;
            }
            if (!bl && eStructuralFeature.isMany()) {
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof AttributeList)) {
                        throw new InvalidAttributeValException(string2);
                    }
                    this.checkPermission(string, eStructuralFeature.getEType(), (AttributeList)e);
                }
            } else {
                if (!(object instanceof AttributeList)) {
                    throw new InvalidAttributeValException(string2);
                }
                this.checkPermission(string, eStructuralFeature.getEType(), (AttributeList)object);
            }
        } else if (RestrictedAccess.isRestricted((String)string) && RestrictedAccess.isRestricted((String)string, (String)(string3 = eClassifier.getInstanceClass().getName()), (String)string2)) {
            RoleBasedAuthorizer roleBasedAuthorizer;
            try {
                roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
            }
            if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                throw new ConfigServiceException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0035E", (Object[])new Object[]{string2, string3, string}, null));
            }
        }
    }

    private void clearRestrictedAttributes(String string, AttributeList attributeList) throws ConfigServiceException {
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable((String)string)) {
            this.clearRestrictedAttributesBase(string, attributeList);
        }
    }

    private Object clearRestrictedAttribute(String string, String string2, String string3, Object object) throws ConfigServiceException {
        Object object2 = object;
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable((String)string)) {
            object2 = this.clearRestrictedAttributeBase(string, string2, string3, object);
        }
        return object;
    }

    private void clearRestrictedAttributesBase(String string, AttributeList attributeList) throws ConfigServiceException {
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string2 != null) {
            for (int i = 0; i < attributeList.size(); ++i) {
                String string3;
                Object object;
                Attribute attribute = (Attribute)attributeList.get(i);
                Object object2 = attribute.getValue();
                if (object2 == (object = this.clearRestrictedAttributeBase(string, string2, string3 = attribute.getName(), object2))) continue;
                attributeList.set(i, new Attribute(string3, object));
            }
        }
    }

    private Object clearRestrictedAttributeBase(String string, String string2, String string3, Object object) throws ConfigServiceException {
        if (object instanceof AttributeList) {
            this.clearRestrictedAttributesBase(string, (AttributeList)object);
        } else if (object instanceof List) {
            if (!RestrictedAccess.isReadable((String)string, (String)TypeRegistry.getFullyQualifiedType(string2), (String)string3)) {
                RoleBasedAuthorizer roleBasedAuthorizer;
                try {
                    roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
                }
                catch (Exception exception) {
                    throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
                }
                if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                    ((List)object).clear();
                }
            } else {
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof AttributeList)) continue;
                    this.clearRestrictedAttributesBase(string, (AttributeList)e);
                }
            }
        } else if (!RestrictedAccess.isReadable((String)string, (String)TypeRegistry.getFullyQualifiedType(string2), (String)string3)) {
            RoleBasedAuthorizer roleBasedAuthorizer;
            try {
                roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", null, null));
            }
            if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                object = null;
            }
        }
        return object;
    }

    private void checkAttributeListVersion(AttributeList attributeList) throws VersionNotMatchException {
        DocumentDigest documentDigest = null;
        try {
            documentDigest = (DocumentDigest)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Version");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        documentDigest = null;
        if (documentDigest != null && !((Object)documentDigest).equals(this.getDocumentDigest())) {
            throw new VersionNotMatchException();
        }
    }

    private DocumentDigest getDocumentDigest() {
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

