/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerTypeConstants;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EndpointConfigHelper
implements DistinguishedEndpointConstants,
ServerTypeConstants {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$EndpointConfigHelper == null ? (class$com$ibm$ws$management$configservice$EndpointConfigHelper = EndpointConfigHelper.class$("com.ibm.ws.management.configservice.EndpointConfigHelper")) : class$com$ibm$ws$management$configservice$EndpointConfigHelper), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static final List emptyArray = new ArrayList(0);
    private static final ServerindexFactory serverIndexFactory = ServerindexFactory.eINSTANCE;
    private static final IpcPackage ipcPckg = IpcFactory.eINSTANCE.getIpcPackage();
    private static Map endpointMap = new HashMap();
    private static Map serverTypeMap;
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$EndpointConfigHelper;

    static void getAllEndpointMetaInfo(EClassifier eClassifier, AttributeList attributeList) {
        String string;
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllEndpointMetaInfo", (Object)eClassifier);
        }
        if ((distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string = TypeRegistry.getTypeShortName(eClassifier))) != null) {
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                String string2 = distinguishedEndpointInfoArray[i].getEndpointName();
                AttributeList attributeList2 = EndpointConfigHelper.getEndpointMetaInfo(string2);
                attributeList.add(new Attribute(string2, attributeList2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllEndpointMetaInfo");
        }
    }

    static List getEndpointAttributeNames(EClassifier eClassifier) {
        ArrayList<String> arrayList;
        String string;
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEndpointAttributeNames", (Object)eClassifier);
        }
        if ((distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string = TypeRegistry.getTypeShortName(eClassifier))) != null) {
            arrayList = new ArrayList<String>(distinguishedEndpointInfoArray.length);
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                arrayList.add(distinguishedEndpointInfoArray[i].getEndpointName());
            }
        } else {
            arrayList = emptyArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEndpointAttributeNames", arrayList);
        }
        return arrayList;
    }

    static boolean isEndpointAttribute(EClassifier eClassifier, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEndpointAttribute", (Object)new Object[]{eClassifier, string});
        }
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string2);
        boolean bl = false;
        if (distinguishedEndpointInfoArray != null) {
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isEndpointAttribute," + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getEndpointAttribute(EObject eObject, String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEndpointAttribute", (Object)new Object[]{eObject, string, new Boolean(bl)});
        }
        String string2 = TypeRegistry.getTypeShortName((EClassifier)eObject.eClass());
        DocAccessor docAccessor = EndpointConfigHelper.getServerIndexAccessor(eObject);
        Resource resource = docAccessor.getResource();
        Object object = null;
        Resource resource2 = resource;
        synchronized (resource2) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
            String string3 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"serverName", (Object)string3);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string3)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"matched", (Object)serverEntry);
                break;
            }
            if (serverEntry != null) {
                object = EndpointConfigHelper.getNamedEndpoint(serverEntry, string, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEndpointAttribute", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerType(RepositoryContext repositoryContext, EClassifier eClassifier) throws ConfigServiceException {
        String string = TypeRegistry.getTypeShortName(eClassifier);
        String string2 = (String)serverTypeMap.get(string);
        if (string2 != null) {
            RepositoryContext repositoryContext2 = repositoryContext.getParent();
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
            Resource resource = docAccessor.getResource();
            Object var7_7 = null;
            Resource resource2 = resource;
            synchronized (resource2) {
                String string3 = repositoryContext.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"serverName", (Object)string3);
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                ServerEntry serverEntry = null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                    if (!serverEntry2.getServerName().equals(string3)) continue;
                    serverEntry = serverEntry2;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"matched", (Object)serverEntry);
                    break;
                }
                if (serverEntry == null) {
                    serverEntry = EndpointConfigHelper.createServerEntry(repositoryContext2, string3);
                }
                if (string2 != null) {
                    string2 = "DEPLOYMENT_MANAGER".equals(string2) ? "DEPLOYMENT_MANAGER" : ("NODE_AGENT".equals(string2) ? "NODE_AGENT" : ("APPLICATION_SERVER".equals(string2) && (serverEntry.getServerType() == null || serverEntry.getServerType().equals("MESSAGE_BROKER")) ? "APPLICATION_SERVER" : ("MESSAGE_BROKER".equals(string2) && serverEntry.getServerType() == null ? "MESSAGE_BROKER" : serverEntry.getServerType())));
                    serverEntry.setServerType(string2);
                }
                docAccessor.localSave();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getServerType(RepositoryContext repositoryContext) throws ConfigServiceException {
        Resource resource;
        String string = null;
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            String string2 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"serverName", (Object)string2);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string2)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"matched", (Object)serverEntry);
                break;
            }
            if (serverEntry != null) {
                string = serverEntry.getServerType();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerEntry", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setEndpointAttribute(RepositoryContext repositoryContext, EClassifier eClassifier, String string, AttributeList attributeList, MOFUtil.ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setEndpointAttribute", (Object)new Object[]{repositoryContext, eClassifier, string, attributeList});
        }
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        Resource resource = docAccessor.getResource();
        Object var10_10 = null;
        Resource resource2 = resource;
        synchronized (resource2) {
            String string3 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"serverName", (Object)string3);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string3)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"matched", (Object)serverEntry);
                break;
            }
            if (serverEntry == null) {
                serverEntry = EndpointConfigHelper.createServerEntry(repositoryContext2, string3);
            }
            EndpointConfigHelper.setNamedEndpoint(serverEntry, string2, string, attributeList, referenceHandler, stack);
            docAccessor.localSave();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setEndpointAttribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteEndpoints(RepositoryContext repositoryContext, String string, EClassifier eClassifier) throws ConfigServiceException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteEndpoints", (Object)new Object[]{repositoryContext, string, eClassifier});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                ServerIndex serverIndex;
                ServerEntry serverEntry;
                EList eList = resource.getContents();
                if (eList != null && eList.size() > 0 && (serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex = (ServerIndex)eList.get(0), string)) != null) {
                    List list = EndpointConfigHelper.getEndpointAttributeNames(eClassifier);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, (String)iterator.next());
                        if (namedEndPoint == null) continue;
                        MOFUtil.deleteEObject((EObject)namedEndPoint);
                    }
                    docAccessor.localSave();
                }
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteEndpoints");
        }
    }

    static EClassifier getEndpointMetaObj() {
        return ipcPckg.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerEntry createServerEntry(RepositoryContext repositoryContext, String string, ObjectName objectName) throws ConfigServiceException {
        ServerEntry serverEntry;
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerEntry", (Object)new Object[]{repositoryContext, string, objectName});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                ServerIndex serverIndex;
                EList eList = resource.getContents();
                if (eList.size() == 0) {
                    serverIndex = serverIndexFactory.createServerIndex();
                    eList.add(serverIndex);
                } else {
                    serverIndex = (ServerIndex)resource.getContents().get(0);
                }
                serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex, string);
                if (serverEntry == null) {
                    RepositoryContext repositoryContext2;
                    Object object;
                    DocAccessor docAccessor2;
                    ServerIndex serverIndex2;
                    ServerEntry serverEntry2;
                    if (objectName != null && (serverEntry2 = EndpointConfigHelper.lookupServerEntry(serverIndex2 = (ServerIndex)(docAccessor2 = WorkspaceHelper.getDocAccessor((RepositoryContext)(object = (repositoryContext2 = WorkspaceHelper.getContext(repositoryContext.getWorkSpace(), ConfigServiceHelper.getConfigDataId(objectName))).getParent()), "serverindex.xml")).getResource().getContents().get(0), ConfigServiceHelper.getDisplayName(objectName))) != null) {
                        serverEntry = (ServerEntry)RefObjectHelperFactory.getRefObjectHelper().clone((EObject)serverEntry2);
                    }
                    if (serverEntry == null) {
                        serverEntry = serverIndexFactory.createServerEntry();
                    }
                    serverEntry.setServerName(string);
                    repositoryContext2 = serverEntry.getSpecialEndpoints();
                    object = repositoryContext2.iterator();
                    while (object.hasNext()) {
                        docAccessor2 = (NamedEndPoint)object.next();
                        serverIndex2 = docAccessor2.getEndPoint();
                        if (serverIndex2 == null) continue;
                        serverIndex2.setPort(EndpointConfigHelper.adjustPort(repositoryContext, serverIndex2.getPort(), null));
                    }
                    serverIndex.getServerEntries().add((Object)serverEntry);
                }
                docAccessor.localSave();
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerEntry", (Object)serverEntry);
        }
        return serverEntry;
    }

    static ServerEntry createServerEntry(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        return EndpointConfigHelper.createServerEntry(repositoryContext, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteServerEntry(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerEntry", (Object)new Object[]{repositoryContext, string});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                EList eList = resource.getContents();
                if (eList.size() > 0) {
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex, string);
                    if (serverEntry != null) {
                        MOFUtil.deleteEObject((EObject)serverEntry);
                    }
                    docAccessor.localSave();
                }
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getDeployedApplications(Session session, ObjectName objectName) throws ConfigServiceException {
        Resource resource;
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)).getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry((ServerIndex)resource.getContents().get(0), ConfigServiceHelper.getDisplayName(objectName));
            ArrayList arrayList = new ArrayList(serverEntry.getDeployedApplications());
            return arrayList;
        }
    }

    private static DocAccessor getServerIndexAccessor(EObject eObject) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerIndexAccessor", (Object)eObject);
        }
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serverContext", (Object)repositoryContext);
        }
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerIndexAccessor", (Object)docAccessor);
        }
        return docAccessor;
    }

    private static ServerEntry lookupServerEntry(ServerIndex serverIndex, String string) {
        EList eList = serverIndex.getServerEntries();
        ServerEntry serverEntry = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry2 = (ServerEntry)iterator.next();
            if (!serverEntry2.getServerName().equals(string)) continue;
            serverEntry = serverEntry2;
            break;
        }
        return serverEntry;
    }

    private static Object getNamedEndpoint(ServerEntry serverEntry, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNamedEndpoint", (Object)new Object[]{serverEntry, string});
        }
        Serializable serializable = null;
        NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, string);
        if (namedEndPoint != null) {
            serializable = bl ? MOFUtil.getAttributes((EObject)namedEndPoint.getEndPoint(), null, true) : MOFUtil.createObjectName((EObject)namedEndPoint.getEndPoint());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNamedEndpoint", (Object)serializable);
        }
        return serializable;
    }

    private static NamedEndPoint lookupNamedEndpoint(ServerEntry serverEntry, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupNamedEndpoint", (Object)new Object[]{serverEntry, string});
        }
        NamedEndPoint namedEndPoint = null;
        EList eList = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint2 = (NamedEndPoint)iterator.next();
            if (!string.equals(namedEndPoint2.getEndPointName())) continue;
            namedEndPoint = namedEndPoint2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNamedEndpoint", namedEndPoint);
        }
        return namedEndPoint;
    }

    private static void setNamedEndpoint(ServerEntry serverEntry, String string, String string2, AttributeList attributeList, MOFUtil.ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        NamedEndPoint namedEndPoint;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNamedEndpoint", (Object)new Object[]{serverEntry, string2, attributeList});
        }
        EList eList = serverEntry.getSpecialEndpoints();
        NamedEndPoint namedEndPoint2 = null;
        EObject eObject = eList.iterator();
        while (eObject.hasNext()) {
            namedEndPoint = (NamedEndPoint)eObject.next();
            if (!string2.equals(namedEndPoint.getEndPointName())) continue;
            namedEndPoint2 = namedEndPoint;
            break;
        }
        if (attributeList == null) {
            if (namedEndPoint2 != null) {
                MOFUtil.deleteEObject(namedEndPoint2);
            }
        } else {
            for (eObject = serverEntry.eContainer(); eObject != null && !(eObject instanceof ServerIndex); eObject = eObject.eContainer()) {
            }
            namedEndPoint = (ServerIndex)eObject;
            if (namedEndPoint2 == null) {
                namedEndPoint2 = serverIndexFactory.createNamedEndPoint();
                namedEndPoint2.setEndPointName(string2);
                eList.add(namedEndPoint2);
                if (EndpointConfigHelper.isUniqueEndpoint(string, string2)) {
                    namedEndPoint.getEndPointRefs().add((Object)namedEndPoint2);
                }
            }
            if (namedEndPoint2.getEndPoint() == null) {
                EndPoint endPoint = ipcPckg.getIpcFactory().createEndPoint();
                endPoint.setPort(-1);
                namedEndPoint2.setEndPoint(endPoint);
            }
            EndpointConfigHelper.fillDefaultEndpoint((ServerIndex)namedEndPoint, serverEntry, string, string2, attributeList);
            MOFUtil.setAttributes(WorkspaceHelper.getContext(serverEntry.eResource()), (EObject)namedEndPoint2.getEndPoint(), attributeList, referenceHandler, stack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setNamedEndpoint");
        }
    }

    private static AttributeList getEndpointMetaInfo(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEndpointMetaInfo", (Object)string);
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("_Attribute_MetaInfo_Name", string));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Default_Value", null));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        String string2 = TypeRegistry.getTypeShortName((EClassifier)ipcPckg.getEndPoint());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"typeName", (Object)string2);
        }
        attributeList.add(new Attribute("_Attribute_MetaInfo_Type", string2));
        try {
            String[] stringArray = TypeRegistry.getSubTypes(string2);
            if (stringArray != null && stringArray.length > 0) {
                attributeList.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(stringArray)));
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            // empty catch block
        }
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEndpointMetaInfo", (Object)attributeList);
        }
        return attributeList;
    }

    private static int defaultEndpoint(String string, String string2) {
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string);
        int n = 0;
        for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
            if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string2)) continue;
            n = distinguishedEndpointInfoArray[i].getDefaultPort();
            break;
        }
        return n;
    }

    private static boolean isUniqueEndpoint(String string, String string2) {
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string);
        boolean bl = false;
        for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
            if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string2)) continue;
            bl = distinguishedEndpointInfoArray[i].isUnique();
            break;
        }
        return bl;
    }

    public static int adjustPort(RepositoryContext repositoryContext, int n, List arrayList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("adjustPort," + n));
        }
        if (n == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("adjustPort," + n));
            }
            return n;
        }
        try {
            Object object;
            if (arrayList == null) {
                Object object2;
                arrayList = new ArrayList<Integer>();
                if (repositoryContext.getType().getName().equals("servers")) {
                    repositoryContext = repositoryContext.getParent();
                }
                if (!repositoryContext.getType().getName().equals("nodes")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"should never happen");
                    }
                    return n;
                }
                object = repositoryContext.getType();
                RepositoryDocumentType repositoryDocumentType = object.getRootDocumentType();
                ConfigDataId configDataId = new ConfigDataId(repositoryContext.getURI(), repositoryDocumentType.getFilePattern());
                ObjectName objectName = ConfigServiceHelper.createObjectName(configDataId, repositoryDocumentType.getRootRefObjectTypes()[0], repositoryContext.getName());
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session(repositoryContext.getWorkSpace().getUserName(), true);
                String string = (String)configService.getAttribute(session, objectName, "hostName");
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Node");
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName2, null);
                ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
                for (int i = 0; i < objectNameArray.length; ++i) {
                    object2 = (String)configService.getAttribute(session, objectNameArray[i], "hostName");
                    if (!string.equals(object2)) continue;
                    arrayList2.add(objectNameArray[i]);
                }
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    object2 = (ObjectName)iterator.next();
                    ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, (ObjectName)object2, ConfigServiceHelper.createObjectName(null, "EndPoint"), null);
                    for (int i = 0; i < objectNameArray2.length; ++i) {
                        Integer n2 = (Integer)configService.getAttribute(session, objectNameArray2[i], "port");
                        if (n2 == null) continue;
                        arrayList.add(n2);
                    }
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (n != (Integer)object.next()) continue;
                ++n;
                n = EndpointConfigHelper.adjustPort(repositoryContext, n, arrayList);
                break;
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw configServiceException;
        }
        catch (AdminException adminException) {
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("adjustPort," + n));
        }
        return n;
    }

    private static void fillDefaultEndpoint(ServerIndex serverIndex, ServerEntry serverEntry, String string, String string2, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fillDefaultEndpoint", (Object)new Object[]{serverIndex, string2, attributeList});
        }
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "host");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (object == null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "host", serverIndex.getHostName());
        }
        object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "port");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (object == null) {
            EndPoint endPoint;
            int n = -1;
            NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, string2);
            if (namedEndPoint != null && (endPoint = namedEndPoint.getEndPoint()) != null) {
                n = endPoint.getPort();
            }
            if (n == -1) {
                n = EndpointConfigHelper.defaultEndpoint(string, string2);
            }
            n = EndpointConfigHelper.adjustPort(WorkspaceHelper.getContext(serverIndex.eResource()), n, null);
            ConfigServiceHelper.setAttributeValue(attributeList, "port", new Integer(n));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        endpointMap.put("SystemMessageServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("DRS_CLIENT_ADDRESS", 7873, false)});
        endpointMap.put("JMSServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("JMSSERVER_DIRECT_ADDRESS", 5559, false), new DistinguishedEndpointInfo("JMSSERVER_QUEUED_ADDRESS", 5558, false)});
        endpointMap.put("NameServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("BOOTSTRAP_ADDRESS", 9810, false)});
        endpointMap.put("ObjectRequestBroker", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("ORB_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", 0, false)});
        endpointMap.put("NodeAgent", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("NODE_DISCOVERY_ADDRESS", 7272, true)});
        endpointMap.put("CellManager", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("CELL_MULTICAST_DISCOVERY_ADDRESS", 5000, true), new DistinguishedEndpointInfo("CELL_DISCOVERY_ADDRESS", 7277, true)});
        endpointMap.put("SOAPConnector", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("SOAP_CONNECTOR_ADDRESS", 8880, false)});
        serverTypeMap = new HashMap();
        serverTypeMap.put("ApplicationServer", "APPLICATION_SERVER");
        serverTypeMap.put("JMSServer", "MESSAGE_BROKER");
        serverTypeMap.put("NodeAgent", "NODE_AGENT");
        serverTypeMap.put("CellManager", "DEPLOYMENT_MANAGER");
    }

    private static class DistinguishedEndpointInfo {
        private String endpointName;
        private int defaultPort;
        private boolean isUnique;

        DistinguishedEndpointInfo(String string, int n, boolean bl) {
            this.endpointName = string;
            this.defaultPort = n;
            this.isUnique = bl;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public boolean isUnique() {
            return this.isUnique;
        }
    }
}

