/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MOFUtil {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$MOFUtil == null ? (class$com$ibm$ws$management$configservice$MOFUtil = MOFUtil.class$("com.ibm.ws.management.configservice.MOFUtil")) : class$com$ibm$ws$management$configservice$MOFUtil), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static final Class[] innerConfigObjectTypes = new Class[]{class$com$ibm$websphere$models$config$process$ServerComponent == null ? (class$com$ibm$websphere$models$config$process$ServerComponent = MOFUtil.class$("com.ibm.websphere.models.config.process.ServerComponent")) : class$com$ibm$websphere$models$config$process$ServerComponent, class$com$ibm$ejs$models$base$resources$J2EEResourceFactory == null ? (class$com$ibm$ejs$models$base$resources$J2EEResourceFactory = MOFUtil.class$("com.ibm.ejs.models.base.resources.J2EEResourceFactory")) : class$com$ibm$ejs$models$base$resources$J2EEResourceFactory};
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$MOFUtil;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$process$ServerComponent;
    static /* synthetic */ Class class$com$ibm$ejs$models$base$resources$J2EEResourceFactory;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$loggingservice$ras$ServiceLog;

    public static EStructuralFeature getAttributeMetaObj(EObject eObject, String string, boolean bl) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj((EClass)eObject, string, new Stack(), bl);
    }

    public static EObject newRefObject(RepositoryContext repositoryContext, EObject eObject, ObjectName objectName) throws ConfigServiceException {
        EObject eObject2 = WorkspaceHelper.getTemplate(repositoryContext.getWorkSpace(), (EClassifier)eObject, objectName);
        if (eObject2 == null) {
            eObject2 = MOFUtil.newInstance(eObject);
        }
        return eObject2;
    }

    public static EObject convertToEObject(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertToEObject", (Object)new Object[]{session, objectName});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        EObject eObject = docAccessor.lookup(configDataId);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertToEObject", (Object)eObject);
        }
        return eObject;
    }

    public static EObject newInstance(EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"newInstance", (Object)eObject);
        }
        EClass eClass = (EClass)eObject;
        EObject eObject2 = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"newInstance", (Object)eObject2);
        }
        return eObject2;
    }

    public static void validateConfigData(EObject eObject, AttributeList attributeList) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        Stack stack = new Stack();
        MOFUtil.validateAttributeList(eObject, attributeList, attributeList, stack);
    }

    public static void setAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        Object object = attributeList.iterator();
        while (object.hasNext()) {
            EStructuralFeature eStructuralFeature;
            String string = ((Attribute)object.next()).getName();
            if (SystemAttributes.isSystemAttribute(string) || EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string) || !SpecialAttributeRegistry.isReadOnlyAttribute(eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false))) continue;
            throw new ReadOnlyAttributeException(string);
        }
        MOFUtil.validateConfigData((EObject)eObject.eClass(), attributeList);
        object = new ReferenceHandler();
        MOFUtil.setAttributes(repositoryContext, eObject, attributeList, (ReferenceHandler)object, new Stack());
        ((ReferenceHandler)object).update(repositoryContext);
    }

    public static void resetAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetAttributes", (Object)new Object[]{eObject, attributeList});
        }
        MOFUtil.validateConfigData((EObject)eObject.eClass(), attributeList);
        List list = MOFUtil.getAllAttributeMetaObjs(eObject.eClass());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            MOFUtil.unsetAttribute(eObject, eStructuralFeature.getName());
        }
        MOFUtil.setAttributes(repositoryContext, eObject, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetAttributes");
        }
    }

    public static void unsetAttribute(EObject eObject, String string) throws ConfigServiceException {
        EStructuralFeature eStructuralFeature;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetAttribute", (Object)new Object[]{eObject, string});
        }
        if (SpecialAttributeRegistry.isReadOnlyAttribute(eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false))) {
            throw new ReadOnlyAttributeException(string);
        }
        if (EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string)) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
            EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, null, new ReferenceHandler(), new Stack());
        } else if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof EObject)) continue;
                RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
                MOFUtil.objectRemoved(repositoryContext, (EObject)e, new ReferenceHandler(), new Stack());
            }
            ((List)eObject.eGet(eStructuralFeature)).clear();
        } else {
            Object object = eObject.eGet(eStructuralFeature);
            if (object instanceof EObject) {
                RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
                MOFUtil.objectRemoved(repositoryContext, (EObject)object, new ReferenceHandler(), new Stack());
            }
            eObject.eUnset(eStructuralFeature);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetAttribute");
        }
    }

    public static Object addElementAt(RepositoryContext repositoryContext, EObject eObject, String string, Object object, int n, boolean bl) throws ConfigServiceException {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute(string, arrayList));
        Stack<String> stack = new Stack<String>();
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, bl);
        MOFUtil.validateAttribute(eStructuralFeature, arrayList, attributeList, stack);
        stack.clear();
        stack.push(string);
        List list = (List)eObject.eGet(eStructuralFeature);
        if (object instanceof ConfigDataId && !MOFUtil.isComposite(eStructuralFeature)) {
            try {
                object2 = MOFUtil.lookup(repositoryContext, (ConfigDataId)object, MOFUtil.getAttributePath(stack));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.MOFUtil.addElementAt", (String)"183");
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack), exception);
            }
        } else if (object instanceof AttributeList && eStructuralFeature instanceof EReference) {
            ReferenceHandler referenceHandler = new ReferenceHandler();
            EObject eObject2 = MOFUtil.createRefObject(repositoryContext, (EObject)eStructuralFeature.getEType(), (AttributeList)object, referenceHandler, stack);
            SpecialAttributeRegistry.checkUnique(((EReference)eStructuralFeature).getEReferenceType(), list, eObject2);
            object2 = eObject2;
            referenceHandler.update(repositoryContext);
        } else if (eStructuralFeature instanceof EAttribute) {
            object2 = object;
        } else {
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
        }
        if (n < 0 || n >= list.size()) {
            list.add(object2);
        } else {
            list.add(n, object2);
        }
        if (object2 instanceof EObject) {
            MOFUtil.objectAdded(repositoryContext, (EObject)object2, new ReferenceHandler(), stack);
        }
        return object2;
    }

    public static void removeElement(RepositoryContext repositoryContext, EObject eObject, String string, Object object) throws ConfigServiceException {
        Object object2;
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false);
        if (!eStructuralFeature.isMany()) {
            throw new InvalidAttributeValException(new String[]{string});
        }
        if (eStructuralFeature instanceof EReference && object instanceof ConfigDataId) {
            object2 = MOFUtil.lookup(repositoryContext, (ConfigDataId)object, new String[]{string});
        } else if (eStructuralFeature instanceof EAttribute) {
            object2 = object;
        } else {
            throw new InvalidAttributeValException(new String[]{string});
        }
        if (object2 instanceof EObject) {
            MOFUtil.deleteEObject((EObject)object2);
            MOFUtil.objectRemoved(repositoryContext, (EObject)object2, new ReferenceHandler(), new Stack());
        } else {
            ((List)eObject.eGet(eStructuralFeature)).remove(object2);
        }
    }

    public static EObject createRefObject(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        MOFUtil.validateConfigData(eObject, attributeList);
        ReferenceHandler referenceHandler = new ReferenceHandler();
        EObject eObject2 = MOFUtil.createRefObject(repositoryContext, eObject, attributeList, referenceHandler, new Stack());
        referenceHandler.update(repositoryContext);
        return eObject2;
    }

    public static AttributeList getAttributes(EObject eObject, String[] stringArray, boolean bl) {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributes", (Object)new Object[]{eObject, stringArray});
        }
        EClass eClass = eObject.eClass();
        if (stringArray == null) {
            EStructuralFeature eStructuralFeature;
            int n;
            list = MOFUtil.getAllAttributeMetaObjs(eClass);
            List list2 = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            stringArray = new String[list.size() + list2.size()];
            for (n = 0; n < list.size(); ++n) {
                eStructuralFeature = (EStructuralFeature)list.get(n);
                stringArray[n] = eStructuralFeature.getName();
            }
            eStructuralFeature = list2.iterator();
            while (eStructuralFeature.hasNext()) {
                stringArray[n] = (String)eStructuralFeature.next();
                ++n;
            }
        }
        list = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                ((AttributeList)list).add(new Attribute(stringArray[i], MOFUtil.getAttribute(eObject, stringArray[i], bl)));
                continue;
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"caught excpetion", (Object)((Object)configServiceException));
                }
                FFDCFilter.processException((Throwable)((Object)configServiceException), (String)"com.ibm.ws.management.configservice.MOFUtil.getAttributes", (String)"271");
            }
        }
        ((AttributeList)list).add(new Attribute("_Websphere_Config_Data_Id", MOFUtil.createConfigDataId(eObject)));
        ((AttributeList)list).add(new Attribute("_Websphere_Config_Data_Type", TypeRegistry.getTypeShortName((EClassifier)eClass)));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes", (Object)list);
        }
        return list;
    }

    public static Object getAttribute(EObject eObject, String string, boolean bl) throws ConfigServiceException {
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)new Object[]{eObject, string});
        }
        if (EndpointConfigHelper.isEndpointAttribute((EClassifier)(eClass = eObject.eClass()), string)) {
            Object object = EndpointConfigHelper.getEndpointAttribute(eObject, string, bl);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)object);
            }
            return object;
        }
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eClass, string, false);
        Serializable serializable = eObject.eGet(eStructuralFeature);
        if (serializable != null) {
            if (eStructuralFeature.isMany()) {
                List list = serializable;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                if (eStructuralFeature instanceof EAttribute) {
                    if (eStructuralFeature.getEType() instanceof EEnum) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Enumerator enumerator = (Enumerator)iterator.next();
                            String string2 = enumerator == null ? null : enumerator.getName();
                            arrayList.add(string2);
                        }
                    } else {
                        arrayList.addAll(list);
                    }
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject2 = (EObject)iterator.next();
                        if (bl && MOFUtil.isComposite(eStructuralFeature)) {
                            arrayList.add(MOFUtil.getAttributes(eObject2, null, bl));
                            continue;
                        }
                        arrayList.add(MOFUtil.createObjectName(eObject2));
                    }
                }
                serializable = arrayList;
            } else if (eStructuralFeature instanceof EReference) {
                serializable = bl && MOFUtil.isComposite(eStructuralFeature) ? MOFUtil.getAttributes((EObject)serializable, null, bl) : MOFUtil.createObjectName((EObject)serializable);
            } else if (eStructuralFeature.getEType() instanceof EEnum) {
                serializable = ((Object)serializable).toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)serializable);
        }
        return serializable;
    }

    public static void delete(EObject eObject) {
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
        MOFUtil.deleteEObject(eObject);
        MOFUtil.objectRemoved(repositoryContext, eObject, new ReferenceHandler(), new Stack());
    }

    static void deleteEObject(EObject eObject) {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            MOFUtil.clearReferences(eObject2);
        }
        MOFUtil.clearReferences(eObject);
        EcoreUtil.remove((EObject)eObject);
    }

    private static void clearReferences(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            Collection collection = EcoreUtil.UsageCrossReferencer.find((EObject)eObject, (ResourceSet)resource.getResourceSet());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator.next();
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature.isMany()) {
                    EObject eObject2 = setting.getEObject();
                    List list = (List)eObject2.eGet(eStructuralFeature);
                    list.remove(eObject);
                    continue;
                }
                setting.set(null);
            }
        }
    }

    public static AttributeList getAttributesMetaInfo(EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributesMetaInfo", (Object)eObject);
        }
        AttributeList attributeList = new AttributeList();
        List list = MOFUtil.getAllAttributeMetaObjs((EClass)eObject);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            attributeList.add(new Attribute(eStructuralFeature.getName(), MOFUtil.getAttributeMetaInfo(TypeRegistry.getTypeShortName((EClassifier)eObject), eStructuralFeature)));
        }
        EndpointConfigHelper.getAllEndpointMetaInfo((EClassifier)((EClass)eObject), attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributesMetaInfo", (Object)attributeList);
        }
        return attributeList;
    }

    static ObjectName createObjectName(RepositoryContext repositoryContext) {
        ConfigDataId configDataId = new ConfigDataId(repositoryContext.getURI(), null);
        return ConfigServiceHelper.createObjectName(configDataId);
    }

    static ObjectName createObjectName(EObject eObject) {
        EStructuralFeature eStructuralFeature;
        ConfigDataId configDataId = MOFUtil.createConfigDataId(eObject);
        String string = TypeRegistry.getTypeShortName((EClassifier)eObject.eClass());
        String string2 = null;
        Object object = null;
        try {
            eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), "name", false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attrFeature", (Object)eStructuralFeature);
            }
            object = eObject.eGet(eStructuralFeature);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
        if (object == null) {
            try {
                eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), "memberName", false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"attrFeature", (Object)eStructuralFeature);
                }
                if (eStructuralFeature != null && TypeRegistry.getTypeShortName(eStructuralFeature.getEType()).equals("String") && !eStructuralFeature.isMany()) {
                    object = eObject.eGet(eStructuralFeature);
                }
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                // empty catch block
            }
        }
        if (object == null) {
            try {
                eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), "serverName", false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"attrFeature", (Object)eStructuralFeature);
                }
                if (eStructuralFeature != null && TypeRegistry.getTypeShortName(eStructuralFeature.getEType()).equals("String") && !eStructuralFeature.isMany()) {
                    object = eObject.eGet(eStructuralFeature);
                }
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                // empty catch block
            }
        }
        if (object != null) {
            string2 = object.toString();
        }
        return ConfigServiceHelper.createObjectName(configDataId, string, string2);
    }

    static ConfigDataId createConfigDataId(EObject eObject) {
        ConfigDataId configDataId = null;
        Resource resource = eObject.eResource();
        if (resource != null) {
            URI uRI = resource.getURI();
            uRI = uRI.appendFragment(resource.getURIFragment(eObject));
            String string = uRI.toString();
            String string2 = WorkspaceHelper.getContext(resource).getURI();
            configDataId = new ConfigDataId(string2, string);
        }
        return configDataId;
    }

    static URI getURI(ConfigDataId configDataId) {
        String string = configDataId.getHref();
        URI uRI = URI.createURI((String)string);
        return uRI;
    }

    static void objectRemoved(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"objectRemoved", (Object)new Object[]{repositoryContext, eObject});
        }
        if (repositoryContext.getType().getName().equals("servers")) {
            MOFUtil.objectRemovedBasic(repositoryContext, eObject, referenceHandler, stack);
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                MOFUtil.objectRemovedBasic(repositoryContext, (EObject)treeIterator.next(), referenceHandler, stack);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"objectRemoved");
        }
    }

    private static void objectRemovedBasic(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        try {
            EClass eClass = eObject.eClass();
            List list = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, null, referenceHandler, stack);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning((TraceComponent)tc, (String)"ADMG0022W", (Object)new Object[]{configServiceException, repositoryContext.getName()});
        }
    }

    static void objectAdded(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"objectAdded", (Object)new Object[]{repositoryContext, eObject});
        }
        if (repositoryContext.getType().getName().equals("servers")) {
            MOFUtil.objectAddedBasic(repositoryContext, eObject, referenceHandler, stack);
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                MOFUtil.objectAddedBasic(repositoryContext, (EObject)treeIterator.next(), referenceHandler, stack);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"objectAdded");
        }
    }

    private static void objectAddedBasic(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        EClass eClass;
        try {
            eClass = eObject.eClass();
            List list = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, new AttributeList(), referenceHandler, stack);
            }
            if ("servers".equals(repositoryContext.getType().getName())) {
                EndpointConfigHelper.setServerType(repositoryContext, (EClassifier)eObject.eClass());
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning((TraceComponent)tc, (String)"ADMG0022W", (Object)new Object[]{configServiceException, repositoryContext.getName()});
        }
        if (eObject instanceof EndPoint) {
            try {
                eClass = (EndPoint)eObject;
                int n = eClass.getPort();
                if (n != 0) {
                    eClass.setPort(0);
                    eClass.setPort(EndpointConfigHelper.adjustPort(repositoryContext, n, null));
                }
            }
            catch (ConfigServiceException configServiceException) {
                Tr.warning((TraceComponent)tc, (String)"ADMG0022W", (Object)new Object[]{configServiceException, repositoryContext.getName()});
            }
        }
    }

    private static List getAllAttributeMetaObjs(EClass eClass) {
        ArrayList arrayList = new ArrayList(eClass.getEAllAttributes());
        arrayList.addAll(eClass.getEAllReferences());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (MOFUtil.isValidAttribute(eStructuralFeature)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EStructuralFeature getAttributeMetaObj(EClass eClass, String string, Stack stack, boolean bl) throws InvalidAttributeNameException {
        EStructuralFeature eStructuralFeature;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributeMetaObj", (Object)new Object[]{eClass, string});
        }
        try {
            if (stack == null) {
                stack = new Stack<String>();
            }
            stack.push(string);
            eStructuralFeature = eClass.getEStructuralFeature(string);
            if (eStructuralFeature == null || !MOFUtil.isValidAttribute(eStructuralFeature, bl)) {
                throw new InvalidAttributeNameException(MOFUtil.getAttributePath(stack));
            }
        }
        finally {
            stack.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributeMetaObj", (Object)eStructuralFeature);
        }
        return eStructuralFeature;
    }

    private static EStructuralFeature getAttributeMetaObj(EClass eClass, String string, Stack stack) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj(eClass, string, stack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateAttributeList(EObject object, AttributeList attributeList, AttributeList attributeList2, Stack stack) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        Object object2;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"validateAttributeList", (Object)new Object[]{object, attributeList});
            }
            String string = null;
            try {
                string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
                object2 = TypeRegistry.getMetaObject(string);
                if (((EClassifier)object).getInstanceClass().isAssignableFrom(object2.getInstanceClass())) {
                    object = object2;
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"type is not specified");
                }
            }
            catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
                FFDCFilter.processException((Throwable)((Object)invalidConfigDataTypeException), (String)"com.ibm.ws.management.configservice.MOFUtil.validateAttributeList", (String)"497");
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug((TraceComponent)tc, (String)"specified type is not valid", (Object)string);
            }
        }
        object2 = attributeList.iterator();
        while (object2.hasNext()) {
            Attribute attribute = (Attribute)object2.next();
            String string = attribute.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"name", (Object)string);
            }
            Object object3 = attribute.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"val", (Object)object3);
            }
            if (EndpointConfigHelper.isEndpointAttribute((EClassifier)object, string)) {
                try {
                    stack.push(string);
                    if (object3 != null && !(object3 instanceof AttributeList)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    MOFUtil.validateAttributeList((EObject)EndpointConfigHelper.getEndpointMetaObj(), (AttributeList)object3, attributeList2, stack);
                    continue;
                }
                finally {
                    stack.pop();
                    continue;
                }
            }
            if (SystemAttributes.isSystemAttribute(string)) continue;
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj(object, string, false);
            MOFUtil.validateAttribute(eStructuralFeature, object3, attributeList2, stack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateAttributeList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAttribute(EStructuralFeature eStructuralFeature, Object object, AttributeList attributeList, Stack stack) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"validateAttribute", (Object)new Object[]{eStructuralFeature, object});
            }
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"validateAttribute");
                }
                return;
            }
            try {
                stack.push(eStructuralFeature.getName());
                EClassifier eClassifier = eStructuralFeature.getEType();
                if (!MOFUtil.isComposite(eStructuralFeature)) {
                    if (eStructuralFeature.isMany() && object instanceof List) {
                        Iterator iterator = ((List)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (eStructuralFeature instanceof EAttribute) {
                                if ((!(eClassifier instanceof EEnum) || e instanceof String) && (eClassifier instanceof EEnum || eClassifier.isInstance(e))) continue;
                                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                            }
                            if (!(e instanceof ObjectName)) {
                                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                            }
                            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)e);
                            if (!configDataId.isLocal() || ConfigServiceHelper.lookup(attributeList, configDataId) != null) continue;
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                    } else {
                        if (!(object instanceof ObjectName)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)object);
                        if (configDataId.isLocal() && ConfigServiceHelper.lookup(attributeList, configDataId) == null) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                    }
                    break block22;
                }
                if (eStructuralFeature instanceof EReference && object instanceof AttributeList) {
                    MOFUtil.validateAttributeList((EObject)eClassifier, (AttributeList)object, attributeList, stack);
                    break block22;
                }
                if (eStructuralFeature.isMany() && object instanceof List) {
                    Iterator iterator = ((List)object).iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (eStructuralFeature instanceof EAttribute) {
                            if ((!(eClassifier instanceof EEnum) || e instanceof String) && (eClassifier instanceof EEnum || eClassifier.isInstance(e))) continue;
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                        MOFUtil.validateAttributeList((EObject)eClassifier, (AttributeList)e, attributeList, stack);
                    }
                    break block22;
                }
                if (eStructuralFeature instanceof EAttribute) {
                    String string;
                    if (eClassifier instanceof EEnum && !(object instanceof String) || !(eClassifier instanceof EEnum) && !eClassifier.isInstance(object)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    if (eStructuralFeature.getName().equals("name") && !(class$com$ibm$websphere$models$config$loggingservice$ras$ServiceLog == null ? (class$com$ibm$websphere$models$config$loggingservice$ras$ServiceLog = MOFUtil.class$("com.ibm.websphere.models.config.loggingservice.ras.ServiceLog")) : class$com$ibm$websphere$models$config$loggingservice$ras$ServiceLog).isAssignableFrom(eStructuralFeature.getContainerClass()) && !ConfigServiceHelper.checkIfNameValid(string = (String)object)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    break block22;
                }
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
            }
            finally {
                stack.pop();
            }
        }
        if (object == null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateAttribute");
        }
    }

    static void setAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttributes", (Object)new Object[]{eObject, attributeList});
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (SystemAttributes.isSystemAttribute(attribute.getName())) continue;
            MOFUtil.setAttribute(repositoryContext, eObject, attribute.getName(), attribute.getValue(), referenceHandler, stack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAttribute(RepositoryContext repositoryContext, EObject eObject, String string, Object object, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttribute", (Object)new Object[]{eObject, string, object});
        }
        try {
            stack.push(string);
            if (EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string)) {
                if (object != null && !(object instanceof AttributeList)) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, (AttributeList)object, referenceHandler, stack);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setAttribute");
                }
                return;
            }
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false);
            if (object == null) {
                if (eStructuralFeature.isMany()) {
                    List list = (List)eObject.eGet(eStructuralFeature);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof EObject)) continue;
                        MOFUtil.objectRemoved(repositoryContext, (EObject)e, referenceHandler, stack);
                    }
                    list.clear();
                } else {
                    Object object2 = eObject.eGet(eStructuralFeature);
                    if (object2 instanceof EObject) {
                        MOFUtil.objectRemoved(repositoryContext, eObject, referenceHandler, stack);
                    }
                    eObject.eUnset(eStructuralFeature);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setAttribute");
                }
                return;
            }
            if (!MOFUtil.isComposite(eStructuralFeature)) {
                if (eStructuralFeature.isMany() && !(object instanceof List)) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                referenceHandler.addDeferredUpdate(eObject, eStructuralFeature, object, MOFUtil.getAttributePath(stack));
            } else if (eStructuralFeature.isMany() && object instanceof List) {
                List list = (List)eObject.eGet(eStructuralFeature);
                list.clear();
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList;
                    Object object3 = iterator.next();
                    if (eStructuralFeature instanceof EReference && object3 instanceof AttributeList) {
                        attributeList = (AttributeList)object3;
                        EClassifier eClassifier = eStructuralFeature.getEType();
                        EObject eObject2 = MOFUtil.createRefObject(repositoryContext, (EObject)eClassifier, (AttributeList)object3, referenceHandler, stack);
                        list.add(eObject2);
                        MOFUtil.objectAdded(repositoryContext, eObject2, referenceHandler, stack);
                        continue;
                    }
                    if (object3 != null && eStructuralFeature.getEType() instanceof EEnum && (object3 = (attributeList = (EEnum)eStructuralFeature.getEType()).getEEnumLiteral((String)object3).getInstance()) == null) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    list.add(object3);
                }
            } else if (eStructuralFeature instanceof EReference && object instanceof AttributeList) {
                EObject eObject3 = MOFUtil.createRefObject(repositoryContext, (EObject)eStructuralFeature.getEType(), (AttributeList)object, referenceHandler, stack);
                eObject.eSet(eStructuralFeature, (Object)eObject3);
                MOFUtil.objectAdded(repositoryContext, eObject3, referenceHandler, stack);
            } else if (eStructuralFeature instanceof EAttribute) {
                EEnum eEnum;
                if (eStructuralFeature.getEType() instanceof EEnum && (object = (eEnum = (EEnum)eStructuralFeature.getEType()).getEEnumLiteral((String)object).getInstance()) == null) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                eObject.eSet(eStructuralFeature, object);
            }
        }
        finally {
            stack.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    private static EObject createRefObject(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRefObject", (Object)new Object[]{eObject, attributeList});
        }
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
            object = TypeRegistry.getMetaObject(string);
            if (((EClassifier)eObject).getInstanceClass().isAssignableFrom(object.getInstanceClass())) {
                eObject = object;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"type is not specified");
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException((Throwable)((Object)invalidConfigDataTypeException), (String)"com.ibm.ws.management.configservice.MOFUtil.createRefObject", (String)"725");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"specified type is not valid", (Object)string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.MOFUtil.createRefObject", (String)"728");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unexpected exception", (Object)exception);
            }
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
        }
        object = null;
        try {
            object = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Template");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        EObject eObject2 = MOFUtil.newRefObject(repositoryContext, eObject, (ObjectName)object);
        MOFUtil.setAttributes(repositoryContext, eObject2, attributeList, referenceHandler, stack);
        ConfigDataId configDataId = null;
        try {
            configDataId = (ConfigDataId)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (configDataId != null && configDataId.isLocal()) {
            referenceHandler.addLocalRefObject(configDataId, eObject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRefObject", (Object)eObject2);
        }
        return eObject2;
    }

    static AttributeList getAttributeMetaInfo(String string, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributeMetaInfo", (Object)eStructuralFeature);
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("_Attribute_MetaInfo_Name", eStructuralFeature.getName()));
        EClassifier eClassifier = eStructuralFeature.getEType();
        Object object = eStructuralFeature.getDefaultValue();
        if (object != null && eClassifier instanceof EEnum) {
            object = object.toString();
        }
        if (object != null && !(object instanceof Serializable)) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"defaultValue is not serializable:", (Object)object);
            }
            object = null;
        }
        attributeList.add(new Attribute("_Attribute_MetaInfo_Default_Value", object));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Collection", new Boolean(eStructuralFeature.isMany())));
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        attributeList.add(new Attribute("_Attribute_MetaInfo_Type", string2));
        try {
            String[] stringArray = TypeRegistry.getSubTypes(string2);
            if (stringArray != null && stringArray.length > 0) {
                attributeList.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(stringArray)));
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            // empty catch block
        }
        boolean bl = eStructuralFeature instanceof EReference;
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Object", new Boolean(bl)));
        List list = RequiredAttributesRegistry.getRequiredAttributes(string);
        boolean bl2 = list != null && list.contains(eStructuralFeature.getName());
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Required", new Boolean(bl2)));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Reference", new Boolean(!MOFUtil.isComposite(eStructuralFeature))));
        if (eClassifier instanceof EEnum) {
            AttributeList attributeList2 = new AttributeList();
            EEnum eEnum = (EEnum)eClassifier;
            EList eList = eEnum.getELiterals();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EEnumLiteral eEnumLiteral = (EEnumLiteral)iterator.next();
                attributeList2.add(new Attribute(eEnumLiteral.getName(), new Integer(eEnumLiteral.getValue())));
            }
            attributeList.add(new Attribute("_Attribute_MetaInfo_Enum_Info", attributeList2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributeMeta", (Object)attributeList);
        }
        return attributeList;
    }

    private static String[] getAttributePath(Stack stack) {
        String[] stringArray = new String[stack.size()];
        stack.toArray(stringArray);
        return stringArray;
    }

    private static boolean isValidAttribute(EStructuralFeature eStructuralFeature, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidAttribute", (Object)new Object[]{eStructuralFeature, new Boolean(bl)});
        }
        boolean bl2 = true;
        if (eStructuralFeature.isVolatile()) {
            bl2 = false;
        } else {
            Class clazz = eStructuralFeature.getEType().getInstanceClass();
            if (clazz == null) {
                bl2 = !bl;
            } else {
                for (int i = 0; i < innerConfigObjectTypes.length; ++i) {
                    if (!MOFUtil.isComposite(eStructuralFeature) || !innerConfigObjectTypes[i].isAssignableFrom(clazz)) continue;
                    bl2 = bl;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isValidAttribute, " + bl2));
        }
        return bl2;
    }

    private static boolean isValidAttribute(EStructuralFeature eStructuralFeature) {
        return MOFUtil.isValidAttribute(eStructuralFeature, false);
    }

    private static boolean isComposite(EStructuralFeature eStructuralFeature) {
        boolean bl = true;
        if (eStructuralFeature instanceof EReference) {
            bl = ((EReference)eStructuralFeature).isContainment();
        }
        return bl;
    }

    private static EObject lookup(RepositoryContext repositoryContext, ConfigDataId configDataId, String[] stringArray) throws InvalidAttributeValException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookup", (Object)new Object[]{repositoryContext, configDataId});
        }
        if (repositoryContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookup", null);
            }
            return null;
        }
        try {
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext.getWorkSpace(), configDataId);
            EObject eObject = docAccessor.lookup(configDataId);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookup", (Object)eObject);
            }
            return eObject;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.MOFUtil.lookup", (String)"848");
            throw new InvalidAttributeValException(stringArray, exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ReferenceHandler {
        private List deferredUpdates = new ArrayList();
        private HashMap localRefObjs = new HashMap();

        ReferenceHandler() {
        }

        public void addLocalRefObject(ConfigDataId configDataId, EObject eObject) {
            this.localRefObjs.put(configDataId, eObject);
        }

        public void addDeferredUpdate(EObject eObject, EStructuralFeature eStructuralFeature, Object object, String[] stringArray) {
            DeferredUpdateInfo deferredUpdateInfo = new DeferredUpdateInfo();
            deferredUpdateInfo.refObj = eObject;
            deferredUpdateInfo.feature = eStructuralFeature;
            deferredUpdateInfo.value = object;
            deferredUpdateInfo.attributePath = stringArray;
            this.deferredUpdates.add(deferredUpdateInfo);
        }

        public void update(RepositoryContext repositoryContext) throws InvalidAttributeValException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"update", (Object)repositoryContext);
            }
            Iterator iterator = this.deferredUpdates.iterator();
            while (iterator.hasNext()) {
                Object object;
                DeferredUpdateInfo deferredUpdateInfo = (DeferredUpdateInfo)iterator.next();
                if (deferredUpdateInfo.feature.isMany()) {
                    object = (List)deferredUpdateInfo.value;
                    List list = (List)deferredUpdateInfo.refObj.eGet(deferredUpdateInfo.feature);
                    list.clear();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof ObjectName)) {
                            throw new InvalidAttributeValException(deferredUpdateInfo.attributePath);
                        }
                        list.add(this.getReferredObj(repositoryContext, ConfigServiceHelper.getConfigDataId((ObjectName)e), deferredUpdateInfo.attributePath));
                    }
                    continue;
                }
                if (!(deferredUpdateInfo.value instanceof ObjectName)) {
                    throw new InvalidAttributeValException(deferredUpdateInfo.attributePath);
                }
                object = this.getReferredObj(repositoryContext, ConfigServiceHelper.getConfigDataId((ObjectName)deferredUpdateInfo.value), deferredUpdateInfo.attributePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"referredObj", (Object)object);
                }
                deferredUpdateInfo.refObj.eSet(deferredUpdateInfo.feature, object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"update");
            }
        }

        private Object getReferredObj(RepositoryContext repositoryContext, ConfigDataId configDataId, String[] stringArray) throws InvalidAttributeValException {
            EObject eObject = null;
            if (configDataId.isLocal()) {
                eObject = (EObject)this.localRefObjs.get(configDataId);
                if (eObject == null) {
                    throw new InvalidAttributeValException(stringArray, (Exception)((Object)new ConfigDataNotFoundException(null, configDataId, null)));
                }
            } else {
                eObject = MOFUtil.lookup(repositoryContext, configDataId, stringArray);
            }
            return eObject;
        }

        static class DeferredUpdateInfo {
            public EObject refObj;
            public EStructuralFeature feature;
            public Object value;
            public String[] attributePath;

            DeferredUpdateInfo() {
            }
        }
    }
}

