/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.csmetadata.EMFAttribute;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RequiredAttributesRegistry
extends DefaultHandler {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$RequiredAttributesRegistry == null ? (class$com$ibm$ws$management$configservice$RequiredAttributesRegistry = RequiredAttributesRegistry.class$("com.ibm.ws.management.configservice.RequiredAttributesRegistry")) : class$com$ibm$ws$management$configservice$RequiredAttributesRegistry), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static RequiredAttributesRegistry instance = null;
    private static final String[] validationFiles = new String[]{"resources-validation.xml", "securitycenter-validation.xml", "environment-validation.xml", "servermanagement-validation.xml", "probdetermination-validation.xml", "distmanagement-validation.xml"};
    private XMLReader parser;
    private Stack context = new Stack();
    private Hashtable requiredAttrsTable = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$RequiredAttributesRegistry;

    public RequiredAttributesRegistry() throws Exception {
        this.parser = XMLReaderFactory.createXMLReader();
        this.parser.setEntityResolver(this);
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
    }

    private void generate() throws Exception {
        for (int i = 0; i < validationFiles.length; ++i) {
            this.parseValidationFile(validationFiles[i]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("trace");
            Object var2_3 = null;
            ManagerAdmin.configureClientTrace((String)string, (String)"stdout", null, (boolean)true, null, (boolean)false);
            instance.dump();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void parseValidationFile(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseValidationFile", (Object)string);
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        InputSource inputSource = new InputSource(inputStream);
        this.parser.parse(inputSource);
        inputSource.setSystemId(string);
        inputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseValidationFile");
        }
    }

    public static List getRequiredAttributes(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)RequiredAttributesRegistry.instance.requiredAttrsTable.get(string);
        EClass eClass = null;
        try {
            eClass = TypeRegistry.getMetaObject(string);
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            return null;
        }
        EList eList = eClass.getEAllSuperTypes();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EClass eClass2 = (EClass)iterator.next();
            String string2 = TypeRegistry.getTypeShortName((EClassifier)eClass2);
            List list = (List)RequiredAttributesRegistry.instance.requiredAttrsTable.get(string2);
            if (list == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(list);
                continue;
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static void checkRequiredAttributes(EObject eObject) throws RequiredAttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"haveAllRequiredAttributes", (Object)eObject);
        }
        RequiredAttributesRegistry.checkRequiredAttributesBasic(eObject);
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            RequiredAttributesRegistry.checkRequiredAttributesBasic(eObject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"haveAllRequiredAttributes");
        }
    }

    private static void checkRequiredAttributesBasic(EObject eObject) throws RequiredAttributeNotFoundException {
        EClass eClass;
        String string;
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkRequiredAttributesBasic", (Object)eObject);
        }
        if ((list = RequiredAttributesRegistry.getRequiredAttributes(string = TypeRegistry.getTypeShortName((EClassifier)(eClass = eObject.eClass())))) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"attrName", (Object)string2);
                }
                try {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(string2);
                    if (eStructuralFeature == null || eObject.eGet(eStructuralFeature) != null) continue;
                    throw new RequiredAttributeNotFoundException(string + '.' + string2);
                }
                catch (Exception exception) {
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredAttributesBasic");
        }
    }

    private void addRequiredAttribute(String string, String string2) {
        ArrayList<String> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRequiredAttribute", (Object)new Object[]{string, string2});
        }
        if ((arrayList = (ArrayList<String>)this.requiredAttrsTable.get(string)) == null) {
            arrayList = new ArrayList<String>(5);
            this.requiredAttrsTable.put(string, arrayList);
        }
        arrayList.add(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRequiredAttribute");
        }
    }

    private void dump() {
        Set set = this.requiredAttrsTable.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            System.out.println("=================================================");
            System.out.println("RequiredAttributes for type " + string);
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                System.out.print(string2 + ",");
            }
            System.out.print("\n");
        }
    }

    private Object parseForm(Attributes attributes) throws SAXException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseForm", (Object)attributes);
        }
        String string2 = attributes.getValue("name");
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"val", (Object)string2);
        }
        string = (n = (string = string2.substring(string2.lastIndexOf(46) + 1)).lastIndexOf("DetailForm")) == -1 ? null : string.substring(0, n).trim();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseForm", (Object)string);
        }
        return string;
    }

    private Object parseField(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseField", (Object)attributes);
        }
        String string = attributes.getValue("depends");
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"val", (Object)string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().equals("required")) {
                string2 = attributes.getValue("property");
                this.addRequiredAttribute(this.findFormType(), string2);
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseField", string2);
        }
        return string2;
    }

    private String findFormType() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findFormType");
        }
        String string = null;
        int n = 0;
        int n2 = this.context.size() - 1;
        while (n2 >= 0) {
            ContextElement contextElement = (ContextElement)this.context.get(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("e:" + contextElement.getName()));
            }
            if (contextElement.getName().equals("form")) {
                string = (String)contextElement.getValue();
                break;
            }
            --n2;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findFormType", string);
        }
        return string;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startElement", (Object)new Object[]{string, string2, string3, attributes});
        }
        Object object = null;
        if (string2.equals("form")) {
            object = this.parseForm(attributes);
        } else if (string2.equals("field")) {
            object = this.parseField(attributes);
        }
        this.context.push(new ContextElement(string2, object));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startElement", (Object)string2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endElement", (Object)string2);
        }
        this.context.pop();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endElement", (Object)string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            instance = new RequiredAttributesRegistry();
            instance.generate();
            EList eList = CSMetadataMgr.getConfigServiceMetadata().getRequiredAttributes();
            for (int i = 0; i < eList.size(); ++i) {
                EMFAttribute eMFAttribute = (EMFAttribute)eList.get(i);
                instance.addRequiredAttribute(TypeRegistry.getShortType(eMFAttribute.getTypeName()), eMFAttribute.getAttrName());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.RequiredAttributesRegistry", (String)"80");
        }
    }

    private class ContextElement {
        private String elementName;
        private Object val;

        public ContextElement(String string) {
            this(string, null);
        }

        public ContextElement(String string, Object object) {
            this.elementName = string;
            this.val = object;
        }

        public String getName() {
            return this.elementName;
        }

        public Object getValue() {
            return this.val;
        }
    }
}

