/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerClusterDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$ClusterMemberDelegator == null ? (class$com$ibm$ws$management$configservice$ClusterMemberDelegator = ServerClusterDelegator.class$("com.ibm.ws.management.configservice.ClusterMemberDelegator")) : class$com$ibm$ws$management$configservice$ClusterMemberDelegator), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$ClusterMemberDelegator;

    public ServerClusterDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("clusters"));
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        ObjectName objectName2 = super.createConfigData(session, objectName, string, attributeList);
        this.clusterMemberCreated(session, objectName, -1);
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attributeList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            super.setAttributes(session, objectName, attributeList);
            return;
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attributeList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            super.setAttributes(session, objectName, attributeList);
            return;
        }
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        super.addElement(session, objectName, string, object, n);
        this.clusterMemberCreated(session, objectName, n);
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteConfigData", (Object)new Object[]{session, objectName});
        }
        try {
            object3 = this.baseConfigService.getAppManagement();
            object2 = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cluster", (Object)object2);
            }
            object = new Hashtable<String, Object>();
            Object object4 = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (object4 != null) {
                ((Hashtable)object).put("app.client.locale", object4);
            }
            object3.removeAllAppsFromCluster((ObjectName)object2, (Hashtable)object, session.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.ServerClusterDelegator", (String)"48", (Object)this);
            throw new ConfigServiceException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", (Object[])new Object[]{exception}, null));
        }
        object3 = this.baseConfigService.getAttributes(session, objectName, new String[]{"members"}, false);
        object2 = (List)((Attribute)((ArrayList)object3).get(0)).getValue();
        object = object2.iterator();
        while (object.hasNext()) {
            this.baseConfigService.deleteConfigData(session, (ObjectName)object.next());
        }
        super.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteConfigData");
        }
    }

    private void clusterMemberCreated(Session session, ObjectName objectName, int n) throws ConfigServiceException {
        ServerCluster serverCluster;
        Object object;
        List list = (List)this.baseConfigService.getAttribute(session, objectName, "members");
        int n2 = list.size();
        if (n == -1) {
            n = n2 - 1;
        }
        AttributeList attributeList = (AttributeList)list.get(n);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(attributeList);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string != null) {
            stringBuffer.append("Node=").append(string).append(":");
        }
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string2 != null) {
            stringBuffer.append("Server=").append(string2);
        }
        ObjectName objectName3 = this.baseConfigService.resolve(session, stringBuffer.toString())[0];
        Server server = (Server)MOFUtil.convertToEObject(session, objectName3);
        if (n2 == 1) {
            object = ConfigHelperFactory.getPlatformClusterConfigHelper(null);
            serverCluster = (ServerCluster)MOFUtil.convertToEObject(session, objectName);
            object.configureServerClusterFromServer(serverCluster, server);
        }
        object = ConfigHelperFactory.getPlatformClusterMemberConfigHelper(null);
        serverCluster = (ClusterMember)MOFUtil.convertToEObject(session, objectName2);
        object.configureClusterMember((ClusterMember)serverCluster, server);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

