/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$ServerDelegator == null ? (class$com$ibm$ws$management$configservice$ServerDelegator = ServerDelegator.class$("com.ibm.ws.management.configservice.ServerDelegator")) : class$com$ibm$ws$management$configservice$ServerDelegator), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static final String SERVER_TYPE = "serverType";
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$ServerDelegator;

    public ServerDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers"));
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        AttributeList attributeList = super.getAttributesMetaInfo(string);
        AttributeList attributeList2 = MOFUtil.getAttributeMetaInfo("ServerEntry", TypeRegistry.getMetaObject("ServerEntry").getEStructuralFeature(SERVER_TYPE));
        attributeList.add(new Attribute(SERVER_TYPE, attributeList2));
        return attributeList;
    }

    protected ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        List list;
        boolean bl;
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfigObject", (Object)new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        this.checkServerTypeAttr(attributeList);
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        ObjectName objectName3 = this.getTemplate(session, attributeList);
        EndpointConfigHelper.createServerEntry(repositoryContext, this.getName(attributeList), objectName3);
        ObjectName objectName4 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
        AttributeList attributeList2 = new AttributeList();
        attributeList2.add(new Attribute("clusterName", null));
        this.baseConfigService.setAttributes(session, objectName4, attributeList2);
        PlatformServerConfigHelper platformServerConfigHelper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)MOFUtil.convertToEObject(session, objectName));
        platformServerConfigHelper.configureServer((Server)MOFUtil.convertToEObject(session, objectName4));
        ObjectName[] objectNameArray2 = this.baseConfigService.queryConfigObjects(session, objectName4, ConfigServiceHelper.createObjectName(null, "AdminService"), null);
        if (objectNameArray2.length > 0) {
            object = objectNameArray2[0];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"adminService", (Object)object);
            }
            serializable = ConfigServiceHelper.getObjectLocation(objectName);
            objectNameArray = ((Properties)serializable).getProperty("cell");
            objectName2 = this.baseConfigService.resolve(session, "Cell=" + (String)objectNameArray)[0];
            bl = "STANDALONE".equals(this.baseConfigService.getAttribute(session, objectName2, "cellType"));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("standAlone," + bl));
            }
            list = new AttributeList();
            ((AttributeList)list).add(new Attribute("standalone", new Boolean(bl)));
            this.baseConfigService.setAttributes(session, (ObjectName)object, (AttributeList)list);
        }
        object = ConfigServiceHelper.getDisplayName(objectName4);
        try {
            serializable = ConfigServiceHelper.createObjectName(null, "VariableMap");
            objectNameArray = this.baseConfigService.queryConfigObjects(session, objectName4, (ObjectName)serializable, null);
            if (objectNameArray.length == 0) {
                objectName2 = this.baseConfigService.createConfigData(session, objectName4, "VariableMap", "VariableMap", new AttributeList());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new varMap = ", (Object)objectName2);
                }
            } else {
                objectName2 = objectNameArray[0];
            }
            bl = true;
            list = (List)this.baseConfigService.getAttribute(session, objectName2, "entries");
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                AttributeList attributeList3 = (AttributeList)object2.next();
                try {
                    String string = (String)ConfigServiceHelper.getAttributeValue(attributeList3, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"symbolicName = ", (Object)string);
                    }
                    if (!string.equals("SERVER_LOG_ROOT")) continue;
                    ConfigServiceHelper.setAttributeValue(attributeList3, "value", "${LOG_ROOT}/" + (String)object);
                    this.baseConfigService.setAttributes(session, ConfigServiceHelper.createObjectName(attributeList3), attributeList3);
                    bl = false;
                    break;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                }
            }
            if (bl) {
                object2 = new AttributeList();
                ((AttributeList)object2).add(new Attribute("symbolicName", "SERVER_LOG_ROOT"));
                ((AttributeList)object2).add(new Attribute("value", "${LOG_ROOT}/" + (String)object));
                ((AttributeList)object2).add(new Attribute("description", "The log root directory for server " + (String)object + "."));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"varAttrList = ", (Object)object2);
                }
                this.baseConfigService.createConfigData(session, objectName2, "entries", "VariableSubstitutionEntry", (AttributeList)object2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning((TraceComponent)tc, (String)"ADMG0025W", (Object)new Object[]{object, configServiceException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigObject", (Object)objectName4);
        }
        return objectName4;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        Object object;
        Cloneable cloneable;
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteConfigData", (Object)new Object[]{session, objectName});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        repositoryContext = repositoryContext.getParent();
        String string = ConfigServiceHelper.getDisplayName(objectName);
        String string2 = (String)this.baseConfigService.getAttribute(session, objectName, "clusterName");
        ObjectName[] objectNameArray2 = this.baseConfigService.getRelationship(session, objectName, "parent");
        String string3 = ConfigServiceHelper.getDisplayName(objectNameArray2[0]);
        try {
            objectNameArray = this.baseConfigService.getAppManagement();
            objectName2 = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server", (Object)objectName2);
            }
            cloneable = new Hashtable<String, Object>();
            object = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (object != null) {
                ((Hashtable)cloneable).put("app.client.locale", object);
            }
            objectNameArray.removeAllAppsFromServer(objectName2, (Hashtable)cloneable, session.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.ServerDelegator", (String)"78", (Object)this);
            throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0011E", (Object[])new Object[]{exception}, null));
        }
        if (string2 != null && string2.length() >= 0 && (objectNameArray = this.baseConfigService.resolve(session, "ServerCluster=" + string2)).length > 0) {
            objectName2 = objectNameArray[0];
            cloneable = this.baseConfigService.getAttributes(session, objectName2, new String[]{"members"}, false);
            object = (List)((Attribute)((ArrayList)cloneable).get(0)).getValue();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                String string4 = (String)this.baseConfigService.getAttribute(session, objectName3, "nodeName");
                if (!this.baseConfigService.getAttribute(session, objectName3, "memberName").equals(string) || !string4.equals(string3)) continue;
                this.baseConfigService.deleteConfigDataBasic(session, objectName3);
            }
        }
        super.deleteConfigData(session, objectName);
        EndpointConfigHelper.deleteServerEntry(repositoryContext, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteConfigData");
        }
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        this.checkServerTypeAttr(attributeList);
        super.setAttributes(session, objectName, attributeList);
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        this.checkServerTypeAttr(stringArray);
        super.unsetAttributes(session, objectName, stringArray);
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        this.checkServerTypeAttr(attributeList);
        super.resetAttributes(session, objectName, attributeList);
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributes", (Object)new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (stringArray == null) {
            bl2 = true;
        } else {
            attributeList = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(SERVER_TYPE)) {
                    bl2 = true;
                    continue;
                }
                attributeList.add(stringArray[i]);
            }
            stringArray = new String[attributeList.size()];
            attributeList.toArray(stringArray);
        }
        attributeList = super.getAttributes(session, objectName, stringArray, bl);
        if (bl2) {
            String string = this.getServerType(session, objectName);
            attributeList.add(new Attribute(SERVER_TYPE, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes", (Object)attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)new Object[]{session, objectName, string});
        }
        Object object = SERVER_TYPE.equals(string) ? this.getServerType(session, objectName) : super.getAttribute(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)object);
        }
        return object;
    }

    private void checkServerTypeAttr(AttributeList attributeList) throws ReadOnlyAttributeException {
        try {
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, SERVER_TYPE);
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return;
        }
    }

    private void checkServerTypeAttr(String[] stringArray) throws ReadOnlyAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(SERVER_TYPE)) continue;
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
    }

    private String getServerType(Session session, ObjectName objectName) throws ConfigServiceException {
        return EndpointConfigHelper.getServerType(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

