/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WorkspaceHelper {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$configservice$WorkspaceHelper == null ? (class$com$ibm$ws$management$configservice$WorkspaceHelper = WorkspaceHelper.class$("com.ibm.ws.management.configservice.WorkspaceHelper")) : class$com$ibm$ws$management$configservice$WorkspaceHelper), (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    static /* synthetic */ Class class$com$ibm$ws$management$configservice$WorkspaceHelper;

    static WorkSpace getWorkspace(EObject eObject) {
        WorkSpace workSpace = null;
        Resource resource = eObject.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(resource);
            if (repositoryContext != null) {
                workSpace = repositoryContext.getWorkSpace();
            }
        }
        return workSpace;
    }

    static WorkSpace getWorkspace(Session session) throws ConfigServiceException {
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWorkspace", (Object)session);
        }
        WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
        try {
            workSpace = session.isShareWorkspace() ? workSpaceManager.getWorkSpace(session.getUserName()) : workSpaceManager.getWorkSpace(session.toString());
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException((Throwable)((Object)workSpaceException), (String)"com.ibm.ws.management.configservice.WorkspaceHelper.getWorkspace", (String)"47");
            throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWorkspace", (Object)workSpace);
        }
        return workSpace;
    }

    static RepositoryContext getContext(Session session, ConfigDataId configDataId) throws ConfigServiceException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getContext(workSpace, configDataId);
    }

    static RepositoryContext getContext(WorkSpace workSpace, ConfigDataId configDataId) throws ConfigServiceException {
        RepositoryContext repositoryContext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getContext", (Object)new Object[]{workSpace, configDataId});
        }
        try {
            repositoryContext = workSpace.findContext(configDataId.getContextUri());
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException((Throwable)((Object)workSpaceException), (String)"com.ibm.ws.management.configservice.WorkspaceHelper.getContext", (String)"69");
            throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getContext", (Object)repositoryContext);
        }
        return repositoryContext;
    }

    static DocAccessor getDocAccessor(WorkSpace workSpace, ConfigDataId configDataId) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDocAccessor", (Object)new Object[]{workSpace, configDataId});
        }
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(workSpace, configDataId);
        String string = MOFUtil.getURI(configDataId).path();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDocAccessor", (Object)docAccessor);
        }
        return docAccessor;
    }

    static DocAccessor getDocAccessor(final RepositoryContext repositoryContext, final String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDocAccessor", (Object)new Object[]{repositoryContext, string});
        }
        try {
            Object object;
            Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), false);
            if (resource == null) {
                if (repositoryContext.isAvailable(string)) {
                    if (!repositoryContext.isExtracted(string)) {
                        if (!RestrictedAccess.isReadable((String)string)) {
                            try {
                                object = ContextManagerFactory.getInstance().getServerSubject();
                                ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        repositoryContext.extract(string, false);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw privilegedActionException.getException();
                            }
                        } else {
                            repositoryContext.extract(string, false);
                        }
                    }
                    resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
                } else {
                    object = repositoryContext.getResourceSet().getResourceFactoryRegistry().getFactory(URI.createURI((String)string));
                    resource = object.createResource(URI.createURI((String)string));
                    repositoryContext.getResourceSet().getResources().add((Object)resource);
                }
            }
            resource.setTrackingModification(true);
            object = new DocAccessor(resource);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDocAccessor", (Object)object);
            }
            return object;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.getDocAccessor", (String)"96");
            throw new ConfigDocumentLoadException(repositoryContext.getURI() + '/' + string, exception);
        }
    }

    static DocAccessor getDocAccessor(Session session, ConfigDataId configDataId) throws ConfigServiceException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getDocAccessor(workSpace, configDataId);
    }

    static DocAccessor getDocAccessor(Session session, WorkSpaceFile workSpaceFile) throws ConfigServiceException {
        String string;
        String string2 = workSpaceFile.getURI();
        int n = string2.lastIndexOf(string = workSpaceFile.getFileName().replace(File.separatorChar, '/'));
        String string3 = n <= 0 ? "" : string2.substring(0, n - 1);
        return WorkspaceHelper.getDocAccessor(session, new ConfigDataId(string3, string));
    }

    static Collection getScopeContexts(Session session, ObjectName objectName) throws ConfigServiceException {
        Collection<RepositoryContext> collection;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getScopeContexts", (Object)new Object[]{session, objectName});
        }
        try {
            if (objectName == null) {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                collection = workSpace.findContext(repositoryMetaData.getContextType("cells"));
            } else {
                collection = new ArrayList<RepositoryContext>(1);
                collection.add(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)));
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException((Throwable)((Object)workSpaceException), workSpaceException.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getScopeContexts", collection);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EObject getTemplate(WorkSpace workSpace, EClassifier eClassifier, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTemplate", (Object)new Object[]{workSpace, eClassifier, objectName});
        }
        EObject eObject = null;
        if (objectName == null) {
            eObject = WorkspaceHelper.getTemplate(workSpace, eClassifier);
        } else {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(workSpace, configDataId);
            Resource resource = docAccessor.getResource();
            synchronized (resource) {
                eObject = docAccessor.lookup(configDataId);
                if (!eClassifier.isInstance((Object)eObject)) {
                    String string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0021E", (Object[])new Object[]{TypeRegistry.getTypeShortName(eClassifier), TypeRegistry.getTypeShortName((EClassifier)eObject.eClass())}, null);
                    throw new ConfigServiceException(string);
                }
                TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
                eObject = templateManager.getRefObjectHelper().clone(eObject);
                WorkspaceHelper.clearNameAttribute(eObject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTemplate", (Object)eObject);
        }
        return eObject;
    }

    private static EObject getTemplate(WorkSpace workSpace, EClassifier eClassifier) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTemplate", (Object)new Object[]{workSpace, eClassifier});
        }
        EObject eObject = null;
        try {
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext = templateManager.getRootTemplateContext();
            repositoryContext = repositoryContext.findContext("default");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"templateContext", (Object)repositoryContext);
            }
            List list = repositoryContext.getAllList(true);
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            Object object = list.iterator();
            block4: while (object.hasNext()) {
                WorkSpaceFile workSpaceFile = (WorkSpaceFile)object.next();
                if (!workSpaceFile.getFileName().endsWith(".xml")) continue;
                try {
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(workSpaceFile.getContext(), workSpaceFile.getFileName());
                    Resource resource = docAccessor.getResource();
                    EList eList = resource.getContents();
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject2 = (EObject)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"root obj", (Object)eObject2);
                        }
                        if (!eClassifier.equals(eObject2.eClass())) continue;
                        arrayList.add(eObject2);
                        break block4;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"unable to load templates", (Object)("templates" + workSpaceFile.getFileName()));
                }
            }
            if (arrayList.size() == 0) {
                eObject = null;
            } else {
                eObject = (EObject)arrayList.iterator().next();
                object = templateManager.getRefObjectHelper();
                eObject = object.clone(eObject);
                WorkspaceHelper.clearNameAttribute(eObject);
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception, exception.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTemplate", (Object)eObject);
        }
        return eObject;
    }

    public static ValidationManager getValidationManager(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getValidationManager", (Object)session);
        }
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ValidationManagerRegistry validationManagerRegistry = ValidationHelper.getRegistry();
            ValidationManager validationManager = validationManagerRegistry.getValidationManager(workSpace);
            if (validationManager == null) {
                ValidationPolicy validationPolicy = ValidationHelper.createPolicy();
                validationPolicy.setIncludeCross(true);
                validationPolicy.setIncludeExtracted(true);
                validationPolicy.setIncludeParentChain(true);
                validationPolicy.setIncludeLocalSiblings(true);
                validationPolicy.setIncludeAll(false);
                validationManager = validationManagerRegistry.getValidationManager(workSpace, validationPolicy, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getValidationManager", (Object)validationManager);
            }
            return validationManager;
        }
        catch (ValidationManagerException validationManagerException) {
            throw new ConfigServiceException((Throwable)((Object)validationManagerException), TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0016E", (Object[])new Object[]{session}, null));
        }
    }

    static boolean isConfigDocument(RepositoryContextType repositoryContextType, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isConfigDocument", (Object)new Object[]{repositoryContextType, string});
        }
        boolean bl2 = bl = repositoryContextType.getChildDocumentType(string) != null;
        if (!bl) {
            Iterator iterator = repositoryContextType.getChildContextTypes().iterator();
            while (iterator.hasNext() && !(bl = WorkspaceHelper.isConfigDocument((RepositoryContextType)iterator.next(), string))) {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isConfigDocument," + bl));
        }
        return bl;
    }

    static RepositoryContext getContext(Resource resource) {
        ContextResourceSet contextResourceSet = (ContextResourceSet)resource.getResourceSet();
        return contextResourceSet.getContext();
    }

    private static void clearNameAttribute(EObject eObject) {
        try {
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), "name", false);
            eObject.eUnset(eStructuralFeature);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

