/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.rmi.RMIConnector;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteReceiver;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RMIConnectorClient
implements AdminServiceProxy {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$rmi$RMIConnectorClient == null ? (class$com$ibm$ws$management$connector$rmi$RMIConnectorClient = RMIConnectorClient.class$("com.ibm.ws.management.connector.rmi.RMIConnectorClient")) : class$com$ibm$ws$management$connector$rmi$RMIConnectorClient), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private RMIConnector connector;
    private RMINotificationListener rmiListener;
    private Properties proxyProps;
    private boolean online = false;
    static /* synthetic */ Class class$com$ibm$ws$management$connector$rmi$RMIConnectorClient;
    static /* synthetic */ Class class$com$ibm$ws$management$connector$rmi$RMIConnector;

    public RMIConnectorClient(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init>" + this.getPropsString(properties)));
        }
        this.proxyProps = new Properties();
        this.proxyProps.setProperty("type", "RMI");
        this.proxyProps.setProperty("host", properties.getProperty("host"));
        this.proxyProps.setProperty("port", properties.getProperty("port"));
        this.proxyProps.setProperty("com.ibm.websphere.naming.jndicache.cacheobject", "none");
        String string = "iiop://" + this.proxyProps.getProperty("host", "localhost") + ":" + this.proxyProps.getProperty("port", "2809");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using PROVIDER_URL " + string));
        }
        this.proxyProps.setProperty("java.naming.provider.url", string);
        boolean bl = properties.getProperty("username") != null & properties.getProperty("password") != null;
        if (bl) {
            this.setupSecurityCredentials(properties);
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupSecurityCredentials(Properties properties) throws ConnectorAuthenticationException {
        boolean bl;
        boolean bl2 = bl = new Boolean(properties.getProperty("isInternal")) == false;
        if (bl) {
            String string = properties.getProperty("username");
            String string2 = properties.getProperty("password");
            if (tc.isDebugEnabled() && string == null) {
                Tr.debug((TraceComponent)tc, (String)"username not specified");
            }
            if (tc.isDebugEnabled() && string2 == null) {
                Tr.debug((TraceComponent)tc, (String)"password not specified");
            }
            try {
                if (string == null || string2 == null) return;
                Subject subject = SecurityHelper.authenticate(string, string2);
                SecurityHelper.setInvocationSubject(subject);
                return;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed to login", (Object)exception);
                }
                if (!tc.isEntryEnabled()) throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), exception);
                Tr.exit((TraceComponent)tc, (String)"<init> - exception");
                throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), exception);
            }
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getInvocationSubject();
            if (subject == null) {
                subject = SecurityHelper.getReceivedSubject();
            }
            if (subject != null) {
                SecurityHelper.setInvocationSubject(subject);
                return;
            } else {
                Tr.service((TraceComponent)tc, (String)"ADMC0032W");
            }
            return;
        }
        catch (Exception exception) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"exception occurred setting invocation credential", (Object)exception);
        }
    }

    public RMIConnector getRMIConnector() {
        return this.connector;
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    private void reconnect() throws ConnectorNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconnect");
        }
        try {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", "corbaloc:iiop:" + this.proxyProps.getProperty("host", "localhost") + ":" + this.proxyProps.getProperty("port", "2809") + "/" + "WsnAdminNameService");
            InitialContext initialContext = new InitialContext(properties);
            this.connector = (RMIConnector)PortableRemoteObject.narrow((Object)initialContext.lookup("RMIConnector"), (Class)(class$com$ibm$ws$management$connector$rmi$RMIConnector == null ? (class$com$ibm$ws$management$connector$rmi$RMIConnector = RMIConnectorClient.class$("com.ibm.ws.management.connector.rmi.RMIConnector")) : class$com$ibm$ws$management$connector$rmi$RMIConnector));
            this.online = true;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.reconnect", (String)"118", (Object)this);
            this.online = false;
            throw new ConnectorNotAvailableException(namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconnect");
        }
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy adminServiceProxy) {
        PushRemoteReceiver pushRemoteReceiver = new PushRemoteReceiver(adminServiceProxy);
        try {
            this.rmiListener = (RMINotificationListener)PortableRemoteObject.toStub((Remote)new RMINotificationListenerService(pushRemoteReceiver));
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.createRemoteReceiver", (String)"146", (Object)this);
        }
        return pushRemoteReceiver;
    }

    private void handleRemoteException(RemoteException remoteException) throws ConnectorException {
        this.online = false;
        throw new ConnectorException("RemoteException received", remoteException);
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking isAlive");
        }
        if (!this.online) {
            this.reconnect();
        }
        Session session = null;
        try {
            session = this.connector.isAlive();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                session = this.connector.isAlive();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.isAlive", (String)"174", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return session;
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking queryNames");
        }
        if (!this.online) {
            this.reconnect();
        }
        Set set = null;
        try {
            set = this.connector.queryNames(objectName, queryExp);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                set = this.connector.queryNames(objectName, queryExp);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.queryNames", (String)"201", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return set;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        Object object = null;
        try {
            object = this.connector.getAttribute(objectName, string);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                object = this.connector.getAttribute(objectName, string);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttribute", (String)"224", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        AttributeList attributeList = null;
        try {
            attributeList = this.connector.getAttributes(objectName, stringArray);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                attributeList = this.connector.getAttributes(objectName, stringArray);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttributes", (String)"246", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking setAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.setAttribute(objectName, attribute);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.setAttribute(objectName, attribute);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttribute", (String)"269", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking setAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        AttributeList attributeList2 = null;
        try {
            attributeList2 = this.connector.setAttributes(objectName, attributeList);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                attributeList2 = this.connector.setAttributes(objectName, attributeList);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttributes", (String)"289", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return attributeList2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking invoke");
        }
        if (!this.online) {
            this.reconnect();
        }
        Object object = null;
        try {
            object = this.connector.invoke(objectName, string, objectArray, stringArray);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                object = this.connector.invoke(objectName, string, objectArray, stringArray);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.invoke", (String)"311", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return object;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getDefaultDomain");
        }
        if (!this.online) {
            this.reconnect();
        }
        String string = null;
        try {
            string = this.connector.getDefaultDomain();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                string = this.connector.getDefaultDomain();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDefaultDomain", (String)"332", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return string;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getDomainName");
        }
        if (!this.online) {
            this.reconnect();
        }
        String string = null;
        try {
            string = this.connector.getDomainName();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                string = this.connector.getDomainName();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDomainName", (String)"351", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return string;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getMBeanCount");
        }
        if (!this.online) {
            this.reconnect();
        }
        Integer n = null;
        try {
            n = this.connector.getMBeanCount();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                n = this.connector.getMBeanCount();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanCount", (String)"370", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return n;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getMBeanInfo");
        }
        if (!this.online) {
            this.reconnect();
        }
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.connector.getMBeanInfo(objectName);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                mBeanInfo = this.connector.getMBeanInfo(objectName);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanInfo", (String)"392", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return mBeanInfo;
    }

    public boolean isRegistered(ObjectName objectName) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking isRegistered");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        try {
            bl = this.connector.isRegistered(objectName);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                bl = this.connector.isRegistered(objectName);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.isRegistered", (String)"412", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return bl;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking isInstanceOf");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        try {
            bl = this.connector.isInstanceOf(objectName, string);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                bl = this.connector.isInstanceOf(objectName, string);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.isInstanceOf", (String)"433", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return bl;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking addNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        ListenerIdentifier listenerIdentifier = null;
        try {
            listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, this.rmiListener);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, this.rmiListener);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.addNotificationListener", (String)"474", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return listenerIdentifier;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking removeNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener(listenerIdentifier);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.removeNotificationListener(listenerIdentifier);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", (String)"497", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking resetFilter");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.resetFilter(listenerIdentifier, consolidatedFilter);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.resetFilter(listenerIdentifier, consolidatedFilter);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.resetFilter", (String)"517", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking pullNotifications");
        }
        if (!this.online) {
            this.reconnect();
        }
        Notification[] notificationArray = null;
        try {
            notificationArray = this.connector.pullNotifications(listenerIdentifier, n);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                notificationArray = this.connector.pullNotifications(listenerIdentifier, n);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getEvents", (String)"540", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return notificationArray;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invoking getServerMBean");
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName objectName = null;
        try {
            objectName = this.connector.getServerMBean();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                objectName = this.connector.getServerMBean();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorClient.getServerMBean", (String)"352", (Object)this);
                this.handleRemoteException(remoteException);
            }
        }
        return objectName;
    }

    private String getPropsString(Properties properties) {
        String string = "props: {";
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = string + ",";
            }
            ++n;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("password")) {
                string = string + " " + string2 + "=" + "*****";
                continue;
            }
            string = string + " " + string2 + "=" + properties.get(string2);
        }
        string = string + "}";
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

