/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.rmi.RMIConnectorService;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RMIConnectorController
implements JMXConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$rmi$RMIConnectorController == null ? (class$com$ibm$ws$management$connector$rmi$RMIConnectorController = RMIConnectorController.class$("com.ibm.ws.management.connector.rmi.RMIConnectorController")) : class$com$ibm$ws$management$connector$rmi$RMIConnectorController), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private RMIConnectorService connector;
    private Properties connectorProps;
    private boolean started = false;
    private static final String JNDI_NAME = "RMIConnector";
    static /* synthetic */ Class class$com$ibm$ws$management$connector$rmi$RMIConnectorController;

    public void initialize(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)properties);
        }
        this.connectorProps = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        if (this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start - Connector already started");
            }
            return;
        }
        InitialContext initialContext = null;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            initialContext = new InitialContext(properties);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"77", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMC0021W", (Object)namingException);
            throw new ConnectorNotAvailableException("", namingException);
        }
        try {
            this.connector = RMIConnectorService.getInstance();
            initialContext.rebind(JNDI_NAME, (Object)this.connector);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"90", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMC0022W", (Object)remoteException);
            throw new ConnectorNotAvailableException("", remoteException);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"98", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMC0021W", (Object)namingException);
            throw new ConnectorNotAvailableException("", namingException);
        }
        this.connector.start();
        this.started = true;
        Tr.audit((TraceComponent)tc, (String)"ADMC0026I", (Object)this.connectorProps.getProperty("port"));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start - RMI Connector started successfully");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stop - RMI Connector already stopped");
            }
            return;
        }
        this.connector.stop();
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            initialContext.unbind(JNDI_NAME);
            this.started = false;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.stop", (String)"132", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMC0023W", (Object)namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProperties() {
        return this.connectorProps;
    }

    public String getName() {
        return "type=RMI;host=" + this.connectorProps.getProperty("host") + ";" + "port" + "=" + this.connectorProps.getProperty("port");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

