/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import com.ibm.ws.management.connector.soap.SOAPRequest;
import com.ibm.ws.management.connector.soap.SOAPResponse;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$soap$SOAPConnector == null ? (class$com$ibm$ws$management$connector$soap$SOAPConnector = SOAPConnector.class$("com.ibm.ws.management.connector.soap.SOAPConnector")) : class$com$ibm$ws$management$connector$soap$SOAPConnector), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private static AdminServiceDelegator targetObject = new AdminServiceDelegator();
    private static SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean securityEnabled = SecurityHelper.getHelper().isSecurityEnabled();
    static /* synthetic */ Class class$com$ibm$ws$management$connector$soap$SOAPConnector;

    public void service(SOAPConnection sOAPConnection) throws HttpException, IOException {
        String string;
        Fault fault;
        Throwable throwable;
        boolean bl;
        Response response;
        Call call;
        int n;
        SOAPContext sOAPContext;
        SOAPResponse sOAPResponse;
        SOAPRequest sOAPRequest;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"service");
            }
            sOAPRequest = sOAPConnection.getSOAPRequest();
            sOAPResponse = sOAPConnection.getSOAPResponse();
            SOAPContext sOAPContext2 = new SOAPContext();
            sOAPContext = new SOAPContext();
            n = SOAPResponse.SC_OK;
            call = null;
            response = null;
            Header header = null;
            bl = false;
            throwable = null;
            Subject subject = null;
            try {
                call = SOAPUtils.extractSoapCall(sOAPRequest.getInputStream(), sOAPRequest.getContentLength(), sOAPRequest.getContentType(), sOAPContext2, smr);
                if (this.securityEnabled) {
                    header = call.getHeader();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Header: " + header));
                    }
                    if (header != null) {
                        fault = null;
                        string = null;
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        String string5 = header.getAttribute(SOAPUtils.securityEnabled);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Security Enabled: " + new Boolean(string5)));
                        }
                        Vector vector = header.getHeaderEntries();
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Element element = (Element)enumeration.nextElement();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"nodeName", (Object)element.getNodeName());
                            }
                            NodeList nodeList = element.getChildNodes();
                            int n2 = nodeList.getLength();
                            string4 = null;
                            for (int i = 0; i < n2; ++i) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"node value", (Object)nodeList.item(i).getNodeValue());
                                }
                                string4 = nodeList.item(i).getNodeValue();
                            }
                            if (element.getNodeName().equals("username")) {
                                fault = string4;
                                continue;
                            }
                            if (element.getNodeName().equals("password")) {
                                string = string4;
                                continue;
                            }
                            if (element.getNodeName().equals("LoginMethod")) {
                                string2 = string4;
                                continue;
                            }
                            if (!element.getNodeName().equals("token")) continue;
                            string3 = string4;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("username: " + (String)((Object)fault)));
                        }
                        if (string2.equals("BasicAuth")) {
                            if (fault != null && string != null && ((String)((Object)fault)).length() > 0 && string.length() > 0) {
                                subject = this.basicAuth((String)((Object)fault), string);
                            }
                        } else if (string2.equals("TokenBased") && string3 != null && string3.length() > 0) {
                            subject = this.tokenBasedAuth(string3);
                        }
                    }
                }
                this.checkURI(call);
                if (this.securityEnabled) {
                    SecurityHelper.resetContext();
                    if (subject != null) {
                        SecurityHelper.setReceivedSubject(subject);
                        SecurityHelper.pushInvocationSubject(subject);
                    }
                    response = this.invoke(call, sOAPContext);
                } else {
                    response = this.invoke(call, sOAPContext);
                }
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.service", (String)"212", (Object)this);
                bl = true;
                throwable = throwable2;
                if (!tc.isDebugEnabled()) break block30;
                Tr.debug((TraceComponent)tc, (String)"Caught exception", (Object)throwable2);
            }
        }
        if (bl) {
            fault = new Fault(new SOAPException(Constants.FAULT_CODE_SERVER, throwable.getMessage()));
            try {
                fault.setFaultString(SOAPUtils.convertObjectToString(throwable));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.service", (String)"228", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"error occurs when serializing the exception", (Object)exception);
                }
                throw new HttpException(SOAPResponse.SC_INTERNAL_SERVER_ERROR);
            }
            fault.setFaultActorURI(sOAPRequest.getURI());
            n = SOAPResponse.SC_INTERNAL_SERVER_ERROR;
            string = null;
            if (call != null) {
                string = call.getEncodingStyleURI();
            }
            if (string == null) {
                string = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            sOAPContext = new SOAPContext();
            response = new Response(null, null, fault, null, null, string, sOAPContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("the response object = " + response));
        }
        sOAPResponse.writeSOAPResponse(response, sOAPContext, smr, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"service");
        }
    }

    private void checkURI(Call call) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkURI", (Object)call);
        }
        String string = call.getTargetObjectURI();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Soap Call URI: " + string));
        }
        if (string == null || !string.equalsIgnoreCase("urn:AdminService")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkURI", (Object)call);
            }
            throw new AdminException(nls.getString("ADMC0005E", "SOAP URI Violation"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkURI", (Object)call);
        }
    }

    private Response invoke(Call call, SOAPContext sOAPContext) throws AdminException, Throwable {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invoke", (Object)call);
        }
        String string = call.getEncodingStyleURI();
        Vector vector = call.getParams();
        Object[] objectArray = null;
        Class[] classArray = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Method Name: " + call.getMethodName()));
        }
        if (vector != null) {
            int n = vector.size();
            objectArray = new Object[n];
            classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                object2 = (Parameter)vector.elementAt(i);
                objectArray[i] = ((Parameter)object2).getValue();
                classArray[i] = ((Parameter)object2).getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Parameter: " + objectArray[i] + "(type: " + classArray[i] + ")"));
                }
                if (string != null) continue;
                string = ((Parameter)object2).getEncodingStyleURI();
            }
        }
        if (string == null) {
            string = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Bean bean = null;
        try {
            object = null;
            object = MethodUtils.getMethod(targetObject, call.getMethodName(), classArray);
            bean = new Bean(((Method)object).getReturnType(), ((Method)object).invoke((Object)targetObject, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"351", (Object)this);
            object2 = invocationTargetException.getTargetException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke");
            }
            throw object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"358", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke");
            }
            throw new AdminException(noSuchMethodException, nls.getString("ADMC0007E"));
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"365", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke");
            }
            throw new AdminException(illegalAccessException, nls.getString("ADMC0007E"));
        }
        object = null;
        if (bean.type != Void.TYPE) {
            if (bean.value != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("return object type = " + bean.value.getClass() + "; value = " + bean.value));
                }
                object = new Parameter(RPCConstants.ELEM_RETURN, bean.value.getClass(), bean.value, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("return object type = " + bean.type + "; value = " + bean.value));
                }
                object = new Parameter(RPCConstants.ELEM_RETURN, bean.type, bean.value, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke");
        }
        return new Response(call.getTargetObjectURI(), call.getMethodName(), (Parameter)object, null, null, string, sOAPContext);
    }

    private Subject basicAuth(String string, String string2) {
        Subject subject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"basicAuth");
            }
            subject = null;
            try {
                subject = SecurityHelper.authenticate(RealmSecurityName.getSecurityName((String)string), string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.invoke", (String)"406", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"unable to authenticate incoming request", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"basicAuth");
        }
        return subject;
    }

    private Subject tokenBasedAuth(String string) {
        Subject subject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"tokenBasedAuth");
            }
            byte[] byArray = Base64.decode(string);
            WSSecurityContext wSSecurityContext = SecurityHelper.getHelper().getWSSecurityContext();
            subject = null;
            try {
                WSSecurityContextResult wSSecurityContextResult = wSSecurityContext.acceptSecContext(byArray);
                subject = wSSecurityContextResult.getSubject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnector.tokenBasedAuth", (String)"415", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"unable to authenticate incoming request", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"tokenBasedAuth");
        }
        return subject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

