/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.jsse.IBMJSSEProvider;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PullRemoteReceiver;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.ContextManagerImpl;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SOAPConnectorClient
implements InvocationHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$soap$SOAPConnectorClient == null ? (class$com$ibm$ws$management$connector$soap$SOAPConnectorClient = SOAPConnectorClient.class$("com.ibm.ws.management.connector.soap.SOAPConnectorClient")) : class$com$ibm$ws$management$connector$soap$SOAPConnectorClient), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private static final Vector emptyParams = new Vector(1);
    private static final String SOAPActionURI = "urn:AdminService";
    private SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean offline = true;
    private boolean secEnabled;
    private boolean isInternal;
    private Properties proxyProps;
    private URL url;
    private String protocol = "http";
    private String host;
    private String port;
    private String user;
    private String password;
    private int requestTimeout;
    private boolean JSSEFIPSProviderEnabled = false;
    private boolean keyStoreWarning = true;
    private boolean trustStoreWarning = true;
    static /* synthetic */ Class class$com$ibm$ws$management$connector$soap$SOAPConnectorClient;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$javax$management$QueryExp;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$javax$management$Attribute;
    static /* synthetic */ Class class$javax$management$AttributeList;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$apache$soap$SOAPException;
    static /* synthetic */ Class class$com$ibm$ws$management$event$ConsolidatedFilter;
    static /* synthetic */ Class class$com$ibm$ws$management$event$PushNotificationListener;
    static /* synthetic */ Class class$com$ibm$ws$management$event$ListenerIdentifier;
    static /* synthetic */ Class class$java$lang$Integer;

    private void loadFIPS() {
        Provider provider = null;
        try {
            provider = Security.getProvider("IBMJSSE");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSE) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        if (provider == null) {
            provider = new IBMJSSEProvider();
            Security.addProvider(provider);
        }
        Provider provider2 = null;
        try {
            provider2 = Security.getProvider("IBMJSSEFIPS");
        }
        catch (Throwable throwable) {
            System.err.println("getProvider(IBMJSSEFIPS) Exception caught: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        try {
            if (provider2 == null) {
                int n = 0;
                if (provider != null) {
                    Provider[] providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        if (providerArray[i] == null || !new String("IBMJSSE").equals(providerArray[i].getName())) continue;
                        n = i;
                        break;
                    }
                }
                provider2 = (Provider)Class.forName("com.ibm.fips.jsse.IBMJSSEFIPSProvider").newInstance();
                if (n > 0) {
                    Security.insertProviderAt(provider2, n);
                } else {
                    Security.addProvider(provider2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception caught adding IBMJSSEFIPS: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public SOAPConnectorClient(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SOAPConnectorClient");
        }
        this.proxyProps = (Properties)properties.clone();
        String string = this.proxyProps.getProperty("com.ibm.ssl.contextProvider");
        if (string != null && string.equals("IBMJSSEFIPS")) {
            this.loadFIPS();
        }
        this.host = this.proxyProps.getProperty("host");
        this.port = this.proxyProps.getProperty("port");
        this.user = this.proxyProps.getProperty("username");
        this.password = this.proxyProps.getProperty("password");
        String string2 = this.proxyProps.getProperty("com.ibm.SOAP.requestTimeout");
        if (string2 == null) {
            string2 = System.getProperty("com.ibm.SOAP.requestTimeout", "600");
        }
        this.requestTimeout = Integer.parseInt(string2);
        this.secEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled"));
        this.isInternal = new Boolean(this.proxyProps.getProperty("isInternal"));
        if (this.secEnabled) {
            this.protocol = "https";
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SOAPConnectorClient");
        }
    }

    public String getType() {
        return "SOAP";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy adminServiceProxy) {
        return new PullRemoteReceiver(adminServiceProxy);
    }

    private void reconnect() throws ConnectorNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconnect");
        }
        if (!this.offline) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconnect");
            }
            return;
        }
        final Call call = new Call();
        call.setSOAPMappingRegistry(this.smr);
        call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        call.setTargetObjectURI(SOAPActionURI);
        call.setMethodName("isAlive");
        call.setParams(emptyParams);
        call.setTargetObjectURI(SOAPActionURI);
        call.setTimeout(this.requestTimeout * 1000);
        if (this.secEnabled) {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                    return null;
                }
            });
        }
        try {
            try {
                Response response = (Response)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws SOAPException, ConnectorNotAvailableException {
                        Response response = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                        return response;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                throw exception;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", (String)"145", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconnect", (Object)exception);
            }
            if (this.JSSEFIPSProviderEnabled) {
                throw new ConnectorNotAvailableException(nls.getString("ADMC0054E"), exception);
            }
            throw new ConnectorNotAvailableException(exception);
        }
        this.offline = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconnect");
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"invoke", (Object)new Object[]{method, objectArray});
        }
        String string = method.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("method name: " + string));
        }
        if (string.equals("invoke")) {
            return this.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
        }
        if (string.equals("getAttribute")) {
            return this.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
        }
        if (string.equals("getAttributes")) {
            return this.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
        }
        if (string.equals("setAttribute")) {
            this.setAttribute((ObjectName)objectArray[0], (Attribute)objectArray[1]);
            return null;
        }
        if (string.equals("setAttributes")) {
            return this.setAttributes((ObjectName)objectArray[0], (AttributeList)objectArray[1]);
        }
        if (string.equals("isAlive")) {
            return this.isAlive();
        }
        if (string.equals("reconnect")) {
            this.reconnect();
            return null;
        }
        if (string.equals("getType")) {
            return this.getType();
        }
        if (string.equals("getProxyProperties")) {
            return this.getProxyProperties();
        }
        if (string.equals("queryNames")) {
            return this.queryNames((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
        }
        if (string.equals("getMBeanCount")) {
            return this.getMBeanCount();
        }
        if (string.equals("getDomainName")) {
            return this.getDomainName();
        }
        if (string.equals("getDefaultDomain")) {
            return this.getDefaultDomain();
        }
        if (string.equals("getMBeanInfo")) {
            return this.getMBeanInfo((ObjectName)objectArray[0]);
        }
        if (string.equals("getServerMBean")) {
            return this.getServerMBean();
        }
        if (string.equals("isInstanceOf")) {
            return this.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]);
        }
        if (string.equals("isRegistered")) {
            return this.isRegistered((ObjectName)objectArray[0]);
        }
        if (string.equals("openRemoteNotificationChannel")) {
            return this.openRemoteNotificationChannel((AdminServiceProxy)objectArray[0]);
        }
        if (string.equals("addNotificationListener")) {
            return this.addNotificationListener((ConsolidatedFilter)objectArray[0], (PushNotificationListener)objectArray[1]);
        }
        if (string.equals("removeNotificationListener")) {
            this.removeNotificationListener((ListenerIdentifier)objectArray[0]);
            return null;
        }
        if (string.equals("resetFilter")) {
            this.resetFilter((ListenerIdentifier)objectArray[0], (ConsolidatedFilter)objectArray[1]);
            return null;
        }
        if (string.equals("pullNotifications")) {
            return this.pullNotifications((ListenerIdentifier)objectArray[0], (Integer)objectArray[1]);
        }
        throw new ConnectorException(nls.getFormattedMessage("ADMC0044E", new Object[]{string}, "Unsupported AdminClient operation: {0}"));
    }

    public Session isAlive() throws Throwable {
        return (Session)this.invokeTemplate("isAlive", emptyParams, false);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        if (queryExp != null) {
            vector.addElement(new Parameter("queryexp", queryExp.getClass(), queryExp, null));
        } else {
            vector.addElement(new Parameter("queryexp", class$javax$management$QueryExp == null ? (class$javax$management$QueryExp = SOAPConnectorClient.class$("javax.management.QueryExp")) : class$javax$management$QueryExp, queryExp, null));
        }
        return (Set)this.invokeTemplate("queryNames", vector, false);
    }

    public Integer getMBeanCount() throws Throwable {
        return (Integer)this.invokeTemplate("getMBeanCount", emptyParams, false);
    }

    public String getDomainName() throws Throwable {
        return (String)this.invokeTemplate("getDomainName", emptyParams, false);
    }

    public String getDefaultDomain() throws Throwable {
        return (String)this.invokeTemplate("getDefaultDomain", emptyParams, false);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        return (MBeanInfo)this.invokeTemplate("getMBeanInfo", vector, false);
    }

    public ObjectName getServerMBean() throws Throwable {
        return (ObjectName)this.invokeTemplate("getServerMBean", emptyParams, false);
    }

    public Boolean isInstanceOf(ObjectName objectName, String string) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("classname", class$java$lang$String == null ? (class$java$lang$String = SOAPConnectorClient.class$("java.lang.String")) : class$java$lang$String, string, null));
        return (Boolean)this.invokeTemplate("isInstanceOf", vector, false);
    }

    public Boolean isRegistered(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        return (Boolean)this.invokeTemplate("isRegistered", vector, false);
    }

    public Object getAttribute(ObjectName objectName, String string) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("attribute", class$java$lang$String == null ? (class$java$lang$String = SOAPConnectorClient.class$("java.lang.String")) : class$java$lang$String, string, null));
        return this.invokeTemplate("getAttribute", vector, true);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("attribute", array$Ljava$lang$String == null ? (array$Ljava$lang$String = SOAPConnectorClient.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, stringArray, null));
        return (AttributeList)this.invokeTemplate("getAttributes", vector, true);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("attribute", class$javax$management$Attribute == null ? (class$javax$management$Attribute = SOAPConnectorClient.class$("javax.management.Attribute")) : class$javax$management$Attribute, attribute, null));
        this.invokeTemplate("setAttribute", vector, true);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("attribute", class$javax$management$AttributeList == null ? (class$javax$management$AttributeList = SOAPConnectorClient.class$("javax.management.AttributeList")) : class$javax$management$AttributeList, attributeList, null));
        return (AttributeList)this.invokeTemplate("setAttributes", vector, true);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = SOAPConnectorClient.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, objectName, null));
        vector.addElement(new Parameter("operationname", class$java$lang$String == null ? (class$java$lang$String = SOAPConnectorClient.class$("java.lang.String")) : class$java$lang$String, string, null));
        vector.addElement(new Parameter("params", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SOAPConnectorClient.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, objectArray, null));
        vector.addElement(new Parameter("signature", array$Ljava$lang$String == null ? (array$Ljava$lang$String = SOAPConnectorClient.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, stringArray, null));
        return this.invokeTemplate("invoke", vector, true);
    }

    private Object invokeTemplate(String string, Vector vector, boolean bl) throws Throwable {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeTemplate", (Object)string);
        }
        if (this.offline) {
            try {
                this.reconnect();
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"invokeTemplate - failed", (Object)throwable);
                }
                if (throwable instanceof ConnectorNotAvailableException) {
                    throw throwable;
                }
                throw new ConnectorNotAvailableException(throwable);
            }
        }
        final Call call = new Call();
        call.setSOAPMappingRegistry(this.smr);
        call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        call.setTargetObjectURI(SOAPActionURI);
        call.setMethodName(string);
        call.setParams(vector);
        call.setTimeout(this.requestTimeout * 1000);
        if (this.secEnabled) {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                    return null;
                }
            });
            if (bl && (object = this.getSecurityHeader(this.isInternal)) != null) {
                call.setHeader((Header)object);
            }
        }
        object = null;
        try {
            try {
                object = (Response)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws SOAPException, ConnectorNotAvailableException {
                        Response response = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                        return response;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception.equals(class$org$apache$soap$SOAPException == null ? (class$org$apache$soap$SOAPException = SOAPConnectorClient.class$("org.apache.soap.SOAPException")) : class$org$apache$soap$SOAPException)) {
                    SOAPException sOAPException = (SOAPException)exception;
                    throw sOAPException;
                }
                throw exception;
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", (String)"466", (Object)this);
            try {
                this.offline = true;
                this.reconnect();
            }
            catch (ConnectorNotAvailableException connectorNotAvailableException) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invokeTemplate - failed", (Object)new Object[]{string, sOAPException});
            }
            if (this.offline) {
                throw new ConnectorNotAvailableException(sOAPException);
            }
            String string2 = nls.getFormattedMessage("ADMC0009E", new Object[]{string}, "Failed to make a SOAP call: {0}");
            throw new ConnectorException(string2, sOAPException);
        }
        if (((Response)object).generatedFault()) {
            Fault fault = ((Response)object).getFault();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invokeTemplate", (Object)string);
            }
            this.handleAdminFault(fault);
        } else {
            Parameter parameter = ((Response)object).getReturnValue();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invokeTemplate", (Object)string);
            }
            if (parameter != null) {
                return parameter.getValue();
            }
        }
        return null;
    }

    private void handleAdminFault(Fault fault) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleAdminFault");
        }
        String string = fault.getFaultString();
        Throwable throwable = null;
        try {
            throwable = (Throwable)SOAPUtils.convertStringToObject(string);
            throwable = throwable.fillInStackTrace();
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", (String)"533", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"error occurs while deserializing the received exception", (Object)throwable2);
            }
            throwable = new IllegalArgumentException(nls.getString("ADMC0043E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleAdminFault", (Object)throwable);
        }
        throw throwable;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNotificationListener", (Object)pushNotificationListener);
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("filter", class$com$ibm$ws$management$event$ConsolidatedFilter == null ? (class$com$ibm$ws$management$event$ConsolidatedFilter = SOAPConnectorClient.class$("com.ibm.ws.management.event.ConsolidatedFilter")) : class$com$ibm$ws$management$event$ConsolidatedFilter, consolidatedFilter, null));
        vector.addElement(new Parameter("listener", class$com$ibm$ws$management$event$PushNotificationListener == null ? (class$com$ibm$ws$management$event$PushNotificationListener = SOAPConnectorClient.class$("com.ibm.ws.management.event.PushNotificationListener")) : class$com$ibm$ws$management$event$PushNotificationListener, pushNotificationListener, null));
        ListenerIdentifier listenerIdentifier = (ListenerIdentifier)this.invokeTemplate("addNotificationListener", vector, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNotificationListener", (Object)listenerIdentifier);
        }
        return listenerIdentifier;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeNotificationListener", (Object)listenerIdentifier);
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", class$com$ibm$ws$management$event$ListenerIdentifier == null ? (class$com$ibm$ws$management$event$ListenerIdentifier = SOAPConnectorClient.class$("com.ibm.ws.management.event.ListenerIdentifier")) : class$com$ibm$ws$management$event$ListenerIdentifier, listenerIdentifier, null));
        this.invokeTemplate("removeNotificationListener", vector, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetFilter");
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", class$com$ibm$ws$management$event$ListenerIdentifier == null ? (class$com$ibm$ws$management$event$ListenerIdentifier = SOAPConnectorClient.class$("com.ibm.ws.management.event.ListenerIdentifier")) : class$com$ibm$ws$management$event$ListenerIdentifier, listenerIdentifier, null));
        vector.addElement(new Parameter("fileter", class$com$ibm$ws$management$event$ConsolidatedFilter == null ? (class$com$ibm$ws$management$event$ConsolidatedFilter = SOAPConnectorClient.class$("com.ibm.ws.management.event.ConsolidatedFilter")) : class$com$ibm$ws$management$event$ConsolidatedFilter, consolidatedFilter, null));
        this.invokeTemplate("resetFilter", vector, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetFilter");
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pullNotifications", (Object)new Object[]{listenerIdentifier, n});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", class$com$ibm$ws$management$event$ListenerIdentifier == null ? (class$com$ibm$ws$management$event$ListenerIdentifier = SOAPConnectorClient.class$("com.ibm.ws.management.event.ListenerIdentifier")) : class$com$ibm$ws$management$event$ListenerIdentifier, listenerIdentifier, null));
        vector.addElement(new Parameter("batchSize", class$java$lang$Integer == null ? (class$java$lang$Integer = SOAPConnectorClient.class$("java.lang.Integer")) : class$java$lang$Integer, n, null));
        Notification[] notificationArray = (Notification[])this.invokeTemplate("pullNotifications", vector, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pullNotifications", (Object)notificationArray);
        }
        return notificationArray;
    }

    private Header createSOAPSecHeader(String string, String string2) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSOAPSecHeader");
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", (String)"619", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), exception);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vector = new Vector<Element>();
        Element element = document.createElement("username");
        Text text = document.createTextNode(string);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("password");
        text = document.createTextNode(string2);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("LoginMethod");
        text = document.createTextNode("BasicAuth");
        element.appendChild(text);
        vector.addElement(element);
        header.setHeaderEntries(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSOAPSecHeader");
        }
        return header;
    }

    private Header getSecurityHeader(boolean bl) throws ConnectorException {
        Header header = null;
        header = bl ? this.processInternal() : this.processExternal();
        return header;
    }

    private Header createSOAPSecHeader(String string) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSOAPSecHeader");
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", (String)"661", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), exception);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vector = new Vector<Element>();
        Element element = document.createElement("token");
        Text text = document.createTextNode(string);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("LoginMethod");
        text = document.createTextNode("TokenBased");
        element.appendChild(text);
        vector.addElement(element);
        header.setHeaderEntries(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSOAPSecHeader");
        }
        return header;
    }

    private Header processExternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processExternal");
        }
        Header header = null;
        if (this.user == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SOAPConnectorClient - exception");
            }
            throw new ConnectorAuthenticationException(nls.getString("ADMC0035E", "no username specified"));
        }
        if (this.password == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SOAPConnectorClient - exception");
            }
            throw new ConnectorAuthenticationException(nls.getString("ADMC0036E", "no password specified"));
        }
        header = this.createSOAPSecHeader(this.user, this.password);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processExternal");
        }
        return header;
    }

    private Header processInternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processInternal");
        }
        Subject subject = null;
        Header header = null;
        subject = SecurityHelper.retrieveSubject();
        if (subject != null) {
            try {
                SecurityHelper.getActualSubject(subject);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processInternal - getActualSubject failed getting token Subject.");
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.processInternal", (String)"919", (Object)this);
                subject = null;
            }
        }
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processInternal - no subject");
            }
        } else {
            String string = null;
            WSSecurityContext wSSecurityContext = SecurityHelper.getHelper().getWSSecurityContext();
            String string2 = SecurityHelper.getHelper().getRealm();
            if (wSSecurityContext != null) {
                block14: {
                    try {
                        byte[] byArray = wSSecurityContext.initSecContext(subject, this.host, string2);
                        string = Base64.encode(byArray);
                    }
                    catch (WSSecurityContextException wSSecurityContextException) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"fail to initialize the security context");
                    }
                }
                if (string != null) {
                    header = this.createSOAPSecHeader(string);
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"ADMC0034W");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processInternal");
        }
        return header;
    }

    private URL getUrl() throws ConnectorNotAvailableException {
        if (this.url == null) {
            String string = this.protocol + "://" + this.host + ":" + this.port + "/";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("soap url: " + string));
            }
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.management.connector.soap.SOAPConnectorClient.SOAPConnectorClient", (String)"143", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"SOAPConnectorClient - failed", (Object)malformedURLException);
                }
                throw new ConnectorNotAvailableException(malformedURLException);
            }
        }
        return this.url;
    }

    private void setupSslSetting(boolean bl) {
        String string;
        String string2;
        Object object;
        boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupSslSetting", (Object)new Boolean(bl));
        }
        boolean bl3 = bl2 = AdminServiceFactory.getAdminService() != null;
        if ((bl || bl2) && (object = SecurityHelper.getHelper().getSOAPSslSetting()) != null) {
            string2 = ((Properties)object).getProperty("com.ibm.ssl.contextProvider");
            if (string2 != null && string2.equals("IBMJSSEFIPS") && (string = ((Properties)object).getProperty("ssl.SocketFactory.provider")) != null) {
                Security.setProperty("ssl.SocketFactory.provider", string);
            }
            if ((string2 = ((Properties)object).getProperty("com.ibm.ssl.keyStore")) != null) {
                System.setProperty("javax.net.ssl.keyStore", string2);
            }
            if ((string2 = ((Properties)object).getProperty("com.ibm.ssl.trustStore")) != null) {
                System.setProperty("javax.net.ssl.trustStore", string2);
            }
            if ((string2 = ((Properties)object).getProperty("com.ibm.ssl.keyStorePassword")) != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", string2);
            }
            if ((string2 = ((Properties)object).getProperty("com.ibm.ssl.trustStorePassword")) != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", string2);
            }
        }
        if (!bl) {
            String string3;
            object = this.proxyProps.getProperty("javax.net.ssl.trustStore");
            string2 = this.proxyProps.getProperty("javax.net.ssl.keyStore");
            string = this.proxyProps.getProperty("javax.net.ssl.trustStorePassword");
            String string4 = this.proxyProps.getProperty("javax.net.ssl.keyStorePassword");
            String string5 = this.proxyProps.getProperty("com.ibm.ssl.contextProvider");
            if (string5 != null && string5.equals("IBMJSSEFIPS") && (string3 = this.proxyProps.getProperty("ssl.SocketFactory.provider")) != null) {
                Security.setProperty("ssl.SocketFactory.provider", string3);
                this.JSSEFIPSProviderEnabled = true;
            }
            if (object == null) {
                if (System.getProperty("javax.net.ssl.trustStore") == null && this.trustStoreWarning) {
                    this.trustStoreWarning = false;
                    Tr.warning((TraceComponent)tc, (String)"ADMC0037W");
                }
            } else {
                System.setProperty("javax.net.ssl.trustStore", (String)object);
            }
            if (string2 == null) {
                if (System.getProperty("javax.net.ssl.keyStore") == null && this.keyStoreWarning) {
                    this.keyStoreWarning = false;
                    Tr.warning((TraceComponent)tc, (String)"ADMC0038W");
                }
            } else {
                System.setProperty("javax.net.ssl.keyStore", string2);
            }
            if (string != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", string);
            }
            if (string4 != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", string4);
            }
        }
        ContextManagerImpl.registerPackage((String)"com.ibm.net.ssl.internal.www.protocol");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupSslSetting", (Object)new Boolean(bl));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

