/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.mail.MessagingException;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;

public class SOAPResponse
extends HttpResponse {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$soap$SOAPResponse == null ? (class$com$ibm$ws$management$connector$soap$SOAPResponse = SOAPResponse.class$("com.ibm.ws.management.connector.soap.SOAPResponse")) : class$com$ibm$ws$management$connector$soap$SOAPResponse), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    public static int SC_OK = 200;
    public static int SC_INTERNAL_SERVER_ERROR = 500;
    static /* synthetic */ Class class$com$ibm$ws$management$connector$soap$SOAPResponse;

    public SOAPResponse(SOAPConnection sOAPConnection) {
        super((HttpConnection)sOAPConnection);
    }

    public void setContentType(String string) {
        this.addHeader("Content-Type", string);
    }

    public void setContentLength(String string) {
        this.addHeader("Content-Length", string);
    }

    public void writeSOAPResponse(Response response, SOAPContext sOAPContext, SOAPMappingRegistry sOAPMappingRegistry, int n) throws IOException, HttpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSOAPResponse");
        }
        StringWriter stringWriter = null;
        try {
            Envelope envelope = response.buildEnvelope();
            stringWriter = new StringWriter();
            envelope.marshall(stringWriter, sOAPMappingRegistry, sOAPContext);
            sOAPContext.setRootPart(stringWriter.toString(), "text/xml;charset=utf-8");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the generated soap response envelop is ", (Object)stringWriter.toString());
            }
            TransportMessage transportMessage = new TransportMessage(null, sOAPContext, null);
            transportMessage.editOutgoing(null);
            transportMessage.save();
            this.setStatus(n);
            this.setContentType(transportMessage.getContentType());
            Enumeration enumeration = transportMessage.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addHeader(string, transportMessage.getHeader(string));
            }
            this.setContentLength(new Integer(transportMessage.getContentLength()).toString());
            transportMessage.writeTo(this.getOutputStream());
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"105", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSOAPResponse - exception", (Object)((Object)messagingException));
            }
            throw new HttpException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"109", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSOAPResponse - exception", (Object)illegalArgumentException);
            }
            throw new HttpException();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.management.connector.soap.SoapResponse.writeSoapResponse", (String)"113", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSOAPResponse - exception", (Object)sOAPException);
            }
            throw new HttpException();
        }
        finally {
            if (stringWriter != null) {
                stringWriter.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSOAPResponse");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

