/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;

public class SOAPUtils {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$connector$soap$SOAPUtils == null ? (class$com$ibm$ws$management$connector$soap$SOAPUtils = SOAPUtils.class$("com.ibm.ws.management.connector.soap.SOAPUtils")) : class$com$ibm$ws$management$connector$soap$SOAPUtils), (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    public static final QName targetExceptionType = new QName("admin", "TargetExceptionType");
    public static final QName targetExceptionMessage = new QName("admin", "TargetExceptionMessage");
    public static final QName securityEnabled = new QName("admin", "SecurityEnabled");
    public static final String adminServiceURI = "urn:AdminService";
    static /* synthetic */ Class class$com$ibm$ws$management$connector$soap$SOAPUtils;

    public static Call extractSoapCall(InputStream inputStream, int n, String string, SOAPContext sOAPContext, SOAPMappingRegistry sOAPMappingRegistry) throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractCall");
        }
        Call call = null;
        try {
            DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
            Envelope envelope = ServerUtils.readEnvelopeFromInputStream(documentBuilder, inputStream, n, string, null, sOAPContext);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Incoming Soap Envelope: " + envelope));
            }
            Body body = envelope.getBody();
            Vector vector = body.getBodyEntries();
            Element element = (Element)vector.elementAt(0);
            String string2 = envelope.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string3 = body.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string4 = string3 != null ? string3 : string2;
            String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
            String string6 = string5 != null ? string5 : string4;
            String string7 = element.getLocalName();
            String string8 = element.getNamespaceURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI=" + string8 + " method=" + string7));
            }
            Element element2 = DOMUtils.getFirstChildElement(element);
            Vector<Parameter> vector2 = null;
            if (element2 != null) {
                vector2 = new Vector<Parameter>();
                while (element2 != null) {
                    String string9 = DOMUtils.getAttributeNS(element2, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                    String string10 = string9 != null ? string9 : string6;
                    Bean bean = sOAPMappingRegistry.unmarshall(string10, RPCConstants.Q_ELEM_PARAMETER, element2, sOAPContext);
                    Parameter parameter = (Parameter)bean.value;
                    if (string9 != null) {
                        parameter.setEncodingStyleURI(string9);
                    }
                    vector2.addElement(parameter);
                    element2 = DOMUtils.getNextSiblingElement(element2);
                }
            }
            call = new Call(string8, string7, vector2, null, string5, sOAPContext);
            call.setSOAPMappingRegistry(sOAPMappingRegistry);
            call.setHeader(envelope.getHeader());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unmarshalled RPC call is " + call));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.connector.soap.SoapUtils.extractSoapCall", (String)"157");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unable to extract the SOAP Call", (Object)exception);
            }
            SOAPException sOAPException = new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception", nls.getString("ADMC0011E", "The Soap RPC call can't be unmarshalled"), exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"extractCall");
            }
            throw sOAPException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractCall");
        }
        return call;
    }

    /*
     * Loose catch block
     */
    public static String convertObjectToString(Object object) throws IllegalArgumentException {
        byte[] byArray;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"convertObjectToString");
            }
            ObjectOutputStream objectOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
            Object var5_5 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertObjectToString", (String)"219");
            }
            break block12;
            {
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertObjectToString", (String)"187");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"failed to convert object to string", (Object)iOException);
                    }
                    throw new IllegalArgumentException(iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertObjectToString", (String)"219");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertObjectToString");
        }
        return Base64.encode(byArray);
    }

    /*
     * Loose catch block
     */
    public static Object convertStringToObject(String string) throws IllegalArgumentException {
        Object object;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"convertStringToObject");
            }
            ObjectInputStream objectInputStream = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(string));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            Object var5_6 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertStringToObject", (String)"269");
            }
            break block14;
            {
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertStringToObject", (String)"248");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"failed to convert string to object", (Object)iOException);
                    }
                    throw new IllegalArgumentException(iOException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertStringToObject", (String)"257");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no class definition for to-be-serialized object", (Object)classNotFoundException);
                    }
                    throw new IllegalArgumentException(classNotFoundException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.connector.soap.SoapUtils.convertStringToObject", (String)"269");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertStringToObject");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

