/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deploymentmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.util.Utils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class DeploymentManager
extends RuntimeCollaborator
implements NotificationListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$deploymentmanager$DeploymentManager == null ? (class$com$ibm$ws$management$deploymentmanager$DeploymentManager = DeploymentManager.class$("com.ibm.ws.management.deploymentmanager.DeploymentManager")) : class$com$ibm$ws$management$deploymentmanager$DeploymentManager), (String)"Admin", (String)"com.ibm.ws.management.resources.adminservice");
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer NODEAGENT_LISTENER = new Integer(1);
    private static long ntfySeqNum = 0L;
    private MBeanFactory mbeanFactory;
    private String cellName;
    private String repositoryRootURI;
    private Set stoppingNodeAgents = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$com$ibm$ws$management$deploymentmanager$DeploymentManager;

    public DeploymentManager(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)new Object[]{string, string2});
        }
        this.cellName = string2;
        this.repositoryRootURI = string;
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            this.mbeanFactory.activateMBean("DeploymentManager", this, "DeploymentManager", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.DeploymentManager", (String)"77", (Object)this);
        }
        this.registerToDiscoveryMBean();
        this.listenForJ2EEStateStoppingNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"bindMBean");
        }
        super.bindMBean(modelMBeanInfo, modelMBean);
        if (modelMBeanInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"info:", (Object)modelMBeanInfo);
            }
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"mBeanDescriptor", (Object)descriptor);
            }
            String string = "DeploymentManager";
            descriptor.setField("displayName", string);
            String string2 = (String)descriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("type:" + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindMBean");
        }
    }

    public Set restartActiveNodes(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restartActiveNodes");
        }
        HashSet<String> hashSet = new HashSet<String>();
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.restartActiveNodes", (String)"153", (Object)this);
        }
        Set set = adminService.queryNames(objectName, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            String string = ObjectNameHelper.getNodeName(objectName);
            Tr.audit((TraceComponent)tc, (String)"ADMN0026I", (Object)new Object[]{string, bl});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"nodeagent object name", (Object)objectName);
            }
            Object[] objectArray = new Object[]{bl, bl2};
            String[] stringArray = new String[]{bl.getClass().getName(), bl2.getClass().getName()};
            boolean bl3 = true;
            try {
                adminService.invoke(objectName, "restart", objectArray, stringArray);
            }
            catch (Exception exception) {
                Exception exception2;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.restartActiveNodes", (String)"143", (Object)this);
                if (exception instanceof MBeanException) {
                    exception2 = ((MBeanException)exception).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed to invoke ripple on node", (Object)new Object[]{string, bl});
                }
                Tr.warning((TraceComponent)tc, (String)"ADMN0030W", (Object)new Object[]{string, exception2.getMessage()});
                bl3 = false;
            }
            if (!bl3) continue;
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restartActiveNodes");
        }
        return hashSet;
    }

    public Set syncActiveNodes(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"syncActiveNodes");
        }
        HashSet<String> hashSet = new HashSet<String>();
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeSync");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.syncActiveNodes", (String)"153", (Object)this);
        }
        Set set = adminService.queryNames(objectName, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            String string = ObjectNameHelper.getNodeName(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"nodeagent object name", (Object)objectName);
            }
            boolean bl2 = true;
            try {
                if (bl.booleanValue()) {
                    adminService.invoke(objectName, "sync", null, null);
                } else {
                    adminService.invoke(objectName, "requestSync", null, null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.syncActiveNodes", (String)"143", (Object)this);
                if (exception instanceof MBeanException) {
                    Exception exception2 = ((MBeanException)exception).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed to do file sync on node", (Object)new Object[]{string, bl});
                }
                bl2 = false;
            }
            if (!bl2) continue;
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"syncActiveNodes");
        }
        return hashSet;
    }

    public void stopNodeAgent(String string) throws Exception {
        AdminClient adminClient;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopNodeAgent");
        }
        if ((adminClient = RoutingTable.getInstance().getAdminClient(string)) == null) {
            throw new AdminException("no entry found in the routing table for node:" + string);
        }
        ObjectName objectName = adminClient.getServerMBean();
        adminClient.invoke(objectName, "stop", null, null);
        RoutingTable.getInstance().removeChild(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopNodeAgent");
        }
    }

    public void stopNode(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopNode");
        }
        ObjectName objectName = null;
        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
        if (adminClient == null) {
            throw new AdminException("no entry found in the routing table for node:" + string);
        }
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.stopNode", (String)"305", (Object)this);
        }
        Set set = adminClient.queryNames(objectName, null);
        ObjectName objectName2 = objectName = set.iterator().hasNext() ? (ObjectName)set.iterator().next() : null;
        if (objectName == null) {
            throw new AdminException("no NodeAgent mbean found at node: " + string);
        }
        adminClient.invoke(objectName, "stopNode", null, null);
        RoutingTable.getInstance().removeChild(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopNode");
        }
    }

    private void registerToDiscoveryMBean() {
        block2: {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = "WebSphere:type=Discovery,process=" + adminService.getProcessName() + ",*";
                ObjectName objectName = new ObjectName(string);
                Set set = adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                adminService.addNotificationListener(objectName, this, null, DISCOVERY_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.registerToDiscoveryMBean", (String)"358", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"can not register as a listener to DiscoveryMBean", (Object)jMException);
            }
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, NODEAGENT_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.listenForJ2EEStateStoppingNotifications", (String)"373", (Object)this);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification");
        }
        Notification notification2 = null;
        String string = notification.getType();
        if (object.equals(DISCOVERY_LISTENER)) {
            if (string.equals("websphere.discovery.process.found")) {
                notification2 = new Notification("websphere.process.running", this.getObjectName(), ntfySeqNum++);
                notification2.setUserData(notification.getUserData());
                this.checkRemoteClock((Properties)notification.getUserData());
            } else if (string.equals("websphere.discovery.process.lost")) {
                serializable = (Properties)notification.getUserData();
                NodeAgentInfo nodeAgentInfo = new NodeAgentInfo(((Properties)serializable).getProperty("nodeName"), ((Properties)serializable).getProperty("processName"));
                String string2 = "websphere.process.failed";
                if (this.stoppingNodeAgents.remove(nodeAgentInfo)) {
                    string2 = "websphere.process.stopped";
                }
                notification2 = new Notification(string2, this.getObjectName(), ntfySeqNum++);
                notification2.setUserData(serializable);
            }
        } else if (object.equals(NODEAGENT_LISTENER) && string.equals("j2ee.state.stopping")) {
            notification2 = new Notification("websphere.process.stopping", this.getObjectName(), ntfySeqNum++);
            serializable = (ObjectName)notification.getSource();
            NodeAgentInfo nodeAgentInfo = new NodeAgentInfo(((ObjectName)serializable).getKeyProperty("node"), ((ObjectName)serializable).getKeyProperty("name"));
            this.stoppingNodeAgents.add(nodeAgentInfo);
            Properties properties = new Properties();
            properties.setProperty("processName", nodeAgentInfo.getServerName());
            properties.setProperty("nodeName", nodeAgentInfo.getNodeName());
            notification2.setUserData(properties);
        }
        if (notification2 != null) {
            try {
                this.sendNotification(notification2);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.handleNotification", (String)"411", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    private void checkRemoteClock(Properties properties) {
        try {
            String string = properties.getProperty("nodeName");
            String string2 = properties.getProperty("processName");
            ObjectName objectName = null;
            AdminService adminService = AdminServiceFactory.getAdminService();
            Set set = adminService.queryNames(new ObjectName(":*,type=JVM,node=" + string + ",process=" + string2), null);
            if (!set.isEmpty()) {
                objectName = (ObjectName)set.iterator().next();
                if (!objectName.getKeyProperty("version").equals("5.0") && !Utils.isClockInSync(null, objectName)) {
                    Tr.warning((TraceComponent)tc, (String)"ADMN0035W", (Object)string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JVM MBean not found for nodeagent on " + string));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.checkRemoteClock", (String)"465", (Object)this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class NodeAgentInfo {
        private String nodeName;
        private String serverName;

        NodeAgentInfo(String string, String string2) {
            this.nodeName = string;
            this.serverName = string2;
        }

        String getNodeName() {
            return this.nodeName;
        }

        String getServerName() {
            return this.serverName;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                NodeAgentInfo nodeAgentInfo = (NodeAgentInfo)object;
                return this.nodeName.equals(nodeAgentInfo.getNodeName()) && this.serverName.equals(nodeAgentInfo.getServerName());
            }
            return false;
        }

        public int hashCode() {
            return this.nodeName.hashCode() + this.serverName.hashCode();
        }
    }
}

