/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.descriptor.DescriptorExtensions;
import com.ibm.ws.management.descriptor.StandardDescriptorFieldName;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class MBeanDescriptorLoader
extends DefaultHandler
implements StandardDescriptorFieldName,
DescriptorExtensions {
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.management.descriptor.validateDescriptors";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resource.adminservice");
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$descriptor$MBeanDescriptorLoader == null ? (class$com$ibm$ws$management$descriptor$MBeanDescriptorLoader = MBeanDescriptorLoader.class$("com.ibm.ws.management.descriptor.MBeanDescriptorLoader")) : class$com$ibm$ws$management$descriptor$MBeanDescriptorLoader), (String)"MBeanFactory", (String)"com.ibm.ws.management.resources.adminservice");
    private ModelMBeanInfo info = null;
    private String description = null;
    private Descriptor mbeanDescriptor = null;
    private List parentTypes = new ArrayList();
    private List attributes = new ArrayList();
    private List operations = new ArrayList();
    private List notifications = new ArrayList();
    private List constructors = new ArrayList();
    private Stack contextStack = new Stack();
    private Stack currentElement = new Stack();
    private StringBuffer characters = new StringBuffer();
    private Locator locator = null;
    static /* synthetic */ Class class$com$ibm$ws$management$descriptor$MBeanDescriptorLoader;

    public ModelMBeanInfo loadDescriptor(InputStream inputStream, String string) throws DescriptorParseException {
        ModelMBeanInfo modelMBeanInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadDescriptor", (Object)string);
        }
        try {
            XMLReader xMLReader = ParserFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            boolean bl = Boolean.getBoolean(VALIDATE_DESCRIPTOR_PROPERTY);
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            xMLReader.setEntityResolver(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            xMLReader.parse(inputSource);
            modelMBeanInfo = this.getModelMBeanInfo();
        }
        catch (Exception exception) {
            Exception exception2;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.loadDescriptor", (String)"97", (Object)this);
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            DescriptorParseException descriptorParseException = new DescriptorParseException(exception2, string);
            Tr.warning((TraceComponent)tc, (String)"ADMN0001W", (Object)((Object)descriptorParseException));
            throw descriptorParseException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadDescriptor", (Object)modelMBeanInfo);
        }
        return modelMBeanInfo;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolveEntity", (Object)string2);
        }
        InputSource inputSource = null;
        try {
            if (string2.endsWith("MbeanDescriptor.dtd")) {
                string2 = "xml/MbeanDescriptor.dtd";
                InputStream inputStream = this.getClass().getResourceAsStream(string2);
                inputSource = new InputSource(inputStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.resolveEntity", (String)"126", (Object)this);
            throw new SAXException(nls.getFormattedMessage("ADMN0003E", new Object[]{string2}, null), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resovleEntity", inputSource);
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"error", (Object)sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endDocument");
        }
        this.loadParentTypes();
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("name", "jmx.attribute.changed");
        descriptorSupport.setField("messageID", "notification.attribute.changed");
        descriptorSupport.setField("visibility", new Integer(3));
        ModelMBeanNotificationInfo modelMBeanNotificationInfo = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.changed"}, "jmx.attribute.changed", null, descriptorSupport);
        this.addFeatureInfo(this.notifications, modelMBeanNotificationInfo, true);
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[this.attributes.size()];
        this.attributes.toArray(modelMBeanAttributeInfoArray);
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[this.constructors.size()];
        this.constructors.toArray(modelMBeanConstructorInfoArray);
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[this.operations.size()];
        this.operations.toArray(modelMBeanOperationInfoArray);
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[this.notifications.size()];
        this.notifications.toArray(modelMBeanNotificationInfoArray);
        this.info = new ModelMBeanInfoSupport("javax.management.modelmbean.RequiredModelMBean", this.description, modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray, this.mbeanDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endDocument", (Object)this.mbeanDescriptor);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startElement", (Object)string2);
        }
        this.currentElement.push(string2);
        if (string2.equals("MBean")) {
            this.parseMBeanInfo(attributes);
        } else if (string2.equals("attribute")) {
            this.addFeatureInfo(this.attributes, this.parseAttributeInfo(attributes), true);
        } else if (string2.equals("operation")) {
            this.parseOperationInfo(attributes);
        } else if (string2.equals("notification")) {
            this.parseNotificationInfo(attributes);
        } else if (string2.equals("parameter")) {
            this.pushContext(this.parseParameterInfo(attributes));
        } else if (string2.equals("parentType")) {
            this.pushContext(this.parseParentType(attributes));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endElement", (Object)string2);
        }
        try {
            if (string2.equals("operation")) {
                MBeanParameterInfo[] mBeanParameterInfoArray = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"signature", (Object)mBeanParameterInfoArray);
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"opDescriptor", (Object)descriptor);
                }
                int n = (Integer)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("impact," + n));
                }
                String string4 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"type", (Object)string4);
                }
                String string5 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"description", (Object)string5);
                }
                String string6 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"name", (Object)string6);
                }
                ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(string6, string5, mBeanParameterInfoArray, string4, n, descriptor);
                this.addFeatureInfo(this.operations, modelMBeanOperationInfo, true);
            } else if (string2.equals("constructor")) {
                MBeanParameterInfo[] mBeanParameterInfoArray = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"signature", (Object)mBeanParameterInfoArray);
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"descriptor", (Object)descriptor);
                }
                String string7 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"description", (Object)string7);
                }
                String string8 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"name", (Object)string8);
                }
                ModelMBeanConstructorInfo modelMBeanConstructorInfo = new ModelMBeanConstructorInfo(string8, string7, mBeanParameterInfoArray, descriptor);
                this.addFeatureInfo(this.constructors, modelMBeanConstructorInfo, true);
            } else if (string2.equals("notification")) {
                int n = this.findSameType("notificationType");
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)this.popupContext().value;
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"descriptor", (Object)descriptor);
                }
                String string9 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"description", (Object)string9);
                }
                String string10 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"name", (Object)string10);
                }
                ModelMBeanNotificationInfo modelMBeanNotificationInfo = new ModelMBeanNotificationInfo(stringArray, string10, string9, descriptor);
                this.addFeatureInfo(this.notifications, modelMBeanNotificationInfo, true);
            } else if (string2.equals("signature")) {
                int n = this.findSameType("parameter");
                MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[n];
                for (int i = mBeanParameterInfoArray.length - 1; i >= 0; --i) {
                    mBeanParameterInfoArray[i] = (MBeanParameterInfo)this.popupContext().value;
                }
                this.pushContext(mBeanParameterInfoArray);
            }
            Object var12_26 = null;
            if (this.characters.length() > 0) {
                String string11 = this.characters.toString();
                if ((string11 = string11.trim()).length() > 0) {
                    this.pushContext(string11);
                }
                this.characters.setLength(0);
            }
            this.currentElement.pop();
        }
        catch (Throwable throwable) {
            Object var12_27 = null;
            if (this.characters.length() > 0) {
                String string12 = this.characters.toString();
                if ((string12 = string12.trim()).length() > 0) {
                    this.pushContext(string12);
                }
                this.characters.setLength(0);
            }
            this.currentElement.pop();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endElement");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.characters.append(cArray, n, n2);
    }

    private void loadParentTypes() {
        int n = this.findSameType("parentType");
        for (int i = 0; i < n; ++i) {
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)this.popupContext().value;
            this.attributes.addAll(Arrays.asList(modelMBeanInfo.getAttributes()));
            this.operations.addAll(Arrays.asList(modelMBeanInfo.getOperations()));
            this.notifications.addAll(Arrays.asList(modelMBeanInfo.getNotifications()));
        }
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.info;
    }

    private void parseMBeanInfo(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseMBeanInfo", (Object)attributes);
        }
        this.mbeanDescriptor = new DescriptorSupport();
        this.mbeanDescriptor.setField("name", "Dummy_Name");
        this.mbeanDescriptor.setField("descriptorType", "mbean");
        this.mbeanDescriptor.setField("currencyTimeLimit", "0");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attrName:", (Object)string);
            }
            String string2 = attributes.getValue(i);
            if (string.equals("description")) {
                this.description = string2;
                continue;
            }
            this.setDescriptorFields(string, string2, this.mbeanDescriptor);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseMBeanInfo", (Object)this.mbeanDescriptor);
        }
    }

    private ModelMBeanAttributeInfo parseAttributeInfo(Attributes attributes) throws SAXException {
        Cloneable cloneable;
        MBeanParameterInfo[] mBeanParameterInfoArray;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseAttributeInfo", (Object)attributes);
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("descriptorType", "attribute");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attrName:", (Object)string5);
            }
            string = attributes.getValue(i);
            if (string5.equals("name")) {
                string3 = string;
                continue;
            }
            if (string5.equals("type")) {
                string4 = string;
                continue;
            }
            if (string5.equals("description")) {
                string2 = string;
                continue;
            }
            this.setDescriptorFields(string5, string, descriptorSupport);
        }
        descriptorSupport.setField("name", string3);
        String string6 = (String)descriptorSupport.getFieldValue("getMethod");
        boolean bl = string6 != null && string6.length() > 0;
        string = (String)descriptorSupport.getFieldValue("setMethod");
        boolean bl2 = string != null && string.length() > 0;
        boolean bl3 = false;
        if (bl) {
            int n = string6.lastIndexOf(46) + 1;
            int n2 = string6.indexOf(40);
            if (n2 == -1) {
                n2 = string6.length();
            }
            mBeanParameterInfoArray = string6.substring(n, n2);
            if (string4.equals("java.lang.Boolean") && mBeanParameterInfoArray.startsWith("is")) {
                bl3 = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"attrDescriptor", (Object)descriptorSupport);
        }
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = new ModelMBeanAttributeInfo(string3, string4, string2, bl, bl2, bl3, descriptorSupport);
        if (bl) {
            String string7 = "getter for attribute " + string3;
            mBeanParameterInfoArray = new DescriptorSupport();
            mBeanParameterInfoArray.setField("name", string6);
            mBeanParameterInfoArray.setField("descriptorType", "operation");
            mBeanParameterInfoArray.setField("role", "getter");
            mBeanParameterInfoArray.setField("targetObjectType", "objectReference");
            cloneable = new ModelMBeanOperationInfo(string6, string7, new MBeanParameterInfo[0], string4, 2, (Descriptor)mBeanParameterInfoArray);
            this.addFeatureInfo(this.operations, (MBeanFeatureInfo)((Object)cloneable), true);
        }
        if (bl2) {
            String string8 = "setter for attribute " + string3;
            mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo(string3, string4, "setter for attribute")};
            cloneable = new DescriptorSupport();
            cloneable.setField("name", string);
            cloneable.setField("descriptorType", "operation");
            cloneable.setField("role", "setter");
            cloneable.setField("targetObjectType", "objectReference");
            ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(string, string8, mBeanParameterInfoArray, "void", 1, (Descriptor)cloneable);
            this.addFeatureInfo(this.operations, modelMBeanOperationInfo, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseAttributeInfo", (Object)modelMBeanAttributeInfo);
        }
        return modelMBeanAttributeInfo;
    }

    private void parseConstructorInfo(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseConstructorInfo", (Object)attributes);
        }
        String string = null;
        String string2 = null;
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("descriptorType", "operation");
        descriptorSupport.setField("role", "constructor");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attrName", (Object)string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value", (Object)string4);
            }
            if (string3.equals("name")) {
                string = string4;
                continue;
            }
            if (string3.equals("description")) {
                string2 = string4;
                continue;
            }
            this.setDescriptorFields(string3, string4, descriptorSupport);
        }
        descriptorSupport.setField("name", string);
        this.pushContext(string);
        this.pushContext(string2);
        this.pushContext(descriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseConstructorInfo", (Object)descriptorSupport);
        }
    }

    private void parseOperationInfo(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseOperationInfo");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("descriptorType", "operation");
        descriptorSupport.setField("role", "operation");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getLocalName(i);
            String string5 = attributes.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attrName", (Object)string4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value", (Object)string5);
            }
            if (string4.equals("name")) {
                string = string5;
                continue;
            }
            if (string4.equals("description")) {
                string2 = string5;
                continue;
            }
            if (string4.equals("type")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("impact")) {
                if (string5.compareToIgnoreCase("INFO") == 0) {
                    n = 2;
                    continue;
                }
                if (string5.compareToIgnoreCase("ACTION") == 0) {
                    n = 1;
                    continue;
                }
                if (string5.compareToIgnoreCase("ACTION_INFO") != 0) continue;
                n = 3;
                continue;
            }
            this.setDescriptorFields(string4, string5, descriptorSupport);
        }
        descriptorSupport.setField("name", string);
        this.pushContext(string);
        this.pushContext(string2);
        this.pushContext(string3);
        this.pushContext(new Integer(n));
        this.pushContext(descriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseOperationInfo");
        }
    }

    private void parseNotificationInfo(Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseNotificationInfo", (Object)attributes);
        }
        String string = null;
        String string2 = null;
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("descriptorType", "notification");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            if (string3.equals("name")) {
                string2 = string4;
                continue;
            }
            if (string3.equals("description")) {
                string = string4;
                continue;
            }
            this.setDescriptorFields(string3, string4, descriptorSupport);
        }
        descriptorSupport.setField("name", string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"notifDescriptor", (Object)descriptorSupport);
        }
        this.pushContext(string2);
        this.pushContext(string);
        this.pushContext(descriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseNotificationInfo");
        }
    }

    private MBeanParameterInfo parseParameterInfo(Attributes attributes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseParameterInfo", (Object)attributes);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes.getLocalName(i);
            String string5 = attributes.getValue(i);
            if (string4.equals("name")) {
                string2 = string5;
                continue;
            }
            if (string4.equals("type")) {
                string = string5;
                continue;
            }
            if (!string4.equals("description")) continue;
            string3 = string5;
        }
        MBeanParameterInfo mBeanParameterInfo = new MBeanParameterInfo(string2, string, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseParameterInfo", (Object)mBeanParameterInfo);
        }
        return mBeanParameterInfo;
    }

    private ModelMBeanInfo parseParentType(Attributes attributes) throws SAXException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseParentType", (Object)attributes);
        }
        String string = null;
        String string2 = null;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            object = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            if (((String)object).equals("type")) {
                string = string3;
                continue;
            }
            if (!((String)object).equals("descriptorFile")) continue;
            string2 = string3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"type", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"descriptorFile", string2);
        }
        MBeanFactoryImpl mBeanFactoryImpl = (MBeanFactoryImpl)AdminServiceFactory.getMBeanFactory();
        try {
            object = mBeanFactoryImpl.getDescriptorManager().getDescriptor(string, string2);
        }
        catch (DescriptorParseException descriptorParseException) {
            FFDCFilter.processException((Throwable)((Object)descriptorParseException), (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.parseParentType", (String)"608", (Object)this);
            throw new SAXException(nls.getFormattedMessage("ADMN0004E", new Object[]{string}, null), (Exception)((Object)descriptorParseException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseParentType", (Object)object);
        }
        return object;
    }

    private void setDescriptorFields(String string, String string2, Descriptor descriptor) throws SAXException {
        if (string.equals("collaboratorClass")) {
            descriptor.setField("collaboratorClass", string2);
        } else if (string.equals("type")) {
            descriptor.setField("type", string2);
        } else if (string.equals("class")) {
            descriptor.setField("class", string2);
        } else if (string.equals("targetObjectType")) {
            descriptor.setField("targetObjectType", string2);
        } else if (string.equals("default")) {
            descriptor.setField("default", string2);
        } else if (string.equals("displayName")) {
            descriptor.setField("displayName", string2);
        } else if (string.equals("getMethod")) {
            descriptor.setField("getMethod", string2);
        } else if (string.equals("setMethod")) {
            descriptor.setField("setMethod", string2);
        } else if (string.equals("role")) {
            if (!string2.equalsIgnoreCase("setter") && !string2.equalsIgnoreCase("getter")) {
                string2 = "operation";
            }
            descriptor.setField("role", string2);
        } else if (string.equals("protocolMap")) {
            descriptor.setField("protocolMap", string2);
        } else if (string.equals("persistPolicy")) {
            descriptor.setField("persistPolicy", string2);
        } else if (string.equals("persistPeriod")) {
            descriptor.setField("persistPeriod", string2);
        } else if (string.equals("currencyTimeLimit")) {
            descriptor.setField("currencyTimeLimit", string2);
        } else if (string.equals("iterable")) {
            if (string2.equals("true")) {
                descriptor.setField("iterable", Boolean.TRUE);
            } else {
                descriptor.setField("iterable", Boolean.FALSE);
            }
        } else if (string.equals("visibility")) {
            Integer n = null;
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorLoader.setDescriptorFields", (String)"673", (Object)this);
            }
            if (n == null || n < 1 || n > 4) {
                throw new SAXParseException(nls.getFormattedMessage("ADMN0002E", new Object[]{string2}, null), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
        } else if (string.equals("presentationString")) {
            descriptor.setField("presentationString", string2);
        } else if (string.equals("severity")) {
            descriptor.setField("severity", string2);
        } else if (string.equals("messageId")) {
            descriptor.setField("messageId", string2);
        } else if (string.equals("useLog")) {
            descriptor.setField("log", string2);
        } else if (string.equals("version")) {
            descriptor.setField("version", string2);
        } else if (string.equals("platform")) {
            descriptor.setField("platform", string2);
        } else if (string.equals("logFile")) {
            descriptor.setField("logFile", string2);
        } else if (string.equals("configureMBean")) {
            if (string2.equals("true")) {
                descriptor.setField("configureMBean", Boolean.TRUE);
            } else {
                descriptor.setField("configureMBean", Boolean.FALSE);
            }
        } else if (string.equals("deprecated")) {
            descriptor.setField("deprecated", string2);
        }
    }

    private int findSameType(String string) {
        int n = this.contextStack.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            ContextElement contextElement = (ContextElement)this.contextStack.get(n);
            if (!string.equals(contextElement.elementName)) break;
            --n;
            ++n2;
        }
        return n2;
    }

    private void pushContext(Object object) {
        ContextElement contextElement = new ContextElement((String)this.currentElement.peek(), object);
        this.contextStack.push(contextElement);
    }

    private ContextElement popupContext() {
        ContextElement contextElement = (ContextElement)this.contextStack.pop();
        return contextElement;
    }

    private boolean addFeatureInfo(List list, MBeanFeatureInfo mBeanFeatureInfo, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addFeatureInfo", (Object)mBeanFeatureInfo);
        }
        boolean bl2 = false;
        String string = mBeanFeatureInfo.getName();
        for (int i = 0; i < list.size(); ++i) {
            MBeanFeatureInfo mBeanFeatureInfo2 = (MBeanFeatureInfo)list.get(i);
            bl2 = mBeanFeatureInfo2.getName().equals(string);
            if (bl2 && mBeanFeatureInfo instanceof MBeanOperationInfo) {
                MBeanParameterInfo[] mBeanParameterInfoArray;
                MBeanParameterInfo[] mBeanParameterInfoArray2 = ((MBeanOperationInfo)mBeanFeatureInfo2).getSignature();
                bl2 = mBeanParameterInfoArray2.length == (mBeanParameterInfoArray = ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()).length;
                for (int j = 0; bl2 && j < mBeanParameterInfoArray.length; ++j) {
                    if (mBeanParameterInfoArray2[j].getType().equals(mBeanParameterInfoArray[j].getType())) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            if (!bl) break;
            list.set(i, mBeanFeatureInfo);
            break;
        }
        if (!bl2) {
            list.add(mBeanFeatureInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addFeatureInfo," + bl2));
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ContextElement {
        public String elementName;
        public Object value;

        public ContextElement(String string, Object object) {
            this.elementName = string;
            this.value = object;
        }

        public String toString() {
            return "elementName:" + this.elementName + ",value:" + this.value;
        }
    }
}

