/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.descriptor.MBeanDescriptorLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.xml.sax.InputSource;

public class MBeanDescriptorManager {
    private static String resourceBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)resourceBundleName);
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$descriptor$MBeanDescriptorManager == null ? (class$com$ibm$ws$management$descriptor$MBeanDescriptorManager = MBeanDescriptorManager.class$("com.ibm.ws.management.descriptor.MBeanDescriptorManager")) : class$com$ibm$ws$management$descriptor$MBeanDescriptorManager), (String)"MBeanFactory", (String)resourceBundleName);
    private DescriptorClassLoader descriptorClassLoader;
    private HashMap infoCache = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$management$descriptor$MBeanDescriptorManager;

    public MBeanDescriptorManager() {
        this.descriptorClassLoader = new DescriptorClassLoader();
    }

    public synchronized ModelMBeanInfo getDescriptor(String string, String string2) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDescriptor", (Object)string);
        }
        ModelMBeanInfo modelMBeanInfo = null;
        Object v = this.infoCache.get(string);
        if (v == null) {
            modelMBeanInfo = this.loadDescriptorFile(string, string2);
            this.infoCache.put(string, modelMBeanInfo);
        } else {
            modelMBeanInfo = (ModelMBeanInfo)v;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDescriptor", (Object)modelMBeanInfo);
        }
        return new ModelMBeanInfoSupport(modelMBeanInfo);
    }

    public InputSource loadMBeanDescriptorFile(String string, String string2) {
        Object object;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadMBeanDescriptorFile", (Object)new Object[]{string, string2});
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = "com/ibm/ws/management/descriptor/xml/" + string + ".xml";
        }
        if ((inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string3)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"can not find the system descriptor file", (Object)string3);
            }
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"consult the MBeanExtension for descriptor file");
                }
                object = AdminInitializer.getInstance().getMBeanExtensions();
                string3 = ((MBeanExtensions)object).getDescriptorUri(string);
                List list = ((MBeanExtensions)object).getClasspath(string);
                if (string3 != null) {
                    String[] stringArray = list.toArray(new String[0]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.descriptorClassLoader.addPath(stringArray[i]);
                    }
                    inputStream = this.descriptorClassLoader.getResourceAsStream(string3);
                }
            }
        }
        object = new InputSource(inputStream);
        ((InputSource)object).setSystemId(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadMBeanDescriptorFile", (Object)object);
        }
        return object;
    }

    public InputSource loadSecurityDescriptorFile(String string, String string2) {
        Object object;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadSecurityDescriptorFile", (Object)new Object[]{string, string2});
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = "com/ibm/ws/management/descriptor/xml/" + string + "Security.xml";
        }
        if ((inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string3)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"can not find the system descriptor file", (Object)string3);
            }
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"consult the MBeanExtension for descriptor file");
                }
                object = AdminInitializer.getInstance().getMBeanExtensions();
                string3 = ((MBeanExtensions)object).getDescriptorUri(string);
                List list = ((MBeanExtensions)object).getClasspath(string);
                if (string3 != null) {
                    string3 = this.toSecurityMBeanDescriptor(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Trying MBeanExtension security descriptor file:" + string3));
                    }
                    String[] stringArray = list.toArray(new String[0]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.descriptorClassLoader.addPath(stringArray[i]);
                    }
                    inputStream = this.descriptorClassLoader.getResourceAsStream(string3);
                }
            }
        }
        object = new InputSource(inputStream);
        ((InputSource)object).setSystemId(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadSecurityDescriptorFile", (Object)object);
        }
        return object;
    }

    private String toSecurityMBeanDescriptor(String string) {
        int n = string.lastIndexOf(".xml");
        string = n == -1 ? string + "Security" : string.substring(0, n) + "Security.xml";
        return string;
    }

    public ModelMBeanInfo loadDescriptorFile(String string, String string2) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadDescriptorFile", (Object)string2);
        }
        InputSource inputSource = this.loadMBeanDescriptorFile(string, string2);
        InputStream inputStream = inputSource.getByteStream();
        String string3 = inputSource.getSystemId();
        if (inputStream == null) {
            throw new DescriptorParseException(new FileNotFoundException(string3), string3);
        }
        MBeanDescriptorLoader mBeanDescriptorLoader = new MBeanDescriptorLoader();
        ModelMBeanInfo modelMBeanInfo = mBeanDescriptorLoader.loadDescriptor(inputStream, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadDescriptorFile", (Object)string3);
        }
        return modelMBeanInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DescriptorClassLoader
    extends URLClassLoader {
        private ArrayList descriptorPath = new ArrayList();

        DescriptorClassLoader() {
            super(new URL[0]);
        }

        public void addPath(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addPath", (Object)string);
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    File file = new File(stringTokenizer.nextToken());
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", (String)"210", (Object)this);
                    }
                    try {
                        URL uRL = file.toURL();
                        if (this.descriptorPath.contains(uRL)) continue;
                        this.descriptorPath.add(uRL);
                        super.addURL(uRL);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", (String)"221", (Object)this);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addPath", (Object)string);
            }
        }
    }
}

