/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class DiscoveryMBean
extends RuntimeCollaborator
implements RoutingListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$DiscoveryMBean == null ? (class$com$ibm$ws$management$discovery$DiscoveryMBean = DiscoveryMBean.class$("com.ibm.ws.management.discovery.DiscoveryMBean")) : class$com$ibm$ws$management$discovery$DiscoveryMBean), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private static long ntfySeqNum = 0L;
    private String childType;
    private String parentType;
    private String myType;
    private ServerInfo parent;
    private ArrayList children = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$DiscoveryMBean;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$ServerInfo;

    public DiscoveryMBean() {
        this.myType = AdminServiceFactory.getAdminService().getProcessType();
        if (this.myType.equals("DeploymentManager")) {
            this.childType = "NodeAgent";
        } else if (this.myType.equals("NodeAgent")) {
            this.childType = "ManagedProcess";
            this.parentType = "DeploymentManager";
        } else if (this.myType.equals("ManagedProcess")) {
            this.parentType = "NodeAgent";
        }
    }

    public ServerInfo getParent() {
        return this.parent;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"childAdded");
        }
        String string = serverInfo.getName();
        String string2 = serverInfo.getPid();
        String string3 = serverInfo.getVersion();
        Notification notification = new Notification("websphere.discovery.process.found", this.getObjectName(), ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string);
        properties.setProperty("nodeName", serverInfo.getNode());
        properties.setProperty("processId", string2);
        properties.setProperty("version", string3);
        notification.setUserData(properties);
        if (this.childType.equals("NodeAgent")) {
            string = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            if (!this.children.contains(string)) {
                this.children.add(string);
            }
        }
        Tr.info((TraceComponent)tc, (String)"ADMD0023I", (Object)new Object[]{string, this.childType, string2});
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.childAdded", (String)"86", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"childAdded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"childRemoved");
        }
        String string = serverInfo.getName();
        Notification notification = new Notification("websphere.discovery.process.lost", this.getObjectName(), ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string);
        properties.setProperty("nodeName", serverInfo.getNode());
        notification.setUserData(properties);
        if (this.childType.equals("NodeAgent")) {
            string = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.remove(string);
        }
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.childRemoved", (String)"115", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"childRemoved");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parentAdded");
        }
        this.parent = serverInfo;
        String string = serverInfo.getName();
        String string2 = RoutingTable.getInstance().getPid(string);
        Notification notification = new Notification("websphere.discovery.agent.found", this.getObjectName(), ntfySeqNum++);
        notification.setUserData(serverInfo);
        Tr.info((TraceComponent)tc, (String)"ADMD0023I", (Object)new Object[]{string, this.parentType, string2});
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.parentAdded", (String)"109", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
    }

    public void query(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"query", (Object)serverInfo);
        }
        String string = serverInfo.getRole();
        if (this.myType.equals("ManagedProcess") && string.equals("NodeAgent")) {
            RoutingTable.getInstance().addParent(serverInfo);
            this.answerDiscovery(serverInfo);
        } else if (this.myType.equals("NodeAgent") && string.equals("ManagedProcess")) {
            RoutingTable.getInstance().addChild(serverInfo);
            this.answerDiscovery(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"query");
        }
    }

    public void respond(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"respond", (Object)serverInfo);
        }
        String string = serverInfo.getRole();
        if (this.myType.equals("NodeAgent")) {
            if (string.equals("ManagedProcess")) {
                RoutingTable.getInstance().addChild(serverInfo);
            }
        } else if (this.myType.equals("ManagedProcess") && string.equals("NodeAgent")) {
            RoutingTable.getInstance().addParent(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"responsd");
        }
    }

    private void answerDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"answerDiscovery");
        }
        AdminClient adminClient = null;
        try {
            adminClient = serverInfo.getAdminClient();
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", (String)"227", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMD0024W", (Object)serverInfo.getName());
        }
        if (adminClient != null) {
            Object object;
            ObjectName objectName = null;
            ObjectName objectName2 = null;
            try {
                object = serverInfo.getName();
                objectName2 = new ObjectName("*:*,type=Discovery,process=" + (String)object);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            try {
                object = adminClient.queryNames(objectName2, null);
                if (object.iterator().hasNext()) {
                    objectName = (ObjectName)object.iterator().next();
                    adminClient.invoke(objectName, "respond", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{(class$com$ibm$ws$management$discovery$ServerInfo == null ? (class$com$ibm$ws$management$discovery$ServerInfo = DiscoveryMBean.class$("com.ibm.ws.management.discovery.ServerInfo")) : class$com$ibm$ws$management$discovery$ServerInfo).getName()});
                } else {
                    Tr.warning((TraceComponent)tc, (String)"ADMD0024W", (Object)serverInfo.getName());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", (String)"259", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ADMD0024W", (Object)serverInfo.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"answerDiscovery");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

