/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.DiscoveryEvent;
import com.ibm.ws.management.discovery.DiscoveryListener;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.exception.DiscardQueryException;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.DiscoveryQueryMsg;
import com.ibm.ws.management.discovery.protocol.DiscoveryResponseMsg;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.management.ObjectName;

public class DiscoveryService
implements QueryHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$DiscoveryService == null ? (class$com$ibm$ws$management$discovery$DiscoveryService = DiscoveryService.class$("com.ibm.ws.management.discovery.DiscoveryService")) : class$com$ibm$ws$management$discovery$DiscoveryService), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private TraceNLS nls;
    private static long querySerialNumber = 1L;
    private static HashSet unresolvableHosts = new HashSet();
    private Endpoint endpoint;
    private PeerAdv advertisement;
    private EndpointAddress serviceAddress;
    private ServerInfo serverInfo;
    private String adminType;
    private String cellName;
    private String nodeName;
    private boolean isNodeAgent;
    Vector discoveryListeners;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$DiscoveryService;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$ServerInfo;

    public DiscoveryService(ServerInfo serverInfo, Endpoint endpoint, PeerAdv peerAdv) {
        Properties properties;
        block8: {
            this.nls = TraceNLS.getTraceNLS((String)bundleName);
            this.isNodeAgent = false;
            this.discoveryListeners = new Vector();
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"DiscoveryService");
            }
            this.serverInfo = serverInfo;
            this.endpoint = endpoint;
            this.advertisement = peerAdv;
            properties = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)properties.get("adminTypeProperty");
            this.cellName = (String)properties.get("cellNameConfigProperty");
            this.nodeName = (String)properties.get("nodeNameConfigProperty");
            try {
                this.serviceAddress = new EndpointAddress(endpoint.getEndpointAddress().getURI() + "DiscoveryService");
            }
            catch (InvalidEndpointAddressException invalidEndpointAddressException) {
                FFDCFilter.processException((Throwable)((Object)invalidEndpointAddressException), (String)"com.ibm.ws.management.discovery.DiscoveryService.DiscoveryService", (String)"61", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"invalide endpoint address", (Object)((Object)invalidEndpointAddressException));
            }
        }
        endpoint.registerHandler("DiscoveryService", this);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getting adminType");
            }
            String string = (String)properties.get("adminTypeProperty");
            this.isNodeAgent = string.equals("NodeAgent");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"can't get adminType", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryService.DiscoveryService", (String)"90", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DiscoveryService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.addElement(discoveryListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.removeElement(discoveryListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long sendQuery(EndpointAddress endpointAddress, ServerInfo serverInfo) {
        long l;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendQuery");
            }
            l = querySerialNumber++;
            boolean bl = true;
            if (endpointAddress != null) {
                Object object;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("End-2-end messaging: queryId: " + l));
                }
                Message message = null;
                try {
                    object = new DiscoveryQueryMsg(0, l, serverInfo, this.advertisement);
                    message = new Message(((DiscoveryQueryMsg)object).getXMLDocument().getInputStream(), this.serviceAddress, endpointAddress);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"message[src, dest]", (Object)new Object[]{this.serviceAddress, endpointAddress});
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"116", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ADMD0007W", (Object)exception.getMessage());
                    l = -1L;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("sendQuery: " + l));
                    }
                    return l;
                }
                object = null;
                try {
                    String string;
                    block29: {
                        try {
                            object = this.endpoint.getMessenger(endpointAddress);
                            if (object == null) break block29;
                            DiscoveryListener[] discoveryListenerArray = this.copyListener();
                            DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, DiscoveryEvent.SENDING, l);
                            for (int i = 0; i < discoveryListenerArray.length; ++i) {
                                discoveryListenerArray[i].event(discoveryEvent);
                            }
                            object.sendMessage(message);
                        }
                        catch (UnknownHostException unknownHostException) {
                            String string2;
                            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"151", (Object)this);
                            l = -1L;
                            bl = false;
                            String string22 = endpointAddress.getProtocolHost();
                            if (!unresolvableHosts.contains(string22)) {
                                unresolvableHosts.add(string22);
                                Tr.warning((TraceComponent)tc, (String)"ADMD0022W", (Object)new Object[]{string22});
                            }
                            Object var13_18 = null;
                            if (bl && unresolvableHosts.contains(string2 = endpointAddress.getProtocolHost())) {
                                unresolvableHosts.remove(string2);
                            }
                            if (object != null) {
                                object.close();
                            }
                            break block30;
                        }
                        catch (IOException iOException) {
                            String string3;
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"165", (Object)this);
                            l = -1L;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"IOExceiption occurs while sending messages", (Object)iOException);
                            }
                            Object var13_19 = null;
                            if (bl && unresolvableHosts.contains(string3 = endpointAddress.getProtocolHost())) {
                                unresolvableHosts.remove(string3);
                            }
                            if (object != null) {
                                object.close();
                            }
                            break block30;
                        }
                        catch (Throwable throwable) {
                            String string4;
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"174", (Object)this);
                            DiscoveryListener[] discoveryListenerArray = this.copyListener();
                            DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, DiscoveryEvent.ROLLBACK, l);
                            for (int i = 0; i < discoveryListenerArray.length; ++i) {
                                discoveryListenerArray[i].event(discoveryEvent);
                            }
                            l = -1L;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"unable to send out the discovery query message", (Object)throwable);
                            }
                            Object var13_20 = null;
                            if (bl && unresolvableHosts.contains(string4 = endpointAddress.getProtocolHost())) {
                                unresolvableHosts.remove(string4);
                            }
                            if (object != null) {
                                object.close();
                            }
                            break block30;
                        }
                    }
                    Object var13_17 = null;
                    if (bl && unresolvableHosts.contains(string = endpointAddress.getProtocolHost())) {
                        unresolvableHosts.remove(string);
                    }
                }
                catch (Throwable throwable) {
                    String string;
                    Object var13_21 = null;
                    if (bl && unresolvableHosts.contains(string = endpointAddress.getProtocolHost())) {
                        unresolvableHosts.remove(string);
                    }
                    if (object != null) {
                        object.close();
                    }
                    throw throwable;
                }
                if (object != null) {
                    object.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendQuery: " + l));
        }
        return l;
    }

    public ProcessQueryStruct processQuery(XMLDocument xMLDocument) throws DiscardQueryException, IOException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processQuery");
        }
        ProcessQueryStruct processQueryStruct = new ProcessQueryStruct();
        DiscoveryQueryMsg discoveryQueryMsg = null;
        DiscoveryResponseMsg discoveryResponseMsg = null;
        try {
            discoveryQueryMsg = new DiscoveryQueryMsg(xMLDocument);
            object2 = discoveryQueryMsg.getPeerAdv();
            String string = Utils.getProductVersion();
            String string2 = ((PeerAdv)object2).getVersion();
            String string3 = ((PeerAdv)object2).getNode();
            object = ((PeerAdv)object2).getRole();
            int n = Utils.compareVersions(string, string2);
            if (this.adminType.equals("DeploymentManager") && n < 0) {
                Tr.error((TraceComponent)tc, (String)"ADMD0026W", (Object)new Object[]{string, string3 + ", " + string2});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string + ") is earlier than that of the nodeagent (" + string2 + ")");
            }
            if (!((String)object).equals("ManagedProcess") && this.adminType.equals("NodeAgent") && n > 0) {
                Tr.error((TraceComponent)tc, (String)"ADMD0026W", (Object)new Object[]{string2, this.nodeName + ", " + string});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string2 + ") is earlier than that of the nodeagent (" + string + ")");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryService.processQuery", (String)"156", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processQuery - can not rebuild the query");
            }
            throw new DiscardQueryException("can not read the query document");
        }
        object2 = discoveryQueryMsg.getServerInfo();
        if (((ServerInfo)object2).match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"role matched", (Object)new Object[]{object2, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processQuery - role not matched", (Object)new Object[]{object2, this.serverInfo});
            }
            throw new DiscardQueryException("role not matched");
        }
        int n = discoveryQueryMsg.getDiscoveryType();
        long l = discoveryQueryMsg.getQueryId();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("query Id = " + l));
        }
        if (l <= 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processQuery: discardQuery");
            }
            throw new DiscardQueryException("No queryId included with the query message");
        }
        object = discoveryQueryMsg.getPeerAdv();
        processQueryStruct.serverName = ((PeerAdv)object).getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("serverName Id = " + processQueryStruct.serverName));
        }
        DiscoveryListener[] discoveryListenerArray = this.copyListener();
        DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, (PeerAdv)object, l, true);
        for (int i = 0; i < discoveryListenerArray.length; ++i) {
            discoveryListenerArray[i].event(discoveryEvent);
        }
        ServerInfo serverInfo = new ServerInfo(((PeerAdv)object).getCell(), ((PeerAdv)object).getNode(), ((PeerAdv)object).getRole());
        discoveryResponseMsg = new DiscoveryResponseMsg(0, l, serverInfo, this.advertisement);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processQuery");
        }
        processQueryStruct.response = discoveryResponseMsg;
        return processQueryStruct;
    }

    public void pushResponse(XMLDocument xMLDocument) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pushResponse");
        }
        DiscoveryResponseMsg discoveryResponseMsg = null;
        try {
            discoveryResponseMsg = new DiscoveryResponseMsg(xMLDocument);
            object2 = discoveryResponseMsg.getResponse();
            String string = Utils.getProductVersion();
            String string2 = ((PeerAdv)object2).getVersion();
            String string3 = ((PeerAdv)object2).getNode();
            object = ((PeerAdv)object2).getRole();
            int n = Utils.compareVersions(string, string2);
            if (this.adminType.equals("DeploymentManager") && n < 0) {
                Tr.error((TraceComponent)tc, (String)"ADMD0026W", (Object)new Object[]{string, string3 + ", " + string2});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string + ") is earlier than that of the nodeagent (" + string2 + ")");
            }
            if (!((String)object).equals("ManagedProcess") && this.adminType.equals("NodeAgent") && n > 0) {
                Tr.error((TraceComponent)tc, (String)"ADMD0026W", (Object)new Object[]{string2, this.nodeName + ", " + string});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string2 + ") is earlier than that of the nodeagent (" + string + ")");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryService.pushResponse", (String)"263", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"pushResponse - failed");
            }
            return;
        }
        object2 = discoveryResponseMsg.getServerInfo();
        if (((ServerInfo)object2).match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"role matched", (Object)new Object[]{object2, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"role not matched", (Object)new Object[]{object2, this.serverInfo});
            }
            return;
        }
        int n = discoveryResponseMsg.getDiscoveryType();
        long l = discoveryResponseMsg.getQueryId();
        object = discoveryResponseMsg.getResponse();
        DiscoveryListener[] discoveryListenerArray = this.copyListener();
        DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, (PeerAdv)object, l, false);
        for (int i = 0; i < discoveryListenerArray.length; ++i) {
            discoveryListenerArray[i].event(discoveryEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void respond(EndpointAddress var1_1, ProcessQueryStruct var2_2) {
        if (DiscoveryService.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)DiscoveryService.tc, (String)"respond");
        }
        var3_3 = var2_2.response;
        var4_4 = var2_2.serverName;
        var5_5 = null;
        try {
            var5_5 = new Message(var3_3.getXMLDocument().getInputStream(), this.serviceAddress, var1_1);
            if (DiscoveryService.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)DiscoveryService.tc, (String)"message[src, dest]", (Object)new Object[]{this.serviceAddress, var1_1});
            }
        }
        catch (Exception var6_6) {
            FFDCFilter.processException((Throwable)var6_6, (String)"com.ibm.ws.management.discovery.DiscoveryService.respond", (String)"256", (Object)this);
            if (DiscoveryService.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)DiscoveryService.tc, (String)"unable to send out the discovery response message", (Object)var6_6);
            }
            Tr.warning((TraceComponent)DiscoveryService.tc, (String)"ADMD0008W", (Object)var6_6.getMessage());
        }
        var6_7 = null;
        try {
            var6_7 = this.endpoint.getMessenger(var1_1);
            var6_7.sendMessage(var5_5);
        }
        catch (IOException var7_8) {
            FFDCFilter.processException((Throwable)var7_8, (String)"com.ibm.ws.management.discovery.DiscoveryService.respond", (String)"266", (Object)this);
            if (DiscoveryService.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)DiscoveryService.tc, (String)"unable to send out the discovery response message", (Object)var7_8);
            }
        }
        finally {
            if (var6_7 != null) {
                var6_7.close();
            }
        }
        var7_9 = var3_3.getRole();
        if (DiscoveryService.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)DiscoveryService.tc, (String)("isNodeAgent: " + this.isNodeAgent + " peerRole: " + var7_9 + " peerServerName: " + var4_4));
        }
        if (this.isNodeAgent && var7_9 != null && var7_9.equals("ManagedProcess") && var4_4 != null) {
            var9_11 = SecurityHelper.getServerSubject();
            if (var9_11 != null) {
                SecurityHelper.pushInvocationSubject(var9_11);
            }
            try {
                if (DiscoveryService.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)DiscoveryService.tc, (String)"Node agent sending discovery response via connector");
                }
                if ((var10_12 = RoutingTable.getInstance().getAdminClient(var4_4)) != null) {
                    var11_14 = new ObjectName("*:*,type=Discovery,process=" + var4_4);
                    var12_15 = var10_12.queryNames(var11_14, null);
                    if (var12_15.iterator().hasNext()) {
                        var13_16 = (ObjectName)var12_15.iterator().next();
                        var10_12.invoke(var13_16, "respond", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{(DiscoveryService.class$com$ibm$ws$management$discovery$ServerInfo == null ? (DiscoveryService.class$com$ibm$ws$management$discovery$ServerInfo = DiscoveryService.class$("com.ibm.ws.management.discovery.ServerInfo")) : DiscoveryService.class$com$ibm$ws$management$discovery$ServerInfo).getName()});
                    }
                    Tr.debug((TraceComponent)DiscoveryService.tc, (String)("unable to get discovery MBean for process " + var4_4));
                }
                if (!DiscoveryService.tc.isDebugEnabled()) ** GOTO lbl66
                Tr.debug((TraceComponent)DiscoveryService.tc, (String)("unable to get connector for process " + var4_4));
            }
            catch (Exception var10_13) {
                if (DiscoveryService.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)DiscoveryService.tc, (String)("failed to send discovery response via connector:" + var10_13));
                }
                FFDCFilter.processException((Throwable)var10_13, (String)"com.ibm.ws.management.discovery.DiscoveryService.respond", (String)"383", (Object)this);
            }
            finally {
                if (var9_11 != null) {
                    SecurityHelper.popInvocationSubject(var9_11);
                }
            }
        } else if (DiscoveryService.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)DiscoveryService.tc, (String)"will not respond via connector.");
        }
lbl66:
        // 8 sources

        if (DiscoveryService.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)DiscoveryService.tc, (String)"respond");
        }
    }

    public void demux(Message message) {
        block21: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"demux");
            }
            XMLDocument xMLDocument = null;
            EndpointAddress endpointAddress = message.getSourceAddress();
            try {
                object = message.getDataInputStream();
                xMLDocument = new XMLDocument((InputStream)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.DiscoveryService.demux", (String)"315", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to create an XML document from the message", (Object)exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"demux");
                }
                return;
            }
            if (xMLDocument == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The discovery document is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"demux");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the incoming discovery message is: ", (Object)xMLDocument);
            }
            object = xMLDocument.getDocumentElement();
            String string = object.getTagName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("the opening tag is " + string));
            }
            if (string.equalsIgnoreCase("jxta:DiscoveryQuery")) {
                try {
                    ProcessQueryStruct processQueryStruct = this.processQuery(xMLDocument);
                    if (processQueryStruct != null) {
                        this.respond(endpointAddress, processQueryStruct);
                    }
                    break block21;
                }
                catch (DiscardQueryException discardQueryException) {
                    FFDCFilter.processException((Throwable)((Object)discardQueryException), (String)"com.ibm.ws.management.discovery.DiscoveryService.demux", (String)"344", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"the query discarded");
                    }
                    break block21;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.DiscoveryService.demux", (String)"347", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"IO error occurs while processing the query", (Object)iOException);
                    }
                    break block21;
                }
            }
            if (string.equalsIgnoreCase("jxta:DiscoveryResponse")) {
                this.pushResponse(xMLDocument);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unsupported discovery message", (Object)string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"demux");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveryListener[] copyListener() {
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            return this.discoveryListeners.toArray(new DiscoveryListener[0]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ProcessQueryStruct {
        public String serverName;
        public DiscoveryResponseMsg response;

        private ProcessQueryStruct() {
        }
    }
}

