/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MUdpTransport;
import com.ibm.ws.management.discovery.transport.TcpTransport;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpTransport;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Endpoint {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$Endpoint == null ? (class$com$ibm$ws$management$discovery$Endpoint = Endpoint.class$("com.ibm.ws.management.discovery.Endpoint")) : class$com$ibm$ws$management$discovery$Endpoint), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private Hashtable handlers = new Hashtable();
    private Hashtable transports = new Hashtable();
    private TransportProtocol primaryTransport;
    private EndpointAdv epadv;
    private String name;
    private EndpointAddress address;
    private ThreadPoolMgr tpMgr;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$Endpoint;

    public Endpoint(EndpointAdv endpointAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Endpoint");
        }
        this.epadv = endpointAdv;
        this.name = endpointAdv.getName();
        try {
            this.address = new EndpointAddress(endpointAdv.getEndpointAddress().trim());
        }
        catch (InvalidEndpointAddressException invalidEndpointAddressException) {
            FFDCFilter.processException((Throwable)((Object)invalidEndpointAddressException), (String)"com.ibm.ws.management.discovery.Endpoint.Endpoint", (String)"61", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMD0010E");
            return;
        }
        TransportAdvertisement transportAdvertisement = endpointAdv.getTransportAdvertisement();
        String string = transportAdvertisement.getProtocol();
        if (string.equalsIgnoreCase("TCP")) {
            TcpTransport tcpTransport = new TcpTransport((TcpAdv)transportAdvertisement);
            this.addProtocol(tcpTransport);
        } else if (string.equalsIgnoreCase("UDP")) {
            UdpTransport udpTransport = new UdpTransport((UdpAdv)transportAdvertisement);
            this.addProtocol(udpTransport);
        } else if (string.equalsIgnoreCase("MUDP")) {
            MUdpTransport mUdpTransport = new MUdpTransport((MUdpAdv)transportAdvertisement);
            this.addProtocol(mUdpTransport);
        } else {
            Tr.error((TraceComponent)tc, (String)"ADMD0011E");
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Endpoint");
        }
    }

    public ThreadPoolMgr getThreadPoolMgr() {
        return this.tpMgr;
    }

    public void initialize(ThreadPoolMgr threadPoolMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.tpMgr = threadPoolMgr;
        Enumeration enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            TransportProtocol transportProtocol = (TransportProtocol)enumeration.nextElement();
            try {
                transportProtocol.init(this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.Endpoint.initialize", (String)"101", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to initilize the transport", (Object)exception);
                }
                Tr.warning((TraceComponent)tc, (String)"ADMD0012E", (Object)transportProtocol.getProtocolName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void demux(Message message) {
        EndpointAddress endpointAddress;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"demux");
        }
        if (!this.addressMatched(endpointAddress = message.getDestinationAddress())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the incoming message is not for this endpoint", (Object)new Object[]{endpointAddress, this.address});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"demux - failed");
            }
            return;
        }
        String string = endpointAddress.getServiceName();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The message doesn't specify the target service");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"demux - failed");
            }
            return;
        }
        QueryHandler queryHandler = this.lookupHandler(string);
        if (queryHandler == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No handler is found for the incoming message", (Object)string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"demux - failed");
            }
            return;
        }
        queryHandler.demux(message);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"demux");
        }
    }

    public synchronized void registerHandler(String string, QueryHandler queryHandler) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerHandler", (Object)string);
        }
        this.handlers.put(string, queryHandler);
    }

    public synchronized QueryHandler lookupHandler(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"lookupHandler", (Object)string);
        }
        return (QueryHandler)this.handlers.get(string);
    }

    public void addProtocol(TransportProtocol transportProtocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addProtocol: " + transportProtocol.getProtocolName()));
        }
        if (this.primaryTransport == null) {
            this.primaryTransport = transportProtocol;
        }
        this.transports.put(transportProtocol.getProtocolName(), transportProtocol);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addProtocol");
        }
    }

    public TransportProtocol getProtocol(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getProtocol", (Object)string);
        }
        return (TransportProtocol)this.transports.get(string);
    }

    public EndpointAddress getEndpointAddress() {
        return this.address;
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return this.primaryTransport.getMessenger(endpointAddress);
    }

    private boolean addressMatched(EndpointAddress endpointAddress) {
        boolean bl;
        block7: {
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addressMatched", (Object)endpointAddress);
            }
            if ((bl = endpointAddress.getProtocolName().equalsIgnoreCase(this.address.getProtocolName())) && !endpointAddress.getProtocolAddress().equalsIgnoreCase(this.address.getProtocolAddress()) && !(string = endpointAddress.getProtocolHost()).equals("127.0.0.1")) {
                String string2 = this.address.getProtocolHost();
                try {
                    if (!InetAddress.getByName(string).equals(InetAddress.getByName(string2))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"target host does not match local host", (Object)new Object[]{string, string2});
                        }
                        bl = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"can not get host inetaddress", (Object)unknownHostException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addressMatched", (Object)new Boolean(bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

