/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;

public class EndpointAddress {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$EndpointAddress == null ? (class$com$ibm$ws$management$discovery$EndpointAddress = EndpointAddress.class$("com.ibm.ws.management.discovery.EndpointAddress")) : class$com$ibm$ws$management$discovery$EndpointAddress), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private String protocol;
    private String protocolHost;
    private String protocolPort;
    private String serviceName;
    private boolean unified = true;
    private boolean warningIssued = false;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$EndpointAddress;

    public EndpointAddress() {
    }

    public EndpointAddress(int n, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"EndpointAddress", (Object)new Object[]{new Integer(n), string, string2});
        }
        if (n == 1) {
            this.protocol = "TCP";
        } else if (n == 0) {
            this.protocol = "UDP";
        } else if (n == 2) {
            this.protocol = "MUDP";
        }
        this.serviceName = string3;
        this.protocolHost = this.unifyHost(string);
        this.protocolPort = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"EndpointAddress");
        }
    }

    public EndpointAddress(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"EndpointAddress", (Object)new Object[]{string, string2, string3});
        }
        this.protocol = string;
        this.serviceName = string4;
        this.protocolHost = this.unifyHost(string2);
        this.protocolPort = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"EndpointAddress");
        }
    }

    public EndpointAddress(String string) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"EndpointAddress", (Object)string);
        }
        this.parse(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"EndpointAddress");
        }
    }

    private String unifyHost(String string) {
        return string;
    }

    private void parse(String string) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parse", (Object)string);
        }
        int n = string.indexOf("://");
        String string2 = null;
        if (n == -1) {
            throw new InvalidEndpointAddressException(string);
        }
        this.protocol = string.substring(0, n);
        string2 = string.substring(n + 3);
        this.parse1(string2);
    }

    private void parse1(String string) {
        int n = string.indexOf("/");
        String string2 = null;
        if (n == -1) {
            int n2 = string.indexOf(58);
            if (n2 != -1) {
                this.protocolHost = this.unifyHost(string.substring(0, n2));
                this.protocolPort = string.substring(n2 + 1);
            } else {
                this.protocolHost = this.unifyHost(string);
            }
        } else {
            String string3 = string.substring(0, n);
            int n3 = string3.indexOf(58);
            if (n3 != -1) {
                this.protocolHost = this.unifyHost(string3.substring(0, n3));
                this.protocolPort = string3.substring(n3 + 1);
            } else {
                this.protocolHost = this.unifyHost(string3);
            }
            string2 = string.substring(n + 1);
            n = string2.indexOf("/");
            this.serviceName = n == -1 ? string2 : string2.substring(0, n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("protocol = " + this.protocol + " host = " + this.protocolHost + "port = " + this.protocolPort + " service = " + this.serviceName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parse");
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public void setProtocolName(String string) {
        this.protocol = string;
    }

    public String getProtocolAddress() {
        if (this.protocolPort != null) {
            return this.getProtocolHost() + ":" + this.protocolPort;
        }
        return this.getProtocolHost();
    }

    public String getProtocolHost() {
        if (!this.unified) {
            this.protocolHost = this.unifyHost(this.protocolHost);
        }
        return this.protocolHost;
    }

    public String getProtocolPort() {
        return this.protocolPort;
    }

    public void setProtocolAddress(String string) {
        this.parse1(string);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getURI() {
        if (this.serviceName != null) {
            return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/" + this.serviceName;
        }
        return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/";
    }

    public String toString() {
        return this.getURI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

