/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpMessenger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MUdpMessenger
extends UdpMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$MUdpMessenger == null ? (class$com$ibm$ws$management$discovery$transport$MUdpMessenger = MUdpMessenger.class$("com.ibm.ws.management.discovery.transport.MUdpMessenger")) : class$com$ibm$ws$management$discovery$transport$MUdpMessenger), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.discovery");
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$MUdpMessenger;

    public MUdpMessenger(EndpointAddress endpointAddress, TransportProtocol transportProtocol) throws IOException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"MUdpMessenger", (Object)endpointAddress);
        }
        this.destination = endpointAddress;
        this.protocol = transportProtocol;
        this.header = new Header();
        this.source = transportProtocol.getLocalAddress();
        String string = this.destination.getProtocolAddress();
        int n = string.indexOf(":");
        if (n == -1) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(string.substring(n + 1));
        if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("multicast port is " + this.port));
        }
        this.inetAddress = InetAddress.getByName(string.substring(0, n));
        if (!this.inetAddress.isMulticastAddress()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0002E", "only multicast address is allowed"));
        }
        if (!this.openSocket()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getFormattedMessage("ADMD0003E", new Object[]{this.inetAddress}, "Failed to open the multicast socket to join multicast group: {0}"));
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"MUdpMessenger");
        }
    }

    public void close() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"close");
        }
        if (this.socket != null) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
                this.socket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.MUdpMessenger.close", (String)"109", (Object)this);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"close");
        }
    }

    private boolean openSocket() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"openSocket");
        }
        this.socket = null;
        try {
            this.socket = new MulticastSocket();
            ((MulticastSocket)this.socket).joinGroup(this.inetAddress);
            ((MulticastSocket)this.socket).setTimeToLive(0);
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"openSocket - good");
            }
            return true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.MUdpMessenger.openSocket", (String)"134", (Object)this);
            if (this.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)this.tc, (String)"openSocket - bad", (Object)exception);
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

