/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.management.discovery.transport.UdpServer;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MulticastServer
extends UdpServer {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$MulticastServer == null ? (class$com$ibm$ws$management$discovery$transport$MulticastServer = MulticastServer.class$("com.ibm.ws.management.discovery.transport.MulticastServer")) : class$com$ibm$ws$management$discovery$transport$MulticastServer), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private MulticastSocket serverSocket;
    private EndpointAddress mAddress;
    private InetAddress group;
    private String defaultAddr = "232.133.104.73";
    private int multicastSize;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    private static NodeAgentConnector nodeAgentConnector;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$MulticastServer;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$ServerInfo;

    public MulticastServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MulticastServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return MulticastServer.this.createUdpConnection();
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MulticastServer");
        }
    }

    public EndpointAddress getMulticastAddress() {
        return this.mAddress;
    }

    public void initialize(EndpointAddress endpointAddress, int n, int n2) throws Exception {
        boolean bl;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("initialize @" + n));
            }
            this.port = n;
            this.alive = true;
            this.mAddress = new EndpointAddress();
            this.mAddress.setProtocolName("MUDP");
            if (endpointAddress.getProtocolAddress() != null) {
                this.mAddress.setProtocolAddress(endpointAddress.getProtocolAddress());
            } else {
                this.mAddress.setProtocolAddress(this.defaultAddr);
            }
            this.multicastSize = n2 <= 0 ? this.bufSize : n2;
            try {
                this.group = InetAddress.getByName(this.mAddress.getProtocolAddress());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("the multicast group is " + this.group));
                }
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.initialize", (String)"89", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to initialize the mutlicast server", (Object)unknownHostException);
                }
                Tr.warning((TraceComponent)tc, (String)"ADMD0014W", (Object)new Integer(n));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initialize - failed");
                }
                return;
            }
            this.serverSocket = new MulticastSocket(n);
            bl = false;
            try {
                this.serverSocket.joinGroup(this.group);
                bl = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.initialize", (String)"135", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"unable to join the multicast group", (Object)iOException);
            }
        }
        if (bl) {
            this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
            this.acceptThread.start();
        } else {
            Tr.warning((TraceComponent)tc, (String)"ADMD0015W", (Object)this.group);
            this.rediscover();
        }
        nodeAgentConnector = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void shutdown(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        this.alive = false;
        try {
            try {
                this.serverSocket.leaveGroup(this.group);
                this.serverSocket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"124", (Object)this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"129", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMD0016W", (Object)interruptedException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        DatagramPacket datagramPacket = null;
        while (this.alive && !Thread.interrupted()) {
            boolean bl = true;
            try {
                byte[] byArray = new byte[this.multicastSize];
                datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.serverSocket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"170", (Object)this);
                if (this.alive) {
                    Tr.warning((TraceComponent)tc, (String)"ADMD0017W", (Object)iOException.getMessage());
                }
                bl = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Datagram packet(port, length): ", (Object)new Object[]{new Integer(datagramPacket.getPort()), new Integer(datagramPacket.getLength())});
            }
            if (!this.alive || !bl) continue;
            UdpConnection udpConnection = null;
            try {
                udpConnection = this.allocateConnection();
                udpConnection.init(this.endpoint, datagramPacket);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the connection is initialized");
                }
                this.handleConnection(udpConnection);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"185", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connection  handling failure:", (Object)throwable);
                }
                if (udpConnection == null) continue;
                this.freeConnection(udpConnection);
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    void rediscover() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rediscover");
        }
        AdminClient adminClient = null;
        boolean bl = false;
        Subject subject = SecurityHelper.getServerSubject();
        if (subject != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        try {
            adminClient = nodeAgentConnector.create();
        }
        catch (ConnectorException connectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unable to create admin client to nodeagent", (Object)((Object)connectorException));
            }
            bl = true;
        }
        if (adminClient != null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("*:*,type=Discovery,process=" + Utils.getNodeAgentName());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            try {
                Set set = adminClient.queryNames(objectName, null);
                if (set.iterator().hasNext()) {
                    ObjectName objectName2 = (ObjectName)set.iterator().next();
                    adminClient.invoke(objectName2, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{(class$com$ibm$ws$management$discovery$ServerInfo == null ? (class$com$ibm$ws$management$discovery$ServerInfo = MulticastServer.class$("com.ibm.ws.management.discovery.ServerInfo")) : class$com$ibm$ws$management$discovery$ServerInfo).getName()});
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed to send out discover message", (Object)exception);
                }
                bl = true;
            }
        }
        if (bl) {
            Tr.warning((TraceComponent)tc, (String)"ADMD0024W", (Object)Utils.getNodeAgentName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rediscover");
        }
    }

    public static void setupNodeAgentConnector(EndPointMgr endPointMgr) {
        nodeAgentConnector = new NodeAgentConnector(endPointMgr);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NodeAgentConnector {
        String bootstrapPort;
        String soapPort;

        NodeAgentConnector(EndPointMgr endPointMgr) {
            EndPointMgr.NodeEndPoints nodeEndPoints = endPointMgr.getNodeEndPoints("@");
            EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(Utils.getNodeAgentName());
            EndPoint endPoint = serverEndPoints.getEndPoint("BOOTSTRAP_ADDRESS");
            if (endPoint != null) {
                this.bootstrapPort = new Integer(endPoint.getPort()).toString();
            }
            if ((endPoint = serverEndPoints.getEndPoint("SOAP_CONNECTOR_ADDRESS")) != null) {
                this.soapPort = new Integer(endPoint.getPort()).toString();
            }
        }

        AdminClient create() throws ConnectorException {
            Properties properties;
            boolean bl;
            AdminClient adminClient;
            block10: {
                block9: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"create");
                    }
                    adminClient = null;
                    bl = false;
                    String string = SecurityHelper.getHelper().isSecurityEnabled() ? "true" : "false";
                    properties = new Properties();
                    properties.setProperty("securityEnabled", string);
                    properties.setProperty("host", "localhost");
                    properties.setProperty("isInternal", "true");
                    if (this.soapPort != null) {
                        properties.setProperty("port", this.soapPort);
                        properties.setProperty("type", "SOAP");
                        properties.setProperty("securityEnabled", string);
                        try {
                            adminClient = AdminClientFactory.createAdminClient(properties);
                            bl = true;
                        }
                        catch (ConnectorException connectorException) {
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug((TraceComponent)tc, (String)"unable to create soap client to remote process", (Object)new Object[]{properties, connectorException});
                        }
                    }
                }
                if (!bl && this.bootstrapPort != null) {
                    properties.setProperty("port", this.bootstrapPort);
                    properties.setProperty("type", "RMI");
                    try {
                        adminClient = AdminClientFactory.createAdminClient(properties);
                        bl = true;
                    }
                    catch (ConnectorException connectorException) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug((TraceComponent)tc, (String)"unable to create rmi client to remote process", (Object)new Object[]{properties, connectorException});
                    }
                }
            }
            if (!bl) {
                throw new ConnectorException("could not create an admin client to nodeagent process");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"create", (Object)properties);
            }
            return adminClient;
        }
    }
}

