/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import java.io.InputStream;
import java.net.Socket;

public class TcpConnection
implements Runnable {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$TcpConnection == null ? (class$com$ibm$ws$management$discovery$transport$TcpConnection = TcpConnection.class$("com.ibm.ws.management.discovery.transport.TcpConnection")) : class$com$ibm$ws$management$discovery$transport$TcpConnection));
    Endpoint endpoint;
    Socket socket;
    public static final int SoTimeout = 180000;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$TcpConnection;

    public void init(Endpoint endpoint, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.endpoint = endpoint;
        this.socket = socket;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.socket.getInputStream();
            if (inputStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No InputStream");
                }
                this.socket.close();
                return;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"61", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" failed to create inputStream");
            }
            try {
                this.socket.close();
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"66", (Object)this);
            }
            return;
        }
        while (true) {
            int n = 0;
            try {
                byte[] byArray = new byte[Header.length];
                this.socket.setSoTimeout(180000);
                n = inputStream.read(byArray, 0, Header.length);
                if (-1 == n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" End of inputsteam. Closing socket");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (n != Header.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TcpHeader size mismatch( " + n + "," + Header.length + ")"));
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Header header = new Header();
                if (!header.decipher(byArray, 0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"can not understand the TcpHeader");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("message size = " + header.size));
                }
                int n2 = 0;
                byte[] byArray2 = new byte[header.size];
                for (n = 0; n < header.size; n += n2) {
                    try {
                        n2 = inputStream.read(byArray2, n, header.size - n);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"117", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"inputStream is broken");
                        }
                        inputStream.close();
                        this.socket.close();
                        return;
                    }
                    if (n2 != -1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no more bytes to receive - incomplete message");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (n != header.size) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"size mismatch, message corrupted");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Message message = new Message(byArray2, 0, header.size);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" forward the message up to the endpoint");
                }
                this.endpoint.demux(message);
                if (!tc.isEntryEnabled()) continue;
                Tr.exit((TraceComponent)tc, (String)"run");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"150", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"run - exception", (Object)exception);
                }
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

