/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class TcpMessenger
implements EndpointMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$TcpMessenger == null ? (class$com$ibm$ws$management$discovery$transport$TcpMessenger = TcpMessenger.class$("com.ibm.ws.management.discovery.transport.TcpMessenger")) : class$com$ibm$ws$management$discovery$transport$TcpMessenger), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.discovery");
    private EndpointAddress destination;
    private EndpointAddress source;
    private InetAddress inetAddress;
    private TransportProtocol protocol;
    private Socket socket;
    private int port;
    private Header header;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$TcpMessenger;

    public TcpMessenger(EndpointAddress endpointAddress, TransportProtocol transportProtocol) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TcpMessenger", (Object)endpointAddress);
        }
        this.destination = endpointAddress;
        this.protocol = transportProtocol;
        this.header = new Header();
        this.source = transportProtocol.getLocalAddress();
        String string = this.destination.getProtocolAddress();
        int n = string.indexOf(":");
        if (n == -1) {
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(string.substring(n + 1));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("port = " + this.port));
        }
        this.inetAddress = InetAddress.getByName(string.substring(0, n));
        if (!this.openSocket()) {
            throw new IOException(this.nls.getFormattedMessage("ADMD0004E", new Object[]{new Integer(this.port)}, "can not open the TCP socket: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TcpMessenger(EndpointAddress, TcpTrasnport)");
        }
    }

    public void sendMessage(Message message) throws IOException {
        Object object;
        Object object2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendMessage");
        }
        if (this.destination == null) {
            throw new IOException();
        }
        InputStream inputStream = message.getInputStream();
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(new byte[Header.length]);
        int n2 = 0;
        int n3 = 4096;
        while (-1 != (n = inputStream.read((byte[])(object2 = new byte[n3])))) {
            if (0 == n) continue;
            if (n < n3) {
                object = new byte[n];
                System.arraycopy(object2, 0, object, 0, n);
                object2 = object;
            }
            n2 += ((byte[])object2).length;
            vector.addElement((byte[])object2);
        }
        this.header.cmd = (byte)2;
        object2 = this.protocol.getLocalAddress().getProtocolHost();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("local host name is: " + (String)object2));
        }
        this.header.srcAddr = InetAddress.getByName((String)object2).getAddress();
        this.header.srcPort = this.protocol.getPort();
        this.header.option = 2;
        this.header.size = n2;
        this.header.cipher((byte[])vector.elementAt(0), 0);
        if (this.socket == null && !this.openSocket()) {
            throw new IOException(this.nls.getFormattedMessage("ADMD0004E", new Object[]{new Integer(this.port)}, "can not open the TCP socket: {0}"));
        }
        for (n = 0; n < 2; ++n) {
            try {
                object = this.socket.getOutputStream();
                for (int i = 0; i < vector.size(); ++i) {
                    ((OutputStream)object).write((byte[])vector.elementAt(i));
                }
                ((OutputStream)object).flush();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"sendMessage - successful");
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.sendMessage", (String)"156", (Object)this);
                if (this.openSocket()) continue;
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                    this.socket = null;
                    continue;
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.sendMessage", (String)"169", (Object)this);
                    throw new IOException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendMessage - failed");
        }
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.close", (String)"188", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    private boolean openSocket() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"openSocket");
            }
            this.socket = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InetAddress, port: ", (Object)new Object[]{this.inetAddress, new Integer(this.port)});
                }
                this.socket = new Socket(this.inetAddress, this.port);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openSocket - good");
                }
                return true;
            }
            catch (ConnectException connectException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connection refused", (Object)connectException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpMessenger.openSocket", (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"general socket exception", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openSocket - bad");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

