/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UnicastServer;
import java.io.IOException;
import java.net.InetAddress;

public class TcpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$TcpTransport == null ? (class$com$ibm$ws$management$discovery$transport$TcpTransport = TcpTransport.class$("com.ibm.ws.management.discovery.transport.TcpTransport")) : class$com$ibm$ws$management$discovery$transport$TcpTransport), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private boolean initialized = false;
    protected int port;
    protected EndpointAddress localAddress;
    private UnicastServer unicastServer;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$TcpTransport;

    public TcpTransport(TcpAdv tcpAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TcpTransport");
        }
        InetAddress inetAddress = null;
        this.port = new Integer(tcpAdv.getPort());
        String string = tcpAdv.getLocalAddress();
        try {
            inetAddress = string == null ? AdminHelper.getInstance().getLocalHost() : InetAddress.getByName(string);
            if (inetAddress.getHostAddress().equals("127.0.0.1")) {
                Tr.warning((TraceComponent)tc, (String)"ADMD0025W");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.TcpTransport.TcpTransport", (String)"60", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to initialize TcpTransport with exception: ", (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"ADMD0018E", (Object)exception.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("TCP");
        this.localAddress.setProtocolAddress(inetAddress.getHostName() + ":" + this.port);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TcpTransport");
        }
    }

    public void init(Endpoint endpoint) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.unicastServer = new UnicastServer(endpoint);
        this.unicastServer.initialize(this.port);
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return MessengerFactory.createMessenger(endpointAddress, this);
    }

    public void close() {
        this.unicastServer.shutdown(true);
    }

    public String getProtocolName() {
        return "TCP";
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

