/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.eclipse.emf.ecore.EPackage;

public class UdpServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$UdpServer == null ? (class$com$ibm$ws$management$discovery$transport$UdpServer = UdpServer.class$("com.ibm.ws.management.discovery.transport.UdpServer")) : class$com$ibm$ws$management$discovery$transport$UdpServer), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    protected ThreadPool threadPool = null;
    protected ObjectPool connectionPool = null;
    protected int port;
    protected int bufSize = 16384;
    protected boolean alive;
    protected Thread acceptThread = null;
    protected Endpoint endpoint;
    private DatagramSocket serverSocket;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$UdpServer;

    public UdpServer() {
    }

    public UdpServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UdpServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UdpServer.this.createUdpConnection();
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UdpServer");
        }
    }

    public void initialize(int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize @" + n));
        }
        this.alive = true;
        Boolean bl = AdminHelper.getInstance().useMultiHome();
        if (bl == null) {
            this.serverSocket = new DatagramSocket(n);
        } else if (bl.booleanValue()) {
            this.serverSocket = new DatagramSocket(n, null);
        } else {
            InetAddress inetAddress = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new DatagramSocket(n, inetAddress);
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize - successful");
        }
    }

    public void shutdown(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        this.alive = false;
        try {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"124", (Object)this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"129", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ADMD0016W", (Object)interruptedException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected UdpConnection createUdpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createUdpConnection");
        }
        return new UdpConnection();
    }

    public void handleConnection(UdpConnection udpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleConnection");
        }
        try {
            this.threadPool.execute((Runnable)udpConnection);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.handleConnection", (String)"148", (Object)this);
        }
    }

    public UdpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"allocateConnection");
        }
        return (UdpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(UdpConnection udpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"freeConnection");
        }
        return !this.connectionPool.add((Object)udpConnection);
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        DatagramPacket datagramPacket = null;
        while (this.alive && !Thread.interrupted()) {
            block11: {
                try {
                    byte[] byArray = new byte[this.bufSize];
                    datagramPacket = new DatagramPacket(byArray, byArray.length);
                    this.serverSocket.receive(datagramPacket);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"170", (Object)this);
                    if (!this.alive) break block11;
                    Tr.warning((TraceComponent)tc, (String)"ADMD0017W", (Object)iOException.getMessage());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Datagram packet(port, length): ", (Object)new Object[]{new Integer(datagramPacket.getPort()), new Integer(datagramPacket.getLength())});
            }
            if (!this.alive) continue;
            UdpConnection udpConnection = null;
            try {
                udpConnection = this.allocateConnection();
                udpConnection.init(this.endpoint, datagramPacket);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the connection is initialized");
                }
                this.handleConnection(udpConnection);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"185", (Object)this);
                if (udpConnection != null) {
                    this.freeConnection(udpConnection);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("connection handling failure: " + throwable.getMessage()));
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    protected ThreadPool getThreadPool(ThreadPoolMgr threadPoolMgr, String string, int n) {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(1);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(true);
        threadPool = threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

