/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpServer;
import java.io.IOException;
import java.net.InetAddress;

public class UdpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$UdpTransport == null ? (class$com$ibm$ws$management$discovery$transport$UdpTransport = UdpTransport.class$("com.ibm.ws.management.discovery.transport.UdpTransport")) : class$com$ibm$ws$management$discovery$transport$UdpTransport), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    protected int port;
    protected boolean initialized = false;
    protected EndpointAddress localAddress;
    private UdpServer udpServer;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$UdpTransport;

    public UdpTransport() {
    }

    public UdpTransport(UdpAdv udpAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UdpTransport");
        }
        InetAddress inetAddress = null;
        this.port = new Integer(udpAdv.getPort());
        String string = udpAdv.getLocalAddress();
        try {
            inetAddress = string == null ? AdminHelper.getInstance().getLocalHost() : InetAddress.getByName(string);
            if (inetAddress.getHostAddress().equals("127.0.0.1")) {
                Tr.warning((TraceComponent)tc, (String)"ADMD0025W");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.UdpTransport.UdpTransport", (String)"57", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMD0019E", (Object)exception.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("UDP");
        this.localAddress.setProtocolAddress(inetAddress.getHostName() + ":" + this.port);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UdpTransport");
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return MessengerFactory.createMessenger(endpointAddress, this);
    }

    public void init(Endpoint endpoint) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.udpServer = new UdpServer(endpoint);
        this.udpServer.initialize(this.port);
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolName() {
        return "UDP";
    }

    public void close() {
        this.udpServer.shutdown(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

