/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.TcpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.emf.ecore.EPackage;

public class UnicastServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$discovery$transport$UnicastServer == null ? (class$com$ibm$ws$management$discovery$transport$UnicastServer = UnicastServer.class$("com.ibm.ws.management.discovery.transport.UnicastServer")) : class$com$ibm$ws$management$discovery$transport$UnicastServer), (String)"Admin", (String)"com.ibm.ws.management.resources.discovery");
    private ThreadPool threadPool = null;
    private ObjectPool connectionPool = null;
    private ServerSocket serverSocket;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$transport$UnicastServer;

    public UnicastServer(Endpoint endpoint) {
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UnicastServer.this.createTcpConnection();
            }
        };
    }

    public void initialize(int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize @" + n));
        }
        this.alive = true;
        Boolean bl = AdminHelper.getInstance().useMultiHome();
        if (bl == null) {
            this.serverSocket = new ServerSocket(n);
        } else if (bl.booleanValue()) {
            this.serverSocket = new ServerSocket(n, 50, null);
        } else {
            InetAddress inetAddress = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new ServerSocket(n, 50, inetAddress);
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize - successful");
        }
    }

    public void shutdown(boolean bl) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"shutdown");
            }
            this.alive = false;
            try {
                try {
                    Socket socket = new Socket("localhost", this.serverSocket.getLocalPort());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", (String)"78", (Object)this);
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", (String)"83", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"failed to shutdown the UnicastServer", (Object)interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected TcpConnection createTcpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createTcpConnection");
        }
        return new TcpConnection();
    }

    public void handleConnection(TcpConnection tcpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleConnection");
        }
        try {
            this.threadPool.execute((Runnable)tcpConnection);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.handleConnection", (String)"101", (Object)this);
        }
    }

    public TcpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"allocateConnection");
        }
        return (TcpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(TcpConnection tcpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"freeConnection");
        }
        return !this.connectionPool.add((Object)tcpConnection);
    }

    public void run() {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            while (this.alive && !Thread.interrupted()) {
                Socket socket;
                block15: {
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"118", (Object)this);
                        if (!this.alive) break block15;
                        Tr.warning((TraceComponent)tc, (String)"ADMD0020W", (Object)iOException.getMessage());
                    }
                }
                if (this.alive && socket != null) {
                    TcpConnection tcpConnection = null;
                    try {
                        tcpConnection = this.allocateConnection();
                        tcpConnection.init(this.endpoint, socket);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"the connection is initialized");
                        }
                        this.handleConnection(tcpConnection);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"130", (Object)this);
                        if (tcpConnection != null) {
                            this.freeConnection(tcpConnection);
                        }
                        Tr.warning((TraceComponent)tc, (String)"ADMD0021W", (Object)throwable.getMessage());
                    }
                    continue;
                }
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"138", (Object)this);
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"147", (Object)this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)"failed to cloase server socket", (Object)iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private ThreadPool getThreadPool(ThreadPoolMgr threadPoolMgr, String string, int n) {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(1);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(true);
        threadPool = threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

