/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.util.SecurityHelper;
import javax.management.Notification;
import javax.security.auth.Subject;

public abstract class AbstractPushRemoteSender
extends RemoteSender
implements AlarmListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$AbstractPushRemoteSender == null ? (class$com$ibm$ws$management$event$AbstractPushRemoteSender = AbstractPushRemoteSender.class$("com.ibm.ws.management.event.AbstractPushRemoteSender")) : class$com$ibm$ws$management$event$AbstractPushRemoteSender), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private static final int MAX_CACHED = 5;
    private static final int BATCH_SIZE = 20;
    private static final long MAX_NORMAL_WAIT_TIME = 500L;
    private static final long MAX_FAILURE_WAIT_TIME = 60000L;
    private Alarm sendAlarm = null;
    private long currentWaitTime = 500L;
    private boolean connectorExceptionOccurred = false;
    static /* synthetic */ Class class$com$ibm$ws$management$event$AbstractPushRemoteSender;

    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)NotificationService.getInfo(notification));
        }
        super.handleNotification(notification);
        if (this.getNumNotifications() >= 5 || this.isStoppingNotification(notification)) {
            this.flushNotifications();
        } else {
            this.createAlarmIfNecessary(this.currentWaitTime);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    public void stop() {
        super.stop();
        this.cancelAlarm();
    }

    private boolean isStoppingNotification(Notification notification) {
        return notification.getType().endsWith("stopping");
    }

    protected void receiverPermanentlyUnavailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receiverPermanentlyUnavailable");
        }
        super.receiverPermanentlyUnavailable();
        this.stop();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"receiverPermanentlyUnavailable");
        }
    }

    private synchronized void cancelAlarm() {
        if (this.sendAlarm != null) {
            this.sendAlarm.cancel();
            this.deleteAlarm();
        }
    }

    private synchronized void deleteAlarm() {
        this.sendAlarm = null;
    }

    private synchronized void createAlarmIfNecessary(long l) {
        if (this.isActive() && this.sendAlarm == null && this.getNumNotifications() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting alarm for " + l + "ms"));
            }
            this.sendAlarm = AlarmManager.create((long)l, (AlarmListener)this);
        }
    }

    private void flushNotifications() {
        this.cancelAlarm();
        this.createAlarmIfNecessary(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Object v1;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm");
            }
            Subject subject = null;
            try {
                subject = SecurityHelper.getServerSubject();
                if (subject != null) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
                if (this.getNumNotifications() > 0) {
                    Notification[] notificationArray = this.getNotifications(20);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Sending " + notificationArray.length + " notifications " + "to " + this.getIdentifier()));
                    }
                    try {
                        if (!this.pushNotifications(notificationArray)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"send returned false; requeuing");
                            }
                            this.requeueNotifications(notificationArray);
                        }
                        this.connectorExceptionOccurred = false;
                    }
                    catch (ConnectorException connectorException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"send got ConnectorException; requeuing", (Object)((Object)connectorException));
                        }
                        this.connectorExceptionOccurred = true;
                        this.requeueNotifications(notificationArray);
                        FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.event.AbstractPushRemoteSender.alarm", (String)"199", (Object)this);
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var6_6 = null;
                try {
                    if (subject != null) {
                        SecurityHelper.popInvocationSubject(subject);
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var8_10 = v0;
                this.deleteAlarm();
                this.currentWaitTime = this.connectorExceptionOccurred ? Math.min(60000L, this.currentWaitTime * 2L) : 500L;
                this.createAlarmIfNecessary(this.currentWaitTime);
                throw throwable;
            }
            try {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject(subject);
                }
                v1 = null;
                break block17;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var8_9 = v1;
        this.deleteAlarm();
        this.currentWaitTime = this.connectorExceptionOccurred ? Math.min(60000L, this.currentWaitTime * 2L) : 500L;
        this.createAlarmIfNecessary(this.currentWaitTime);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    protected abstract boolean pushNotifications(Notification[] var1) throws ConnectorException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

