/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.FilterElement;
import com.ibm.ws.management.event.NotificationService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ConsolidatedFilter
implements NotificationFilter {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$ConsolidatedFilter == null ? (class$com$ibm$ws$management$event$ConsolidatedFilter = ConsolidatedFilter.class$("com.ibm.ws.management.event.ConsolidatedFilter")) : class$com$ibm$ws$management$event$ConsolidatedFilter), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    static final long serialVersionUID = 8448046386485560623L;
    private Set filters = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$com$ibm$ws$management$event$ConsolidatedFilter;

    public boolean addFilter(NotificationListener notificationListener, ObjectName objectName, NotificationFilter notificationFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addFilter", (Object)new Object[]{notificationListener, objectName, notificationFilter});
        }
        this.filters.add(new FilterElement(notificationListener, objectName, notificationFilter));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("filter is now " + this.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addFilter");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilter(ObjectName objectName, NotificationListener notificationListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeFilter", (Object)notificationListener);
        }
        boolean bl = false;
        Set set = this.filters;
        synchronized (set) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                if (!((FilterElement)iterator.next()).matches(objectName, notificationListener)) continue;
                iterator.remove();
                bl = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("filter is now " + this.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeFilter", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isNotificationEnabled", (Object)NotificationService.getInfo(notification));
        }
        boolean bl = false;
        Set set = this.filters;
        synchronized (set) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                if (!((FilterElement)iterator.next()).isNotificationEnabled(notification)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isNotificationEnabled", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendFilterEntries(ConsolidatedFilter consolidatedFilter, ServerInfo serverInfo) {
        boolean bl = false;
        Set set = consolidatedFilter.filters;
        synchronized (set) {
            Iterator iterator = consolidatedFilter.filters.iterator();
            while (iterator.hasNext()) {
                String string;
                FilterElement filterElement = (FilterElement)iterator.next();
                ObjectName objectName = filterElement.info.getName();
                String string2 = objectName.getKeyProperty("cell");
                if (string2 != null && !string2.equals(serverInfo.getCell()) || (string = objectName.getKeyProperty("node")) != null && !string.equals(serverInfo.getNode())) continue;
                this.filters.add(filterElement);
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return "ConsolidatedFilter: " + this.filters;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConsolidatedFilter)) {
            return false;
        }
        ConsolidatedFilter consolidatedFilter = (ConsolidatedFilter)object;
        return ((Object)consolidatedFilter.filters).equals(this.filters);
    }

    Set getFiltersForUnitTest() {
        return this.filters;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

