/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminClientImpl;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.FilterChangeListener;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ThreadPool;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public class DownstreamServerManager
implements FilterChangeListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$DownstreamServerManager == null ? (class$com$ibm$ws$management$event$DownstreamServerManager = DownstreamServerManager.class$("com.ibm.ws.management.event.DownstreamServerManager")) : class$com$ibm$ws$management$event$DownstreamServerManager), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private Map filterMap;
    private Map serverMap;
    private ThreadPool updaterThreadPool;
    private Subject securitySubject;
    private static final String THREADPOOL_NAME = "DownstreamServerNotificationUpdaters";
    private static final int THREADPOOL_MIN = 1;
    private static final int THREADPOOL_MAX = 10;
    static /* synthetic */ Class class$com$ibm$ws$management$event$DownstreamServerManager;

    public DownstreamServerManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.filterMap = Collections.synchronizedMap(new HashMap());
        this.serverMap = Collections.synchronizedMap(new HashMap());
        this.updaterThreadPool = new ThreadPool(THREADPOOL_NAME, 1, 10);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void addDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDownstreamServer", (Object)serverInfo);
        }
        DSMEntry dSMEntry = null;
        if (this.isFilterAdded()) {
            dSMEntry = this.createDSMEntry(serverInfo);
        }
        this.serverMap.put(serverInfo, dSMEntry);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDownstreamServer");
        }
    }

    private DSMEntry createDSMEntry(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDSMEntry", (Object)serverInfo);
        }
        ConsolidatedFilter consolidatedFilter = this.createFilter(serverInfo);
        DSMEntry dSMEntry = null;
        if (!consolidatedFilter.isEmpty()) {
            ListenerIdentifier listenerIdentifier = this.addRemoteListener(serverInfo, consolidatedFilter);
            dSMEntry = new DSMEntry(consolidatedFilter, listenerIdentifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDSMEntry", dSMEntry);
        }
        return dSMEntry;
    }

    private ConsolidatedFilter createFilter(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFilter", (Object)serverInfo);
        }
        ConsolidatedFilter consolidatedFilter = new ConsolidatedFilter();
        Iterator iterator = this.filterMap.values().iterator();
        while (iterator.hasNext()) {
            consolidatedFilter.appendFilterEntries((ConsolidatedFilter)iterator.next(), serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFilter", (Object)consolidatedFilter);
        }
        return consolidatedFilter;
    }

    private ListenerIdentifier addRemoteListener(ServerInfo serverInfo, ConsolidatedFilter consolidatedFilter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRemoteListener", (Object)new Object[]{serverInfo, consolidatedFilter});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        PushUpstreamServerSender pushUpstreamServerSender = new PushUpstreamServerSender();
        ListenerIdentifier listenerIdentifier = remoteNotificationBroadcaster.addNotificationListener(consolidatedFilter, pushUpstreamServerSender);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRemoteListener", (Object)listenerIdentifier);
        }
        return listenerIdentifier;
    }

    private void updateRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRemoteListener", (Object)new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.resetFilter(dSMEntry.listenerId, dSMEntry.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRemoteListener");
        }
    }

    private void removeRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRemoteListener", (Object)new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.removeNotificationListener(dSMEntry.listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRemoteListener");
        }
    }

    private RemoteNotificationBroadcaster getRemoteProxy(ServerInfo serverInfo) throws ConnectorException {
        return ((AdminClientImpl)serverInfo.getAdminClient()).getProxy();
    }

    public synchronized void removeDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDownstreamServer", (Object)serverInfo);
        }
        this.serverMap.remove(serverInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDownstreamServer");
        }
    }

    public synchronized void setFilter(Object object, ConsolidatedFilter consolidatedFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setFilter", (Object)new Object[]{object, consolidatedFilter});
        }
        this.filterMap.put(object, consolidatedFilter);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setFilter");
        }
    }

    public synchronized void unsetFilter(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetFilter", (Object)object);
        }
        this.filterMap.remove(object);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetFilter");
        }
    }

    private boolean isFilterAdded() {
        return !this.filterMap.isEmpty();
    }

    private void updateServerListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateServerListeners");
        }
        Iterator iterator = this.serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            ServerInfo serverInfo = (ServerInfo)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("examining server " + serverInfo));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Updating servers in separate thread");
                }
                this.updaterThreadPool.execute((Runnable)new ServerListenerUpdater(serverInfo));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.event.DownstreamServerManager.updateServerListeners", (String)"243", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerListeners");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ServerListenerUpdater
    implements Runnable {
        private ServerInfo serverInfo;

        public ServerListenerUpdater(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        public void run() {
            Subject subject;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            if ((subject = SecurityHelper.getServerSubject()) != null) {
                SecurityHelper.pushInvocationSubject(subject);
            }
            DSMEntry dSMEntry = (DSMEntry)DownstreamServerManager.this.serverMap.get(this.serverInfo);
            try {
                if (dSMEntry == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"DSMEntry null");
                    }
                    if (DownstreamServerManager.this.isFilterAdded()) {
                        dSMEntry = DownstreamServerManager.this.createDSMEntry(this.serverInfo);
                        DownstreamServerManager.this.serverMap.put(this.serverInfo, dSMEntry);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("DSMEntry: " + dSMEntry));
                    }
                    RemoteNotificationBroadcaster remoteNotificationBroadcaster = DownstreamServerManager.this.getRemoteProxy(this.serverInfo);
                    if (DownstreamServerManager.this.isFilterAdded()) {
                        ConsolidatedFilter consolidatedFilter = DownstreamServerManager.this.createFilter(this.serverInfo);
                        if (!consolidatedFilter.equals(dSMEntry.filter)) {
                            dSMEntry.filter = consolidatedFilter;
                            DownstreamServerManager.this.updateRemoteListener(this.serverInfo, dSMEntry);
                        }
                    } else {
                        DownstreamServerManager.this.removeRemoteListener(this.serverInfo, dSMEntry);
                        DownstreamServerManager.this.serverMap.put(this.serverInfo, null);
                    }
                }
            }
            catch (ReceiverNotFoundException receiverNotFoundException) {
                FFDCFilter.processException((Throwable)((Object)receiverNotFoundException), (String)"com.ibm.ws.management.event.DownstreamServerManager.ServerListenerUpdater.run", (String)"308", (Object)this);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.ws.management.event.DownstreamServerManager.ServerListenerUpdater.run", (String)"334", (Object)this);
            }
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }

    class DSMEntry {
        ConsolidatedFilter filter;
        ListenerIdentifier listenerId;

        DSMEntry(ConsolidatedFilter consolidatedFilter, ListenerIdentifier listenerIdentifier) {
            this.filter = consolidatedFilter;
            this.listenerId = listenerIdentifier;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

