/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ws.management.event.NotificationInfo;
import java.io.Serializable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class FilterElement
implements Serializable {
    static final long serialVersionUID = 5020421872211159772L;
    final int listenerId;
    final NotificationInfo info;

    FilterElement(NotificationListener notificationListener, ObjectName objectName, NotificationFilter notificationFilter) {
        this(notificationListener, new NotificationInfo(objectName, notificationFilter));
    }

    FilterElement(NotificationListener notificationListener, NotificationInfo notificationInfo) {
        this.listenerId = notificationListener.hashCode();
        this.info = notificationInfo;
    }

    public boolean isNotificationEnabled(Notification notification) {
        return this.info.isNotificationEnabled(notification);
    }

    public boolean listenerMatches(NotificationListener notificationListener) {
        if (notificationListener != null) {
            return notificationListener.hashCode() == this.listenerId;
        }
        return false;
    }

    public boolean matches(ObjectName objectName, NotificationListener notificationListener) {
        return this.listenerMatches(notificationListener) && (objectName == null || this.info.getName().equals(objectName));
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            FilterElement filterElement = (FilterElement)object;
            return filterElement.listenerId == this.listenerId && filterElement.info.equals(this.info);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + new Integer(this.listenerId).hashCode();
        n = 37 * n + this.info.hashCode();
        return n;
    }

    public String toString() {
        return "FilterElement:[id=" + this.listenerId + ";info=" + this.info + "]";
    }
}

