/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.util.ThreadPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class LocalNotificationService
implements WsNotifListener,
WsNotifListenerContainer {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$LocalNotificationService == null ? (class$com$ibm$ws$management$event$LocalNotificationService = LocalNotificationService.class$("com.ibm.ws.management.event.LocalNotificationService")) : class$com$ibm$ws$management$event$LocalNotificationService), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    public static final long TIME_TO_WAIT_FOR_LISTENER = 60000L;
    private List listeners = new ArrayList();
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatcherPool = new ThreadPool("LocalNotificationService dispatcher", 0, 10);
    private static final int DISPATCH_POOL_MIN_SIZE = 0;
    private static final int DISPATCH_POOL_MAX_SIZE = 10;
    private boolean listenersUpdated = true;
    static /* synthetic */ Class class$com$ibm$ws$management$event$LocalNotificationService;

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNotificationListener", (Object)new Object[]{objectName, notificationListener, notificationFilter, object});
        }
        this.addListenerInternal(objectName, notificationListener, notificationFilter, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNotificationListener");
        }
    }

    public void addNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNotificationListenerExtended", (Object)new Object[]{objectName, notificationListener, notificationFilter, object});
        }
        this.addListenerInternal(objectName, notificationListener, notificationFilter, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNotificationListenerExtended");
        }
    }

    protected boolean addListenerInternal(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        ListenerInfo listenerInfo = new ListenerInfo(objectName, notificationListener, notificationFilter, object);
        return this.addListener(listenerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener wsNotifListener) {
        boolean bl = false;
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(wsNotifListener)) {
                this.listeners.add(wsNotifListener);
                bl = true;
                this.listenersUpdated = true;
            }
        }
        return bl;
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeNotificationListener", (Object)new Object[]{objectName, notificationListener});
        }
        this.removeListenerInternal(objectName, notificationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNotificationListener");
        }
    }

    public void removeNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeNotificationListenerExtended", (Object)new Object[]{objectName, notificationListener});
        }
        this.removeListenerInternal(objectName, notificationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNotificationListenerExtended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListenerInternal(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException {
        List list = this.listeners;
        synchronized (list) {
            ListenerInfo listenerInfo = this.getListenerInfo(objectName, notificationListener);
            if (listenerInfo == null) {
                throw new ListenerNotFoundException("Did not find listener " + notificationListener);
            }
            while (listenerInfo != null) {
                this.listeners.remove(listenerInfo);
                listenerInfo = this.getListenerInfo(objectName, notificationListener);
            }
            this.listenersUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener wsNotifListener) {
        boolean bl = false;
        List list = this.listeners;
        synchronized (list) {
            bl = this.listeners.remove(wsNotifListener);
            if (bl) {
                this.listenersUpdated = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumListeners() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    private ListenerInfo getListenerInfo(ObjectName objectName, NotificationListener notificationListener) {
        ListenerInfo listenerInfo = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo2 = (ListenerInfo)iterator.next();
            if (!listenerInfo2.isMatching(objectName, notificationListener)) continue;
            listenerInfo = listenerInfo2;
            break;
        }
        return listenerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)(notification.getType() + "[source=" + notification.getSource() + "]"));
        }
        List list = this.listeners;
        synchronized (list) {
            if (this.listenersUpdated) {
                WsNotifListener[] wsNotifListenerArray = new ListenerInfo[this.listeners.size()];
                wsNotifListenerArray = this.listeners.toArray(wsNotifListenerArray);
                this.dispatcher = new NotificationDispatcher(this, wsNotifListenerArray, true, this.dispatcherPool);
            }
        }
        this.dispatcher.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    public String toString() {
        return "LocalNotificationService";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

