/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Notification;
import javax.security.auth.Subject;

public class NotificationDispatcher
implements WsNotifListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$NotificationDispatcher == null ? (class$com$ibm$ws$management$event$NotificationDispatcher = NotificationDispatcher.class$("com.ibm.ws.management.event.NotificationDispatcher")) : class$com$ibm$ws$management$event$NotificationDispatcher), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private final ThreadPool dispatchPool;
    private final WsNotifListenerContainer container;
    private final WsNotifListener[] listeners;
    private final boolean removeNonresponsiveListeners;
    static /* synthetic */ Class class$com$ibm$ws$management$event$NotificationDispatcher;

    public NotificationDispatcher(WsNotifListenerContainer wsNotifListenerContainer, WsNotifListener[] wsNotifListenerArray, boolean bl, ThreadPool threadPool) {
        this.container = wsNotifListenerContainer;
        this.listeners = wsNotifListenerArray;
        this.removeNonresponsiveListeners = bl;
        this.dispatchPool = threadPool;
    }

    public void handleNotification(Notification notification) {
        if (this.listeners.length > 0) {
            new DispatchANotificationToAllListeners(notification).dispatch();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DispatchANotificationToAListener
    implements Runnable {
        private int listenerId;
        private Notification notif;
        private DispatchANotificationToAllListeners dispatcher;
        private Subject subject;

        public DispatchANotificationToAListener(int n, Notification notification, DispatchANotificationToAllListeners dispatchANotificationToAllListeners) {
            this.listenerId = n;
            this.notif = notification;
            this.dispatcher = dispatchANotificationToAllListeners;
        }

        public void run() {
            this.setServerCredentials();
            WsNotifListener wsNotifListener = NotificationDispatcher.this.listeners[this.listenerId];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Dispatching to listener #" + this.listenerId + " notification " + this.notif), (Object)wsNotifListener);
            }
            try {
                wsNotifListener.handleNotification(this.notif);
            }
            catch (ReceiverPermanentlyUnavailableException receiverPermanentlyUnavailableException) {
                FFDCFilter.processException((Throwable)((Object)receiverPermanentlyUnavailableException), (String)"com.ibm.ws.management.event.NotificationDispatcher.run", (String)"219", (Object)this);
                NotificationDispatcher.this.container.removeListener(wsNotifListener);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADME0006W", (Object)new Object[]{this.notif, wsNotifListener, throwable});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Returned from listener #" + this.listenerId));
            }
            this.unsetServerCredentials();
            this.dispatcher.markComplete(this.listenerId);
        }

        private void setServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ DispatchANotificationToAListener this$1;
                {
                    this.this$1 = dispatchANotificationToAListener;
                }

                public Object run() {
                    DispatchANotificationToAListener.access$502(this.this$1, SecurityHelper.getServerSubject());
                    if (DispatchANotificationToAListener.access$500(this.this$1) != null) {
                        SecurityHelper.pushInvocationSubject(DispatchANotificationToAListener.access$500(this.this$1));
                    }
                    return null;
                }
            });
        }

        private void unsetServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ DispatchANotificationToAListener this$1;
                {
                    this.this$1 = dispatchANotificationToAListener;
                }

                public Object run() {
                    if (DispatchANotificationToAListener.access$500(this.this$1) != null) {
                        SecurityHelper.popInvocationSubject(DispatchANotificationToAListener.access$500(this.this$1));
                    }
                    return null;
                }
            });
        }

        static /* synthetic */ Subject access$502(DispatchANotificationToAListener dispatchANotificationToAListener, Subject subject) {
            dispatchANotificationToAListener.subject = subject;
            return dispatchANotificationToAListener.subject;
        }

        static /* synthetic */ Subject access$500(DispatchANotificationToAListener dispatchANotificationToAListener) {
            return dispatchANotificationToAListener.subject;
        }
    }

    class DispatchANotificationToAllListeners {
        private final Notification notif;
        private boolean[] completeRegistry;
        private int numListenersReturned = 0;
        private final long timeout;

        public DispatchANotificationToAllListeners(Notification notification) {
            this.notif = notification;
            this.completeRegistry = new boolean[NotificationDispatcher.this.listeners.length];
            this.timeout = (Long)AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ DispatchANotificationToAllListeners this$1;
                {
                    this.this$1 = dispatchANotificationToAllListeners;
                }

                public Object run() {
                    return Long.getLong("com.ibm.ws.management.event.LocalNotificationService.handleNotificationTimeout", 300000L);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Emitting to " + NotificationDispatcher.this.listeners.length + " listeners"), (Object)this.notif);
            }
            for (int i = 0; i < NotificationDispatcher.this.listeners.length; ++i) {
                try {
                    NotificationDispatcher.this.dispatchPool.execute((Runnable)new DispatchANotificationToAListener(i, this.notif, this));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            DispatchANotificationToAllListeners dispatchANotificationToAllListeners = this;
            synchronized (dispatchANotificationToAllListeners) {
                if (this.isNotificationComplete()) {
                    return;
                }
                try {
                    this.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isNotificationComplete() && NotificationDispatcher.this.removeNonresponsiveListeners) {
                    this.removeUncompletedListeners();
                }
            }
        }

        private boolean isNotificationComplete() {
            return this.numListenersReturned >= NotificationDispatcher.this.listeners.length;
        }

        private void removeUncompletedListeners() {
            for (int i = 0; i < this.completeRegistry.length; ++i) {
                if (this.completeRegistry[i]) continue;
                WsNotifListener wsNotifListener = NotificationDispatcher.this.listeners[i];
                Tr.error((TraceComponent)tc, (String)"ADME0005E", (Object)new String[]{Long.toString(this.timeout), wsNotifListener.toString()});
                NotificationDispatcher.this.container.removeListener(wsNotifListener);
            }
        }

        synchronized void markComplete(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"markComplete", (Object)new Integer(n));
            }
            this.completeRegistry[n] = true;
            ++this.numListenersReturned;
            if (this.isNotificationComplete()) {
                this.notify();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"markComplete");
            }
        }
    }
}

