/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamServerManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.MBeanServerDelegateListener;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.ProcessListener;
import com.ibm.ws.management.event.PullRemoteSender;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteSender;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.util.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.Notification;

public class NotificationService
implements WsNotifListener,
WsNotifListenerContainer,
RemoteNotificationBroadcaster {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$event$NotificationService == null ? (class$com$ibm$ws$management$event$NotificationService = NotificationService.class$("com.ibm.ws.management.event.NotificationService")) : class$com$ibm$ws$management$event$NotificationService), (String)"Admin", (String)"com.ibm.ws.management.resources.event");
    private List listeners;
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatcherPool;
    private static final int DISPATCH_POOL_MIN_SIZE = 0;
    private static final int DISPATCH_POOL_MAX_SIZE = 10;
    private boolean listenersUpdated = true;
    private Map remoteSenders = new HashMap();
    private DownstreamServerManager downstreamServerManager;
    private PushRemoteSender upstreamServerSender;
    static /* synthetic */ Class class$com$ibm$ws$management$event$NotificationService;

    public NotificationService(MBeanServer mBeanServer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.listeners = new ArrayList();
        this.downstreamServerManager = new DownstreamServerManager();
        new MBeanServerDelegateListener(mBeanServer, this);
        new ProcessListener(this);
        this.dispatcherPool = new ThreadPool("NotificationService dispatcher", 0, 10);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) {
        RemoteSender remoteSender;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNotificationListener", (Object)new Object[]{consolidatedFilter, pushNotificationListener});
        }
        if (pushNotificationListener == null) {
            remoteSender = new PullRemoteSender();
        } else {
            remoteSender = new PushRemoteSender(pushNotificationListener);
            if (pushNotificationListener instanceof PushUpstreamServerSender) {
                this.replaceUpstreamServerSender((PushRemoteSender)remoteSender);
            }
        }
        remoteSender.setFilter(consolidatedFilter);
        this.addListener(remoteSender);
        ListenerIdentifier listenerIdentifier = remoteSender.getIdentifier();
        this.downstreamServerManager.setFilter(listenerIdentifier, consolidatedFilter);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNotificationListener", (Object)listenerIdentifier);
        }
        return listenerIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener wsNotifListener) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListener", (Object)wsNotifListener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            object = null;
            try {
                object = ((RemoteSender)wsNotifListener).getIdentifier();
                this.remoteSenders.put(object, wsNotifListener);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        boolean bl = false;
        object = this.listeners;
        synchronized (object) {
            bl = this.listeners.add(wsNotifListener);
        }
        if (bl) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListener", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener wsNotifListener) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeListener", (Object)wsNotifListener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            object = null;
            try {
                object = ((RemoteSender)wsNotifListener).getIdentifier();
                RemoteSender remoteSender = (RemoteSender)this.remoteSenders.remove(object);
                if (remoteSender != null) {
                    remoteSender.stop();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        boolean bl = false;
        object = this.listeners;
        synchronized (object) {
            bl = this.listeners.remove(wsNotifListener);
        }
        if (bl) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeListener", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)NotificationService.getInfo(notification));
        }
        Object var2_2 = null;
        if (this.listenersUpdated) {
            List list = this.listeners;
            synchronized (list) {
                WsNotifListener[] wsNotifListenerArray = new WsNotifListener[this.listeners.size()];
                wsNotifListenerArray = this.listeners.toArray(wsNotifListenerArray);
                this.dispatcher = new NotificationDispatcher(this, wsNotifListenerArray, false, this.dispatcherPool);
            }
        }
        this.dispatcher.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceUpstreamServerSender(PushRemoteSender pushRemoteSender) {
        Map map = this.remoteSenders;
        synchronized (map) {
            if (this.upstreamServerSender != null) {
                try {
                    this.removeNotificationListener(this.upstreamServerSender.getIdentifier());
                }
                catch (ReceiverNotFoundException receiverNotFoundException) {
                    // empty catch block
                }
            }
            this.upstreamServerSender = pushRemoteSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeNotificationListener", (Object)listenerIdentifier);
        }
        RemoteSender remoteSender = null;
        Map map = this.remoteSenders;
        synchronized (map) {
            remoteSender = (RemoteSender)this.remoteSenders.get(listenerIdentifier);
        }
        if (remoteSender == null) {
            throw new ReceiverNotFoundException(listenerIdentifier);
        }
        this.removeListener(remoteSender);
        this.downstreamServerManager.unsetFilter(listenerIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNotificationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ReceiverNotFoundException {
        RemoteSender remoteSender;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetFilter", (Object)new Object[]{listenerIdentifier, consolidatedFilter});
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            remoteSender = (RemoteSender)this.remoteSenders.get(listenerIdentifier);
        }
        if (remoteSender == null) {
            throw new ReceiverNotFoundException(listenerIdentifier);
        }
        remoteSender.setFilter(consolidatedFilter);
        this.downstreamServerManager.setFilter(listenerIdentifier, consolidatedFilter);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pullNotifications", (Object)new Object[]{listenerIdentifier, n});
        }
        Notification[] notificationArray = this.remoteSenders;
        synchronized (this.remoteSenders) {
            PullRemoteSender pullRemoteSender = (PullRemoteSender)this.remoteSenders.get(listenerIdentifier);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (pullRemoteSender == null) {
                throw new ReceiverNotFoundException(listenerIdentifier);
            }
            notificationArray = pullRemoteSender.pullNotifications(n);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"pullNotifications");
            }
            return notificationArray;
        }
    }

    public DownstreamServerManager getDownstreamServerManager() {
        return this.downstreamServerManager;
    }

    public void stopUpstreamServerSending() {
    }

    public void restartUpstreamServerSending() {
    }

    public static String getInfo(Notification notification) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(notification.getType());
        stringBuffer.append(" [source=" + notification.getSource());
        stringBuffer.append(",userData=" + notification.getUserData() + "]");
        return stringBuffer.toString();
    }

    public static String getInfo(Notification[] notificationArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < notificationArray.length; ++i) {
            stringBuffer.append(NotificationService.getInfo(notificationArray[i]));
            if (i + 1 >= notificationArray.length) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "NotificationService";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

